# 1 "jn.c"

















































# 1 "/u/cinclude/math.h"
























extern int errno, signgam;

extern double atof(), frexp(), ldexp(), modf();
extern double j0(), j1(), jn(), y0(), y1(), yn();
extern double erf(), erfc();
extern double exp(), log(), log10(), pow(), sqrt();
extern double floor(), ceil(), fmod(), fabs();
extern double gamma();
extern double hypot();
extern int matherr();
extern double sinh(), cosh(), tanh();
extern double sin(), cos(), tan(), asin(), acos(), atan(), atan2();
















# 55 "/u/cinclude/math.h"


# 59 "/u/cinclude/math.h"


# 63 "/u/cinclude/math.h"
























struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};










# 50 "jn.c"

# 1 "/u/cinclude/values.h"































































# 91 "/u/cinclude/values.h"











































# 51 "jn.c"

# 1 "/u/cinclude/errno.h"























# 28 "/u/cinclude/errno.h"

extern int errno;
extern int mpxerr;


























































extern char * sys_errlist[];
void perror ();































































































# 52 "jn.c"

extern double jn_error();

double
jn(n, x)
register int n;
register double x;
{
	double a, b, temp, t;
	int i;

	if (((x) < 0 ? -(x) : (x)) > (3.14159265358979323846 * ((double)(1L << (8 * (int)sizeof(long)) - 2) * (1L << ((8 * (int)sizeof(double)) - 8 + 0 - 1) - (8 * (int)sizeof(long)) + 1))))
		return (jn_error(n, x, 1));
	if (n == 0)
		return (j0(x));
	if (x == 0)
		return (x);
	if (n < 0) {
		n = -n;
		x = -x;
	}
	if (n == 1)
		return (j1(x));
	if (n <= x) {
		a = j0(x);
		b = j1(x);
		for (i = 1; i < n; i++) {
			temp = b;
			b = (i + i)/x * b - a;
			a = temp;
		}
		return (b);
	}
	temp = x * x;
	for (t = 0, i = n + 16; i > n; i--)
		t = temp/(i + i - t);
	a = t = x/(n + n - t);
	b = 1;
	for (i = n - 1; i > 0; i--) {
		temp = b;
		b = (i + i)/x * b - a;
		a = temp;
	}
	return (t * j0(x)/b);
}

double
yn(n, x)
register int n;
register double x;
{
	double a, b, temp;
	int i, neg;

	if (x <= 0) {
		struct exception exc;

		exc.type = 1;
		exc.name = "yn";
		exc.arg1 = n;
		exc.arg2 = x;
		exc.retval = -((float)0.7237005145e76);
		if (!matherr(&exc)) {
			(void) write(2, "yn: DOMAIN error\n", 17);
			errno = 33;
		}
		return (exc.retval);
	}
	if (x > (3.14159265358979323846 * ((double)(1L << (8 * (int)sizeof(long)) - 2) * (1L << ((8 * (int)sizeof(double)) - 8 + 0 - 1) - (8 * (int)sizeof(long)) + 1))))
		return (jn_error(n, x, 0));
	if (n == 0)
		return (y0(x));
	neg = 0;
	if (n < 0) {
		n = -n;
		neg = n % 2;
	}
	b = y1(x);
	if (n > 1) {
		a = y0(x);
		for (i = 1; i < n; i++) {
			temp = b;
			b = (i + i)/x * b - a;
			a = temp;
		}
	}
	return (neg ? -b : b);
}

static double
jn_error(n, x, jnflag)
int n;
double x;
int jnflag;
{
	struct exception exc;

	exc.type = 5;
	exc.name = jnflag ? "jn" : "yn";
	exc.arg1 = n;
	exc.arg2 = x;
	exc.retval = 0.0;
	if (!matherr(&exc)) {
		(void) write(2, exc.name, 2);
		(void) write(2, ": TLOSS error\n", 14);
		errno = 34;
	}
	return (exc.retval);
}
