/* error.h */

/*
 * 	(c) Copyright 1990 J B Systems
 *	This file contains non-based support modifications
 *	for operation under MPX.  Derived from Encores' base
 *	mode C compiler.
 */

/*	$Header: /home/jbev/encore/nbc/nbccom/RCS/error.h,v 1.7 2016/01/28 20:40:12 jbev Exp $	      */

#ifndef ONEPASS
#undef BUFSTDERR
#endif

extern void exit();

int         nerrors = 0; /* number of errors */
int         Wflag = 0;	/* Non-zero means do not print warnings */

/* VARARGS1 */
uerror(s, a)		/* second parameter must be a pointer */
char  *s;
char *a;
{
/*
 * nonfatal error message
 * the routine where is different for pass 1 and pass 2;
 *  it tells where the error took place
 */
    ++nerrors;
    where('u');
    fprintf(stderr, s, a);
    fprintf(stderr, "\n");
#ifdef BUFSTDERR
    fflush(stderr);
#endif
    if (nerrors > 30)
	cerror("too many errors");
}

/*
 * This version is required for the alpha because a pointer
 * is 64 bits and an int is 32 bits.  It causes an error.
 */
/* VARARGS1 */
uderror(s, a)		/* second parameter must be an integer */
char  *s;
int    a;
{
/*
 * nonfatal error message
 * the routine where is different for pass 1 and pass 2;
 *  it tells where the error took place
 */
    ++nerrors;
    where('u');
    fprintf(stderr, s, a);
    fprintf(stderr, "\n");
#ifdef BUFSTDERR
    fflush(stderr);
#endif
    if (nerrors > 30)
	cerror("too many errors");
}

/* VARARGS1 */
cerror(s, a, b)
char    *s;
char    *a;
char    *b;
{				/* compiler error: die */
    fflush(stdout);
    where('c');
    if (nerrors && nerrors <= 30) {
	/* give the compiler the benefit of the doubt */
	fprintf(stderr, "cannot recover from earlier errors: goodbye!\n");
    } else {
	fprintf(stderr, "compiler error: ");
	fprintf(stderr, s, a, b);
	fprintf(stderr, "\n");
    }
#ifdef BUFSTDERR
    fflush(stderr);
#endif
    exit(1);
}

/*
 * This version is required for the alpha because a pointer
 * is 64 bits and an int is 32 bits.  It causes an error.
 */
/* VARARGS1 */
cderror(s, a, b)
char    *s;
int	a;
int	b;
{				/* compiler error: die */
    fflush(stdout);
    where('c');
    if (nerrors && nerrors <= 30) {
	/* give the compiler the benefit of the doubt */
	fprintf(stderr, "cannot recover from earlier errors: goodbye!\n");
    } else {
	fprintf(stderr, "compiler error: ");
	fprintf(stderr, s, a, b);
	fprintf(stderr, "\n");
    }
#ifdef BUFSTDERR
    fflush(stderr);
#endif
    exit(1);
}

/* VARARGS1 */
werror(s, a, b)
char   *s;
char   *a;
char   *b;
{				/* warning */
    if (Wflag)
	return;
    where('w');
    fprintf(stderr, "warning: ");
    fprintf(stderr, s, a, b);
    fprintf(stderr, "\n");
#ifdef BUFSTDERR
    fflush(stderr);
#endif
}

/*
 * This version is required for the alpha because a pointer
 * is 64 bits and an int is 32 bits.  It causes an error.
 */
/* VARARGS1 */
wderror(s, a, b)
char   *s;
int	a;
int	b;
{				/* warning */
    if (Wflag)
	return;
    where('w');
    fprintf(stderr, "warning: ");
    fprintf(stderr, s, a, b);
    fprintf(stderr, "\n");
#ifdef BUFSTDERR
    fflush(stderr);
#endif
}

