/* ftest2.c */
/* test program for float.c	*/
/* convert ascii to encore or ieee floating point */

#include <stdlib.h>
#include <stdio.h>
#include "float.h"
/* int ieee  = 1; */
int ieee  = 1;
int debug = 6;
int digits = 0;
FPN ifpn;	/* internal floating point number */
FPN *myatof();
long ftoi();
double atof();

#define FLODEB
#define MYATOF

short errcnt, warncnt, v;
quit(x) {
exit(x);
}

FPN	f1,f2;

main(){
	register i,j,k;
	int rnum[2];
	unsigned char num[100];
	int *fpp;
	float fnum = -1.0;
	double dnum = -1.0;

	for(;;){
again:		printf("enter number: ");
#ifdef OLDWAY
		getnum( &f1 );
#else
		i = 0;
		while ((j = getchar()) != '\n')
			num[i++] = j;
		num[i] = '\0';
	dnum = atof(num);
	fnum = (float)dnum;
	fpp = (int *)&fnum;
	printf("f number[%x][%g]\n",fpp[0], fnum);
	fpp = (int *)&dnum;
	printf("d number[%x %x][%g]\n",fpp[1], fpp[0], dnum);
		myatof(num);
		f1 = ifpn;
#endif
#ifdef FLODEB_X
	printf("exp = %d mant = ",f1.ne);sdump(f1.nf,NF);
		printf("results integer value: %lx\n", ftoi(&f1, 1));
#endif
		printf("result: ");
		f2 = f1;
		if( isnegf( &f1 ) ){
			putchar( '-' );
			negf( &f1 );
		}
		digits = 0;
		putman( &f1 );
		putchar( '.' );
		putchar( 'e' );
		if( f1.ne >= 0 ) putchar( '+' );
		printf("%d\n",f1.ne);
		flconv(6, f2.ne, &f2.nf, rnum, 0);
#ifdef linux
		printf("rnum = %08x%08x\n", rnum[1], rnum[0]);
#else
		printf("rnum = %08x%08x\n", rnum[0], rnum[1]);
#endif
	}
}

putman( f1 ) register FPN *f1; {

	register		k;

	k = divsk( f1->nf, NF, 10, 0 );
	if( isnzs( f1->nf, NF ) ) putman( f1 );
	if (digits++ < 15)
		putchar( k + '0' );
	else
		f1->ne++;
}

getnum( f ) register FPN *f; {

	register	i,tz;
	register	exp;
	register	sign;

	zerof( f );
	sign = exp = tz = 0;

	i = getchar();

	while( i == ' ' ) i = getchar();
	if( i == '-' ){ sign++; i = getchar(); }
	else if( i == '+' ) i = getchar();
	while( i == ' ' ) i = getchar();
	while( i >= '0' && i <= '9' ){
		tz = dodig( f, i-'0', tz );
		i = getchar();
	}
	if( i == '.' ){
		i = getchar();
		while( i >= '0' && i <= '9' ){
			tz = dodig( f, i-'0', tz );
			exp--;
			i = getchar();
		}
	}
	f->ne += tz + exp;
	while( i != '\n' ) i = getchar();
	if( sign ) negf( f );
}

#ifdef FLODEB
fdump( f ) register FPN *f; {

	printf("fdump: %5d  %2x %2x %2x %2x %2x %2x %2x %2x\n",
		f->ne,
		f->nf[7] & 0xff,
		f->nf[6] & 0xff,
		f->nf[5] & 0xff,
		f->nf[4] & 0xff,
		f->nf[3] & 0xff,
		f->nf[2] & 0xff,
		f->nf[1] & 0xff,
		f->nf[0] & 0xff );
}
#endif

#ifdef MYATOF

#include "float.h"

/* floating point service */
static short	fexp;			/* floating exponent		*/
static short	fr[NF];			/* floating fraction		*/
static long	fvhigh,fvlow;		/* floating final form		*/
static short	binexp;

/*	floating point  conversions	*/

#ifdef JUNK
flconv(typ, fe, f, rnum, ieee)
int typ;
short fe;
unsigned char *f;
int *rnum;
int ieee;
{
	register int i,j;
	printf("flconv: typ[%x] exp[%x] frac[",typ,fe);
	for(i=0; i<NF; i++) {
		printf("%x ",f[i]&0xff);
	}
	printf("]\n");
	xflconv(typ, fe, f, rnum, ieee);
	printf("flconv returns %lx %lx\n",rnum[0],rnum[1]);
}

xflconv(typ, fe, f, rnum, ieee)
#else
flconv(typ, fe, f, rnum, ieee)
#endif
int typ;
short fe;
unsigned char *f;
int *rnum;
int ieee;
{
	/* pack up a floating point number */
	register int	i,j;
	register int	sign;

	binexp = 0;

	for( i=0; i<NF; i++ ) fr[i] = f[i] & 0xff;
	fexp = fe;
	rnum[0] = rnum[1] = 0;
	fvhigh = fvlow = 0;
	sign = 0;
	if( fr[NF-1] & 0x80 ){
		sign = j = 1;
		for( i=0; i<NF; i++ ){
			j += ~fr[i] & 0xff;
			fr[i] = j & 0xff;
			j >>= 8;
		}
	}
	for( i=0; i<NF; i++ ) if( fr[i] ) break;
	if( i == NF ) return;			/* true zero */
	pnorm();
	j = 0;
	while( fexp < 0 ) {
		 j = div10();
		 fexp++;
		 pnorm();
	}			 /* reduce dec exp */
	if( j >= 5 ) {
		 incf();
		 pnorm();
	}
	while( fexp > 0 ) {
		j = mul10();
		fexp--;
		if ( j ) pfrsh8(), fr[NF-1] = j, binexp += 8;
		pnorm();
	}
	iftodbl(ieee);
	if (ieee) {
		if( sign ) fvhigh |= 0x80000000L;
	} else {
		if( sign ){
			fvhigh = ~fvhigh;
			fvlow = -fvlow;
			if( fvlow == 0 ) fvhigh++;
		}
	}
	rnum[0] = fvhigh;
	rnum[1] = fvlow;
	if (typ == 5) {			/* if float, truncate */
		fcvtf(rnum, ieee);
		return;
	}
#ifdef linux
	/* swap for linux */
	i = rnum[1];
	rnum[1] = rnum[0];
	rnum[0] = i;
#endif
}

iftodbl(ieee)		/* internal format to 64 bit floating point */
int ieee;
{
	register int	i;
	int	tmpexp;

	if (ieee) {
		for( i=0; i<9; i++ )pfrsh();
		incf();		/* round it up */
		pfrsh();	/* and truncate bit */
	} else {
#ifdef ENCORE
		for( i=0; i<5; i++ )pfrsh();
#else
#ifdef TEST_JIM
		for( i=0; i<6; i++ )pfrsh();
		while ((binexp+63) & 3)pfrsh(), binexp++;
		incf();		/* round it up */
		pfrsh();	/* and truncate bit */
		binexp++;
#else
#ifndef TRYING
	printf("flconv: frac[");
	for(i=NF-1; i>=0; i--) {
		printf("%x ",fr[i]&0xff);
	}
	printf("]\n");
#endif
		for( i=0; i<6; i++ )pfrsh();
		while ((binexp+63) & 3)pfrsh(), binexp++;
		incf();		/* round it up */
		pfrsh();	/* and truncate bit */
		binexp++;
#endif
#endif
	}
#ifndef TRYING
	printf("flconv: frac[");
	for(i=NF-1; i>=0; i--) {
		printf("%x ",fr[i]&0xff);
	}
	printf("]\n");
#endif
	for( i=3; i>=0; i-- ) fvlow = (fvlow << 8) | fr[i];
	for( i=7; i>=4; i-- ) fvhigh = (fvhigh << 8) | fr[i];
	if (ieee) {
		fvhigh &= 0x000fffffL;		/* clear out 12 bits */
		fvhigh |= (long)((binexp + 1085) & 0x7ff) << 20;
	} else {
		fvhigh &= 0x00ffffffL;		/* clear out 8 bits */
#ifdef ENCORE
		fvhigh |= (long)((binexp + 126) & 0x7f) << 24;
#else
		tmpexp = ((62 + binexp) >> 2) + 64;
#ifdef JUNK
		if (tmpexp > 77) {
			/* number too big, use max */
			fvhigh = 0x7fffffff;
			fvlow = 0xffffffff;
		} else if (tmpexp < -77) {
			/* number too small, use zero */
			fvhigh = 0;
			fvlow = 0;
		} else
#endif
 			fvhigh |= (tmpexp & 0x7f) << 24;
#endif
	}
}

pnorm(){
	while( fr[NF-1] <= 63 ){ pflsh(); binexp--; }
	while( fr[NF-1] > 127 ){ pfrsh(); binexp++; }
}

pflsh()
{
	register int	i,j;

	j = 0;
	for( i=0; i<NF; i++ ){
		j |= fr[i] << 1;
		fr[i] = j & 0xff;
		j >>= 8;
	}
}

pfrsh8()
{
	register int	i,j;

	j = 0;
	for( i=0; i<NF-1; i++ )
		fr[i] = fr[i+1];
	fr[NF-1] = 0;
}

pfrsh()
{
	register int	i,j;

	j = 0;
	for( i=NF-1; i>= 0; i-- ){
		j |= fr[i];
		fr[i] = j >> 1;
		j = (j & 1) << 8;
	}
}

mul10()
{
	register int	i,j;

	j = 0;
	for( i=0; i<NF; i++ ){
		j += fr[i] * 10; 
		fr[i] = j & 0xff;
		j >>= 8;
	}
	return (j);
}

div10()
{
	register int	i,j;

	j = 0;
	for( i=NF-1; i>=0; i-- ){
		j <<= 8;
		j |= fr[i];
		fr[i] = j/10;
		j %= 10;
	}
	return j;
}

incf()
{		/* increment */
	register int	i;

	for( i=0; i<NF; i++ ){
		fr[i]++;
		if( (fr[i] &= 0xff) ) return;
	}
}

fcvtf(rnum, ieee)
int *rnum;
int ieee;
{			/* convert to single */
	register int	i;
	long	sign;

	if (ieee) {
		sign = rnum[0] & 0x80000000L;	/* save sign */
		i = (unsigned int)rnum[1] >> 29;	/* get three bits */
		i &= 7;
		rnum[0] -= 0x40000000L;	/* remove exponent bias	*/
		rnum[0] <<= 3;		/* make room for three bits */
		rnum[0] += i;		/* put in bottom three bits */
		rnum[1] = 0;
		rnum[0] += 0x40000000L;	/* restore exponent bias */
		rnum[0] &= 0x7fffffffL;	/* turn off sign	 */
		rnum[0] |= sign;	/* restore sign */
	} else {
		rnum[1] = 0;		/* simply truncate	*/
	}
}

#ifdef NOTNOW
fcvtd(rnum, ieee)
int *rnum;
int ieee;
{			/* convert to double */
	register int	i;
	long	sign;

	if (ieee) {
		sign = rnum[0] & 0x80000000L;
		i = rnum[0];
		i &= 7;
		rnum[1] = (long)i << 29;
		rnum[0] -= 0x40000000L;	/* remove exponent bias	*/
		rnum[0] <<= 1;		/* exponent sign to sign position */
		rnum[0] >>= 4;		/* extend it */
		rnum[0] &= 0x7fffffffL;	/* and clear sign bit */
		rnum[0] += 0x40000000L;	/* restore exponent bias*/
		rnum[0] |= sign;	/* restore sign */
	} else {
		rnum[1] = 0;		/* simply guarantee zero */
	}
}

cvitof( p )reg NODE *p;{		/* convert to float		*/

	reg int	i;
	reg int	signl;
	long	sign;

	sign = 0;
	if( p->nd_fval == 0 ){
		p->nd_fvl2 = 0;
		goto pret;
	}
	if( p->nd_fval < 0 ){
		sign++;
		p->nd_fval = -p->nd_fval;
	}
	for( i=0; i<4; i++ ){
		fr[i] = p->nd_fval & 0xff;
		p->nd_fval >>= 8;
	}
	for( ; i<8; i++ ) fr[i] = 0;
	fexp = binexp = 0;
	pnorm();
	iftodbl(ieee);
	p->nd_fval = fvhigh;
	p->nd_fvl2 = fvlow;
pret:	p->nd_type = TYREAL|(8<<5);
	if( sign ) p->nd_fval |= 0x80000000L;
}

cvftoi( p ) reg NODE *p; {		/* float to int */

	reg int	i;
	reg int	sign;

	if( p->nd_fval == 0 ){
		p->nd_fvl2 = 0;
		p->nd_type = deflong;
		return;
	}
	if( p->nd_fval < 0 ) sign++;
#ifdef IEEE
	i = p->nd_fval >> 20;
	if( varlen( p->nd_type ) == 8 ){	/* from double */
		i &= 0x7ff;			/* exponent is 11 bits */
		i -= 1027;			/* remove bias */
		p->nd_fvl2 >>= 20;
		p->nd_fvl2 &= 0xfff;
		p->nd_fval = (p->nd_fval << 12) | p->nd_fvl2 | 0x80000000L;
		p->nd_fvl2 = 0;
	} else {
		i = (i >> 3) & 0xff;		/* exponent is 8 bits */
		i -= 127;			/* remove bias */
		p->nd_fval = (p->nd_fval << 23 ) | 0x80000000L;
	}
#else		/* use the UNIFORM format	*/
	if( sign ) fneg( p );
	i = p->nd_fval >> 24;
	i &= 0x7f;				/* get exponent	*/
	i -= 64;				/* remove bias	*/
	p->nd_fvl2 >>= 24;
	p->nd_fvl2 &= 0xff;
	p->nd_fval = (p->nd_fval << 8) | p->nd_fvl2;
	p->nd_fvl2 = 0;
#endif
	if( i < -1 ){				/* no significance at all */
		p->nd_fval = 0;
		i = 31;
	}
	while( i < 31 ){
		p->nd_fval >>= 1;
		p->nd_fval &= 0x7fffffffL;
		i++;
	}
	if( sign ) p->nd_fval = -p->nd_fval;
	p->nd_type = deflong;
}

fneg( p ) reg NODE *p; {
#ifdef IEEE
	p->nd_fval ^= 0x80000000L;
#else
	p->nd_fval = ~p->nd_fval;
	if( (p->nd_fvl2 = -p->nd_fvl2) == 0 ) p->nd_fval++;
#endif
}
#endif /* NOTNOW */

#ifdef JUNK
fdump(s)char *s;{
	register int	i;
	printf("fd(%s)fexp = %d binexp = %d ",s,fexp,binexp);
	printf(" %4x %4x [",fvhigh,fvlow);
	for( i=NF-1; i>= 0; i-- ) printf(" %2x",fr[i] );
	printf("]\n");
}
#endif

#endif /* MYATOF */

#ifdef MYATOF

#include <ctype.h>
#include "float.h"

/*  Note : this atof() generates an internal floating point representation
 *	   of a number.  If we are in IEEE mode, the number is translated
 *	   to IEEE format.  Otherwise it is translated to Encore format.
 */

FPN ifpn;	/* internal floating point number */

/* #define FLOATDEB */

#ifdef FLOATDEB
extern int sdump();
unsigned char ss[100];
#else
unsigned char ss[100];
#endif

FPN *
myatof(s)
register  unsigned char  *s;
{
	register int i;
	int	tz;
	int	exp;
	int	sign;
	int	esign;

#ifdef FLOATDEB
	printf("myatof entry: %s\n", s);
	strcpy(ss,s);
	s = ss;
#else
	*ss='\0';
	strcpy(ss,s);
	s = ss;
#endif
	zerof( &ifpn );		/* clear destination number */
	esign = sign = exp = tz = 0;	/* and local variables */

	i = *s++;		/* get 1st char */

#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof start: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* skip any leading white spaces */
	while( i == ' ' || i == '\t') i = *s++;
	/* see if a sign given */
	if( i == '-' ) {
		sign++;
		i = *s++;
	} else if( i == '+' )
		i = *s++;
	/* skip any more white spaces */
	while( i == ' ' || i == '\t') i = *s++;
	/* skip any leading zero's */
	while( i == '0') i = *s++;
	/* now process any number digits */
	while( i >= '0' && i <= '9' ){
		tz = dodig( &ifpn, i-'0', tz );
		i = *s++;
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 1: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	}
	/* now process a fraction, if present */
	if( i == '.' ){
		/* do the fraction */
		i = *s++;
		while( i >= '0' && i <= '9' ){
			tz = dodig( &ifpn, i-'0', tz );
			exp--;
			i = *s++;
		}
	}
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 2: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* now see if exponent */
	exp = (tz + exp);
	tz = 0;			/* zero trailing zeros count */
	/* skip any more white spaces */
	while( i == ' ' || i == '\t') i = *s++;
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 3: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* now process an exponent, if present */
	if( i == 'e' || i == 'E' ){
		/* do the exponent */
		i = *s++;
		/* see if a sign given */
		if( i == '-' ) {
			esign++;
			i = *s++;
		} else if( i == '+' )
			i = *s++;
		/* skip any leading zero's */
		while( i == '0') i = *s++;
		while( i >= '0' && i <= '9' ){
			tz = tz * 10 + i-'0';
			i = *s++;
		}
	}
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 4: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* we are done with number */
	if (esign) tz = -tz;
	/* set the exponent */
	ifpn.ne += (tz + exp);
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 5: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* if negative, negate the value */
	if( sign ) negf( &ifpn );
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("ret myatof: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	return (&ifpn);
}


/*~!float.c*/
/* Name:  float.c Part No.: _______-____r
 *
 * Copyright 1995 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)nbcc:float.c	1.1"

/************************************************************************
*									*
*		float.c							*
*									*
*************************************************************************/

#include "float.h"			/* READ THIS FILE		*/

static int addsk();
static int mulsk();
static int mul10fk();
static int negs();
static int absf();	/* makes positive and returns sign		*/
static int mvb();
static int cmpss();
static int subss();
static int addss();
#ifdef JUNK
static void norm(F);
static void frsh(F);
#endif /* JUNK */

#define reg	register
#define uns	unsigned

/*		Local Variables						*/
/*	Predicates come first						*/
/*	isnegf(f)	is a macro in float.h				*/

isnzf( f ) reg FPN *f; { /* return nz if *f is not identically zero	*/
	reg		i;
	reg uns char	*p;
	reg uns char	*pe;

	p = f->nf;
	pe = p+NF;
	for( p = f->nf, pe = p+NF; p < pe; p++ ) if( *p ) return 1;
	return 0;
}

isnzs( s, n ) reg char *s; {
	reg char	*se;

	for( se = s+n; s < se; s++ ) if( *s ) return 1;
	return 0;
}

/*	basic subroutines follow					*/
/*	addsk adds a integer to a mantissa string.  The only restriction
	on k, is that it must not be greater than the maximum positive
	value of an integer less 255.	The carry out is returned.	*/

static int
addsk( s, n, k ) reg char *s; reg uns k; {
	reg char	*se;

	for( se = s+n; s<se && k; s++ ){
		k += *s & 0xff;
		*s = k;
		k >>= 8;
	}
	return k;
}

static int
mulsk( s, n, radix, k ) reg char *s; reg uns k; {

	reg char	*se;

	for( se = s+n; s<se; s++ ){
		k += (*s & 0xff) * radix;
		*s = k;
		k >>= 8;
	}
	return k;
}

divsk( s, n, radix, k ) reg char *s; reg uns k; {

	reg char	*se;

	for( se = s+n-1; se>=s; se-- ){
		k = (k << 8) | (*se & 0xff);
		*se = k / radix;
		k %= radix;
	}
	return k;
}

/*
mulfk(f,radix,k) is defined as a macro
divfk(r,radix,k) is defined as a macro
*/

/* mul10fk multiplies the mantissa by 10 if it does not overflow.
   If it would overflow, no multiply is done, and the exponent is
   incremented.
*/
static int
mul10fk(f,k) reg FPN *f; reg uns k; {

	if( (f->nf[NF-1] & 0xff) > 12 ){	/* already overflowed */
		f->ne++;
		return;
	}
	k = mulsk( f->nf, NF, 10, k );
	if( k || isnegf(f) ){		/* overflow, divide back out	*/
		k = divsk( f->nf, NF, 10, k );
		f->ne++;
		if( k > 5 ) addsk( f->nf, NF, 1 );		/* round */
	}
}

int
dodig( f, k, tz ) reg FPN *f; {
	if( f->ne ){
		f->ne++;
		return 0;
	}
	if( k == 0 ) return tz+1;
	while( --tz >= 0 ){
		if( f->ne ){			/* already overflowed	*/
			f->ne += tz;
			k = 0;
			break;
		}
		mul10fk( f, 0 );
	}
	if( f->ne ){				/* round on overflow	*/
		if( k >= 5 ) addsk( f->nf, NF, 1 );
		while( (k = divsk(f->nf,NF,10,0)) == 0 ) f->ne++;
		mulsk( f->nf,NF,10,k);
		return 0;
	}
	mul10fk( f, k );
	return 0;
}

static int
negs( s, n ) reg char	*s; {
	reg char	*se;

	for( se = s+n; s<se && *s==0; s++ );
	if( s < se ){
		*s = -*s;
		while( ++s < se ) *s ^= 0xff;
	}
}

negf( f ) reg FPN *f; {
	negs( f->nf, NF );
}

static int
absf( f ) reg FPN *f; {	/* makes positive and returns sign		*/

	if( !isnegf(f) ) return 0;
	negs( f->nf, NF );
	return 1;
}

/*	too many compilers can't handle struct assigns, so we have
	this memcopy routine
*/

static int
mvb( tgt, src, n ) register char *tgt, *src; {
	register char *bnd;

	for( bnd = tgt + n; tgt < bnd; )  *tgt++ = *src++;
}

/*		Major User Routines					*/
addff( f1, f2 ) reg FPN *f1, *f2; {
	reg		k;
	FPN		f3;		/* f2 save cell			*/
	short		sgn1,		/* sign of f1			*/
			sgn2;		/* sign of f2			*/
	short		tz;

#ifdef BADCODE
	f3 = *f2;
#else
	mvb( &f3, f2, sizeof(FPN) );
#endif
	f2 = &f3;
	sgn1 = absf( f1 );
	sgn2 = absf( f2 );
	k = 0;
	while( f1->ne > f2->ne ){	/* align exponents, part 1	*/
		if( f1->nf[NF-1] < 13 ){
			mul10fk( f1, 0 );
			f1->ne--;
		} else {
			k = divfk( f2, 10, 0 );
			f2->ne++;
		}
	}
	while( f2->ne > f1->ne ){	/* align exponents, part 2	*/
		if( f2->nf[NF-1] < 13 ){
			mul10fk( f2, 0 );
			f2->ne--;
		} else {
			k = divfk( f1, 10, 0 );
			f1->ne++;
		}
	}
	tz = f1->ne;
	f1->ne = 0;
	if( sgn1 != sgn2 ) negs( f2->nf, NF );
	sgn2 = (f1->nf[NF-1] ^ f2->nf[NF-1]) & 0x80;
	if( k >= 5 ) k = 1;
	k = addss( f1->nf, NF, f2->nf, NF, k );
	if( !isnzf(f1) ) return;			/* result zero	*/
	if( sgn2 == 0 && (f1->nf[NF-1] ^ f2->nf[NF-1]) & 0x80 ){ /* overflow*/
		if( k ) negs( f1->nf, NF );
		divfk( f1, 10, 0);
		tz++;
		if( k ) negs( f1->nf, NF );
	}
	sgn1 ^= absf(f1);				/* now normalize */
	while( (k = divfk(f1,10,0)) == 0 ) tz++;
	mul10fk( f1, k );				/* restore	 */
	f1->ne += tz;
	if( sgn1 ) negs( f1->nf, NF );
}

subff( f1, f2 ) reg FPN *f1, *f2; {
	FPN	f3;

#ifdef BADCODE
	f3 = *f2;
#else
	mvb( &f3, f2, sizeof(FPN) );
#endif
	negs( f3.nf, NF );
	addff( f1, &f3 );
}

mulff( f1, f2 ) FPN *f1, *f2; {
	reg		i,j;
	reg uns		k;
	reg char	*s;
	reg char	*se;
	char		sb[NF+NF];	/* intermediate multiply buffer	*/
	short		sgn1,		/* sign of f1			*/
			sgn2,		/* sign of f2			*/
			l,
			e;
	FPN		f3;

	if( !isnzf(f1) || !isnzf(f2) ) goto rz;	/* one operand is zero	*/
#ifdef BADCODE
	f3 = *f2;
#else
	mvb( &f3, f2, sizeof(FPN) );
#endif
	f2 = &f3;
	sgn1 = absf( f1 );
	sgn2 = absf( f2 );
#ifdef FLODEB1
	dprt("mulff	");sdump(f1->nf,NF);dprt("	");sdump(f1->nf,NF);
#endif
	for( i=0; i<NF+NF; i++ ) sb[i] = 0;	/* clear buffer		*/

	/* now form the double length product				*/

	for( i=0; i<NF; i++ ){
		k = 0;
		s = sb+i;
		l = NF+NF-i;
		for( j=0; j<NF; j++ ){
			k += (f1->nf[i] & 0xff) * (f2->nf[j] & 0xff);
			addsk( s, l, k & 0xff );
			s++;
			l--;
			k = (k>>8) & 0xff;
		}
	}

	/* now reduce it to normal form					*/
#ifdef FLODEB1
	dprt("bef red: ");sdump(sb,NF+NF);
#endif
	e = 0;
	k = 0;
	while( isnzs( sb+NF,NF ) || sb[NF-1] & 0x80 ){	/* make high part 0 */
		e++;
		k = divsk( sb, NF+NF, 10, 0 );
	}
#ifdef FLODEB1
/*DEB*/dprt("red: k = %d ",k);sdump(sb,NF+NF);
#endif
	if( k >= 5 ) addsk( sb, NF, 1 );	/* rounding step	*/
	if( sb[NF-1] & 0x80 ){			/* still overflow	*/
		e++;
		divsk( sb, NF+NF, 10, 0 );
	}
	f1->ne += f2->ne + e;
	mvb( f1->nf,sb,NF);			/* copy in mantissa	*/
	if( !isnzf( f1 ) ) goto rz;		/* check for zero	*/
	while( (k = divsk( f1->nf, NF, 10, 0 )) == 0 ) f1->ne++;
	mulsk( f1->nf, NF, 10, k );
	if( sgn1 ^ sgn2 ) negs( f1->nf, NF );
	return;

rz:	zerof( f1 );
}

zerof( f ) reg FPN *f; {
	reg uns char	*s,
			*se;

	f->ne = 0;
	for( s=f->nf, se = s+NF; s<se; s++ ) *s = 0;
}

#ifdef FUTURE
/* compare two numbers */
/* return -1 if f1 < f2
   return  0 if f1 = f2
   return +1 if f1 > f2
 */
cmpff( f1, f2 ) FPN *f1, *f2; {
	FPN	f3;
	FPN	f4;
#ifdef BADCODE
	f3 = *f1;
	f4 = *f2;
#else
	mvb( &f3, f1, sizeof(FPN) );
	mvb( &f4, f2, sizeof(FPN) );
#endif
	/* check if negative */
	if( isnegf(f1) ) {
		/* f1 is neg number */
		if( isnegf(f2) ) {
			/* f1 and f2 are negative */
			subff(&f3, &f4);	/* f3 has result */
			/* if f3 is negative f1 < f2 */
			if (isnegf(&f3)) return(-1);
			/* if f3 is positive, f1 > f2 */
			if(isnzf(&f3)) return(1);
			/* f3 = f4 */
			return(0);
		} else {
			/* f1 is negative & f2 is positive number */
			return(-1);	/* f1 < f2 */
		}
	} else {
		/* f1 is positive number */
		if( isnegf(f2) ) {
			/* f1 is positive & f2 is negative */
			return(1);	/* f1 > f2 */
		} else {
			/* f1 and f2 are positive number */
			subff(&f3, &f4);	/* f3 has result */
			/* if f3 is negative f1 < f2 */
			if (isnegf(&f3)) return(-1);
			/* if f3 is positive, f1 > f2 */
			if(isnzf(&f3)) return(1);
			/* f3 = f4 */
			return(0);
		}
	}
}
#endif /* FUTURE */

/* grit your teeth, here comes divide */
divff( f1, f2 ) FPN *f1, *f2; {
	reg		k;
	char		x1[ NF+1 ],		/* multiples of divisor	*/
			x2[ NF+1 ],
			x4[ NF+1 ],
			x8[ NF+1 ],
			di[ NF+1 ];		/* dividend hold cell	*/
	short		sgn1,
			sgn2;
	FPN		f3;

	if( !isnzf( f1 ) ||			/* dividend is zero	*/
	    !isnzf( f2 ) ) return;		/* divisor is zero	*/
#ifdef BADCODE
	f3 = *f2;
#else
	mvb( &f3, f2, sizeof(FPN) );
#endif
	f2 = &f3;
	sgn1 = absf( f1 );
	sgn2 = absf( f2 );
	
	k = f1->ne - f2->ne;
	mvb( di, f1->nf, NF );
	di[NF] = 0;
	zerof( f1 );
	mvb( x1, f2->nf, NF );
	x1[NF] = 0;
	f1->ne = k+1;
	while( cmpss( di, NF+1, x1, NF+1 ) > 0 ){
		mulsk( x1, NF+1, 10, 0);
		f1->ne++;
	}
	mvb( x2, x1, NF+1 );
	addss( x2, NF+1, x1, NF+1, 0 );		/* form 2 * divisor	*/
	mvb( x4, x2, NF+1 );
	addss( x4, NF+1, x2, NF+1, 0 );		/* form 4 * divisor	*/
	mvb( x8, x4, NF+1 );
	addss( x8, NF+1, x4, NF+1, 0 );		/* form 8 * divisor	*/

	while( isnzs( di, NF+1 ) && f1->nf[NF-1] <= 12 ){
		k = 0;
		if( cmpss(di,NF+1,x8,NF+1) >= 0 ){
			k += 8;
			subss(di,NF+1,x8,NF+1,0);
		}
		if( cmpss(di,NF+1,x4,NF+1) >= 0 ){
			k += 4;
			subss(di,NF+1,x4,NF+1,0);
		}
		if( cmpss(di,NF+1,x2,NF+1) >= 0 ){
			k += 2;
			subss(di,NF+1,x2,NF+1,0);
		}
		if( cmpss(di,NF+1,x1,NF+1) >= 0 ){
			k += 1;
			subss(di,NF+1,x1,NF+1,0);
		}
		mul10fk( f1, k );
		f1->ne--;
		mulsk( di, NF+1, 10, 0 );
	}
	if( sgn1 ^ sgn2 ) negf( f1 );
}

static int
cmpss( s1, n1, s2, n2 ) reg char *s1, *s2; {
	reg char	*se1,
			*se2;
	reg		i;

	se1 = s1 + n1;
	se2 = s2 + n2;
	while( n1 > n2 ) if( n1--,*--se1 ) return 1;
	while( n2 > n1 ) if( n2--,*--se2 ) return -1;
	while( se1 > s1 )
		if( (i = (*--se1 & 0xff) - (*--se2 & 0xff)) != 0 ) return i;
	return 0;
}

static int
subss( s1, n1, s2, n2, k ) reg char *s1, *s2; reg uns k;{
	reg char	*se1,
			*se2;

	if( n2 > n1 ) n2 = n1;
	se1 = s1 + n1;
	se2 = s2 + n2;
	while( s2 < se2 ){
		k += (*s1 & 0xff) - (*s2++ & 0xff);
		*s1++ = k;
		k >>= 8;
	}
	while( s1 < se1 ){
		if( k == 0 ) return 0;
		k += (*s1 & 0xff);
		*s1++ = k;
		k >>= 8;
	}
	return k;
}

static int
addss( s1, n1, s2, n2, k ) reg char *s1, *s2; reg uns k;{
	reg char	*se1,
			*se2;

	if( n2 > n1 ) n2 = n1;
	se1 = s1 + n1;
	se2 = s2 + n2;
	while( s2 < se2 ){
		k += (*s1 & 0xff) + (*s2++ & 0xff);
		*s1++ = k;
		k >>= 8;
	}
	while( s1 < se1 ){
		if( k == 0 ) return 0;
		k += (*s1 & 0xff);
		*s1++ = k;
		k >>= 8;
	}
	return k;
}

/*	now a couple of conversions	*/
long
ftoi(f,rnd) reg FPN *f; {
	FPN	f1;
	reg	i;
	reg	j;
	short	sign;
	long	v;

	mvb( &f1, f, sizeof(FPN) );
	sign = absf( &f1 );
	i = 0;
	j = f1.ne;
	while( j > 0 ) mulsk( f1.nf, NF, 10, 0 ), j--;
	while( j < 0 ) i = divsk( f1.nf, NF, 10, 0 ), j++;
	if( rnd && i >= 5 ) addsk( f1.nf, NF, 1 );
	for( i=3; i>=0; i-- ) v <<= 8, v |= f1.nf[i] & 0xff;
	if( sign ) v = -v;
	return v;
}

#ifdef FLODEB
/*DEB*/
static char psb[32];

sdump(s,n) reg char *s; reg n; {
	mvb( psb, s, n );
	sdec( psb,n );
	putchar( '\n' );
}

sdec( s, n ){
	reg i;

	i = divsk( s, n, 10, 0 );
	if( isnzs( s, n ) ) sdec( s, n );
	putchar( i+'0' );
}
#endif

#ifdef JUNK
static void
norm( F )
FPN *F;
{
	register int	i;
	register uns int j=0;

	if (!isnzf (F)) return;		/* zero, return */
	while( F->nf[NF-1] == 0 ){
		for( i=(NF-2); i>=0; i-- ) F->nf[i+1] = F->nf[i];
		F->nf[0] = 0;
		F->ne -= 8;
	}
	while( F->nf[NF-1] <= 63 ){
		for( i=0; i<NF; i++ )
		   j |= F->nf[i] << 1, F->nf[i] = j & 0xff, j >>= 8;
		F->ne--;
	}
	while( (unsigned char)F->nf[NF-1] > 127 ) frsh( F ), F->ne++;
}

static void
frsh( F )
FPN *F;
{
	register int	i;
	register uns int j=0;

	for( i=NF-1; i>= 0; i-- )
	    j |= F->nf[i], F->nf[i] = j >> 1, j = (j << 8) & 0x100;
}
#endif /* JUNK */

itod( num, F )		/* convert int to double */
int num;
FPN *F;
{
	register int	i;
	int	sign;

	zerof( F );
	sign = 0;

	if(num == 0) return;
	if( num < 0 ) sign++, num = -num;
	for( i=0; i<4; i++ ) F->nf[i] = num & 0xff, num >>= 8;
	for( ; i<NF; i++ ) F->nf[i] = 0;
#ifdef JUNK
	norm( F );
#endif
	if( sign ) negf( F );
}

uitod( num, F )		/* convert unsigned int to double */
unsigned int num;
FPN *F;
{
	register int	i;

	zerof( F );

	if(num == 0) return;
	for( i=0; i<4; i++ ) F->nf[i] = num & 0xff, num >>= 8;
	for( ; i<NF; i++ ) F->nf[i] = 0;
#ifdef JUNK
	norm( F );
#endif
}
#endif /* MYATOF */
