/* goasm.c */

#include "defs.h"
/* #define DEBUG */
/* #define DBUG1 */
/* #define DDUMP */

#ifdef DOS
#include <string.h>
#include <io.h>
int	goasm(char);
void	tall();
void	prtval (char *, struct tval *);
void	next();
void	aerr();
void	cext();
void	rset(char);
char * csnegate (char *);
void	ascttst(struct optab *);
void	stab();
void	dtonly();
void	enddt();
int	yeanay();
void	clrerr (char);
void	seterr (char);
void	bndwnopg();
void	cdl();
void	rtb();
void	ler();
void	calm();
void	shf();
void	nss();
void	trsw();
void	zrx();
void	nords();
void	setcpu();
void	rro();
void	gen16 (int, int, int);
void	gen16a (int, int, int, int);
void	agen();
void	agem(int32);
void	gen32 (int, int, int32);
void	bm();
void	bi();
void	bu();
void	fpp();
void	trip();
void	exr();
void	imop();
void	io();
void	svc();
void	trap();
void	extio();
void	bndw();
int32	ageq0(int32, int);
int32	ageq(int32, int);
void	pend();
void	prlit();
void	end2();
void	bfo(struct symbol FAR *);
void	bfn();
void	bfn0();
#ifndef CAID
void	bfn0a();
#endif
void	bfa0 (int32);
void	bfa (int32);
#ifndef CAID
void	bfw (int32);
void	bfh(int);
#endif
void	bfb(int);
void	data();
void	vfd();
void	vfdo(int32, int);
#endif

char	bacflag;		/* biased address flags */
    				/* 1 - BACX read */
    				/* 2 - CSECT address
    				/* 4 - EXTERNAL address */
    				/* 64 - REZ/RES being processed */
char	extflg;			/* external stringback control flag */
    				/* 1 - ext ref record needed */
    				/* 2 non-branch instruction flag */
struct tval extwrd;		/* stringback control address */
char	extnam[8];		/* stringback control symbol */
char	fpflag;			/* IEEE flags */
char	dpflags;		/* datapool flags */
char	endflag;		/* non zero when end card read */
char	end2flag;		/* non zero when pass2 end processed */
char	usname[MAXCHARS];	/* contains 24 chars of ascii name that was */
				/* last unstrung by main unstringer routine */
char	prnt[41];		/* printf buffer */
unsigned char	in[81];		/* input line buffer */

unsigned char	hwbyte[4];	/* this word contains the generated code */
				/* for the current line of assembly broken */
				/* down into up to 4 bytes. this word is */
				/* set up as if it would map into the h */
				/* memory, i.e. the left most byte is for */
				/* byte 0, the rightmost bytes is for by */
				/* the 3 of the word address contained in */
				/* lsts */
char	hwbytf[4];		/* each byte in this word contains a flag */
				/* telling whether the corresponding byte */
				/* of hwbyte contains a valid byte for output */
struct	tval hweval;		/* the mode evaluation of the word in hwbyte */
				/* It is is symbol description format */
char	hbstac[4];		/* left to right terminator list */
short	macstate;		/* macro expansion flags */
char	label[9];		/* 8 char label if any */
short	bits;			/* misc bits for print control */
char	hbavar;			/* holds addr variant to be used */
char	hbbn;			/* common block/section number */
char	hbbbfb;			/* 0 means no data bytes output */
char	hbbbct;			/* NUMBER OF BYTES GENERATED FOR THIS  */
				/* LINE OF SOURCE OR OBJECT */
#ifndef CAID
unsigned char	hbbs[120];	/* binary output stack and count */
				/* first byte is count, then data */
#else
unsigned char	hbbs[80];	/* binary output stack and count */
				/* first byte is count, then data */
#endif
char	pcmode;			/* current program mode */
int32	lict;			/* current line counter */
int32	bits2;			/* holds some misc flags */
/* char	bits4;			/* uninitialized flags */
char	lablscan[8];		/* label we are scanning for */
char	csname[] = "**CSECT*";
char	dsname[] = "**DSECT*";

struct	tval hwbbls;		/* contains PC for bin output routn */
struct	tval currpc;		/* address and sect info for this line */
struct	tval sectpc[4];		/* ABS, DATA, COMM, and CNTL */
				/* section counters in std sym format */
struct	tval	dsize;		/* dsect size for section definition */
struct	tval	csize;		/* csect size for section definition */
int32	hwact;			/* current state information */
char	mpbuf[80];		/* macro expansion buffer */
short	inptstat;		/* macro states for inpt */
int32	inttag;			/* internal tag number */
char	*hwmsp;			/* macro definition area */
/* char	*hwmsb;			/* holds base of macro area */
char	hwmspbuf;		/* count of chars in print buffer */
int32	hwerrf;			/* error flags */
int32	hwcmpb[2];		/* bounding for dsect/csect */

unsigned char	spmac;		/* HOLDS FLAGS FOR SPECIAL CONDITIONS */
				/* IN MACRO PROCESSING. */
char	tot;			/* LENGTH CONSTANT FOR TDAT */
				/* TOT=1,2,4,OR 8 DEPENDING ON DATA BND */
char	hbtttf;			/* VALUE IS A POINTER  FOR DATA BEING */
				/* GENERATED BY THE TRANSLATORS, */
				/* 0 MEANS FOR DATA, 1 FOR GEN, 2 */
				/* FOR LITERALS, 3 FOR VALUE EXPRESSION */

short	hbccct;			/* common block count 0-255 */
struct	tval	inag;		/* augend type and value */
struct	tval	inac;		/* accumuland type and value */
struct	tval	accum;		/* 2nd accumuland type and value */
char	inagbn;			/* block # for common */
char	inacbn;			/* block # for common */

int32	hwcmsize[256];		/* save area for common pc's */

extern struct tval max;		/* defined in io.c */

/* address masks for f & cc bit generation */
int32	ager [] = {
	0x0007FFFFL,		/* byte address mask */
	0x0107FFFEL,		/* halfword adr mask and error mask */
	0x0307FFFCL,		/* word addr mask and error mask */
	0x0707FFFCL,		/* doublword adr mask and error mask */
	0x0007FFFFL,		/* full range adr mask */
	0x000FFFFFL,		/* adr mask to leave adr as is */
	0x0307FFFCL,		/* base reg mode mask */
	0x0007FFFFL,		/* full range for suabr */
	0x0007FFFFL		/* full range for labr */
};

/* address masks for f & cc bit generation */
int32	ages [] = {
	0x00080000L,		/* byte f and cc bits */
	1L,			/* halfword f and cc bits */
	0L,			/* word f and cc bits */
	2L,			/* double word f and cc bits */
	0L,			/* a type f and cc bits (pseudos only) */
	0L,			/* leave f and cc bits as they are */
	0x00080000L,		/* base reg mode needs f bit */
	0L,			/* suabr doesn't need f bit */
	0x00080000L		/* labr does need f bit */
};

/*
 * assemble code
 */

void	aerr();		/*	00    ENTRY  0 - ERROR			*/
void	nss();		/*	01    ENTRY  1 - NOP,HALT,WAIT		*/
void	calm();		/*	04    ENTRY  2 - CALL MONITOR 		*/
void	bm();		/*	05    ENTRY  3 - SBM,ZBM,ABM,TBM	*/
void	rro();		/*	06    ENTRY  4 - REG-TO-REG OPS 	*/
void	ler();		/*	07    ENTRY  5 - LCS,ES,RND		*/
void	trsw();		/*	08    ENTRY  6 - TRSW 			*/
void	rtb();		/*	09    ENTRY  7 - SBR,TBR,ABR,ZBR 	*/
void	shf();		/*	10    ENTRY  8 - SHIFTS 		*/
void	nords();	/*	11    ENTRY  9 - NOR,NORD,SCZ		*/
void	zrx();		/*	12    ENTRY 10 - ZR 			*/
void	trip();		/*	14    ENTRY 12 - TRP,TPR		*/
void	agen();		/*	15    ENTRY 13 - MOST MEMORY REFS. 	*/
void	bu();		/*	16    ENTRY 14 - BU,BFT,ZM ,EXM, 	*/
void	bi();		/*	17    ENTRY 15 - BIB,BIW,BIH,BID 	*/
void	fpp();		/*	18    ENTRY 16 - FLOATING PNT. OPS 	*/
void	imop();		/*	19    ENTRY 17 - IMMEDIATE OPS 		*/
void	exr();		/*	20    ENTRY 18 - EXR,EXRR,LMAP 		*/
void	cdl();		/*	21    ENTRY 19 - CDL SEMI-PSEUDO	*/
void	io();		/*	22    ENTRY 20 - CD,TD,EI,DI,RI,AI,DAI 	*/
void	bacx();		/*	23    ENTRY 21 - BACH,BACW		*/
void	zmx();		/*	24    ENTRY 22 - ZMB,ZMH,ZMW,ZMD	*/
void	data();		/*	29    ENTRY 22 - DATA,DATA{B,H,W,D}	*/
void	vfd();		/*	30    ENTRY 23 - GEN PSEUDO		*/
void	rseis();	/*	33    ENTRY 24 - REIS/SEIS IN NON- BASE	*/
void	pend();		/*	34    ENTRY 25 - END			*/
void	prog();		/*	35    ENTRY 26 - PROGRAM		*/
void	ref();		/*	36    ENTRY 27 - EXT, DEF, SDEF		*/
void	org();		/*	37    ENTRY 28 - ORG			*/
void	arel();		/*	38    ENTRY 29 - ABS, REL, DSECT, CSECT	*/
void	bound();	/*	39    ENTRY 30 - BOUND			*/
void	equ();		/*	40    ENTRY 31 - EQU			*/
void	res();		/*	41    ENTRY 32 - RES			*/
void	ccp1();		/*	42    ENTRY 33 - COMMON			*/
void	titl();		/*	43    ENTRY 34 - TITLE			*/
void	pagp();		/*	44    ENTRY 35 - PAGE			*/
void	list();		/*	45    ENTRY 36 - LIST			*/
void	space();	/*	46    ENTRY 37 - SPACE			*/
void	sdirs();	/*	47    ENTRY 38 - S DIRECTIVES		*/
void	next();		/*	48    ENTRY 39 - ANOP, SEIS/REIS BASE	*/
void	ifpro();	/*	49    ENTRY 40 - IFT,IFF,IFP,IFA	*/
void	defmpro();	/*	50    ENTRY 41 - DEFM			*/
void	endmpro();	/*	51    ENTRY 42 - ENDM 			*/
void	setpro();	/*	52    ENTRY 43 - SET,SETF,SETT, 	*/
			/*			 OPTS,OPTR,OPTT		*/
void	gotop();	/*	53    ENTRY 44 - GOTO			*/
void	endrp();	/*	54    ENTRY 45 - ENDR			*/
void	reptp();	/*	55    ENTRY 46 - REPT			*/
void	exitmp();	/*	56    ENTRY 47 - EXITM			*/
void	formp();	/*	57    ENTRY 48 - FORM			*/
#ifndef CAID
void	stab();		/*	61    ENTRY 61 - .STAB,.COM,.SRC,.SYM	*/
			/*			 .END,.XEQ,.ARG,.STABC	*/
#endif
void	dtonly();	/*	62    ENTRY    - DATAONLY		*/
void	enddt();	/*	63    ENTRY    - ENDDATA		*/
void	lpop();		/*	64    ENTRY 49 - LPOOL			*/
void	rez();		/*	65    ENTRY 50 - REZ			*/
void	equ();		/*	66    ENTRY    - DEQU			*/
void	org();		/*	67    ENTRY    - DORG			*/
void	setcpu();	/*	71    ENTRY 51 - SETCPU,RDSTS, 		*/
			/*			 RPSWT,SMC,CMC		*/
void	svc();		/*	72    ENTRY 52 - SVC			*/
void	trap();		/*	73    ENTRY 53 - TC			*/
void	extio();	/*	74    ENTRY 54 - EXTIO			*/
void	rsc1();		/*	75    ENTRY 55 - RISC STYLE F.P.	*/
void	rsc2();		/*	76    ENTRY 56 - RISC WAITS		*/
void	revrro();	/*	77    ENTRY 57 - RISC REG-TO-REG	*/
void	fpctx();	/*	78    ENTRY 58 - RISC F.P. CONTEXT	*/
void	cf2d();		/* 	79    Entry 79 - cvt flt to dbl		*/
void	cd2f();		/*      80    Entry 80 - cvt dbl to flt		*/

/*
 * opcode switcher table
 *
 */

struct swdata switcher[] = {

	aerr,	/*	00    ENTRY  0 - ERROR			*/
	nss,	/*	01    ENTRY  1 - NOP,HALT,WAIT		*/
	aerr,	/*	02    ENTRY    - SPARE			*/
	aerr,	/*      03    ENTRY    - SPARE 			*/

#define	KINTL1	4	/* no auto operand stripping lower boundry */

	calm,	/*	04    ENTRY  2 - CALL MONITOR 		*/
	bm,	/*	05    ENTRY  3 - SBM,ZBM,ABM,TBM	*/
	rro,	/*	06    ENTRY  4 - REG-TO-REG OPS 	*/
	ler,	/*	07    ENTRY  5 - LCS,ES,RND		*/
	trsw,	/*	08    ENTRY  6 - TRSW 			*/
	rtb,	/*	09    ENTRY  7 - SBR,TBR,ABR,ZBR 	*/
		/*			 ZBDMS,SBDMS       	*/
	shf,	/*	10    ENTRY  8 - SHIFTS 		*/
	nords,	/*	11    ENTRY  9 - NOR,NORD,SCZ		*/
	zrx,	/*	12    ENTRY 10 - ZR 			*/
	bu,	/*	13    ENTRY 11 - AC? (TREAT AS BU) 	*/
	trip,	/*	14    ENTRY 12 - TRP,TPR		*/
	agen,	/*	15    ENTRY 13 - MOST MEMORY REFS. 	*/
	bu,	/*	16    ENTRY 14 - BU,BFT,ZM ,EXM, 	*/
	bi,	/*	17    ENTRY 15 - BIB,BIW,BIH,BID 	*/
	fpp,	/*	18    ENTRY 16 - FLOATING PNT. OPS 	*/
	imop,	/*	19    ENTRY 17 - IMMEDIATE OPS 		*/
	exr,	/*	20    ENTRY 18 - EXR,EXRR,LMAP 		*/
	cdl,	/*	21    ENTRY 19 - CDL SEMI-PSEUDO	*/
	io,	/*	22    ENTRY 20 - CD,TD,EI,DI,RI,AI,DAI 	*/
	bacx,	/*	23    ENTRY 21 - BACH, BACW		*/
	zmx,	/*	24    ENTRY 22 - ZMB,ZMH,ZMW,ZMD	*/
	aerr,	/*	25    ENTRY    - SPARE			*/
	aerr,	/*	26    ENTRY    - SPARE			*/
	aerr,	/*	27    ENTRY    - SPARE			*/
	aerr,	/*	28    ENTRY    - SPARE			*/

#define KINTL2	29	/* no auto operand stripping upper boundry */

	data,	/*	29    ENTRY 22 - DATA,DATA{B,H,W,D}	*/
	vfd,	/*	30    ENTRY 23 - GEN PSEUDO		*/
	aerr,	/*	31    ENTRY    - SPARE			*/
	aerr,	/*	32    ENTRY    - SPARE			*/

#define KINTL3	33	/* bounding checks lower boundry */

	rseis,	/*	33    ENTRY 24 - REIS/SEIS IN NON- BASE	*/
	pend,	/*	34    ENTRY 25 - END			*/
	prog,	/*	35    ENTRY 26 - PROGRAM		*/
	ref,	/*	36    ENTRY 27 - EXT, DEF, SDEF		*/
	org,	/*	37    ENTRY 28 - ORG			*/
	arel,	/*	38    ENTRY 29 - ABS, REL, DSECT, CSECT	*/
	bound,	/*	39    ENTRY 30 - BOUND			*/
	equ,	/*	40    ENTRY 31 - EQU			*/
	res,	/*	41    ENTRY 32 - RES			*/
	ccp1,	/*	42    ENTRY 33 - COMMON			*/
	titl,	/*	43    ENTRY 34 - TITLE			*/
	pagp,	/*	44    ENTRY 35 - PAGE			*/
	list,	/*	45    ENTRY 36 - LIST			*/
	space,	/*	46    ENTRY 37 - SPACE			*/
	sdirs,	/*	47    ENTRY 38 - S DIRECTIVES		*/

#define KINTLN1	48	/* lower boundry of nong supressed entries */	

	next,	/*	48    ENTRY 39 - ANOP, SEIS/REIS BASE	*/
	ifpro,	/*	49    ENTRY 40 - IFT,IFF,IFP,IFA	*/
	defmpro,/*	50    ENTRY 41 - DEFM			*/
	endmpro,/*	51    ENTRY 42 - ENDM 			*/
	setpro,	/*	52    ENTRY 43 - SET,SETF,SETT, 	*/
		/*			 OPTS,OPTR,OPTT		*/
	gotop,	/*	53    ENTRY 44 - GOTO			*/
	endrp,	/*	54    ENTRY 45 - ENDR			*/
	reptp,	/*	55    ENTRY 46 - REPT			*/
	exitmp,	/*	56    ENTRY 47 - EXITM			*/
	formp,	/*	57    ENTRY 48 - FORM			*/
	aerr,	/*	58    ENTRY 58 - SPARE			*/
	aerr,	/*	59    ENTRY 59 - SPARE			*/

#define KINTLN2	59	/* upper boundry of nong supressed entries */

	aerr,	/*	60    ENTRY 60 - SPARE			*/
#ifndef CAID
	stab,	/*	61    ENTRY 61 - .STAB			*/
#else
	aerr,	/*	61    ENTRY 61 - SPARE			*/
#endif
	dtonly,	/*	62    ENTRY 62 - DATAONLY		*/
	enddt,	/*	63    ENTRY 63 - ENDDATA		*/
	lpop,	/*	64    ENTRY 64 - LPOOL			*/
	rez,	/*	65    ENTRY 65 - REZ			*/
	equ,	/*	66    ENTRY 66 - DEQU			*/
	org,	/*	67    ENTRY 67 - DORG			*/
	equ,	/*	68    ENTRY 68 - CEQU			*/
	org,	/*	69    ENTRY 69 - CORG			*/
	aerr,	/*	70    ENTRY 70 - SPARE			*/

#define KINTL4	71	/* end of the operation processes */

	setcpu,	/*	71    ENTRY 51 - SETCPU,RDSTS, 		*/
		/*			 RPSWT,SMC,CMC		*/
	svc,	/*	72    ENTRY 52 - SVC			*/
	trap,	/*	73    ENTRY 53 - TC			*/
	extio,	/*	74    ENTRY 54 - EXTIO			*/
	rsc1,	/*	75    ENTRY 55 - RISC STYLE F.P.	*/
	rsc2,	/*	76    ENTRY 56 - RISC WAITS		*/
	revrro, /*	77    ENTRY 57 - RISC REG-TO-REG	*/
	fpctx, 	/*	78    ENTRY 58 - RISC F.P. CONTEXT	*/
/*	aerr, *//*	79    ENTRY    - SPARE			*/
	cf2d,	/* 	79    Entry 79 - cvt flt to dbl		*/
	cd2f,	/*      80    Entry 80 - cvt dbl to flt		*/
};

static	struct	tval	macr = {	/* macro request entry */
		TYMACREQ,	/* type is macro request */
		0,		/* dsect/abs */
		0,		/* not used */
		0		/* no value */
};

#ifdef DDUMP
/* Dump the stack */
DumpStk(sp, n)
unsigned short *sp;
int n;
{
	int i;

	printf("Stack addr %x, dumping %d bytes\n", sp, 2*n);
	for (i=0; i<n; i++) {
		if (i % 8 == 0)
			printf("%0.8x |", &sp[-(n - (i+1))]);
		printf(" %0.4x", sp[-(n - (i+1))]);
		if (i > 0 && (i+1) % 8 == 0)
			printf("\n");
	}
	for (i=0; i<n; i++) {
		if (i % 8 == 0)
			printf("%0.8x |", &sp[(i+1)]);
		printf(" %0.4x", sp[(i+1)]);
		if (i > 0 && (i+1) % 8 == 0)
			printf("\n");
	}
	printf("\n");
}
#endif

/*
 * goasm - process a file
 * input - current pass number 
 * output - return non zero for EOF/EOM
 *
 */

struct optab *curops;	/* current opcode table entry pointer */

int	goasm(cpass)
char	cpass;
{
	struct optab *ops;		/* opcode table entry pointer */
	struct symbol FAR *stp;		/* symbol table entry pointer */
	int	tvar;			/* just a temp */
	unsigned short *Sptr;		/* stack pointer */
#ifdef DDUMP
	Sptr = (unsigned short *)&cpass;	/* address */
	DumpStk(Sptr,64);
#endif

	end2flag = 0;			/* pass 2 end not processed yet */
	rset(cpass);			/* initialize assembler for this pass */
	cext();				/* clear ouput buffer and flags */

	/* all routines must return here for next directive */
	for(;;) {			/* loop forever */
	  if (end2flag) {		/* pass2 ended, return */
#ifdef DBUG
printf("returning to main from goasm, got end\n");
fflush(stdout);
#endif
	    return(0);			/* pass2 ended, return */
    	  }
	  if (!(lict = inpt())) {	/* get line of input */
	    if (endflag) {		/* if last card end, O.K. */
#ifdef DBUG
printf("returning to main from goasm, got endflag\n");
fflush(stdout);
#endif
    		return(0);		/* if last card end, O.K. */
    	    }
	    /* last line of input no end, give error */
	    abortm("EOF WITHOUT END CARD");
	    /* no return */
	  }
	  in[80] = 0;			/* for now terminate with null */
#ifdef DBUG1
printf("%x |%.80s\n",currpc.value, in);
DumpStk(Sptr,64);
#endif
	  asctflg &= ~ASCTNOD;		/* allow $ to be legal */
	  bits2 &= ~NONGITEM;		/* clear list nong supp flag */
    	  bacflag &= ~4;		/* clear BAC external flag */
	  endflag = 0;			/* no end card yet */
    	  for (tvar=0; tvar <72; tvar++)  /* see if blank line */
    	    if(in[tvar] != ' ')goto doone;  /* assemble if something there */
    	  macstate |= BLANKLN;		/* we have a blank line, ignore */
    	  continue;
doone:
	  if (*in == '*') {		/* if comment, do next line */
    	    if(option & OPT56) {	/* see if are to not print *! */
    	      if (in[1] == '!') {	/* see if *! */
    		macstate |= BLANKLN;	/* we want to ignore the line */
    	      }
    	    }
    	    continue;
    	  }
	  macstate |= NOCOMMT;		/* not a comment line */
	  runst(0x80000000L);		/* unstring label, terminate on space */
#ifdef DBUG
printf("returning from runst usname = %0.8s, currpc.value = %x\n",
 usname, currpc.value);
#endif
	  memcpy (label, usname, 8);	/* move 8 bytes of label */
	  label[8] = '\0';
	  macstate &= ~INTGEN;		/* not generating an internal label */
	  if (!strncmp(lablscan, label, 8))	/* see if this is the label */
	    macstate &= ~CONDSCAN;	/* we found it, clear cond scan */
	  unst(0x80000000L);		/* unstring operator, term on space */
#ifdef DBUG
printf("returning from unst usname = %0.8s, currpc = %x\n",
 usname, currpc.value);
#endif
	  /* go see if macro defined in symbol table */
	  stp = ss (&macr, csnegate(usname));  /* go lookup macro name */
#ifdef DBUG
printf("returning from ss, stp = %x, value = %d\n", stp, (stp ? stp->desc.value : -1));
#endif
	  if (stp) {			/* the macro was found, check type */
#ifdef DBUG
printf("switcher: macro found\n");
printf("returning from ss, macro = %0.8s, stp = %x, value = %d\n", usname, stp, (stp ? stp->desc.value : -1));
#endif
	    dmstp = (struct symbol FAR *)stp->desc.value; /* ptr to macss ptr */

	    /* if macro, do macro expansion */
	    if (stp->desc.type == TYMACDEF) macexp(); /* macro expansion */
	    else
	    /* if form, do form expansion */
	    if (stp->desc.type == TYFRM) formexp();	/* form expansion */
	    continue;			/* continue with next line */
	  }
	  /* not a macro, see if opcode */
	  if (ops = opscan(usname)) {	/* check for a valid opcode */
#ifdef MACP
printf("returning from opscan, ops = %x, opcode = %s, opproc = %d, currpc = %x\n",
 ops, ops->opcode, ops->opproc, currpc.value);
#endif
	    /* we have a valid opcode */
	    if (option & ASECT) ascttst(ops); /* if auto mode, do setup */
/* printf("option = %x\n", option); */
	    curops = ops;		/* save opcode table pointer for all */
#ifdef __alpha
	    hwact = (((unsigned int)ops->binop) << 24) |
		ops->aug << 20 | ops->varcode << 16 | ops->fieldnum << 12 |
		ops->subaug << 8 | ops->opproc;
#else
	    hwact = (int32)(((int32*)curops)[3]); /* get all of opcode descr */
/*	    hwact = (int32)*((int*)curops->binop);  /* get all of opcode descr */
#endif
	    hbavar = ops->varcode;	/* set address variant code */
	    tvar = ops->opproc;		/* get processor number for opcode */

    	    /* see if non branch csect reference */
    	    if (tvar == 15 ||		/* mem reference */
    	      tvar == 5 ||		/* bin in mem instruction */
    	      tvar == 18 ||		/* floating point instruction */
    	      tvar == 24)		/* zero mem instruction */
    	      extflg |= 2;		/* show as non br csect ref */
	    /* see if opcode is list nong supressable */
	    if (tvar >= KINTLN1 && tvar <= KINTLN2)	/* see if in range */
	      bits2 |= NONGITEM;	/* mark as list nong supressable */

	    /* see if we need to allocate label */
	    if (tvar < KINTL3 || tvar >= KINTL4) {	/* allocate label */
	      bndw();			/* adj to proper boundry for opcode */
#ifdef DBUG
printf("calling tall from main with label %0.8s, pcmode = %x\n",label, pcmode);
fflush(stdout);
#endif
	      tall();			/* allocate current label */
	      if ((tvar >= KINTL1 && tvar < KINTL2) ||
	        (tvar >= KINTL4)) {	/* we need to pick up arguments */
	        grps();			/* get the arguments */
					/* they are put in HWNL1 - HWNL3 */
	      }
	    } 				/* no label required */
	    /* switch out to the processing subroutine */
#ifdef DBUG1
printf("main switching to function %d\n", tvar);
DumpStk(Sptr,64);
#endif

	      switcher[tvar].function(); /* go to processing routine */
#ifdef DBUG1
printf("main returning from function %d\n", tvar);
DumpStk(Sptr,64);
#endif
	      continue;			/* do next line of input */
	  }
	  /* valid opcode not found */
#ifdef DBUG
printf ("opcode not found %0.8s, ops = %x\n", usname, ops);
#endif
	  aerr();			/* go see if a macro */
#ifdef DBUG
printf ("main return from aerr()\n");
#endif
	  continue;			/* go do next line */
	}
}

struct	tval	ud = {		/* undefined value entry */
		TYPU,		/* type is undefined */
		0,		/* dsect/abs */
		0,		/* not used */
		0		/* no value */
};

/*
 * pcchk - check for pc in dsect/csect exceeding 0x80000
 * abort assemble in exceeded
 */

void	pcchk()
{
    	/* see if pc exceeds 0x80000 in dsect or csect */
    	if (sectpc[PCDS].value >= 0x80000L ||
    	  sectpc[PCCS].value >= 0x80000L) {
    	  /* we have, abort this assemble */
	  abortm("PROGRAM COUNTER OVERFLOW, CSECT or DSECT exceeds .5MB");
	  /* no return */
    	}
}

/*
 * allocate curr label to staticized prog cntr
 * tall()
 * input - none
 */

void	tall()
{
	struct symbol FAR *stp;	/* symbol table entry pointer */
extern	char *prtyp[];

	if (*label == ' ')return;	/* return if no label */

	if (!yeanay())return;		/* return if not assembling */
	if (PASS & 1) {			/* are we in pass 1 */
/*
prtval("tall pass1", &currpc);
printf("tall pass1: label = [%0.8s], pcmode = %d\n", label, pcmode);
*/
	  /* define this label in symbol table */
	  stp = ss (&currpc, label);  	/* put in sym tab */	
/*
printf("returning from ss, stp = %x\n", stp);
prtval("tall pass1 stp ret", &stp->desc);
*/
	  return;			/* just return */
	} 				/* pass 2, check */
/*
prtval("tall pass2", &ud);
printf("tall pass2: label = [%0.8s], pcmode = %d\n", label, pcmode);
*/
	stp = ss (&ud, label);		/* check label against symbol tbl */
	if (stp && (stp->desc.value == currpc.value) && 
	  (stp->desc.type == currpc.type) &&
	  (stp->desc.flags == currpc.flags))
	  return;			/* return if same */
/*
printf("tall X error\n");
prtval("tall pass2 ud", &ud);
prtval("tall pass2 stp", &stp->desc);
printf("tall pass2: label = %0.8s, pcmode = %d\n", label, pcmode);
prtval("tall pass2 currpc", &currpc);
*/
	seterr ('T');			/* set symbol table error if diff */
	return;
}

/* prtval- pretty print a tval
 * input - a string to print
 *       - the tval pointer
 */

void	prtval (s, dvp)
char *s;
struct tval *dvp;
{
extern	char *prtyp[];
printf("%s: val = %lx, typ = %s, tmp = %x, flags = %s,%s\n",
 s, dvp->value, prtyp[dvp->type], dvp->tmp,
 (dvp->flags & CSDS ? "CSECT" : "DSECT"),
 (dvp->flags & ABSREL ? "REL" : "ABS"));
}

/*
 * next - dummy entry when nothing to do 
 */

void	next()
{
	return;			/* just return */
}

static	struct	tval	macd = {	/* macro definition entry */
		TYMACDEF,	/* type is macro definition */
		0,		/* dsect/abs */
		0,		/* not used */
		0		/* no value yet */
};

/*
 * aerr - entered for opcode not found, see if a macro
 */

void	aerr()
{
	struct symbol FAR *mep;		/* macro entry pointer */
	struct symbol FAR *stp;		/* symbol table entry pointer */

	if (yeanay()) {			/* are we assembling */
	  mep = libsch(usname);		/* go search macro library */
	  if (mep) {			/* see if macro found */
	    /* we found it, put in symbol table */
	    dmstp = mep; 		/* save the addr of the macss entry */
	    /* define this macro in symbol table */
	    macd.value = (longp)dmstp;	/* the pointer to macss entry */
	    macd.tmp = mep->desc.tmp;	/* set the count */
	    macd.flags = mep->desc.flags;	/* parameter count */
/* may need to fix for macros */
	    stp = ss (&macd, csnegate(usname)); /* put in sym tab */
	    dmstp = (struct symbol FAR *)stp->desc.value; /* ptr to macss ptr */
#ifdef MACD
printf("aerro: macro %0.8s found\n",usname);
printf("returning from ss, macro = %0.8s, stp = %x, value = %x\n",
 usname, stp, (stp ? stp->desc.value : -1));
#endif
	    macexp();			/* expand the macro */
#ifdef DBUG
printf("goasm: return from macexp\n");
#endif
	    return;			/* back to caller */
	  }
	  /* macro not in library, set error and output nop */
	  seterr ('B');			/* set bounding error */
	  curops = opscan("NOP");	/* get opcode pointer for nop */
#ifdef __alpha
	  hwact = (((unsigned int)curops->binop) << 24) |
		curops->aug << 20 | curops->varcode << 16 |
		curops->fieldnum << 12 |
		curops->subaug << 8 | curops->opproc;
#else
/*	  hwact = (int32)*((int*)curops->binop);  /* get all of opcode descr */
	    hwact = (int32)(((int32*)curops)[3]); /* get all of opcode descr */
#endif
	  nss();			/* go generate the nop */
	  return;			/* go do next line */
	}
	/* not assembling, scan off rest of line */
	do {
	  val (0);		/* unstring something */
	}
	while (*hbstac == ',');	/* unstring all parameters */
	return;			/* go do next line */
}

/*
 * cext - clear flags that were set during generation of 1 line of code
 * cext()
 * input - none
 */

void	cext()
{
	memset (prnt, ' ', 40);	/* blank out left side of print line */
	dpflags = 0;		/* clear datapool flags */
	memset (hwbytf, '\0', 4); /* clear indicators of bytes generated */
				/* clear address evaluation area */
	hweval.value = 0;	/* clear any value */
	hweval.type = 0;	/* and the type */
	hweval.flags = 0;	/* and the flags */
	bits &= ~CVFL;		/* don't want PC printed */
	hbbn = 0;		/* clear ds/cs flag */
	hbbbct = 0;		/* clear # bytes gen'd/line */
	return;
}

struct	tval	hwltct = {	/* literal definition entry */
		TYPL,		/* type is literal definition */
		0,		/* dsect/abs */
		0,		/* not used */
		0		/* no value yet */
};

/*
 * rset - initialize assembler to start any pass
 * input - pass number, 0 means pass 2, 1 means pass 1
 * output - none
 *
 */

void	rset(pass)
char	pass;
{

	PASS = pass;			/* set current pass value */
    	extflg = 0;			/* clear stringback control flag */
	memset (mpbuf, ' ', 80);	/* clear macro expansion area */
	macstate = 0;			/* clear macro status flag */
	inptstat = 0;			/* clear macro status flags */
	inttag = ((int32)(MACIU << 5) << 24);	/* unasm int sym entry type */
	hwmspbuf = 0;			/* clear store ptr for macro print */
	if (!(PASS & 1)) {		/* are we in pass 2 */
	  dsize = sectpc[1];		/* get dsect size, type */
	  csize = sectpc[3];		/* get csect size, type */
	} else				/* pass 1 */
	  hwmsp = 0;			/* zero macro storage pointer */
	hwerct = 0;			/* zero error count */
	hwerrf = 0;			/* zero error flags */
	bits2 = 0;			/* clear all bits2 flags */
	bits = 0;			/* clear bits flags */
	memset(TCWTITL, ' ',TCWTTLE-TCWTITL);	/* clear title buffer */
	if (option & ASECT)		/* sel option as function of opt 18 */
	  pcmode = PCCS;		/* set csect section */
	else
	  pcmode = PCDS;		/* set dsect section */
	sectpc[0].type = TYPP;		/* set abs section to program type */
	sectpc[0].value = 0;		/* init abs prog counter */
	sectpc[0].flags = 0;		/* set flags to abs, dsect */
	sectpc[1].type = TYPP;		/* set dsect section to program type */
	sectpc[1].value = 0;		/* init dsect prog cntr */
	sectpc[1].flags = ABSREL;	/* set flags to rel, dsect */
	sectpc[3].type = TYPP;		/* set csect section to program type */
	sectpc[3].value = 0;		/* init csect prog cntr */
	sectpc[3].flags = (ABSREL|CSDS);  /* set flags to rel, csect */
	currpc = sectpc[pcmode];	/* set default pc, type, and flags */
	hwbbls = sectpc[1];		/* set loader driver PC to rel 0 */
	hbccct = 0;			/* clear common block count */
	hwltct.value = 0;		/* clear literal pool type and count */
	hwltct.type = TYPL;		/* clear literal pool type and count */
	hwltct.flags = 0;		/* clear literal pool type and count */
	hbbbfb = 0;			/* indicate no bytes have gone out */
	ejct2 (tcwd);			/* force header for tof on lo */
	/* report symbols for pass 2, else skip */
	if ((!(PASS & 1)) && symtab) {	/* are we in pass 2 */
	  struct symbol FAR *p;		/* temp pointer to symbol */
	  struct strback FAR *sbp;		/* temp stringback pointer */

	  for (p = symtab; p->flink; p = p->flink) { /* do all symbols */
#ifdef OLD_OLD
	    if (*p->sym != '!') {	/* do not do internal symbols */
	      /* give the symbol to xref'er */
	      reptr(&p->sym, &p->desc, p->desc.value);
	    }
#endif
	    if(p->desc.type == TYPX) { 	/* see if external symbol */
	      /* get ptr to stingback addr */
	      sbp = (struct strback FAR *)p->desc.value;
	      /* clear dsect sb address */
	      sbp->dsdesc.value = (longp)0;
	      /* clear csect sb address */
	      sbp->csdesc.value = (longp)0;
	      sbp->dsdesc.type = TYPX;	/* set type to external */
	      sbp->csdesc.type = TYPX;	/* set type to external */
	      sbp->dsdesc.flags = 0;	/* default to abs/dsect */
	      sbp->csdesc.flags = 0;	/* default to abs/dsect */
	      p->desc.flags &= ~ABSREL;	/* default to abs */
	    }
#ifndef OLD_OLD
	    if (*p->sym != '!') {	/* do not do internal symbols */
	      /* give the symbol to xref'er */
	      reptr(p->sym, &p->desc, (int32)p->desc.value & 0x7fffff);
	    }
#endif
	  }
	}
	if (PASS & 1)
	    xref_cmd(PASS1);	/* tell reporter end of pass */
	else
	    xref_cmd(PASS2);	/* tell reporter end of pass */
	if (PASS & 1) {	/* are in in pass 1 */
	  memset(litorgs, '\0', 32*sizeof(struct tval));  /* clear lit pool */
  	  /* clear sym tab head cells */
	  memset(symhead, '\0', 32*sizeof(struct symbol FAR *));

	  /* reset symbol table values for pass 1 */
/* NOTE - for multiple assemblies, we should free the space here that was
	 malloced for the previous program */
	  symprevp = 0;		/* reset previous symbol pointer */
	  symtab = 0;		/* reset addr of 1st symbol */

	  hwcmpb[0] = 8;	/* set default max bounding for dsect */
	  hwcmpb[1] = 8;	/* set default max bounding for csect */
	  memcpy(TCWPROG, "MAIN    ", 8);  /* set default program name */
	  macr.type = TYMACREQ;	/* set macro request type code */
	  macr.value = 0;	/* set macro value */
	  macr.flags = 0;	/* set macro flags */
	}
	return;			/* return */
}

/*
 * csnegate - routine to negate 8 char name for for macro lookup
 * input - 8 char name pointer
 * output - point to 8 char negated name
 */

char negname[8];		/* the negated name returned */

char * csnegate (name)
register char * name;
{
	register int	i;
	register char * rname = negname;

	for (i=0; i<8; i++)
	  rname[i] = (char)(-(int)(name[i]));
	return (negname);	/* return negated name pointer */
}

/*
 * auto sectioning support
 */

/*
 * ascttst - determine which section to set for current opcode
 *	     csect or dsect is set based on opcode
 *
 *	     bound, equ, and org are not processed to set section
 *
 *	     bound directives are deferred until the next instruction
 *	     is processed, and then applied to the section established
 *	     for that instruction
 *
 *	     equ and org make the '$' symbol illegal for subsequent
 *	     expression evaluation
 *
 * input - pointer to opcode table entry for current opcode
 * output - dsect or csect mode set as required
 */

/* local storage */
struct	tval asctbvl;		/* holds value from bound processor */
char	asctblb[8];		/* holds label from bound processor */
int32	asctblc;		/* holds curr loc cntr from bound processor */
int32	asctslc;		/* holds saved lict */
char	asctslb[8];		/* holds saved label */
char	asctflg;		/* control flags */

/* instruction type values */
#define OPBOUND	39	/* bound statement */
#define OPEQU	40	/* equ statement */
#define	OPORG	37	/* org statement */

#define OPAC	13	/* ac? type opcode */
#define OPBAC	23	/* bach/bacw type opcode */
#define OPDATA	29	/* data? type opcode */
#define	OPGEN	30	/* gen type opcode */
#define OPRES	41	/* res type opcode */
#define	OPFORM	57	/* form type opcode */
#define	OPREZ	65	/* rez type opcode */
#define OPDEQU	66	/* dequ type opcode */
#define OPDORG	67	/* dorg type opcode */

void	ascttst(opp)
struct optab * opp;	/* opcode table entry */
{

	int	octype = opp->opproc;	/* get process number */

	switch (octype) {

	  case OPEQU:	/* equate */
	  case OPBOUND:	/* bound */
	  case OPORG:	/* org */
	    return;	/* nothing to do for bound, equ, or org */ 

	  case OPAC:	/* ac? */
	  case OPBAC:	/* bac? */
	  case OPDATA:	/* data? */
	  case OPGEN:	/* gen */
	  case OPRES:	/* res */
	  case OPFORM:	/* form */
	  case OPREZ:	/* rez */
	  case OPDEQU:	/* dequ */
	  case OPDORG:	/* dorg */

dodsect:
	    /* establish dsect for data generating opcodes */
	    /* if dsect or common, leave as it is */
	    if (!((pcmode == PCDS) || (pcmode == PCCOM))) {
	      sectpc[pcmode] = currpc;		/* save curr PC */
	      pcmode = PCDS;			/* set dsect mode */
	      currpc = sectpc[pcmode];		/* set pc value for dsect */
	    }
	    break;	/* exit switch */

	default:
	    /* check for data generating opcode and set dsect */
	    if (ASCTDTO & asctflg)goto dodsect;	/* is dataonly flag set? */
	    /* not for dsect, establish csect */

	    /* it is not data generator, so set csect */
	    if (pcmode != PCCS) {		/* are we in csect */
	      sectpc[pcmode] = currpc;		/* save curr PC */
	      pcmode = PCCS;			/* set csect mode */
	      currpc = sectpc[pcmode];		/* set pc value for csect */
	    }
	    break;		/* exit switch */
	}	/* end switch */

	/* if no bound flag, return;
	if(!(ASCTBND & asctflg)) return;
	asctflg &= ~ASCTBND;		/* reset bound flag
	bouc((int32)asctbvl.value);	/* bound new PC */
	memcpy (asctslb, label, 8);	/* save current label */
	asctslc = lict;			/* save current line number */
	lict = asctblc;			/* set old line number */
	memcpy(label, asctblb, 8);	/* get bound label, if any */
	tall();				/* allocate current bound label */
	memcpy(label, asctslb, 8);	/* recover label */
	lict = asctslc;			/* restore line counter */
	return;				/* continue processing */
}	

/*
 * dataonly directive support 
 */

void	dtonly()
{
	asctflg |= ASCTDTO;	/* set data only flag */
	return;			/* do next line */
}

/*
 * enddata directive support 
 */

void	enddt()
{
	asctflg &= ~ASCTDTO;	/* reset data only flag */
	return;			/* do next line */
}

/*
 * yeanay ()
 * Check whether to assemble or not
 * input - non
 * output - 1, if assembling
 *	    0, in not assembling
 */

int	yeanay()
{
	if ((RSCAN | CONDSCAN | DEFMBODY) & macstate)
	  return (0);
	return (1);
}

/*
 * clrerr (err)
 * clear error code for output
 * decrement error count - hwerct
 * input - error code character
 * output - none
 */

void	clrerr (err)
char	err;
{
	if (hwerrf & (1L << (err - 0x40))) {	/* see if error on */
	  hwerrf &= ~(1L << (err - 0x40));
	  hwerct--;				/* decrement count */
	}
}

/*
 * seterr (err)
 * Set error code for output
 * increment error count - hwerct
 * input - error code character
 * output - none
 */

void	seterr (err)
char	err;
{
	hwerrf |= (1L << (err - 0x40));
	hwerct++;				/* bump count */
/*
printf("ERROR %c found\n", err);
*/
}

/*
 * bndwnopg - gen a nop
 */

void	bndwnopg()
{
/* printf("gening a nop to bound pc\n"); */
	igen (0);		/* generate a nop left byte of zero */
	bits &= ~BNDWS3;	/* clear temp bits store */
	if (bits & IMIN)	/* is no buffer image ready */
	  bits |= BNDWS3;	/* save a turned on bit */
	bits &= ~IMIN;		/* clear no buff image ready */
	bits &= ~BNDWS4;	/* clear bit store */
	if (inptstat & EXPAND)	/* expanded mode */
	  bits |= BNDWS4;	/* set bit store */
	inptstat &= ~EXPAND;	/* clear expand mode */
	spmac |= NOPGEN;	/* indicate a nop is being gen'd */
	igen (2);		/* generate rt byte of 2 for nop */
	if (BNDWS3 & bits)	/* bit test */
	  bits |= IMIN;		/* indicate buffer image ready */
	spmac &= ~NOPGEN;	/* clear nop gen flag */
	if (BNDWS4 & bits)	/* bit store */
	  inptstat |= EXPAND;	/* it was on before, save bit */
	currpc = sectpc[pcmode];	/* staticize PC */
	return;
}

/*
 * cdl - pseudo cd instruction
 * form left half of semi pseudo-op cd instruction
 */

void	cdl()
{
	int	paug;			/* pseudo aug */

	paug = curops->aug | ((expr[0].value & 1) << 3);	
	gen16((int)(expr[0].value > 1) & 0x7,
	  (int)(expr[0].value >> 4) & 0x7 , paug);
	return;
}

/*
 * rtb - test bit in reg instructions
 * expr[0].value = reg number
 * expr[1].value = bit number 0-31
 */

void	rtb()
{ 
	int	preg;

	if (expr[1].value < 0 || expr[1].value > 0x1f) {
	  /* bit number error */
	  if (yeanay()) {			/* are we assembling */
	    seterr ('B');			/* set bounding error */
	  }
	}
	preg = curops->aug;			/* get aug code */
	preg |= ((expr[1].value >> 3) & 3);	/* merge in byte # */
	/* gen 16 bit opcode */
	gen16((int)expr[0].value, (int)expr[1].value & 0x7, preg);
	return;
}

/*
 * ler - process register unary instruction (lcs, es, rnd)
 * expr[0].value has destination reg
 * source register is zero
 * aug will be augment
 */

void	ler()
{
	/* source register is zero */
	gen16(0, (int)expr[0].value, curops->aug);	/* gen 16 bit opcode */
	return;
}

/*
 * calm - process calm instruction
 * svc 15 not replaced at current time
 */

void	calm()
{
	/*
	 TBM       12,OPTION       ! TEST FOR SVC 15 (OPTION 20)
         BNS       CALM2           ! NO, BRANCH
         TRR       1,2             ! SVC CALL NUMBER
         LI        1,15            ! SVC INDEX (15)
         LI        7,-4            ! FAKE EXPRESSION COUNT
         STW       7,GRPW          ! SAVE IT
         LW        7,=X'CA600134'  ! SVC OP DESCRIPTOR
         STW       7,HWACT         ! REPLACE CALM DESCRIPTOR
         LI        5,6             ! SVC OP AUGMENT
         BU        SVC             ! PROCESS AS SVC
	*/

	/* calm number is 10 bits, fake out gen16 */
	gen16((int)((expr[0].value & 0x700) >> 4),
	  (int)((expr[0].value & 0x380) >> 7), (int)expr[0].value & 0xf);
	return;
}

/*
 * cf2d - process a RISC style floating point conversion
 * convert floating format to double format
 * input - expr[0].value = source/destination reg
 */

void	cf2d()
{
    	/* use varcode as dr value */
    	/* use reg as sr value */
	/* gen 16 bit opcode */
    	if (option & OPT55) { 		/* option 55 set (IEEE) */
	    gen16a(0x09, (int)expr[0].value, 0x00, 0x0e);	/* TRFW SR */
	    gen16a(0x29, (int)expr[0].value, 0x02, 0x0f);	/* TDPR SR */
	} else {
	    gen16a(0x0d, (int)expr[0].value+1,
		(int)expr[0].value+1, 0x00); /* ZR SR+1 */
	}
}

/*
 * cd2f - process a RISC style floating point conversion
 * convert double format to floating format
 * input - expr[0].value = source/destination reg
 */

void	cd2f()
{
    	/* use varcode as dr value */
    	/* use reg as sr value */
	/* gen 16 bit opcode */
    	if (option & OPT55) { 		/* option 55 set (IEEE) */
	    gen16a(0x09, (int)expr[0].value, 0x00, 0x0f);	/* TRFD SR */
	    gen16a(0x29, (int)expr[0].value, 0x02, 0x0d);	/* TSPR DR */
	}
}

/*
 * rsc1 - process a RISC style floating point instruction
 * input - expr[0].value = destination reg
 */

void	rsc1()
{
    	/* use varcode as dr value */
    	/* use reg as sr value */
	/* gen 16 bit opcode */
	gen16((int)expr[0].value, curops->varcode, curops->aug);
}

/*
 * rsc1 - process a RISC wait instruction
 * input - none
 */

void	rsc2()
{
    	/* use varcode as dr value */
    	/* use 0 as sr value */
	/* gen 16 bit opcode */
	gen16(0, curops->varcode, curops->aug);
}

/*
 * RISC reg - reg ops 
 * expr[0].value has destination reg
 * expr[1].value has source reg
 * regs are reversed from normal reg-reg ops
 */

void	revrro()
{
	/* gen 16 bit opcode */
	gen16((int)expr[1].value, (int)expr[0].value, curops->aug);
	return;
}

/*
 * fpctx RISC reg - reg floating point ops 
 * expr[0].value has source reg
 * expr[1].value has destination reg
 * same as rro but generates 32 bits
 */

void	fpctx()
{
    	int xr = expr[0].value;		/* get source reg */
    	int32 fakeaddr;			/* low order bit of xr */

    	/* use low order bit of xr as high order bit of address */
    	fakeaddr = (xr & 1) << 20;
    	xr >>= 1;			/* just 2 bits of xr */
    	fakeaddr |= (curops->aug << 16);	/* put in aug code */
	/* gen 32 bit opcode */
	gen32((int)expr[1].value, xr, fakeaddr);
}

/*
 * shf - process a shift instruction
 * input - expr[0].value = destination reg
 *	   expr[1].value = shift count
 */

void	shf()
{
	int	preg = 0;			/* pseudo reg */

	if (DEFMBODY & macstate) {		/* are we in body of def */
	  /* nothing to do in that case */
	  gen16(0, (int)expr[0].value, 0);	/* gen 16 bit opcode */
	} else
	if (RSCAN & macstate) {			/* are we in a repeat scan */
	  /* nothing to do in that case */
	  gen16(0, (int)expr[0].value, 0);	/* gen 16 bit opcode */
	} else
	/* shift must be < 32 */
	if (expr[1].value < 0 || expr[1].value > 0x1f) {
	  if (yeanay()) {			/* are we assembling */
	    seterr ('N');			/* set number error */
	  }
	  expr[1].value = 0x1f;			/* set to max */
	}
	if (curops->aug & 1)			/* is this a left shift */
	  preg |= 0x4;				/* set left shift bit */
	if (curops->aug & 2)			/* is this base reg op */
	  preg |= 0x2;				/* set base shift bit */
	/* fake out gen16, use preg as source reg */
	/* it has bits above plus most significant bit of shft count */
	/* aug value will be lower 4 bits of shift count */
	if (expr[1].value > 0x0f)		/* see if shf cnt > 15 */
	  preg |= 1;				/* if so, use upper bit */
	/* gen 16 bit opcode */
	gen16(preg, (int)expr[0].value, (int)expr[1].value & 0x0f);
}

/*
 * nss - process nop instruction
 * source register is zero
 * destination has destination reg
 * aug will be augment
 */

void	nss()
{
	/* source register is zero */
	gen16(0, 0, curops->aug);		/* gen 16 bit opcode */
	return;
}

/*
 * trsw - process trsw instruction
 * expr[0].value has destination reg
 * source register is zero
 * aug will be zero 
 */

void	trsw()
{
	/* source register is zero */
	gen16(0, (int)expr[0].value, curops->aug);	/* gen 16 bit opcode */
	return;
}

/*
 * zrx - process zr instruction
 *	 actually an eor r,r to same reg
 * expr[0].value has source reg
 * expr[1].value has destination reg
 */

void	zrx()
{
	/* source and destination are reversed */
	/* gen 16 bit opcode */
	gen16((int)expr[0].value, (int)expr[0].value, curops->aug);
	return;
}

/*
 * nords - process nor, nord, scz
 * expr[0].value has source reg
 * expr[1].value has destination reg
 */

void	nords()
{
	/* source and destination are reversed */
	/* gen 16 bit opcode */
	gen16((int)expr[1].value, (int)expr[0].value, curops->aug);
	return;
}

/*
 * setcpu - process setcpu and rdsts
 * source reg is zero
 */

void	setcpu()
{
	gen16(0, (int)expr[0].value, curops->aug);	/* gen 16 bit opcode */
	return;
}

/*
 * reg - reg ops 
 * expr[0].value has source reg
 * expr[1].value has destination reg
 */

void	rro()
{
	/* gen 16 bit opcode */
	gen16((int)expr[0].value, (int)expr[1].value, curops->aug);
	return;
}

/*
 * gen16 - generate 16 bit instruction
 * input sr = 3 bit source register
 *       dr = 3 bit destination reg
 *       aug = 4 bit augment
 *  **************************
 *  | opcode | dr | sr | aug |
 *  **************************
 */

void	gen16 (sr, dr, aug)
int	sr;
int	dr;
int	aug;
{
	int16	inst;
	
	if ((sr < 0 || sr > 7) || (dr < 0 || dr > 7)) {	/* valid regs are 0-7 */
	  if (yeanay()) {		/* are we assembling */
	    seterr ('B');		/* set bounding error */
	  }
	}
	inst = (aug & 0xf) | ((sr & 7) << 4) | ((dr & 7) << 7) |
	  ((curops->binop >> 2) << 10);
/*
printf("gen16 sr = %x, dr = %x, aug = %x, inst = %x\n", sr,dr,aug,inst);
*/
	igen ((int)(inst >> 8));	/* gen 1st bytes */
	igen ((int)(inst & 0xff));	/* gen 2nd bytes */
	return;
}

void	gen16a (op, sr, dr, aug)
int	op;
int	sr;
int	dr;
int	aug;
{
	int16	inst;
	
	if ((sr < 0 || sr > 7) || (dr < 0 || dr > 7)) {	/* valid regs are 0-7 */
	  if (yeanay()) {		/* are we assembling */
	    seterr ('B');		/* set bounding error */
	  }
	}
	inst = (aug & 0xf) | ((sr & 7) << 4) | ((dr & 7) << 7) |
	  ((op >> 2) << 10);
	igen ((int)(inst >> 8));	/* gen 1st bytes */
	igen ((int)(inst & 0xff));	/* gen 2nd bytes */
	return;
}

/*
 * agen - process 32 bit reg-mem instructions
 * input - expr[1].value has address
 *       - expr[1].type has address type
 */

void	agen()
{
	int32	newadr;

/*
printf("entered agen v1 = %x, v2 = %x\n", expr[0].value, expr[1].value);
prtval("agen expr[0]", &expr[0]);
prtval("agen expr[1]", &expr[1]);
*/
	hweval = expr[1];		/* save address for printout */
	/* put address word together */
	newadr = ageq ((int32)expr[1].value, expr[1].type);
/* printf("agen before agem call, addr = %lx\n",newadr); */
	agem(newadr);			/* have agem complete */
/* printf("exiting agen after agem call, addr = %lx\n",newadr); */
	return;
}

/*
 * agem - general 32 bit processing routine
 * input - newaddr has 21 bit fixedup addr
 * hweval and hweval.type already set up
 */

void	agem(newadr)
int32	newadr;
{
	int	i;
	int32	xr;

	xr = expr[2].value;
	i = curops->subaug & 3;		/* get arg min/max descr */
/*
printf("agem arg %d, xr %d, addr = %lx\n", i, xr, newadr);
printf("agem2 argmax %d, grpw %d, addr = %lx\n", argmax[i], grpw, newadr);
printf("agem3 argmax[i] - grpw - 6 = %d\n", argmax[i]-grpw-6);
*/
	if ((argmax[i] - grpw - 6) == 0) { /* if max args, xr was specified */
	  if (xr < 1 || xr > 3) {	/* xr must be 1-3 to be valid */
					/* not valid, report error */
	    if (yeanay()) {		/* are we assembling */
	      seterr ('B');		/* set bounding error */
	    }
	  }
	  xr &= 3;			/* clamp to 0-3 */
	  if (BM & option) {		/* is base mode in effect */
	    /* we must fix xr for base mode */
	    newadr &= 0xfffffL;		/* lop off indirect bit */
	    newadr |= ((int32)(xr & 1) << 20);	/* bit now low bit of xr # */
	    xr >>= 1;			/* shift over xr # */
	  }
	} else
	if (!(INDFLAG & hwindr)) {	/* if indirect, ok */
	  if (ADDRERR & bits2) {	/* was there an addressing error */
/*
printf("agem ADDRERR set, addr = %lx\n",newadr);
*/
	    if (yeanay()) {		/* are we assembling */
	      seterr ('B');		/* set bounding error */
	    }
	  }
	}
	bits2 &= ~ADDRERR;		/* clear addressing error flag */
/* printf("agem before gen32 call, addr = %lx\n",newadr); */
	gen32 ((int)expr[0].value, (int)xr, newadr); /* gen 4 bytes of data */
	return;
}

char	eisflg;		/* EIS mode flags */

/*
 * gen32 - generate 32 bit instruction
 * input gr = 3 bit general register
 *       xr = 2 bit index register
 *       addr = 21 bit address with indir, f&cc bit and address 
 *  ***************************
 *  | opcode | gr | xr | addr |
 *  ***************************
 */

void	gen32 (gr, xr, addr)
int	gr;
int	xr;
int32	addr;
{
	int32	inst;
	
/* printf("gen32: gr= %x, xr=%x, addr=%lx\n", gr, xr, addr); */
	/* valid range for gr is 0-7, xr is 0-3 */
	if ((gr < 0 || gr > 7) || (xr < 0 || xr > 3)) {	
	  if (yeanay()) {		/* are we assembling */
	    seterr ('B');		/* set bounding error */
	  }
	}
	if (gr == 0) {			/* if gr = 0, see if bct or bcf instr */
/*	  if (hwact == 0xee01230fL || hwact == 0xf201230fL) { */
	  if (hwact == (int32)0xee01230fL || hwact == (int32)0xf201230fL) {
	    /* we have bct or bcf and no condition codes were set, error */
	    if (yeanay()) {		/* are we assembling */
	      seterr ('B');		/* set bounding error */
	    }
	  }
	}
	eisflg &= ~EISOPC;		/* clear flag for testing */
	if (curops->binop == 0x56 || curops->binop == 0x5a ||
	  curops->binop == 0x5e) {	/* see if stc?, lcra, or lc? */
	  /* it is one of them, force task space flag for listing */
	  eisflg |= EISOPC;		/* set flag */
	}
	/* now put instruction together */
	inst = (addr & 0x1fffffL) | ((int32)(xr & 3) << 21) |
	  ((int32)(gr & 7) << 23) | ((int32)(curops->binop >> 2) << 26);
/*
printf("gen32 gr = %x, xr = %x, addr = %lx, inst = %lx\n", gr,xr,addr,inst);
*/
	/* now gen the bytes */
	igen ((int)((unsigned int32)inst >> 24));	/* gen 1 byte */
	igen ((int)((int32)(inst & 0xff0000L) >> 16));	/* gen 1 byte */
	igen ((int)((inst & 0xff00L) >> 8));	/* gen 1 byte */
	igen ((int)(inst & 0xffL));		/* gen 1 byte */
}

/*
 * bm - process sbm, zbm, abm, and tbm instructions
 * input - expr[0].value = bit number
 * 	 - expr[1].value = address
 */

void	bm()
{
	int	byten;

	byten = expr[0].value >> 3;	/* just get byte value 0-3 */
	if (expr[1].type == TYPX) {	/* is type external */
	  if (byten > 3) {		/* is byte # > 1 word disp */
	    /* if external, has to be in same word */
	    seterr ('B');		/* set bounding error */
	    byten = 0;			/* zero, so stringback won't abort */
	  }
	}
	expr[0].value &= 7;		/* just save bit number */
	expr[1].value = expr[1].value + byten;	/* add byte offset to address */
	/* call agen to generate the rest of the instruction */
	agen();				/* will return after bytes output */
	return;
}

/*
 * bi - process bib, bih, biw, bid instructions
 * input - expr[0].value = register number
 *	 - expr[1].value = address
 */

void	bi()
{
	int32	newadr;
	int	xr;

	hweval = expr[1];			/* save address for printout */
	/* put address word together */
	newadr = ageq ((int32)expr[1].value, expr[1].type);
	xr = curops->aug & 3;		/* use 2 bits of aug as xr value */
	bits2 &= ~ADDRERR;		/* clear addressing error flag */
	gen32 ((int)expr[0].value, xr, newadr);	/* go gen 4 bytes of data */
}

/*
 * bacx - process bach, bacw instructions
 * biased address constant processor
 */

void	bacx()
{
	int32	newadr;

    	if ((!option & ASECT)) {	/* see if autosectioning */
    	  /* do ach/acw if not */	
    	  bu();				/* just use bu code */
    	  return;
    	}
    	bacflag &= 1;			/* show bacx read */
    	/* see if in CSECT */
    	if (expr[0].flags & CSDS)
    	  bacflag &= 2;			/* show in csect */
    	/* see if bac of an external address */
    	if (bacflag & 4) {
    	  expr[0].type = TYPX;		/* external type address */
    	  expr[0].value |= 0x8ffffL;	/* terminator value */
    	}
	expr[2] = expr[1];		/* put xr number in correct field */
	expr[1] = expr[0];		/* put address in correct field */
	expr[0].value = curops->aug;	/* use aug for gen reg */
    	hweval = expr[1];		/* save address for printout */
	/* put address word together */
	newadr = ageq ((int32)expr[1].value, expr[1].type);
	/* go have agen do it for up */
    	newadr &= 0xffffffL;		/* 24 bit address */
	/* now gen the bytes */
	igen ((int)((unsigned int32)newadr >> 24));	/* gen 1 byte */
	igen ((int)((int32)(newadr & 0xff0000L) >> 16)); /* gen 1 byte */
	igen ((int)((newadr & 0xff00L) >> 8));	/* gen 1 byte */
	igen ((int)(newadr & 0xffL));		/* gen 1 byte */
}

/*
 * zmx - process zero memory instructions, zmb, zmh, zmw, zmd
 */

void	zmx()
{
    	bu();		/* just use bu code */
}

/*
 * bu - process branch unconditional, exm, zm, bl, bri, bft
 */

void	bu()
{
	expr[2] = expr[1];		/* put xr number in correct field */
	expr[1] = expr[0];		/* put address in correct field */
	expr[0].value = curops->aug;	/* use aug for gen reg */
	/* go have agen do it for up */
	agen();				/* return after output */
}

/*
 * fpp - process floating point instructions
 */

void	fpp()
{
	int32	newadr;

	hweval = expr[1];			/* save address for printout */
	/* put address word together */
	newadr = ageq ((int32)expr[1].value, expr[1].type);
	/* set aug code for proper instruction type */
	newadr = (newadr & 0x17ffffL) | ((int32)(curops->aug & 3) << 19);
	agem(newadr);			/* have agem complete */
	return;
}

/*
 * trip - 32 bit non memory reference instructions
 * translate register/protect register ops
 */

void	trip()
{
	int32	newadr;
	int	xr;

	/* check for valid register */
	if (expr[0].value < 0 || expr[0].value > 7) {
	  if (yeanay()) {		/* are we assembling */
	    seterr ('B');		/* set bounding error */
	  }
	}
	/* lower 16 bits of instruction is zero, the gp reg and low
	 * order 2 bits of protect reg # make up the address */
	newadr =(int32)((expr[0].value & 7) & ((expr[1].value & 3) << 3)) << 16;
	/* the xr is the upper 2 bits of the protect reg # */
	xr = (expr[1].value & 0xf) >> 2;
	/* the gen purpose reg is the aug code */
	gen32 ((int)curops->aug, xr, newadr);	/* go gen 4 bytes of data */
	return;
}

/*
 * exr - process execute register instructions and lmap
 * input - expr[0].value = reg number
 */

void	exr()
{
	int32	newadr;
	int	xr;

	newadr = curops->varcode;		/* exr exrr desiginator */
	newadr |= (int32)(curops->aug << 16);	/* merge in aug */
	gen32 ((int)expr[0].value, 0, newadr);	/* go gen 4 bytes of data */
	return;
}

/*
 * imop - process immediate instructions
 * input - expr[0].value = reg number
 * 	 - expr[1].value = immediate value
 */

void	imop()
{
	int32	newadr;
	int	xr;

/* printf("entered imop v1 = %x, v2 = %x\n", expr[0].value, expr[1].value); */
	if (curops->aug == 0xa) {		/* is this a rintv instr */
	  newadr = (expr[1].value & 0xff) << 8;	/* get 8 bit imm value */
	} else					/* and fill with zero */
	  newadr = expr[1].value & 0xffffL;	/* get 16 bit imm value */
	newadr |= ((int32)curops->aug << 16);	/* merge in aug */
	gen32 ((int)expr[0].value, 0, newadr);	/* go gen 4 bytes of data */
/* printf("returning after gen32 call\n"); */
	return;
}

/*
 * io - process 'E' class io instructions - cd, td, ei, di, ri, ai, dai
 * input - expr[0].value = 7 bit device address
 *       - expr[1].value = 16 bit command code
 */

void	io()
{
	int32	newadr;
	int	xr;
	int	gr;
/*
printf("io e0 %x e1 %x aug %x\n",
  expr[0].value, expr[1].value, curops->aug);
*/
	newadr = expr[1].value & 0xffffL;	/* get 16 bit command code */
	newadr |= (((int32)curops->aug) << 16);		/* merge in aug */
	/* merge in l/o 2 bits of dev */
	newadr |= ((int32)(expr[0].value & 3) << 19);
	xr = (expr[0].value & 0xc) >> 2;	/* xr is next 2 bits of dev */
	gr = (expr[0].value & 0x70) >> 4;	/* gr is last 3 bits of dev */
	gen32 (gr, xr, newadr);			/* go gen 4 bytes of data */
	return;
}

/*
 * svc - process svc instruction
 * input - hwln1 has 4 bit index value
 * 	 - hwln2 has 12 bit call number
 */

void	svc()
{
	int32	newadr;

	newadr = expr[1].value & 0xfffL;	/* get 12 bit call number */
	if ((grpw + 6) != 1) {			/* is there only 1 arg */
	  newadr |= ((expr[0].value & 0xf) << 12); /* no, get svc index value */
	}
	newadr |= (int32)(curops->aug << 16);	/* merge in aug */
	/* gpr and xr fields are zero for svc */
	gen32 (0, 0, newadr);			/* go gen 4 bytes of data */
	return;
}

/*
 * trap - process trap control instruction
 * input - expr[0].value = 5 bit trap select
 *	 - expr[0].value = 5 bit function select
 */

void	trap()
{
	int32	newadr;

	newadr = expr[1].value & 0x1f;		/* get 5 bit funct sel num */
	newadr |= ((expr[0].value & 0x1f) << 8); /* get 5 bit trap sel num */
	newadr |= ((int32)curops->aug << 16);	/* merge in aug */
	gen32 (0, 0, newadr);			/* go gen 4 bytes of data */
	return;
}

/*
 * extio - process xio instructions sio, hio, etc
 * input - expr[0].value = reg number
 *	 - expr[1].value = channel
 *	 - expr[2].value = subaddress
 */

void	extio()
{
	int32	newadr;

	newadr = expr[1].value & 0xffffL;	/* get 16 bit chan/subadr */
						/* or 8 bit channel number */
	if ((grpw + 6) != 2) {			/* only 2 args present */
 	  /* get 8 bit subaddress */
	  newadr = (newadr << 8) | (expr[2].value & 0xff);
	}
	newadr |= ((int32)curops->aug << 16);		/* merge in aug */
	/* merge in 2 bits of subop */
	newadr |= ((int32)(curops->varcode & 3) << 19);
	/* xr is upper 2 bits of sub-op field, gen 4 bytes */
	gen32 ((int)expr[0].value, (curops->varcode >> 2) & 3, newadr);
	return;
}

/*
 * bndw - bound pc for type of instruction
 */

void	bndw()
{
/*
* bound instruction counter as necessary for the next line
* algorithm for bound - (pc)+8 modulo 8= qty to add for doubleword
*                     -(pc)+8modulo 4=qty to add for word
*                     -(pc)+8modulo 2= qty to add for halfword
*/
	int	ib;
	int32	pcb;
	int32	spc;

	/* see if we are assembling */
	if (!yeanay()) {		/* are we assembling */
	  return;			/* no, return */
	}
	ib = curops->binop & 3;		/* get last 2 bits of boundry info */
	pcb = sectpc[pcmode].value & 7;	/* get last 3 bits of PC */
	spc = bndws1[pcb];		/* pc status */
/*
* 0 eq byte, 1 eq halfword, 2 eq word, 3 eq double word
* we must gen nop if on half boundary and next inst is word
*/
	if ((spc & 1) && (!(spc & 2))) {	/* pc on hw boundry */
	  if((!(ib & 1)) && (ib & 2)) {	/* instuction is a word */
	    bndwnopg();			/* gen a nop instruction */
	    return;			/* return after nop gen */
	  }
	}
	pcb = -pcb;			/* negate last 3 bits of pc */
	pcb += 8;			/* add 8 */
	if ((spc = (bndws2[ib-1] & pcb)) == 0) /* mod 8,4,or 2 by bnd demand */
	  return;			/* no addition required */
	sectpc[pcmode].value += spc;	/* add to curr section counter */
	currpc = sectpc[pcmode];	/* set current pc also */
    	pcchk();			/* check for pc overflow */
	return;
}

/*
 * ageq0 - do address generation
 * put address word together with f, cc and indirect bit
 * input - adr = address to process
 *	 - typ = type code for adr
 * output - updated address
 */

int32	ageq0(adr, typ)
int32	adr;
int	typ;
{
/*
* put address word together with f,cc and indirect bit
* input--address right justified in r2
* output-address with f,cc and i right justified in r7
*/
	int32	mask;
	int32	retval;

	mask = ager[hbavar];		/* get mask for varient code */
	if (adr & (int32)(mask >> 24)) {	/* see if boundry problem */
/*
printf("entered ageq0 adr = %x, mask = %x\n", adr, mask);
*/
	  if (typ != TYPX) {		/* no error for external */
	    if (hbstac[0] != ')') {	/* was last terminator a ')' */
/*
printf("ageq0 ADDRERR set\n");
*/
	      bits2 |= ADDRERR;		/* no set, addr bounding error */
	    } else			/* it was ')', see if assembling */
	    if (yeanay()) {		/* are we assembling */
	      seterr ('B');		/* set bounding error */
	    }
	  }
	}
        if (bacflag & 4) {		/* BAC to an external */
	  retval = 0x8ffffL;		/* yes, fill with terminal value */
    	} else {
	  retval = adr;			/* get the address */
    	  retval &= mask;		/* eliminate unused address bits */
    	}
	retval |= ages[hbavar];		/* put in proper f and cc bits */
	retval |= hwindr;		/* and indirect bit */
	return(retval);			/* return the updated address */
}
	
/*
 * ageq - do address generation
 * put address word together with f, cc and indirect bit
 * input - adr = address to process
 *	 - typ = type code for adr
 * output - updated address
 */

int32	ageq(adr, typ)
int32	adr;
int	typ;
{
/*
* put address word together with f,cc and indirect bit
* input--address right justified in r2
* output-address with f,cc and i right justified in r7
*/
	int32	mask;
	int32	retval;
	
	if (typ == TYPC) {		/* is type common */
	  /* we have common, get block # and see if ssect */
	  if (hwcmsize[(int32)(adr & 0xff0000L) >> 16] & 0x8000000L) {
	    adr &= 0xffffL;		/* clear block # if ssect */
	  }
	}
	mask = ager[hbavar];		/* get mask for varient code */
	if (adr & (int32)(mask >> 24)) {	/* see if boundry problem */
/*
printf("entered ageq adr = %x, mask = %x\n", adr, mask);
*/
	  if (typ != TYPX) {		/* no error for external */
	    if (hbstac[0] != ')') {	/* was last terminator a ')' */
/*
printf("ageq ADDRERR set\n");
*/
	      bits2 |= ADDRERR;		/* no set, addr bounding error */
	    } else			/* it was ')', see if assembling */
	    if (yeanay()) {		/* are we assembling */
	      seterr ('B');		/* set bounding error */
	    }
	  }
	}
	retval = adr;			/* get the address */
	retval &= mask;			/* eliminate unused address bits */
	retval |= ages[hbavar];		/* put in proper f and cc bits */
	retval |= hwindr;		/* and indirect bit */
	return(retval);			/* return the updated address */
}

/*
 * end - end card processing
 * start pass 2 or exit
 */

void	pend()
{
	int32	temp;
	int32	temp2;
	struct symbol FAR *stp;

/*
printf("end entered\n");
fflush(stdout);
*/
	endflag = 1;			/* show end card found */
	if (!yeanay()) {		/* are we assembling */
	  if (PASS & 1) {		/* yes, pass 1 */
	    abortm("** UNEXPECTED END STATEMENT, EITHER MISSING ENDM, ENDR, OR CONDITIONAL LABEL **");
	    /* no return */
	  }
/* printf("pend: X error\n"); */
	  seterr ('X');			/* set symbol definition error */
	}
	macstate = inptstat = 0;	/* reset macro flags */
	prlit();			/* process literals */
/*
printf("prlit return\n");
fflush(stdout);
*/
	if (!(PASS & 1)) {		/* if pass 2, do end processing */
	  end2();			/* do pass 2 processing */
/*
printf("end2 return\n");
fflush(stdout);
*/
	  return;			/* done with this file */
	}
	val(0);				/* indicate nothing unstrung */
					/* this will take care of ; and xref */
	/* get common # and see if it is an ssect */
	temp = (int32)(sectpc[PCCOM].value & 0x00ff0000L) >> 24;
	if ( hwcmsize[temp] & 0x80000000L)
	  /* it is ssect, is it bigger than old */
	  if ((sectpc[PCCOM].value & 0xffffL) > (hwcmsize[temp] & 0xffffL)) 
	    /* save new size */
	    hwcmsize[temp] = ((hwcmsize[temp] & 0xffff0000L) |
	      (sectpc[PCCOM].value & 0xffffL));	/* set new size */
	if (!(bits3 & EXPLFC)) {	/* check for csect or non zero dsect */
	  /* put in xref */
	  /* data section name and size */
	  /* give the symbol to xref'er */
	  reptr(dsname, &sectpc[PCDS], (int32)sectpc[PCDS].value);
	  /* code section name and size */
	  /* give the symbol to xref'er */
	  reptr(csname, &sectpc[PCCS], (int32)sectpc[PCCS].value);
	}
	rset(0);			/* setup for pass 2 */
	cpas(0);			/* change mode to pass 2*/
	bits &= ~IMIN;			/* indicate no buffer image ready */

	/* dump program name and all common definitions */
	if (hbbbfb)return;		/* return if bytes have gone out */
	*hbbs = 0;			/* reset bo stack count */
	memcpy (usname, TCWPROG, 8);	/* set program name */
	bfn ();				/* stack program name in bo stack */
	temp = hwcmpb[0];		/* dsect max bounding */
    	if (option & OPT55 || 		/* option 55 set (IEEE) */
    	  fpflag & 1) {			/* IEEE data in program */
	  temp |= 0x0300;		/* yes, put in IEEE type code */
    	} else if (ASECT & option)	/* auto sectioning */
	  temp |= 0x0200;		/* yes, put in auto sect type code */
    	/* for now, emit type 4 object code for C progs */
    	/* later define new types for C & IEEE & ASECT */
	if (option & DBG)		/* are debug symbols wanted */
    	  temp |= 0x0400;		/* show C object */
	bfa (temp);			/* output 3 bytes to object stack */
/*
printf("ps called\n");
fflush(stdout);
*/
	pb (hbbs, PTPN, 0);		/* publish program name obj */

	/* process section definition, if needed */
	if (bits3 & EXPLFC) {		/* check for csect or non zero dsect */
	  *hbbs = 0;			/* reset binary output stack count */
	  bfb (LFSDEF);			/* output sect ldr funct sub code */
	  bfb (0);			/* output dummy byte count */
	  bfb (hwcmpb[0]);		/* output min bound req for dsect */
	  hbbn = 0;			/* save sect # for publish routine */
	  bfb (hbbn);			/* output section number */
	  bfa0 ((int32)dsize.value);	/* dsect size */
	  memcpy (usname, dsname, 8);	/* move 8 bytes of dsect name */
	  bfn0 ();			/* output 8 bytes from usname */
	  pb (hbbs, EXPFUNC, 0);	/* publish data */
	  *hbbs = 0;			/* reset binary output stack count */
	  bfb (LFSDEF);			/* output sect ldr funct sub code */
	  bfb (0);			/* output dummy byte count */
	  bfb (hwcmpb[1]);		/* output min bound req for csect */
	  hbbn = 1;			/* save sect # for publish routine */
	  bfb (hbbn);			/* output section number */
	  bfa0 ((int32)csize.value);	/* csect size */
	  memcpy (usname, csname, 8);	/* move 8 bytes of csect name */
	  bfn0 ();			/* output 8 bytes from usname */
	  pb (hbbs, EXPFUNC, 0);	/* publish data */
	}

#ifdef DBUG
printf("END1 \n");
prtsymt();				/* dump the symbol table */
#endif
	/* process common definitions */
	stp = symtab;			/* start of symbol table */
	while (stp) {			/* look at all symbols */

	  if (stp->desc.type == TYPD) {		/* is symbol type common */
	    /* process common block definition */
	    temp = stp->desc.value;		/* get block # and size */
	    temp2 = ((int32)(temp & 0xff0000L) >> 16);	/* get block number */
	    if (hwcmsize[temp2] & 0x80000000L)   /* is it ssect */
	      /* get size of section and block number */
	      temp = (hwcmsize[temp2] & 0xffffL) & (temp2 << 16);
	    if (stp->desc.flags & ABSREL)	/* see if abs or rel */
	      temp |= 0x00800000L;	/* put in abs/rel flag value */
	    bfo (stp);			/* put common name on stack */
	    bfa (temp);			/* put block # and size in stack */
	    pb (hbbs, PTCD, 0);		/* put common block def on bo */
	  }
	  stp = stp->flink;		/* go on to next symbol */
	} /* end of symbol table scan */

/*
printf("end symbol tabel scan\n");
fflush(stdout);
*/
	/* initialize ssect save area */
	for (temp = 0; temp < 256; temp++)  /* clear common pc area */
	  hwcmsize[temp] &= 0xffff0000L;	/* just the offset value */
	sectpc[PCCOM].value = 0;	/* clear current common pc */

	/* put date and time into object file */
	if (option & DT) {
	  hbbs[0] = 16;			/* 16 bytes for date/time */
	  hbbs[1] = LFDTID;		/* set function code */
	  hbbs[2] = hbbs[3] = 0;	/* clear rest of wd 1 */
	  memcpy (&hbbs[4], FMTD_DT, 16);	/* move date/time */
	  pb (hbbs, EXPFUNC, 0);	/* no subcode for date/time */
	}
/*
printf("end put date & time\n");
fflush(stdout);
*/

	/* put product information in object file */
	if (prodidl) {			/* is there any id info */
	  hbbs[0] = prodidl;		/* set prod id length */
	  hbbs[1] = LFDTID;		/* set function code */
	  hbbs[2] = 0;			/* clear unused byte */
	  hbbs[3] = 1;			/* set id info flag for pb */
	  memcpy (&hbbs[4], prodid, prodidl);	/* move prod id */
	  pb (hbbs, EXPFUNC, 1);	/* subcode of 1 for prod id */
	}
/*
printf("end product info\n");
fflush(stdout);
*/
	return;				/* go do second pass */
}

/*
 * prlit - process literals
 */

void	prlit()
{
	struct	tval	tmp;
	int32	hwendl;

	if (option & ASECT) {		/* are we auto sectioning */
	  if (pcmode != PCDS) {		/* is curr PC dsect */
	    sectpc[pcmode] = currpc;	/* save pc for section */
	    pcmode = PCDS;		/* set sect to dsect */
	    currpc = sectpc[pcmode];	/* set pc to dsect pc */
	  }
	}
	bndw();				/* force pc to word boundary */
	tmp = sectpc[pcmode];		/* get curr pc pointer */
	tmp.value = (tmp.value + 3) & 0xfffffffcL;	/* and word bound */
	litorgs[hwltct.value >> 16] = tmp;	/* set lpool def & number */
	/* get num of literals and word adjust and add to literal base */
	currpc.value = (hwltct.value & 0xffffL) + tmp.value;
	if (PASS & 1) {			/* is this pass 1 */
	  /* do pass 1 literal processing */
					/* aloc lpool or end card label */
	  tall();			/* allocate current label */
	  /* add number of literals to pc */
	  sectpc[pcmode].value += ((int32)(hwltct.value & 0xffffL) << 2);
    	  pcchk();			/* check for pc overflow */
#ifdef DEBUG
prtval("pass 1 hwltct", &hwltct);
#endif
	  hwltct.value += 0x10000L;	/* bump lpool number */
	  if (((int32)(hwltct.value & 0xff0000L) >> 16) == 0x1f) /* 31 done */
	    bits |= LPOOL31;		/* indicate 31 lpools processed */
	  hwltct.value &= 0xff0000L;	/* zero literal count */
#ifdef DEBUG
prtval("pass 1 hwltct @ return", &hwltct);
#endif
	  return;			/* get out */
	}
	else {
	  struct symbol FAR *stp = symtab;	/* address of 1st symbol */
	  int32	tpc;
	  char	lpn;

	  bits &= ~IMIN;		/* no buffer image ready */
/*
* literals must be output as constants
* at the location they have been assigned to
*/
/* Note:  This code sucks!  It scans the symbol table for each
 * literal in each literal pool.  That can be 32 x 65000.  If
 * the symbol table is large, it can take a very long time!!!
 */
#ifdef DEBUG
prtval("pass2 prlit entered", &hwltct);
/* prtsymt();				/* dump the symbol table */
#endif
	hwendl = hwltct.value & 0xff0000L;	/* get lpoop # and lit # 0 */
	while (stp) {

	  if (stp->desc.type == TYPL && hwendl == stp->desc.value) {
	    /* a literal */
	    int	i;
#ifndef alpha_fix
	    int32 xxx[2];
	    char litname[8];
	    memCpy (litname, stp->sym, 8);	/* copy in 8 bytes */
	    xxx[0] = (int)(litname[0] & 0xff) << 24;
	    xxx[0] |= (int)(litname[1] & 0xff) << 16;
	    xxx[0] |= (int)(litname[2] & 0xff) << 8;
	    xxx[0] |= (int)(litname[3] & 0xff);
	    xxx[1] = (int)(litname[4] & 0xff) << 24;
	    xxx[1] |= (int)(litname[5] & 0xff) << 16;
	    xxx[1] |= (int)(litname[6] & 0xff) << 8;
	    xxx[1] |= (int)(litname[7] & 0xff);
#else
	    int32 FAR * tdp;
	    int32 FAR * xxx = (int32 FAR *)stp->sym;
#endif
#ifdef DEBUG
printf ("literal found value = %x, hwentl = %x\n", stp->desc.value, hwendl);
printf ("literal is %x,%x, type = %d\n", xxx[0], xxx[1], stp->desc.type);
#endif
	    lpn = (int32)hwendl >> 16;			/* get lpool number */
	    /* add literal disp to base to get curr pc of literal */
	    currpc.value = ((hwendl & 0xffffL) << 2) + litorgs[lpn].value;
	    /* set address of next word */
	    sectpc[pcmode].value = currpc.value + 4;
    	    pcchk();			/* check for pc overflow */
	    for ( i = 0; i < 4; i++) {		/* copy in 4 bytes of literal */
	      /* 2nd word is literal value */
	      hwbyte[i] = ((int32)(xxx[1]&((unsigned int32)0xff000000L >> i*8))
		 >> ((3-i)*8));
	      hwbytf[i] =  1;		/* set flag for byte to be gen'd */
	    }
	    /* propagate this change */
	    hbbn = (xxx[0] >> 24) & 0xff;	/* common block num if any */
	    hweval.flags = (xxx[0] >> 16) & 0xff; /* get rel flags */
	    hweval.type = xxx[0] & 0xff;	/* and it's type */
#ifdef alpha_fix
	    tdp = (int32 FAR *)stp->sym;	/* point to data */
#endif
	    hweval.value = 0;			/* default to abs zero */
	    if (hweval.type != 0) {		/* if type not null, test */
	      if (hweval.type == TYPP) {	/* is type prog */
		hbbn = 0;		/* indicate literal in dsect (sect 0) */
		if (hweval.flags & CSDS) {	/* is literal in csect */
		  hbbn = 1;		/* indicate literal in csect (sect 1) */
		}
		/* literal is address */
#ifndef alpha_fix
		hweval.value = xxx[1];	/* get the address */
#else
		hweval.value = tdp[1];	/* get the address */
#endif
	      } else {
	        if (hweval.type == TYPC) {	/* is type common */
		  /* yes, merge block # and offset */
#ifndef alpha_fix
		  hweval.value = (((int32)hbbn << 16) & (xxx[1] & 0xffffL));
#else
		  hweval.value = (((int32)hbbn << 16) & (tdp[1] & 0xffffL));
#endif
	        } else {
		  /* not legal type, mark error */
	  	  seterr ('R');		/* set relocation error */
	        }
	      }
	    } /* type is null */
	    hbbbct++;			/* show byte generated */
	    bits |= CVFL;		/* signal to print prog counter */
	    releas();			/* print the output */
	    stp = symtab;		/* address of 1st symbol */
	    hwendl++;			/* next literal number */
	    continue;			/* continue with while from beginning */
	  }
	  /* no, not the literal, get next symbol */
/*
printf("next stp = %x llink = %x rlink = %x flink = %x\n",
 stp, stp->llink, stp->rlink, stp->flink);
*/
	  stp = stp->flink;
	}
/* printf("return\n"); */
	/* literal not found, must be done with this lpool */
	hwltct.value += 0x10000L;	/* next literal pool numner */
	if (((int32)(hwltct.value & 0xff0000L) >> 16) == 0x1f) /* all 31 done */
	  bits |= LPOOL31;		/* indicate 31 lpools processed */
	hwltct.value &= 0xff0000L;	/* zero literal count */
	}
	return;				/* get out */
}

/*
 * end2 - pass2 end processing
 */

void	end2()
{
	struct	symbol FAR *stp = symtab;	/* start of symbol table */
	struct	strback FAR *sbp;		/* stringback pointer */
	int	i, j;
	int32	temp;

#ifdef DEBUG
prtsymt();				/* dump the symbol table */
#endif

	while (stp) {			/* scan all of symbol table */
	  if (stp->desc.type == TYPP) {	/* is symbol type local */
	    /* process local symbol definition */
	    if (option & DBG) {		/* are debug symbols wanted */
	      /* publish local symbols for debugger */
	      if (stp->desc.flags & ABSREL) {	/* is symbol relocatable */
		/* symbol is not absolute output it */
		*hbbs = 0;		/* reset binary output stack count */
#ifdef OLD_DEBUG
		temp = 0x0b1200L;	/* first 3 bytes of debugger obj rec */
		if (stp->desc.flags & CSDS)	/* is symbol in csect */
		  temp |= 1;		/* yes, set csect flag */
		bfa (temp);		/* put 3 bytes in stack */
		bfb (LFCDBUG);		/* set symbol type to statement */
		bfa ((int32)stp->desc.value << 3); /* sym addr left shifted 3 bits */
		bfb (0);		/* left hand byte length */
		bfb (4);		/* right hand byte length */
	        memCpy (usname, stp->sym, 8);	/* move 8 bytes of sym name */
	        bfn0a ();		/* output 8 bytes from usname */
	        pb (hbbs, EXPFUNC, 0);	/* put common block def on bo */
#else
		temp = 0x0e1400L;	/* first 3 bytes of debugger obj rec */
		if (stp->desc.flags & CSDS)	/* is symbol in csect */
		  temp |= 1;		/* yes, set csect flag */
		bfa (temp);		/* put 3 bytes in stack */
		bfb (LFCDBUG);		/* set symbol type to statement */
    		bfb (0);		/* reserved byte of zero */
		bfh (4);		/* size is 4 bytes */
		bfw ((int32)stp->desc.value << 3); /* sym addr left shifted 3 bits */
	        memCpy (usname, stp->sym, 8);	/* move 8 bytes of sym name */
	        bfn0a ();		/* output 8 bytes from usname */
	        pb (hbbs, EXPFUNC, 0);	/* put common block def on bo */
#endif
	      }				/* symbol is absolute */
	    }				/* no debug option */
	  } else			/* type not local */
	  if (stp->desc.type == TYPX) {	/* is this an external symbol */

	    /* process external symbol references */
	    *hbbs = 0;			/* reset binary output stream */
	    if (!(bits3 & EXPLFC)) {	/* use expanded loader codes */

	      /* use standard loader function codes */
	      bfo (stp);		/* output the external name */
	      sbp = (struct strback FAR *)stp->desc.value;  /* get sb addr */
	      temp = (int32)sbp->dsdesc.value;	/* get dsect stringback */
	      if (sbp->dsdesc.flags & ABSREL)  /* is value rel */
		temp |= 0x00800000L;	/* yes, set rel flag */
	      bfa (temp);		/* output sb address */
	      pb (hbbs, PTEX, 0);	/* publish binary stack */
	    } else {			/* use expanded function codes */

	      /* use expanded loader function codes */
	      bfb (LFEXTRF);		/* put out loader funct sub code */
	      bfb (0);			/* put out dummy byte count */
	      bfb (0);			/* put out unused byte count */
	      sbp = (struct strback FAR *)stp->desc.value;  /* get sb addr */
	      temp = (int32)sbp->dsdesc.value;	/* get dsect stringback */
	      if (sbp->dsdesc.flags & ABSREL)  /* is value rel */
		temp |= 0x00800000L;	/* yes, set rel flag */
#ifdef MACS
memCpy (usname, stp->sym, 8);	/* move 8 bytes of sym name */
usname[8] = '\0';
printf("temp = %x EXTERN [%s]\n", temp, usname);
prtval("end2 stp", &stp->desc);
prtval("end2 ds sbp", &sbp->dsdesc);
#endif
	      if (temp) {		/* any dsect references */
		/* yes, process dsect stringback */
		if (sbp->dsdesc.flags & CSDS) /* pointing into csect */
		  bfb (1);		/* output csect reference */
		else
		  bfb (0);		/* output dsect reference */
	        if (sbp->dsdesc.flags & ABSREL)  /* is value rel */
		  temp |= 0x00800000L;	/* yes, set rel flag */
	        bfa (temp);		/* output sb address */
	        memCpy (usname, stp->sym, 8);	/* move 8 bytes of sym name */
	        bfn0 ();		/* output 8 bytes from usname */
	        pb (hbbs, EXPFUNC, 0);	/* put common block def on bo */
	      }	/* no dsect stringback */

	      /* process csect stringback */
	      *hbbs = 0;		/* reset binary output stream */
	      bfb (LFEXTRF);		/* put out loader funct sub code */
	      bfb (0);			/* put out dummy byte count */
	      bfb (0);			/* put out unused byte count */
	      sbp = (struct strback FAR *)stp->desc.value;  /* get sb addr */
	      temp = (int32)sbp->csdesc.value;	/* get csect stringback */
	      if (sbp->csdesc.flags & ABSREL)  /* is value rel */
		temp |= 0x00800000L;	/* yes, set rel flag */
#ifdef MACS
memCpy (usname, stp->sym, 8);	/* move 8 bytes of sym name */
usname[8] = '\0';
printf("temp = %x EXTERN [%s]\n", temp, usname);
prtval("end2 stp", &stp->desc);
prtval("end2 cs sbp", &sbp->csdesc);
#endif
	      if (temp) {		/* any csect references */
		/* yes, process csect stringback */
		if (sbp->csdesc.flags & CSDS) /* pointing into csect */
		  bfb (1);		/* output csect reference */
		else
		  bfb (0);		/* output dsect reference */
	        if (sbp->csdesc.flags & ABSREL)  /* is value rel */
		  temp |= 0x00800000L;	/* yes, set rel flag */
	        bfa (temp);		/* output sb address */
	        memCpy (usname, stp->sym, 8);	/* move 8 bytes of sym name */
	        bfn0 ();		/* output 8 bytes from usname */
	        pb (hbbs, EXPFUNC, 0);	/* put common block def on bo */
	      }	/* no csect stringback */
	    }
	  }	/* not type external */
	  stp = stp->flink;		/* fetch next symbol pointer */
	}	/* end of symbol table scan */

/*
printf("end2 process end address\n");
fflush(stdout);
*/
	/* compute transfer address from end statement */
	unst (0x81fd0000L);		/* unstring something */
	if (*usname != ' ') {		/* anything unstrung */
	  /* yes, we have a transfer address */
	  hweval = val (1);		/* evaluate unstrung name */
#ifdef DEBUG
prtval("end: hweval", &hweval);
#endif
	  if (hweval.value & 1)		/* is address even */
	    /* no, we have a bounding error */
	    seterr ('B');		/* set bounding error */
	  if (hweval.flags & CSDS)	/* address in dsect */
	    hbbn = 1;			/* show csect section */
	  else
	    hbbn = 0;			/* show dsect section */
	  *hbbs = 0;			/* reset binary output stream */
	  if (hweval.flags & ABSREL) {	/* is address relative */
	    hweval.value |= 0x800000L;	/* addr is rel, set abs/rel flag */
	    if (bits3 & EXPLFC) {	/* are we using exp funct codes */
	      /* yes, generate expanded function codes */
	      bfb (LFTRANS);		/* output loader funct sub code */
	      bfb (0);			/* put out dummy byte count */
	      bfb (0);			/* put out unused byte count */
	      bfb (hbbn);		/* put out section number */
	      bfa0 ((int32)hweval.value);	/* put transfer addr on binary stack */
	      pb (hbbs, EXPFUNC, 0);	/* publish terminal transfer address */
	    } else {			/* use std loader function codes */ 
	      bfa ((int32)hweval.value);	/* put transfer addr on binary stack */
	      pb (hbbs, PTTR, 0);	/* publish terminal transfer address */
	    }
	  } else {			/* use std loader function codes */ 
	    bfa ((int32)hweval.value);	/* put transfer addr on binary stack */
	    pb (hbbs, PTTR, 0);		/* publish terminal transfer address */
	  }
	}	/* no transfer address */

/*
printf("end2 no transfer address\n");
fflush(stdout);
*/
	/* allow end card out */
	bits |= IMIN;			/* show buffer image ready */
	currpc.flags &= ~CSDS;		/* dsect for end card */
	currpc = dsize;			/* default to dsect size */
	if (currpc.value < max.value)	/* is max bigger */
	  currpc = max;			/* use max instead */
	currpc.type = TYPP;		/* insure correct type */
	currpc.flags &= ~CSDS;		/* dsect for end card */
	*hbbs = 0;			/* reset binary output count */
	if (!(bits3 & EXPLFC)) {	/* use expanded loader codes */
	  /* no, use std loader code, put end addr in binary output */
	  temp = currpc.value;		/* save for output */
	  if (currpc.flags & ABSREL)	/* current sect abs or rel */
	    temp |= 0x800000L;		/* set rel flag */
	  bfa (temp);			/* put end address in stack */
	  pb (hbbs, PTO, 0);		/* publish it */
	}
/*
prtval("end2: hweval", &hweval);
fflush(stdout);
*/
	bits |= CVFL;			/* print program counter */
	releas ();			/* print the output */

	/* send out the last byte */
	*hbbs = 1;			/* one byte out */
	hbbs[1] = 0;			/* 1 byte of zero */
	pb (hbbs, 0xf, 0);		/* last byte loader function code */

	/* output number of error during pass 2 */
	{
	  char errmsg[32];

	  sprintf(errmsg, "*  %0.4ld  ERRORS IN %.8s ", hwerct, TCWPROG);
/* printf("program name %.8s, errmsg = %.28s\n", TCWPROG, errmsg); */
	  ppp (28, errmsg, hwerct);	/* print the line */
	}

/*
printf("end2 dump undefined symbols\n");
fflush(stdout);
*/
	/* dump undefined symbols to listing device */
	{
	  char	udmsg[24];

	  stp = symtab;
	  while(stp) {				/* look at all symbols */
	    if (stp->desc.type == TYPU) {	/* is it undefined */
	      sprintf (udmsg,"UNDEFINED      %.8ls", stp->sym);
	       ppp (23, udmsg, 0);		/* print the line */
	    }
	    stp = stp->flink;			/* next symbol */
	  }
	  ejct2 (tcwd);				/* force header for tof on lo */
	  end2flag = 1;				/* show pass2 end processed */
	}
/*
printf("end2 all done, return\n");
fflush(stdout);
*/
	return;
}

/*
 * bfo - put item from symbol table in bo stack
 * input - stp = symbol table pointer for entry to output
 */

void	bfo(stp)
struct symbol FAR * stp;
{
	*hbbs = 0;			/* reset bo stack */
	memCpy (usname, stp->sym, 8);	/* copy in 8 bytes */
	bfn ();				/* use bfn to copy name */
	return;
}

/*
 * bfn - put name from usname into bo stack
 *	 terminate on first space
 *       output pointer is initialized to zero
 * input - name to output in usname
 */
         
void	bfn()
{

	*hbbs = 0;			/* initialize count to zero */
	bfn0 ();			/* use bfn0 to output name */
	return;
}

/*
 * bfn0 - put name from usname into bo stack
 *	 terminate on first space
 *       output pointer is not initialized to zero
 * input - name to output in usname
 */
         
void	bfn0()
{
	int	i;

	for (i=0; i < 8; i++) {		/* max of 8 chars to output */
	  if (usname[i] == ' ')		/* if blank, terminate store */
	    break;
	  else
	    bfb (usname[i]);		/* output character */
	}

}

#ifndef CAID
/*
 * bfn0a - put name from usname into bo stack
 *	output all 8 bytes
 *	output pointer is not initialized to zero
 * input - name to output in usname
 */
         
void	bfn0a()
{
	int	i;

	for (i=0; i < 8; i++) {		/* max of 8 chars to output */
	    bfb (usname[i]);		/* output character */
	}

}
#endif

/*
 * bfa0 - put 3 bytes into binary stack
 *        the data is right justified in val
 *	  bit 8 (abs/rel flag) is reset before output
 * input - 24 bits right justified
 *	   leftmost bits are output first
 */

void	bfa0 (val1)
int32	val1;
{
	bfa (val1 & 0x7fffffL);		/* use bfa to output data */
	return;
}

#ifndef CAID
/*
 * bfw - put 4 bytes into binary stack
 *       the data is right justified in val
 * input - 32 bits right justified
 *	   leftmost bits are output first
 */

void	bfw (val2)
int32	val2;
{
	bfb ((int32)(val2 & 0xff000000L) >> 24); /* output 1st byte */
	bfb ((int32)(val2 & 0xff0000L) >> 16);	/* output 2nd byte */
	bfb ((int32)(val2 & 0xff00L) >> 8);	/* output 3rd byte */
	bfb (val2 & 0xffL);			/* output 4th byte */
	return;
}
#endif

/*
 * bfa - put 3 bytes into binary stack
 *       the data is right justified in val
 * input - 24 bits right justified
 *	   leftmost bits are output first
 */

void	bfa (val2)
int32	val2;
{
	bfb ((int32)(val2 & 0xff0000L) >> 16);	/* output 1st byte */
	bfb ((int32)(val2 & 0xff00L) >> 8);	/* output 2nd byte */
	bfb (val2 & 0xffL);		/* output 3rd byte */
	return;
}

#ifndef CAID
/*
 * bfh - put 2 bytes into binary stack
 *       the data is right justified in val
 * input - 16 bits right justified
 *	   leftmost bits are output first
 */

void	bfh (val2)
int	val2;
{
	bfb ((int32)(val2 & 0xff00L) >> 8);	/* output 1st byte */
	bfb (val2 & 0xffL);		/* output 2nd byte */
	return;
}
#endif

/*
 * bfb - put 1 byte in binary stack (hbbs)
 * input - byte to be output
 */

void	bfb(val3)
int	val3;
{
	hbbs[0]++;			/* incr stack count */
	hbbs[hbbs[0]] = val3;		/* store byte in stack */
	return;
}

/*
 * data - process data, datab, datah, dataw, datad
 */

void	data()
{
again:
/* printf("data: calling tdat\n"); */
	hwindr = 0;			/* clear indirect addr flag */
	tot = (1 << curops->binop);	/* 0-3 becomes 1-8 */
	hbtttf = 0;			/* indicate data statement */
	inac.value = 0;			/* clear address attribute area */
	inac.flags = 0;			/* clear flags attribute area */
	inac.type = 0;			/* clear type attribute area */
/* printf("data: tot = %d, opcode = %s, binop = %d\n", tot, curops->opcode, curops->binop); */
	tdat ();			/* translate rest of data statement */
/* printf("data: return from tdat, term = %c\n", hbstac[0]); */
	if (hbstac[0] == ',')		/* is there mode data */
	  goto again;			/* go do it again */
	return;				/* no,all done */
}

/*
 * vfd - gen data processing
 */

void	vfd()
{
	int32	*dv;			/* cnum return pointer */
	int32	fsize;
	int	i;

	hwindr = 0;			/* clear indirect addr flag */
	hhvfx = 0;			/* clear bit stack */
	hhvfo = 0;			/* clear bit stack position ptr */
	do {				/* loop while we have comma term */
	  hhvff = 0;			/* clear bits scanned counter */
	  hhvfgb = 0;			/* clear good bits for element cnt */
	  if (inptstat & FORMGET) {	/* as we processing a form */
	    while (1) {			/* forever */
	      fsize = *hwcmacp++;	/* pointer to form field info */
	      if (fsize == 0xff)	/* see if at end of form */
	        hwcmacp = hwcmac;	/* reset pointer to beginning */
	      else
		break;			/* exit while with count */
	    }
	  } else {			/* not form expansion */
	    unst(0x80010000L);		/* unstring the field length */
	    if (unterm == '/') {	/* / is the field size term */
	      dv = cnum (10);		/* get the number */
	      fsize = dv[0] & 0xffffL;	/* get size form l/o part of number */
	    } else {			/* invalid term, error */
	      fsize = 5000L;		/* to fail following test */
	    }
	    if (fsize > 4096L) {	/* is field size larger than max */
	      if (yeanay())		/* are we assembling */
	        seterr ('H');		/* set invalid VFD statement error */
	      fsize = 32;		/* set to default value */
	    }
	  }
	  hhvfs = fsize;		/* set final field size */
	  tot = 8;			/* gens are size double */
	  hbtttf = 4;			/* identify us as a gen */
	  inac.value = 0;		/* default to zero */
	  inac.type = 0;		/* and to data type */
	  inac.flags = 0;		/* and to dsect/abs */
	  for(i=0; i<4; i++)		/* clear the terminator list */
	    hbstac[i] = ' ';		/* to blanks */
/*
printf("gen: hhvfgb = %d, hhvfs = %d, hhvfo = %d\n", hhvfgb, hhvfs, hhvfo);
*/
	  tdat ();			/* convert the constant */
/*
printf("gen1: hhvfgb = %d, hhvfs = %d, hhvfo = %d\n", hhvfgb, hhvfs, hhvfo);
*/
	  while (hhvfgb < hhvfs) {	/* pad till enough bits out */
/*
printf("gen2: hhvfgb = %d, hhvfs = %d, hhvfo = %d\n", hhvfgb, hhvfs, hhvfo);
*/
	    vfdo ((int32)' ', 8);	/* output a padding space */
	  }
	  continue;			/* yes, go get next element */
	} while (hbstac[0] == ',');	/* loop till non comma */
/*
printf("gen3: hhvfgb = %d, hhvfs = %d, hhvfo = %d\n", hhvfgb, hhvfs, hhvfo);
*/
	vfdo ((int32)0, 7);		/* push out 1 bit less than byte */
					/* to empty hhvfx */
	return;				/* done */
}

/*
 * vfdo - packer of variable size bit fields and issuer of bytes
 *	  data is inserted from the right
 * input - data = right justified data to go out
 *       - bcnt = number of bits to pack (1-8)
 */

void	vfdo(data1, bcnt)
int32	data1;
int	bcnt;
{
	struct	tval	tempc;
	int32	mask = (1L << bcnt) - 1;	/* mask for incomming data */
/*
printf("vfdo: data=%x bcnt=%d\n", data1, bcnt);
*/
	hhvfx = (hhvfx << bcnt) | (data1 & mask);	/* insert data */
	hhvfo += bcnt;			/* add new bit count to old */
	hhvfgb += bcnt;			/* add to bit count released */
	hhvff += 8;			/* add to field count */
	if (hhvfo < 8)			/* if not a byte yet return */
	  return;			/* not 8 bits yet */
	/* we have a byte to release */
	hhvfo &= 7;			/* bits that will be left */
	if (hhvfs != hhvfgb)		/* are we at end of gen */
	  goto vfdf;			/* no, ignore relocation checks */
	/* here we must check if relocation will be required */
	if (hhvfo)			/* any bits in stack */
	  goto vfdc;			/* yes, check type */
	tempc = sectpc[pcmode];		/* get current PC */
	if ((tempc.value & 3) != 3)	/* must be 3 for rel,ext,com types */
	  goto vfdc;			/* not there, insure prog abs type */
	if (hhvfs < 19 || hhvfs > 32)	/* is field size in range for reloc */
	  goto vfdc;			/* no, must be prog abs type then */
	hweval = inac;			/* output definitions */
	if (inac.type == TYPC)		/* is type common */
	  hbbn = inacbn;		/* save the block number if any */
	else
	  hbbn = secnac;		/* save sect # if any */
vfdf:
	/* gen a byte of whats left after shifting off bits to save */
/*
printf("vfdoX: byte = %x, hhvfo=%d, hhvfgb=%d, hhvfs=%d\n",
	((hhvfx >> hhvfo) & 0xff), hhvfo, hhvfgb, hhvfs);
*/
	igen ((int)((hhvfx >> hhvfo) & 0xff));	/* gen a byte */
	return;				/* exit */
vfdc:
	if (inac.type == 0 && inac.flags == 0)	/* null abs type is o.k. */
	  goto vfdf;			/* gen data */
	/* if program absolute, then o.k. to do gen */
	if ((inac.type == TYPP) && !(inac.flags & ABSREL))
	  goto vfdf;			/* gen data */
	/* not a valid type, give relocation error */
	if (yeanay())			/* are we assembling */
	  seterr ('R');			/* set relocation error */
	goto vfdf;			/* dump the data after error */
}
