/*~!ctscan.c*/
/* Name:  ctscan.c Part No.: _______-____r
 *
 * Copyright 1995 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"$Id: ctscan.c,v 1.2 1995/03/07 23:26:43 jbev Exp $"

/*
 * ctscan - syntax scanner for command line
 *
 *	Gets a string from the line buffer at current cursor position
 *	Each call gets one argument of a maximum of N characters
 *
 *	Calling sequence len = ctscan(buffer, maxlen)
 *	where:
 *		len:	length of line returned, 0 if end of line
 *		buffer:	char pointer to callers return buffer
 *		maxlen:	maximum length of buffer to be returned
 *
 */

/* Log: $
 *
 */

static int get_lbuf();	/* line buffer get routine */
static char input[255];	/* local copy of scan line */
static char *linep = 0;	/* current position in input array */
static int eol = 0;	/*  end of line flag, set when c/r or ! found */

int ctscan(bufr, mlen)
char *	bufr;
int	mlen;
{
  char cib;	/* current input byte */
  char sb = 0;	/* zero if skipping leading blanks */
  char pt = 0;	/* non zero if skipping text */
  char pt2 = 0;	/* non zero if skipping text */
  int cnt = 0;	/* num of chars in bufr */

  /* set output string to null,to show no output yet */
  *bufr = '\0';		/* terminate output line */
  if (eol) {		/* at end of line, reset & return null */
    eol = 0;
    return (0);		/* return null */
  }
  if (linep == 0 && get_lbuf() == 0) return(0);	/* all done if nothing */
  /* process chars till end of line or max count */
  while ((cib = *linep++) && mlen--) {
    switch (cib) {
      case ' ':		/* a blank */
        if (pt||pt2)goto putout;	/* if passing text, output blank */
        if (!sb) continue;	/* ignore leading blanks */
        /* drop thru if not ignoring blanks */
      case ',':		/* comma is delimiter */
      case '=':		/* equal sign is delimiter */
        if (pt||pt2)goto putout;	/* if passing text, output character */
        if (cnt == 0) continue;	/* if nothing found yet, ignor delimiter */
        goto detok;		/* done with is entry */
      case '\n':	/* new line is delimiter */
      case '\r':	/* c/r is delimiter */
      case '\0':	/* null is delimiter */
      case '!':		/* ! is delimiter */
        eol = 1;	/* we are at end of input */
        goto detok;		/* done with is entry */
      case '\'':	/* apost is delimiter */
        if (pt2)continue;	/* if passing text, skip apost */
        if (pt) goto detok;	/* if passing text, now a delimiter */
        pt = 1;		/* now passing text, throw away apost */
        continue;
      case '\"':	/* quote is delimiter */
        if (pt)continue;	/* if passing text, skip quote */
        if (pt2) goto detok;	/* if passing text, now a delimiter */
        pt2 = 1;	/* now passing text, throw away quote */
        continue;
      default:
putout:
        sb = 1;		/* not skipping blanks anymore */
        *bufr++ = cib;	/* put char in output buffer */
        cnt++;		/* bump the count */
        continue;	/* continue processing */
    }
  }
detok:
  *bufr = '\0';		/* null terminate line */
  if (eol) linep = 0;	/* reset linepointer to read input again */
  return (cnt);		/* return what we go */

}

/* This function only works with non-TXPM tasks */
static int get_lbuf()
{
  int regs[8];

  if (linep != 0)return(0);		/* return if scan buffer active */

  mpxsvc(0x2061, regs, regs);		/* m.cmd, get line buf address */
  if(!regs[7])return(0);		/* if error, return */

  /* when mapped out, TXPM is not on system, so address is in O/S */
  regs[1] = regs[7];			/* address of line buffer */
  regs[2] = (int)input;			/* where to copy to */
  regs[4] = regs[6];			/* length of line buffer */
  regs[7] = 0;				/* will be nozero if error */
  mpxsvc(0x207e, regs, regs);		/* copy in the line buffer */
  if(regs[7])return(0);			/* if error, return */
  input[regs[6]] = '\0';		/* null terminate string */
  linep = input;			/* set local pointer address */
  return (regs[6]);			/* return count */
}
