
     NAME
          scanf, fscanf, sscanf - convert formatted input

     SYNTAX
          #include <stdio.h>

          int scanf (format [ , pointer ] ...  )
          char *format;

          int fscanf (stream, format [ , pointer ] ...  )
          FILE *stream;
          char *format;

          int sscanf (s, format [ , pointer ] ...  )
          char *s, *format;

     DESCRIPTION
          Scanf reads from the standard input stream stdin.  Fscanf
          reads from the named input stream.  Sscanf reads from the
          character string s.  Each function reads characters,
          interprets them according to a format, and stores the
          results in its arguments.  Each expects, as arguments, a
          control string format described below, and a set of pointer
          arguments indicating where the converted input should be
          stored.

          The control string usually contains conversion
          specifications, which are used to direct interpretation of
          input sequences.  The control string may contain:

          1. White-space characters (blanks, tabs, new-lines, or
             form-feeds) which, except in two cases described below,
             cause input to be read up to the next non-white-space
             character.
          2. An ordinary character (not %), which must match the next
             character of the input stream.
          3. Conversion specifications, consisting of the character %,
             an optional assignment suppressing character *, an
             optional numerical maximum field width, an optional l
             (ell) or h indicating the size of the receiving variable,
             and a conversion code.

          A conversion specification directs the conversion of the
          next input field; the result is placed in the variable
          pointed to by the corresponding argument, unless assignment
          suppression was indicated by *.  The suppression of
          assignment provides a way of describing an input field which
          is to be skipped.  An input field is defined as a string of
          non-space characters; it extends to the next inappropriate
          character or until the field width, if specified, is
          exhausted.  For all descriptors except ``['' and ``c'',
          white space leading an input field is ignored.

          The conversion code indicates the interpretation of the
          input field; the corresponding pointer argument must usually
          be of a restricted type.  For a suppressed field, no pointer
          argument is given.  The following conversion codes are
          legal:

          %    a single % is expected in the input at this point; no
               assignment is done.
          d    a decimal integer is expected; the corresponding
               argument should be an integer pointer.
          u    an unsigned decimal integer is expected; the
               corresponding argument should be an unsigned integer
               pointer.
          o    an octal integer is expected; the corresponding
               argument should be an integer pointer.
          x    a hexadecimal integer is expected; the corresponding
               argument should be an integer pointer.
          e,f,g
               a floating point number is expected; the next field is
               converted accordingly and stored through the
               corresponding argument, which should be a pointer to a
               float.  The input format for floating point numbers is
               an optionally signed string of digits, possibly
               containing a decimal point, followed by an optional
               exponent field consisting of an E or an e, followed by
               an optional +, -, or space, followed by an integer.
          s    a character string is expected; the corresponding
               argument should be a character pointer pointing to an
               array of characters large enough to accept the string
               and a terminating \0, which will be added
               automatically.  The input field is terminated by a
               white-space character.
          c    a character is expected; the corresponding argument
               should be a character pointer.  The normal skip over
               white space is suppressed in this case; to read the
               next non-space character, use %1s.  If a field width is
               given, the corresponding argument should refer to a
               character array; the indicated number of characters is
               read.
          [    indicates string data and the normal skip over leading
               white space is suppressed.  The left bracket is
               followed by a set of characters, which we will call the
               scanset, and a right bracket; the input field is the
               maximal sequence of input characters consisting
               entirely of characters in the scanset.  The circumflex
               (^), when it appears as the first character in the
               scanset, serves as a complement operator and redefines
               the scanset as the set of all characters not contained
               in the remainder of the scanset string.  There are some
               conventions used in the construction of the scanset.  A
               range of characters may be represented by the construct
               first-last, thus [0123456789] may be expressed [0-9].

               Using this convention, first must be lexically less
               than or equal to last, or else the dash will stand for
               itself.  The dash will also stand for itself whenever
               it is the first or the last character in the scanset.
               To include the right square bracket as an element of
               the scanset, it must appear as the first character
               (possibly preceded by a circumflex) of the scanset, and
               in this case it will not be syntactically interpreted
               as the closing bracket.  The corresponding argument
               must point to a character array large enough to hold
               the data field and the terminating \0, which will be
               added automatically.  At least one character must match
               for this conversion to be considered successful.

          The conversion characters d, u, o, and x may be preceded by
          l or h to indicate that a pointer to long or to short rather
          than to int is in the argument list.  Similarly, the
          conversion characters e, f, and g may be preceded by l to
          indicate that a pointer to double rather than to float is in
          the argument list.  The l or h modifier is ignored for other
          conversion characters.

          Scanf conversion terminates at EOF, at the end of the
          control string, or when an input character conflicts with
          the control string.  In the latter case, the offending
          character is left unread in the input stream.

          Scanf returns the number of successfully matched and
          assigned input items; this number can be zero in the event
          of an early conflict between an input character and the
          control string.  If the input ends before the first conflict
          or conversion, EOF is returned.

     EXAMPLES
          The call:

               int i, n; float x; char name[50];
               n = scanf("%d%f%s", &i, &x, name);

          with the input line:

               25 54.32E-1 thompson

          will assign to n the value 3, to i the value 25, to x the
          value 5.432, and name will contain thompson\0.  Or:

               int i; float x; char name[50];
               (void) scanf("%2d%f%*d %[0-9]", &i, &x, name);

          with input:

               56789 0123 56a72

          will assign 56 to i, 789.0 to x, skip 0123, and place the
          string 56\0 in name.  The next call to getchar (see
          getc(3S)) will return a.

     SEE ALSO
          getc.m, printf.m, strtod.m, strtol.m

     NOTE
          Trailing white space (including a new-line) is left unread
          unless matched in the control string.

     DIAGNOSTICS
          These functions return EOF on end of input and a short count
          for missing or illegal data items.

     SPECIAL CONSIDERATIONS
          The success of literal matches and suppressed assignments is
          not directly determinable.

          (printed 07/30/92 - J B Systems)

