/*
 * unblk.c
 *
 * This program uncompresses MPX compressed files and
 * deletes trailing blanks from a source file
 * input - stdin   
 * output - stdout
 */

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
	unsigned char s[BUFSIZ];

	while (1)
	{
		if (rbl(s, BUFSIZ) <= 0)
			exit(0);
#ifdef JUNK
		s[72] = '\n';
		s[73] = '\0';
#endif
		putloi(s);
	}
}

/* get a line of input. */

int getloi(s, lim)				/*  right from the book.  */
unsigned char s[];
int lim;
{
	int c, i;

	for (i = 0; --lim > 0 && (c = getchar()) != EOF;)
	{
		if ((i >= 6) && ((c == 0xbf) || (c == 0x9f)))
		{
			ungetc(c, stdin);
			return (i);
		}
		s[i++] = c;
		if ((*s != 0xbf) && (*s != 0x9f))
		{
			if (c == '\n')
			{
				if ((s[i - 1] == '\n') && (i > 1))
				{
					while ((s[i - 2] == ' ') && (i > 1))
						--i;
					s[i - 1] = '\n';
				}
				s[i] = '\0';
				return (i);
			}
		}
	}
#ifdef JUNK
	for (i = 0; --lim > 0 && (c = getchar()) != EOF && (s[i++] = c) != '\n';);
	if ((s[i - 1] == '\n') && (i > 1))
	{
		while ((s[i - 2] == ' ') && (i > 1))
			--i;
		s[i - 1] = '\n';
	}
	s[i] = '\0';
#endif
	return (i);
}

/*
 **  output line of text from the source
 */
int putloi(s)
unsigned char *s;
{
	printf("%s", s);
}

unsigned char line[BUFSIZ];
int cmpop = 0;
int cmpflg = 0;
int bcnt = 0;
unsigned char *bptr = 0;
int binary = 1;
int recl = 0;

int rbl(buf, n)
unsigned char *buf;
int n;
{
	register int count = 0;
	register unsigned char *cp;
	int i;

	unsigned char *linadrs = line;

	if (!cmpop)
	{							/* see if we tested for compressed */
		cmpop = 1;				/* set comp tested flag */
		/* read in the first record */
		if ((recl = getloi(line, BUFSIZ)) == 0)
			return (0);			/* this means eof */
		linadrs = line;
		if (*linadrs == 0xbf)
		{						/* is this file compressed */
			cmpflg = 1;			/* set comp data flag */
			bcnt = linadrs[1];	/* set record count */
			bptr = &linadrs[6];	/* set data address */
		}
		else
			goto re00;
	}

	if (cmpflg)
	{							/* reading compressed data? */
		if (bcnt == 0)
		{						/* any data left in buffer */
		  re18:
			/* read in a data record */
			if ((recl = getloi(line, BUFSIZ)) == 0)
				return (0);		/* this means eof */
			linadrs = line;
			if ((*linadrs & 0xdf) != 0x9f)	/* is this valid rec */
				return (EOF);	/* error if not */
			bcnt = linadrs[1];	/* set record count */
			bptr = &linadrs[6];	/* set data address */
		}
	  re20:
		/* see if any blanks */
		if (i = *bptr++)
		{						/* next buffer pointer */
			if (i == 0xff)
				goto re60;		/* if eol, get out */
			while (i--)
			{
				if (count < n)
				{
					*buf++ = ' ';	/* put blank in buffer */
					count++;
				}
			}
		}
		if (--bcnt <= 0)
			goto re18;			/* read next record */

		if (i = *bptr++)
		{						/* next buffer pointer */
			while (i--)
			{
				if (count < n)
					*buf++ = *bptr;	/* put char in buffer */
				bcnt--;			/* decr count */
				bptr++;			/* next buffer pointer */
				count++;
			}
		}
		if (--bcnt <= 0)
			goto re18;			/* read next record */
		goto re20;

	  re60:
		bcnt--;					/* decr count */
		if ((*--buf == ' ') && (count == 1))
		{
			*buf = '\n';		/* put new line at eol */
		}
		else
		{
			*++buf = '\n';		/* put new line at eol */
			count++;
		}

	}
	else
	{

		/* non compressed read here */

		/* read the next record */
		if ((recl = getloi(line, BUFSIZ)) == 0)
			return (0);			/* this means eof */

	  re00:
		/* here we need to strip off blank put in during write */
		/* this is because mpx does not support zero length blocks */
		if ((recl == 1) && (*linadrs == ' '))
			recl = 0;
		/* now append new line to end of buffer */
		if (!binary)
			*(cp = linadrs + recl) = '\n';	/* point to last char */

		/* copy this layer buffer to upper caller's buffer */

		while (count < n)
		{
			if (linadrs > cp)
				break;
			*buf++ = *linadrs++;
			count++;
		}
	}

	return (count);

}
