/* math.s */
*       UNIX 64 BIT MATCH SIMULATION          21-jul-87 HEADER  MATH.S
************************************************************************
*
*        RESTRICTED RIGHTS LEGEND
*
*        USE, DUPLICATION, OR DISCLOSURE IS SUBJECT TO THE RESTRICTIONS
*        STATED IN ISC'S LICENSE AGREEMENT (FORM NO. 1218) OR, FOR
*        GOVERNMENT CUSTOMERS, DAR 7-104.9A.
*
************************************************************************
         SPACE     2
         PROGRAM   MATH        FILE:  MATH.S
         DEF       VER.MATH
         DEF       PRG.MATH
VER.MATH EQU       X'A000'
PRG.MATH EQU       X'3860'
************************************************************************
*                                                                      *
*                   MATH CHANGE HISTORY                                *
*                                                                      *
************************************************************************
*   VER       DATE      BY             DESCRIPTION.                    *
************************************************************************
*                                                                      *
*  A000      07/21/87   JCB           GENERATE INITIAL VERSION         *
*                                                                      *
************************************************************************
         SPACE      5
         LIST      ON,NOMAC,NOREP
************************************************************************
*        DEFINE ENTRIES                                                *
************************************************************************
         SPACE     2
         DEF       _add64
         DEF       _and64
         DEF       _atofhep
         DEF       _atoi64
         DEF       _compare64
         DEF       _compone64
         DEF       _div64
         DEF       _fadd64
         DEF       _fdiv64
         DEF       _fix64
         DEF       _float64
         DEF       _fmul64
         DEF       _fsub64
         DEF       _lshift64
         DEF       _rshift64
         DEF       _mod64
         DEF       _mul64
         DEF       _or64
         DEF       _sub64
         DEF       _xor64
         EXT       _atof
         EXT       _atoi
         SPACE     2
************************************************************************
*   REGISTER EQUATES
************************************************************************
         SPACE     1
AP       EQU       1              ARGUMENT POINTER
X1       EQU       1
X2       EQU       2              GENERAL INDEX NUMBER 2
SP       EQU       3              STACK POINTER
X3       EQU       3
         SPACE     1
R0       EQU       0              GENERAL REGISTER EQUATES
R1       EQU       1
R2       EQU       2
R3       EQU       3
R4       EQU       4
R5       EQU       5
R6       EQU       6
R7       EQU       7
         PAGE
************************************************************************
*   LOCAL MACROS
************************************************************************
         SPACE     1
ENTER    DEFM
         TRR       SP,R1           STACK PTR FOR CALLING FUNCTION
         ADI       SP,-16W         DECREMENT SP FOR CALLED ROUTINE A001
         STD       R0,2W,SP        STORE RETURN ADDR IN STACK & PREV. SP
         STF       R4,4W,SP        STORE REGS 4 THROUGH 7 IN STACK
         LA        AP,8W,R1        PUT ARG AREA ADDR IN AP
         ENDM
         SPACE     1
RETURN   DEFM
         LF        R2,2W,SP        RESTORE REGISTERS FROM STACK
         TRSW      R2              RETURN TO CALLING ROUTINE
         BOUND     1W
         ENDM
         SPACE     2
************************************************************************
*
*   PROGRAMMING CONVENTIONS
*
*   1) THE ARGUMENT POINTER IS MAINTAINED IN REGISTER AP.  AP IS SAVED
*   AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR, SVC'S.
*
*   2) ALL ENTRIES INTO THIS PACKAGE ARE FUNCTIONS, THAT IS, THEY RETURN
*   A VALUE.  THE VALUE IS RETURNED IN R0.  ERRORS ARE GENERALLY
*   INDICATED BY -1.  SUCCESS IS GENERALLY INDICATED BY 0.  CREAT AND
*   OPEN RETURN THE FILE DESCRIPTOR TO SHOW SUCCESS.  WRITE RETURNS 0
*   TO INDICATE EOF DETECTED AND N(>0) TO INDICATE THE NUMBER OF
*   CHARACTERS ACTUALLY TRANSFERRED.
*
*   3) UTILITY SUBROUTINES EXPECT AP AND X2 TO BE PROPERLY INITIALIZED.
*   RESULTS ARE RETURNED IN R7.  ERRORS ARE GENERALLY INDICATED BY -1.
*   SUCCESS IS GENERALLY INDICATED BY 0.
*
************************************************************************
         PAGE
         CSECT
************************************************************************
* add64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_add64   EQU       $              64 bit add
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         ADMD      R6,2D,AP       ADD SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* sub64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_sub64   EQU       $              64 bit sub
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         SUMD      R6,2D,AP       SUB SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* and64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_and64   EQU       $              64 bit and
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         ANMD      R6,2D,AP       AND IN SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* fadd64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_fadd64  EQU       $             64 bit fadd
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         ADFD      R6,2D,AP       FADD SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* fsub64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_fsub64  EQU       $              64 bit fsub
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         SUFD      R6,2D,AP       FSUB SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* fmul64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_fmul64  EQU       $              64 bit fmul
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         MPFD      R6,2D,X2       FMUL SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* fdiv64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_fdiv64  EQU       $              64 bit fdiv
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         DVFD      R6,2D,AP       FDIV SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* mul64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_mul64   EQU       $              64 bit mul
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         MPMW      R6,5W,AP       MUL SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* or64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_or64    EQU       $              64 bit or
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         ORMD      R6,2D,AP       OR IN SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* xor64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_xor64   EQU       $              64 bit xor
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         EOMD      R6,2D,AP       XOR IN SECOND VALUE
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* lshift64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_lshift64  EQU     $              64 bit lshift
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         LW        R4,4W,AP       GET SHIFT COUNT
         BLE       LSX            EXIT IF LE 0
         ANMW      R4,=X'7F'      MASK
         BZ        LSX            EXIT IF ZERO
         TRN       R4,R4          NEG FOR LOOP
LS64     SLLD      R6,1           SHIFT ONE
         BIB       R4,LS64        LOOP
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
LSX      RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* rshift64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_rshift64  EQU     $              64 bit rshift
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,X2       PICK UP 1ST VALUE
         LW        R4,4W,AP       GET SHIFT COUNT
         BLE       RSX            EXIT IF LE 0
         ANMW      R4,=X'7F'      MASK
         BZ        RSX            EXIT IF ZERO
         TRN       R4,R4          NEG FOR LOOP
RS64     SRLD      R6,1           SHIFT ONE
         BIB       R4,RS64        LOOP
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
RSX      RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* compone64 (&dest ,val1)
************************************************************************
         SPACE     1
_compone64   EQU   $              64 bit 1's complement
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         TRC       R6,R6          COMP R6
         TRC       R7,R7          COMP R7
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* fix64(&dest ,val1)
************************************************************************
         SPACE     1
_fix64   EQU       $              64 float to fix
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         FIXD      R6,R6          FIX IT
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* float64(&dest ,val1)
************************************************************************
         SPACE     1
_float64  EQU      $              64 fix to float
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         FLTD      R6,R6          FLOAT IT
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* compare64(val1 ,val2)
************************************************************************
         SPACE     1
_compare64   EQU   $              64 bit compare
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,0D,AP       PICK UP 1ST VALUE
         CAMD      R6,1D,AP       64 BIT COMPARE
         BLT       LT             BR IF LESS THAN
         BEQ       EQ             BR IF EQ
         LI        R0,1           GT, EXIT
         BU        CXT            EXIT
LT       LI        R0,-1          LT, EXIT
         BU        CXT            EXIT
EQ       LI        R0,0           EQ, EXIT
CXT      RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* div64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_div64   EQU       $              64 bit div
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         DVMW      R6,5W,AP       DIV SECOND VALUE
         ES        R6             EXTEND SIGN TO R6
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* mod64 (&dest ,val1, val2)
************************************************************************
         SPACE     1
_mod64   EQU       $              64 bit mod
         ENTER                    SAVE REGISTERS ON STACK
         LD        R6,1D,AP       PICK UP 1ST VALUE
         DVMW      R6,5W,AP       DIV SECOND VALUE
         TRR       R6,R7          REMAINDER TO R7
         ES        R6             EXTEND SIGN TO R6
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* atofhep64 (&dest ,&chars)
************************************************************************
         SPACE     1
_atofhep64  EQU    $              64 bit float conversion
         ENTER                    SAVE REGISTERS ON STACK
         LW        R2,1W,AP       GET ADDRESS OF 1ST VALUE
         STW       R2,0W,SP       PUT IN STACK
         TRR       AP,R7          SAVE AP
         BL        _atof          CONVERT TO FLOATING
         TRR       R7,AP          RESTORE AP
         TRR       R0,R6          FLOATING VALUE
         ZR        R7             CLEAR LOW BITS
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
************************************************************************
* atoi64 (&dest ,val1)
************************************************************************
         SPACE     1
_atoi64  EQU       $              64 bit int conversion
         ENTER                    SAVE REGISTERS ON STACK
         LW        R2,1W,AP       GET ADDRESS OF 1ST VALUE
         STW       R2,8W,SP       PUT IN STACK
         TRR       AP,R7          SAVE AP
         BL        _atoi          CONVERT TO FLOATING
         TRR       R7,AP          RESTORE AP
         TRR       R0,R7          INT VALUE
         ES        R6             CLEAR LOW BITS
         LW        R2,0W,AP       GET ADDRESS OF POINTER TO DEST
         STD       R6,0D,X2       PUT IN DESTINATION LOCATION
         RETURN                   RETURN ADDRESS TO CALLER
*
         END
