*  *********************************************************************
*
*  $Header:  008  06-AUG-91 15:42  MJF       MJF                       $
*  $Log:   @ISCSRC^(DV.UTIL)BFIO.MAR                                   $
*  
*       Rev  008  06-AUG-91 15:42  MJF       MJF                        
*  Disallow BACK on compressed files.  We now return error 20 if the    
*  user tries this.  We used to try it, and we backed up logical        
*  records, which contained several compressed records.  The complete   
*  solution would be to back up by a compressed record, but compressed  
*  records contain no back pointers.  Oh, well!                         
*
*       Rev  007  21-DEC-90 16:20  MJF       MJF
*  Fixed a bug in reading compressed files in the B:READ entry
*  point, when it called RE.READ.  We were checking for the X'BF'
*  sentinel, and we weren't looking for X'9F' also.
*
*  ***   By the way, it doesn't look as if B:BACK works correctly
*  for compressed files!
*
*       Rev  006  17-DEC-90 15:48  MJF       MJF
*  Abort if SVC that gets DSECT returns with an error.
*  Error code is "B:FIO NO MEM"
*
*       Rev  005  17-DEC-90 12:56  MJF       MJF
*  Take out blanking in READC
*
*       Rev  004  07-NOV-89 14:29  GANN      GANN
*  Changed version to E.4B.
*
*       Rev  003  29-MAR-89 14:32  GANN      GANN
*  Changed to zero key locations in allocated memory, and in FCB's
*  located in that memory when reallocating an FCB.
*
*       Rev  002  25-JAN-88 14:59  GAN       GANN
*  Changed so that rrs built for M.ASSN only asks for
*  read access if thats what the user requested. Previously,
*  the open was done with the dorrect access but not the assign.
*
*       Rev  001  25-JAN-88 13:35  GANN      GANN
*   Version control header added
*
*
************************************************************************
*        THIS IS A SUBROUTINE SET THAT ALLOWS FAST I/O TRANSFERS
*        FOR FORTRAN USERS.  ONLY BLOCKED FILES ARE READ.  TWENTY
*        SECTORS ARE READ AT A TIME (1 TRACK), AND INTERNAL
*        SUBROUTINES PROVIDE THE BLOCKING AND UNBLOCKING
*
*        WRITTEN BY J. BEVIER FOR I.S.C. 10/09/86
*
************************************************************************
*
*======= B:OPENP (LFC, PATH, STATUS, RW)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO BE OPENED
*        PATH - CHARACTER ARRAY CONTAINING THE FILES PATHNAME
*        STATUS - INTEGER*4 VARIABLE CONTAINING OPEN STATUS
*        RW - CHARACTER VARIABLE CONTAINING OPEN MODE; I.E.
*             "R" OR "W"
*
*======= B:OPEN (LFC, STATUS, RW)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO BE OPENED
*        STATUS - INTEGER*4 VARIABLE CONTAINING OPEN STATUS
*        RW - CHARACTER VARIABLE CONTAINING OPEN MODE; I.E.
*             "R" OR "W"
*
*======= B:CLOSE (LFC, STATUS)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO BE OPENED
*        STATUS - INTEGER*4 VARIABLE CONTAINING STATUS
*
*======= B:READ (LFC, BUFFER, STATUS)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO BE READ
*              FILE WILL BE READ AS BLOCKED FILE, UNCOMPRESSED.
*        BUFFER - CHARACTER ARRAY TO BE READ INTO.  LENGTH WILL
*                 DETERMINE NUMBER OF CHARACTERS TO READ. I.E.
*                 CHARACTER*120 BUFFER WILL READ 120 BYTES,
*                 CHARACTER*80 BUFFER WILL READ 80 BYTES, ETC.
*        STATUS - INTEGER*4 VARIABLE CONTAINING STATUS
*
*======= B:READC (LFC, BUFFER, STATUS)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO BE READ
*              FILE WILL BE READ AS COMPRESSED BLOCKED FILE.
*        BUFFER - CHARACTER ARRAY TO BE READ INTO.  LENGTH WILL
*                 DETERMINE NUMBER OF CHARACTERS TO READ. I.E.
*                 CHARACTER*120 BUFFER WILL READ 120 BYTES,
*                 CHARACTER*80 BUFFER WILL READ 80 BYTES, ETC.
*        STATUS - INTEGER*4 VARIABLE CONTAINING STATUS
*
*======= B:WRITE (LFC, BUFFER, STATUS)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO BE OPENED
*              FILE WILL BE WRITTEN AS BLOCKED FILE.
*        BUFFER - CHARACTER ARRAY TO BE WRITTEN INTO.  LENGTH WILL
*                 DETERMINE NUMBER OF CHARACTERS TO WRITE. I.E.
*                 CHARACTER*120 BUFFER WILL WRITE 120 BYTES,
*                 CHARACTER*80 BUFFER WILL WRITE 80 BYTES, ETC.
*        STATUS - INTEGER*4 VARIABLE CONTAINING STATUS
*
*======= B:REWIND (LFC, STATUS)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO REWIND
*        STATUS - INTEGER*4 VARIABLE CONTAINING STATUS
*
*======= B:BACK (LFC, STATUS)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO BE BACKSPACED
*        STATUS - INTEGER*4 VARIABLE CONTAINING STATUS
*
*======= B:WEOF (LFC, STATUS)
*
*        LFC - INTEGER*4 CONTAINING LOGICAL FILE CODE TO WEOF
*        STATUS - INTEGER*4 VARIABLE CONTAINING STATUS
*
************************************************************************
*
         PROGRAM   B:FIO           ISC.UTIL.E4B.008             49 $VER
*
         DEF       B:OPENP
         DEF       B:OPEN
         DEF       B:CLOSE
         DEF       B:READ
         DEF       B:READC
         DEF       B:WRITE
         DEF       B:REWIND
         DEF       B:BACK
         DEF       B:WEOF
*
         LIST      NOMAC,NONG,NODATA                                !005
         M.EQUS
         M.TBLS
*
         TITLE     B:OPENP - OPEN FILE ROUTINE
*
         BOUND     1W
RET.P    DATAW     0               RETURN ADDRESS
B:OPENP  EQU       $                OPEN AND ASSIGN FILE WITH PATHNAME
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.P        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R2,*2W,X3       GET PATHNAME ADDRESS
         STW       R2,PATHADR      SAVE PATH ADDRESS
         LW        R4,*3W,X3       GET PATH LENGTH
         STW       R4,PATHLEN      SAVE PATH LENGTH
         LA        R5,*4W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS WORD
         LW        R6,*5W,X3       GET R/W INDICATOR
         STW       R6,R.W          SAVE IT
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        AL.99           RETURN WITH ERROR
*
         LW        R4,PATHLEN      GET PATHNAME LENGTH
         CI        R4,72           IS PATH LENGTH >72
         BLE       $+2W            BR IS O.K.
         LI        R4,72           CLAMP TO 72
         TRN       R4,R4           SET COUNT
         LI        R5,0
         LW        R2,PATHADR      GET PATHNAME ADDRESS
GET.PATH LA        R3,PATHNAME
         LB        R6,0B,X2        GET A BYTE
         STB       R6,0B,X3        PUT IT
         CI        R6,G' '         A BLANK
         BEQ       READ8
         ADI       R2,1B
         ADI       R3,1B
         ADI       R5,1B           PATH NAME LENGTH
         BIB       R4,GET.PATH+1W
READ8    STW       R5,PATHLEN
         STB       R5,RRS+1W+2B    SET PATHNAME LENGTH
         LW        R5,LFC          GET CALLERS LFC
         STW       R5,RRS          PUT IN RRS FOR ALLOCATION
         ADI       R5,4W           ADD IN HEADER
         ADI       R5,3B           ROUND
         SRL       R5,2            MAKE WDS
         STB       R5,RRS+1W+1B    SET IN RRS
         LW        R7,R.W          see what kind of alloc to do     !002
         CI        R7,G'R'         if read...                       !002
         BNE       $+3W                                             !002
         LI        R7,X'080'       ask only for read access         !002
         STB       R7,RRS.ACC      put it in the RRS                !002
         LA        R1,RRS          RRS ADDRESS
         ZR        R7              NO CNP
         SVC       2,X'52'         M.ASSN
         LI        R5,X'0D0'       restore normal rrs               !002
         STB       R5,RRS.ACC                                       !002
         TRR       R7,R7           TEST FOR ERROR
         BNZ       F.ERR           REPORT ERROR
         LI        R5,1            ASSUME READ ACCESS
         ZBM       1,FCBA          READ ONLY FOR RM ALSO
         LW        R4,R.W          GET READ/WRITE IND
         CI        R4,G'R'         IS IT READ
         BEQ       $+3W            BR IF IT IS
         LI        R5,2            WRITE ACCESS
         SBM       1,FCBA          WRITE ACCESS FOR RM ALSO
         STB       R5,CNPXX+2W     PUT IN CNP
         LA        R5,F.ERR        CNP ERROR ADDRESS
         STW       R5,IOERXX       ABORT ADDR IF ERROR
         LW        R1,FCBA         OPEN SPECIFIED FILE
         BL        TST4DISC        OPEN  SK
         BNS       AL.50           BR IF NORM I/O
         SBM       1,FLAGS,X1      SET USE RM FOR THIS FILE
AL.50    ZR        R7              SHOW NO ERROR
AL.99    STW       R7,*STATA       STORE STATUS
         BU        *RET.P          RETURN TO CALLER
*
F.ERR    LI        R7,1            OPEN ERROR ON PATHNAME
         BU        AL.99           COMMON RETURN
*
         TITLE     B:OPEN - OPEN FILE ROUTINE
*
         BOUND     1W
RET.O    DATAW     0               RETURN ADDRESS
B:OPEN  EQU       $                OPEN AND ASSIGN FILE WITH PATHNAME
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.O        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R5,*2W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS WORD
         LW        R6,*3W,X3       GET R/W INDICATOR
         STW       R6,R.W          SAVE IT
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        RL.99           RETURN WITH ERROR
*
         LI        R5,1            ASSUME READ ACCESS
         ZBM       1,FCBA          READ ONLY FOR RM ALSO
         LW        R4,R.W          GET READ/WRITE IND
         CI        R4,G'R'         IS IT READ
         BEQ       $+3W            BR IF IT IS
         LI        R5,2            WRITE ACCESS
         SBM       1,FCBA          WRITE ACCESS FOR RM ALSO
         STB       R5,CNPXX+2W     PUT IN CNP
         LA        R5,P.ERR        CNP ERROR ADDRESS
         STW       R5,IOERXX       ABORT ADDR IF ERROR
         LW        R1,FCBA         OPEN SPECIFIED FILE
         BL        TST4DISC        OPEN  SK
         BNS       RL.50           BR IF NORM I/O
         SBM       1,FLAGS,X1      SET USE RM FOR THIS FILE
RL.50    ZR        R7              SHOW NO ERROR
RL.99    STW       R7,*STATA       STORE STATUS
         BU        *RET.O          RETURN TO CALLER
*
P.ERR    LI        R7,1            OPEN ERROR ON PATHNAME
         BU        RL.99           COMMON RETURN
*
         TITLE     B:READ - READ FILE ROUTINE
*
         BOUND     1W
RET.R    DATAW     0               RETURN ADDRESS
B:READ   EQU       $               READ FILE ROUTINE
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.R        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R2,*2W,X3       GET BUFFER ADDRESS
         STW       R2,BUFFER       SAVE PATH ADDRESS
         LW        R4,*3W,X3       GET BUFFER LENGTH
         STW       R4,BUF.LEN      SAVE BUFFER LENGTH
         LA        R5,*4W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        RD.03           RETURN WITH ERROR
*
         LW        R6,BUFFER       GET BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LW        R6,BUF.LEN      GET TRANSFER COUNT
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       RD.01           BR IF NOT
         BL        RM.READ         USE RM FOR READ
         TRR       R7,R7           ANY RM ERROR
         BNZ       RD.03           GIVE IT TO CALLER
         BU        RD.02           CONTINUE
RD.01    SVC       1,X'31'         USE REG I/O
RD.02    TBM       6,FCB.SFLG,X1   WAS THERE EOF
         BS        RD.EOF          BR IF YES
         TBM       7,FCB.SFLG,X1   WAS THERE EOM
         BS        RD.EOM          BR IF YES
         LB        R7,FCB.SFLG,X1  GET ALL OF STATUS WORD
RD.03    STW       R7,*STATA       GIVE CALLER THE STATUS
         BU        *RET.R          RETURN TO CALLER
RD.EOM   LI        R7,-2           GET EOM ERROR
         BU        RD.03           COMMON RETURN
RD.EOF   LI        R7,-1           GET EOF ERROR
         BU        RD.03           COMMON RETURN
*
         TITLE     B:READC- READ COMPRESSED FILE ROUTINE
*
         BOUND     1W
RET.X    DATAW     0               RETURN ADDRESS
B:READC  EQU       $               READ COMPRESSED FILE ROUTINE
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.X        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R2,*2W,X3       GET BUFFER ADDRESS
         STW       R2,BUFFER       SAVE PATH ADDRESS
         LW        R4,*3W,X3       GET BUFFER LENGTH
         STW       R4,BUF.LEN      SAVE BUFFER LENGTH
         LA        R5,*4W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        RC.03           RETURN WITH ERROR
*
*005          LW        R2,BUFFER       GET CALLERS BUFFER ADDR
*005          LNW       R3,BUF.LEN      GET THE LENGTH
*005          LI        R4,X'20'        GET A BLANK
*005 RC.00    STB       R4,0B,X2        BLANK CALLERS BUFFER
*005          ADI       R2,1B           NEXT BUFFER LOCATION
*005          BIB       R3,RC.00        LOOP FOR ALL
*
         TBM       2,FLAGS,X1      IS THIS FCB READING COMPRESSED
         BS        RC.05           BR IS YES
         LA        R6,LOCAL,X1     GET DUMMY BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LI        R6,1            JUST ONE BYTE
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       RC.11           BR IF NOT
         BL        RM.BACK         USE RM FOR BACK
         BU        RC.12           CONTINUE
RC.11    SVC       1,X'35'         USE REG I/O
RC.12    SBM       2,FLAGS,X1      SET READING COMPRESSED FLAG
*
RC.18    LA        R6,LOCAL,X1     GET LOCAL BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LI        R6,120          COMPRESSED RECORDS ARE 120 BYTES
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       RC.01           BR IF NOT
         BL        RM.READ         USE RM FOR READ
         TRR       R7,R7           ANY RM ERROR
         BNZ       RC.03           GIVE IT TO CALLER
         BU        RC.02           CONTINUE
RC.01    SVC       1,X'31'         USE REG I/O
RC.02    TBM       6,FCB.SFLG,X1   WAS THERE EOF
         BS        RC.EOF          BR IF YES
         TBM       7,FCB.SFLG,X1   WAS THERE EOM
         BS        RC.EOM          BR IF YES
         LB        R7,FCB.SFLG,X1  GET ALL OF STATUS WORD
         BZ        RC.08           BR TO UNCOMPRESS IF OK
RC.03    STW       R7,*STATA       GIVE CALLER THE STATUS
         BU        *RET.X          RETURN TO CALLER
RC.EOM   LI        R7,-2           GET EOM ERROR
         BU        RC.03           COMMON RETURN
RC.EOF   LI        R7,-1           GET EOF ERROR
         BU        RC.03           COMMON RETURN
*
RC.08    LB        R6,LOCAL,X1     GET DATA TYPE CODE
         ZBR       R6,26           CLEAR MISC BYTE
         CI        R6,X'9F'        IS THIS A COMPRESSED RECORD
         BNE       RC.EOF          TELL USER EOF
         LA        R6,LOCAL+6B,X1  GET LOCAL BUFFER ADDRESS
         STW       R6,BUFPTR,X1    RESET BUFFER POINTER
         LNB       R6,LOCAL+1B,X1  GET BYTE COUNT OF DATA THIS RECORD
         STW       R6,BCOUNT,X1    RESET COUNTER
RC.05    LW        R4,BCOUNT,X1    GET REMAINING BYTE COUNT
         BZ        RC.18           GET NEXT BUFFER IF ZERO LEFT
         LW        R3,BUFPTR,X1    GET CURRENT INPUT ADDRESS
         LW        R2,BUFFER       GET CALLERS BUFFER ADRESS
RC.20    LB        R6,0B,X3        GET NUMBER OF BLANKS
         BZ        RC.22           BR IF NONE
         CI        R6,X'FF'        EOL RECORD
         BEQ       RC.60           TRANSFER COMPLETE, GET OUT
         TRN       R6,R6           SET COUNT
         LI        R7,X'20'        GET A BLANK
RC.19    STB       R7,0B,X2        STO BLANK IN USERS BUFFER
         ADI       R2,1B           NEXT OUTPUT BYTE
         BIB       R6,RC.19        PUT OUT BLANKS
RC.22    ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         BZ        RC.40           IF NON LEFT GET NEXT RECORD
         LB        R6,0B,X3        GET NUMBER OF DATA BYTES
         BZ        RC.24           SKIP IF NONE
         ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         TRN       R6,R6           MAKE LOOP COUNTER
RC.21    LB        R7,0B,X3        GET A DATA BYTE
         STB       R7,0B,R2        PUT A DATA BYTE
         ADI       R2,1B           NEXT OUTPUT LOC
         ADI       R3,1B           NEXT INPUT LOC
         ADI       R4,1B           REDUCE COUNT
         BIB       R6,RC.21        LOOP FOR ALL DATA
         TRR       R4,R4           SEE IF DATA LEFT
         BNZ       RC.20           GO DO NEXT COMPRESSED RECORD
         BU        RC.40           GET NEXT RECORD
RC.24    ADI       R3,1B           NEXT INPUT LOC ADDR
         ADI       R4,1B           REDUCE COUNT
         BZ        RC.40           IF NON LEFT GET NEXT RECORD
         BU        RC.20           GO DO NEXT RECORD
RC.40    STW       R2,BUFFER       SAVE USER BUFFER ADDRESS
         BU        RC.18           GET NEXT RECORD
*        EOL FOUND
RC.60    EQU       $               END OF LINE ON COMPRESSED SOURCE
         ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         STW       R3,BUFPTR,X1    SAVE BUFFER POINTER FOR NEXT TIME
         STW       R4,BCOUNT,X1    SAVE COUNT FOR NEXT TIME
         ZMW       *STATA          CLEAR OUT STATUS LOC
         BU        *RET.X          RETURN TO CALLER
*
         TITLE     B:WRITE - WRITE FILE ROUTINE
*
         BOUND     1W
RET.W    DATAW     0               RETURN ADDRESS
B:WRITE  EQU       $               WRITE FILE ROUTINE
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.W        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R2,*2W,X3       GET BUFFER ADDRESS
         STW       R2,BUFFER       SAVE PATH ADDRESS
         LW        R4,*3W,X3       GET BUFFER LENGTH
         STW       R4,BUF.LEN      SAVE BUFFER LENGTH
         LA        R5,*4W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        WR.03           RETURN WITH ERROR
*
         LW        R6,BUFFER       GET BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LW        R6,BUF.LEN      GET TRANSFER COUNT
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       WR.01           BR IF NOT
         BL        RM.WRIT          USE RM FOR WRITE
         TRR       R7,R7           ANY RM ERROR
         BNZ       WR.03           GIVE IT TO CALLER
         BU        WR.02           CONTINUE
WR.01    SVC       1,X'32'         USE REG I/O
WR.02    TBM       6,FCB.SFLG,X1   WAS THERE EOF
         BS        WR.EOF          BR IF YES
         TBM       7,FCB.SFLG,X1   WAS THERE EOM
         BS        WR.EOM          BR IF YES
         LB        R7,FCB.SFLG,X1  GET ALL OF STATUS WORD
WR.03    STW       R7,*STATA       GIVE CALLER THE STATUS
         BU        *RET.W          RETURN TO CALLER
WR.EOM   LI        R7,-2           GET EOM ERROR
         BU        WR.03           COMMON RETURN
WR.EOF   LI        R7,-1           GET EOF ERROR
         BU        WR.03           COMMON RETURN
*
         TITLE     B:WEOF - WEOF FILE ROUTINE
*
         BOUND     1W
RET.F    DATAW     0               RETURN ADDRESS
B:WEOF   EQU       $               WRITE END OF FILE ROUTINE
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.F        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R5,*2W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        EF.03           RETURN WITH ERROR
*
         LA        R6,LOCAL,X1     GET DUMMY BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LI        R6,1            JUST ONE BYTE
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       EF.01           BR IF NOT
         BL        RM.WEOF         USE RM FOR WEOF
         TRR       R7,R7           ANY RM ERROR
         BNZ       EF.03           GIVE IT TO CALLER
         BU        EF.02           CONTINUE
EF.01    SVC       1,X'38'         USE REG I/O
EF.02    TBM       6,FCB.SFLG,X1   WAS THERE EOF
         BS        EF.EOF          BR IF YES
         TBM       7,FCB.SFLG,X1   WAS THERE EOM
         BS        EF.EOM          BR IF YES
         LB        R7,FCB.SFLG,X1  GET ALL OF STATUS WORD
EF.03    STW       R7,*STATA       GIVE CALLER THE STATUS
         BU        *RET.F          RETURN TO CALLER
EF.EOM   LI        R7,-2           GET EOM ERROR
EF.EOF   LI        R7,-1           GET EOF ERROR
         BU        EF.03           COMMON RETURN
*
         TITLE     B:REWIND - REWIND FILE ROUTINE
*
         BOUND     1W
RET.D    DATAW     0               RETURN ADDRESS
B:REWIND EQU       $               REWIND FILE ROUTINE
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.D        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R5,*2W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        RW.03           RETURN WITH ERROR
*
         LA        R6,LOCAL,X1     GET DUMMY BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LI        R6,1            JUST ONE BYTE
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       RW.01           BR IF NOT
         BL        RM.RWND           USE RM FOR REWIND
         TRR       R7,R7           ANY RM ERROR
         BNZ       RW.03           GIVE IT TO CALLER
         BU        RW.02           CONTINUE
RW.01    SVC       1,X'37'         USE REG I/O
RW.02    TBM       6,FCB.SFLG,X1   WAS THERE EOF
         BS        RW.EOF          BR IF YES
         TBM       7,FCB.SFLG,X1   WAS THERE EOM
         BS        RW.EOM          BR IF YES
         LB        R7,FCB.SFLG,X1  GET ALL OF STATUS WORD
RW.03    STW       R7,*STATA       GIVE CALLER THE STATUS
         BU        *RET.D          RETURN TO CALLER
RW.EOM   LI        R7,-2           GET EOM ERROR
         BU        RW.03           COMMON RETURN
RW.EOF   LI        R7,-1           GET EOF ERROR
         BU        RW.03           COMMON RETURN
*
         TITLE     B:BACK - BACK FILE ROUTINE
*
         BOUND     1W
RET.B    DATAW     0               RETURN ADDRESS
B:BACK   EQU       $               BACKSPACE FILE ROUTINE
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.B        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R5,*2W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        BS.03           RETURN WITH ERROR
*
         LA        R6,LOCAL,X1     GET DUMMY BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LI        R6,1            JUST ONE BYTE
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       BS.01           BR IF NOT
         BL        RM.BACK         USE RM FOR BACK
         TRR       R7,R7           ANY RM ERROR
         BNZ       BS.03           GIVE IT TO CALLER
         BU        BS.02           CONTINUE
BS.01    SVC       1,X'35'         USE REG I/O
BS.02    TBM       6,FCB.SFLG,X1   WAS THERE EOF
         BS        BS.EOF          BR IF YES
         TBM       7,FCB.SFLG,X1   WAS THERE EOM
         BS        BS.EOM          BR IF YES
         LB        R7,FCB.SFLG,X1  GET ALL OF STATUS WORD
BS.03    STW       R7,*STATA       GIVE CALLER THE STATUS
         BU        *RET.B          RETURN TO CALLER
BS.EOM   LI        R7,-2           GET EOM ERROR
         BU        BS.03           COMMON RETURN
BS.EOF   LI        R7,-1           GET EOF ERROR
         BU        BS.03           COMMON RETURN
*
         TITLE     B:CLOSE - CLOSE FILE ROUTINE
*
         BOUND     1W
RET.C    DATAW     0               RETURN ADDRESS
B:CLOSE  EQU       $               CLOSE FILE ROUTINE
         TRR       R0,R3           PARAMETER LIST TO R3
         ABR       R0,29           1W FOR CNT
         ADMW      R0,0W,X3        PLUS THE COUNT
         STW       R0,RET.C        SAVE RETURN ADDRESS
         LW        R1,*1W,X3       GET LFC
         STW       R1,LFC          SAVE IT
         LA        R5,*2W,X3       GET STATUS WORD ADDRESS
         STW       R5,STATA        SAVE IT
         ZMW       *STATA          CLEAR STATUS
*
         BL        ALLOFCB         GO ALLOCATE FCB (ADDR RET IN R1)
         STW       R1,FCBA         SAVE THE FCB ADDRESS
         LI        R7,5            LFC NOT OPEN ERROR
         TRR       R1,R1           DID WE FIND IT
         BZ        CL.03           RETURN WITH ERROR
*
         LA        R6,LOCAL,X1     GET DUMMY BUFFER ADDRESS
         STW       R6,FCB.ERWA,X1  PUT IN FCB
         LI        R6,1            JUST ONE BYTE
         STW       R6,FCB.EQTY,X1  PUT IN FCB
         TBM       1,FLAGS,X1      ARE WE USING RM
         BNS       CL.01           BR IF NOT
         BL        RM.CLSE          USE RM FOR CLOSE
         BU        CL.02           CONTINUE
CL.01    SVC       1,X'39'         USE REG I/O
CL.02    ZR        R7              NO CNP
         SVC       2,X'53'         DEASSIGN
CL.03    STW       R7,*STATA       GIVE CALLER THE STATUS
         BU        *RET.C          RETURN TO CALLER
*
         TITLE     TEST FOR DISC FILE ROUTINE - TEST4DSK
*
* TEST LOGICAL FILE CODE FOR NON SYS DISC FILE
* R1=FCB ADDR ON CALL
* CC1 SET - NON SYS DISC FILE, USE RM. CC1 RESET - USE NORMAL I/O
*
TST4DISC ZBR       R0,1            CLEAR CC1
         STF       R0,SAVER        SAVE REGS
         LI        R0,X'10'        SET UP FOR BLOCKED
         TBM       5,2W,R1         DOES FCB SHOW UNBLOCKED
         BNS       RET4D.UN        UNBLOCKED, USE NORMAL I/O
         LW        R4,0W,R1        GET LFC
         ANMW      R4,=X'FFFFFF'   MASK IT
         LA        R1,INQ.INFO     SET UP INQUIRY INFO AREA
         ZR        R5              CLEAR R5
         ZR        R7              NO CNP
         SVC       2,X'48'         M.INQUIRY
         LW        R1,SAVER+1W     RE-LOAD LFC ADDR INTO R1
         CI        R7,29           IS IT ASSIGNED ??
         BEQ       RET4DX          NO
         LW        R2,INQ.INFO+3W  GET DTT ADDRESS
         LB        R6,0,R2         GET DEV TYPE
         CI        R6,3            IS IT A DISC
         BGT       RET4D           BR IF NOT DISC
         LW        R2,INQ.INFO+1W  GET FAT ADDR
         LB        R6,DFT.ACF,R2   GET ACCESS FLAGS/SYS FILE CODE
         ANMW      R6,=X'7'        MASK ALL BUT SYS FILE CODE
         CI        R6,0            IS IT SYS FILE
         BNE       RET4D           RET IF IT IS
         SBM       1,SAVER         SET CC1 FOR RET TO USE RM ROUTINES
         BL        RM.OPEN         OPEN VIA REC MGR
         TRR       R7,R7           ANY RM ERROR
         BNZ       *IOERXX         GIVE IT TO CALLER
         BU        RET4DX          RESTORE REGS AND RETURN
         SPACE     1
RET4D.UN EQU       $
         LI        R0,X'20'        SET UP FOR UNBLOCKED
RET4D    EQU       $
         STB       R0,CNPXX+2W+1B  STORE IN USAGE FIELD OF CNP
         CI        R6,2            IS THIS SGO ??
         BEQ       RET4D.0         YES - FORCE BLK, APPEND
         CI        R6,3            IS THIS SLO ??
         BEQ       RET4D.0         YES - FORCE BLK, APPEND
         CI        R6,4            IS THIS SBO ??
         BNE       RET4D.1         NO - CONTINUE
RET4D.0  EQU       $
         LI        R0,X'10'        SET UP FOR BLOCKED
         STB       R0,CNPXX+2W+1B  STORE IN USAGE FIELD OF CNP
         LI        R7,5            SET UP APPEND ACCESS
         STB       R7,CNPXX+2W     STORE ACCESS INTO CNP
RET4D.1  EQU       $
         LA        R7,CNPXX        GET CNP ADDRESS
         SVC       2,X'42'         M.OPENR
RET4DX   LF        R0,SAVER        RESTORE REGS
         TRSW      R0              RETURN
SAVER    RES       1F              REG SAVE AREA
*
         TITLE     ALLOFCB - ROUTINE TO ALLOCATE AND INITIALIZE FCB
*
*        REGS IN:  R1 CONTAINS LFC TO ALLOCATE
*        REGS OUT: R1 CONTAINS FCB ADDRESS
*
         BOUND     1W
ALLOFCB  EQU       $               ALLOCATE FCB AREA
         LI        R7,-NUMFCBS     GET NUMBER OF FCB AREAS
         LA        R2,FCBS         WHERE FCBS ARE
         LW        R4,=X'FFFFFF'   LFC MASK
AL.LOOP  TBM       0,FLAGS,X2      IS THIS FCB ALLOCATED
         BNS       AL.01           BR IF NOT
         CMMW      R1,FCB.LFC,X2   IS THIS THE SAME LFC
         BEQ       AL.09           RETURN FCB ADDRESS
AL.01    ADI       R2,50W          NEXT AREA
         BIB       R7,AL.LOOP      LOOP FOR ALL
         LI        R7,-NUMFCBS     GET NUMBER OF FCB AREAS
         LA        R2,FCBS         WHERE FCBS ARE
         LW        R4,=X'FFFFFF'   LFC MASK
BL.LOOP  TBM       0,FLAGS,X2      IS THIS FCB ALLOCATED
         BNS       AL.08           BR IF NOT
         ADI       R2,50W          NEXT AREA
         BIB       R7,BL.LOOP      LOOP FOR ALL
         ZR        R2              NON FOUND
         BU        AL.09           RETURN ERROR
AL.08    STW       R1,FCB.LFC,X2   SAVE LFC IN FCB
         LW        R1,=X'06000000' BLOCKED FILE, EXPANDED FCB
         STW       R1,FCB.GCFG,X2  PUT IN FCB
         ZMW       FCB.IST1,X2     EXPND STATUS WD 1
         ZMW       FCB.IST2,X2     EXPND STATUS WD 2
         ZMW       FCB.SFLG,X2     32 FLAG BITS
         ZMB       FCB.SPST,X2     8 FLAG BITS
         ZMW       FCB.RECL,X2     TRANSFER LENGTH
         ZMW       FLAGS,X2        CLEAR FLAGS
         SBM       0,FLAGS,X2      SET ALLOCATED
AL.09    TRR       R2,R1           FCB ADR TO R1
         TRSW      R0              RETURN TO CALLER
*
************************************************************************
*        D A T A    A R E A                                            *
************************************************************************
         BOUND     1W
         SPACE     1
*
*        20 FILE AREAS ARE ALLOWED
*        EACH AREA IS 50 WORDS LONG
*        THE FIRST 16 WORDS IS THE FCB USED FOR I/O
*        WORD 17 IS A FLAG WORD
*        WORD 18 IS THE CURRENT BUFFER POINTER FOR COMPRESSED FILES
*        WORD 19 IS REMAINING BYTES IN THE LOCAL BUFFR
*        WORD 20 FREE
*        WORDS 21 TO 50 IS THE LOCAL 120 BYTE BUFFER FOR UNCOMPRESSING
*
NUMFCBS  EQU       10              10 AREAS
FCBS     RES       50W*NUMFCBS     50 WORDS EACH
FLAGS    EQU       16W             OFFSET TO FLAG WORD
*        BIT 0     SET - FCB ALLOCATED
*                  RESET - AVAILABLE
*        BIT 1     SET - THIS FCB USING RM ROUTINES
*                  RESET - USE STANDARD SVC'S
*        BIT 2     SET - THIS IS A COMPRESSED FILE
*                  RESET - STANDARD BLOCKED FILE
*
BUFPTR   EQU       17W             CURRENT BUFFER POINTER IN LOCAL
BCOUNT   EQU       18W             BYTES REMAING IN LOCAL BUFFER
LOCAL    EQU       20W             30W (120B) LOCAL BUFFER
*
         SPACE     2
         BOUND     1F
INQ.INFO RES       1F              8W FOR M.INQUIRY INFO
         SPACE     2
*        CNPS FOR NATIVE MODE OPENS
         SPACE     1
CNPXX    DATAW     1               IMMEDIATE RETURN IF DENIED
IOERXX   DATAW     F.ERR           ABNORMAL RETURN ADDRESS
         DATAB     0               ACCESS (SET UP DEPENDING
*                                  ON DEVICE/SYSTEM FILE)
         DATAB     0               USAGE
         DATAH     0               STATUS
         DATAW     0               RESERVED
         DATAW     0               RESERVED
         DATAW     0               PARAMETER LINK
         SPACE     1
*
         BOUND     1D
RRS      DATAW     G'SK '          TEMP FILE
         DATAB     1,0,0,0         TYPE 1 RRS
RRS.ACC  DATAW     X'D0008000'                                      !002
         DATAW     0
PATHNAME RES       72B
PATHLEN  DATAW     0               LENGTH OF PATHNAME
LFC      DATAW     0               CALLERS LFC
PATHADR  DATAW     0               PATHNAME ADDRESS
STATA    DATAW     0               STATUS WORD ADDRESS
R.W      DATAW     0               R/W CHARACTER
BUFFER   DATA      0               USERS BUFFER ADDRESS
BUF.LEN  DATAW     0               LENGTH OF CALLERS BUFFER
FCBA     DATAW     0               CURRENT FCB ADDRESS
*
*
************************************************************************
         TITLE     RECORD MANAGER
         LIST      ON,MAC,NODATA
         SPACE     2
************************************************************************
*
*  RECORD MANAGER PROVIDES MULTIPLE BLOCK BUFFERING IN AN EFFORT TO
*  REDUCE I/O OVERHEAD AND IMPROVE CPU UTILIZATION.
*
*  RECORD MANAGER PROVIDES SIMULATION OF THE IOCS SUPEVISOR CALLS AT THE
*  USER LEVEL.  THE SVC SPECIFICATIONS MAY BE TAKEN AS A SPECIFICATION
*  FOR THE CORRESPONDING RECORD MANAGER ENTRY.
*
*  THE SIMULATED BLOCKED I/O SERVICES INCLUDE:
*        MACRO               SVC                 RECORD MANAGER ENTRY
*        M.FILE              SVC 1,X'30'         BL  RM.OPEN
*        M.CLSE              SVC 1,X'39'         BL  RM.CLSE
*        M.READ              SVC 1,X'31'         BL  RM.READ
*        M.WRIT              SVC 1,X'32'         BL  RM.WRIT
*        M.RWND              SVC 1,X'37'         BL  RM.RWND
*        M.BACK              SVC 1,X'35'         BL  RM.BACK
*        M.ADVF              SVC 1,X'34'         BL  RM.ADVF
*        M.ADVR              SVC 1,X'33'         BL  RM.ADVR
*        M.WEOF              SVC 1,X'38'         BL  RM.WEOF
*
*
*  CODING CONVENTIONS:
*  RECORD MANAGER ROUTINES ARE CODED WITH TWO LETTER IDENTIFIERS
*  WHICH PREFIX THE ROUTINE NAME.  THEY ARE:
*
*        RM.NAME             USER ENTRY POINTS
*        BF.NAME             BUFFER MANAGEMENT
*        PL.NAME             POOL MANAGEMENT
*        FL.NAME             FILE MANAGEMENT
*        IT.NAME             INTERNAL UTILITIES
*
*  THROUGHOUT THE ENTIRE BODY OF CODE IT IS ASSUMED THAT ALL REGISTERS
*  MAY BE DESTROYED IN A CALLING SEQUENCE EXCEPT REGISTERS R1 AND R2.
*  THESE REGISTERS CONTAIN:
*        R1 = ADDRESS OF THE USER'S FCB
*        R2 = ADDRESS OF THE CURRENT INPUT / OUTPUT CONTEXT BLOCK
*
*  THE DESCRIPTION OF THE REMAINDER OF THE CODE IS LEFT TO THE COMMENTS
*  WITHIN THE CODE BODY WHICH ARE NEVER ENOUGH BUT HOPEFULLY SUFFICENT.
*
************************************************************************
         SPACE     2
************************************************************************
*  PROGRAM ENTRY POINTS
************************************************************************
*        DEF       RM.OPEN
*        DEF       RM.CLSE
*        DEF       RM.READ
*        DEF       RM.WRIT
*        DEF       RM.ADVF
*        DEF       RM.ADVR
*        DEF       RM.RWND
*        DEF       RM.BACK
*        M.REQS
************************************************************************
*  PROGRAM LIMIT EQUATES
************************************************************************
         SPACE     2
BLKMAX   EQU       20              # BUFFERED BLOCKS PER LFC  JBJB
IOCMAX   EQU       4               # I/O CONTEXT BLOCKS ASSEMBLED
WPB      EQU       192             # WORDS PER BLOCK
BLKSIZ   EQU       WPB*4           # BYTES PER BLOCK
         SPACE     2
************************************************************************
*  INPUT OUTPUT CONTEXT BLOCK EQUATES
************************************************************************
IOC.FCB  EQU       0               FILE CONTROL BLOCK
IOC.CBN  EQU       IOC.FCB+16W     CURRENT BUFFER NUMBER
IOC.CBA  EQU       IOC.CBN+1W      CURRENT BUFFER ADDRESS
IOC.NAB  EQU       IOC.CBA+1W      NUMBER OF ACTIVE BUFFERS
IOC.RCBA EQU       IOC.NAB+1W      RECORD CONTROL BLOCK POINTER
IOC.CPP  EQU       IOC.RCBA+1W     CURRENT POOL POSITION
IOC.CFP  EQU       IOC.CPP+1W      CURRENT FILE POSITION
IOC.FLAG EQU       IOC.CFP+1W      IOC BIT FLAGS
IOC.BCNT EQU       IOC.FLAG+1W     COMPRESSED RECORD CURRENT COUNT
IOC.BPTR EQU       IOC.BCNT+1W     COMPRESSED RECORD POINTER
IOC.BUF  EQU       IOC.BPTR+1W     START OF CONTIGUOUS BUFFERS
IOC.CNP  EQU       IOC.BUF         CNP USES BUF AREA AT OPEN
IOC.SIZE EQU       BLKSIZ*BLKMAX+IOC.BUF  SIZE OF IOC BLOCK
         SPACE     2
************************************************************************
*  RECORD CONTROL BYTE EQUATES
************************************************************************
RCB.EOF  EQU       0               END OF FILE
RCB.BOB  EQU       1               BEGINNING OF BLOCK
RCB.EOB  EQU       2               END OF BLOCK
*
RCB.SBLR EQU       0B              STATUS BYTE LAST RECORD
RCB.BCLR EQU       1B              BYTE COUNT LAST RECORD
RCB.SBTR EQU       2B              STATUS BYTE THIS RECORD
RCB.BCTR EQU       3B              BYTE COUNT THIS RECORD
         PAGE
************************************************************************
*  RECORD MANAGER LAST OPERATION FLAG BYTE EQUATES
************************************************************************
OPENOP   EQU       0               OPEN FLAG
WRITOP   EQU       1               LAST OPERATION WRITE
OUTAOP   EQU       2               OUTPUT ACTIVE FLAG
COMPOP   EQU       3               IF SET, TESTED FOR COMPRESSED FILE
CMPFLG   EQU       4               IF SET, COMPRESSED FILE BEING READ
************************************************************************
*  INPUT OUTPUT CONTEXT BLOCKS
************************************************************************
*        DSECT
IOCTOTL  DATAW     IOC.SIZE*IOCMAX CONTIGUOUS IOC BLOCK SIZE TOTAL
IOCBASE  DATAW     0               BASE ADDR OF BUFFERS
         SPACE     2
************************************************************************
*  REGISTER SAVE AREA
************************************************************************
REGS     RES       1F
ERR.CODE EQU       REGS+7W         ERROR RETURN CODE
*        CSECT
         PAGE
         LIST      MAC,NGLIST                                       !008
*
*  RECORD MANAGER MACROS
*
EQTY     DEFM      EREG,FREG       GET TRANSFER QUANITY FROM FCB
         TBM       6,FCB.GCFG,%FREG
         BNS       %SHORT          BRANCH IF SHORT FCB
         LW        %EREG,FCB.EQTY,%FREG
         BU        %OUT
*
%SHORT   LW        %EREG,FCB.TCW,%FREG
         SRL       %EREG,20
%OUT     EQU       $
         ENDM
*
ERWA     DEFM      EREG,FREG       GET TRANSFER QUANITY FROM FCB
         TBM       6,FCB.GCFG,%FREG
         BNS       %SHORT          BRANCH IF SHORT FCB
         LW        %EREG,FCB.ERWA,%FREG
         BU        %OUT
*
%SHORT   LW        %EREG,FCB.TCW,%FREG
         SLL       %EREG,13
         SRL       %EREG,13        STRIP OFF COUNT AND F BIT
%OUT     EQU       $
         ENDM
         LIST      ON,MAC,NODATA,NONG
         PAGE
************************************************************************
*  RM.OPEN
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.OPEN  STF       R0,REGS         SAVE USER REGISTERS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         EXTABLISH IOC FOR THIS LFC
         TBM       OPENOP,IOC.FLAG,X2   FLAG OPENED
         BS        RM.OPXIT        EXIT IF OPENED ALREADY
         BL        OPEN            GO OPEN
RM.OPXIT LF        R0,REGS         RESTORE REGISTERS
         TRSW      R0              RETURN
         SPACE     2
OPEN     STW       R0,OPENXIT      SAVE RETURN ADDR
         SBM       OPENOP,IOC.FLAG,X2  TAG IOC AS OPENED
         ZMW       IOC.CNP,X2      ZERO THE CNP
         ZMW       IOC.CNP+1W,X2
         ZMW       IOC.CNP+2W,X2
         ZMW       IOC.CNP+3W,X2
         ZMW       IOC.CNP+4W,X2
         ZMW       IOC.CNP+5W,X2
         LI        R7,1            READ MODE
         TBR       R1,1            R/W OPEN?
         BNS       OPEN.01         NO
*        LI        R7,2            WRITE MODE          AS17
         LI        R7,4            MODIFY MODE
OPEN.01  STB       R7,IOC.CNP+2W,X2  SET ACCESS MODE
         SBM       2,IOC.CNP+2W+1B,X2  SET OPEN UNBLOCKED
         SBM       4,IOC.CNP+2W+1B,R2  SET RESOURCE DATA BLOCKED AS17
         LA        R7,IOC.CNP,X2   R7 = A(CNP)
         XCR       R1,R2           R1 = A(IOC FCB)
         SVC       2,X'42'         OPEN RESOURCE
         BS        OPEN.ER         ERROR ON OPEN
         XCR       R1,R2
         BU        *OPENXIT
OPEN.ER  XCR       R1,R2           R2 = A(IOC)
         BU        ABRT13          ERROR ON OPEN
*        DSECT
OPENXIT  RES       1W              RETURN ADDRESS
*        CSECT
*
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
*
         SPACE     3
************************************************************************
*  RM.CLSE
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.CLSE  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         TBM       OPENOP,IOC.FLAG,X2  OPENED?
         BNS       RM.CL02         NO.
         ZBM       WRITOP,IOC.FLAG,X2  LAST OPERATION WRITE?
         BNS       RM.CL01         NO.
************************************************************************
*  WRITE EOF BEFORE REWIND
************************************************************************
         BL        IR.WEOF         WRITE END OF FILE
RM.CL01  ZBM       OUTAOP,IOC.FLAG,X2  POOL OUTPUT ACTIVE?
         BNS       RM.CL02         NO.
         BL        PL.WRIT         PURGE POOL BEFORE CLOSE
RM.CL02  TRR       R2,R1           R1 = A(IOC FCB)
         SVC       1,X'39'         CLOSE THE FILE
         ZMW       FCB.LFC,X2      DEACTIVATE IOC BLOCK
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.RWND - LOGICALLY REWIND FILE
************************************************************************
RM.RWND  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT
         TBM       OPENOP,IOC.FLAG,X2  OPENED?
         BS        RM.RW01         YES.
         BL        OPEN            IMPLICIT OPEN
         BU        RM.RW03
RM.RW01  ZBM       WRITOP,IOC.FLAG,X2  WAS LAST OPERATION WRITE?
         BNS       RM.RW02         NO.
************************************************************************
*  WRITE END OF FILE AFTER LAST WRITE OPERATION BEFORE REWIND
************************************************************************
         BL        IR.WEOF
RM.RW02  BL        BF.RWND
         LW        R3,IOC.CPP,X2   BUFFER POOL FILLED ?
         BZ        RM.RW03         NO.  ALL GONE.
         LW        R3,IOC.CBA,X2   SET A (RCB) TO BEG OF FILE
         LA        R3,1W,X3
         STW       R3,IOC.RCBA,X2
RM.RW03  ZBM       6,FCB.SFLG,X1   CLEAR POSSIBLE EOF IN FCB
         LF        R0,REGS
         TRSW      R0
         SPACE     2
************************************************************************
*  RM.WEOF - WRITE END OF FILE
************************************************************************
RM.WEOF  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         ESTABLISH IOC
         TBM       OPENOP,IOC.FLAG,X2  OPENED?
         BS        RM.WE01         YES.
         BL        OPEN            IMPLICIT OPEN
RM.WE01  BL        IR.WEOF         WRITE END OF FILE.
         SBM       WRITOP,IOC.FLAG,X2  FLAG WRITE LAST OP
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.BKKSP - BACKSPACE RECORD
************************************************************************
RM.BACK  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT
         TBM       OPENOP,IOC.FLAG,X2
         BS        RM.BK00         NOT OPENED YET.
         BL        OPEN
         BU        RM.BKXIT        RETURN
*
RM.BK00  TBM       CMPFLG,IOC.FLAG,X2 Compressed file?              !008
         BS        RM.BKE1         Go if so--error                  !008
         TBM       WRITOP,IOC.FLAGS,X2  WAS WRITE LAST OP?
         BNS       RM.BK01         NO.  DON'T WORRY ABOUT IT.
*
         BL        IR.WEOF         WRITE EOF BEFORE BACKSPACE
         LW        R3,IOC.RCBA,X2  BACK OVER
         SUI       R3,4B           THE
         STW       R3,IOC.RCBA,X2  EOF.
*
RM.BK01  LW        R3,IOC.CPP,X2   POOL EMPTY?
         BZ        RM.BKXIT        YES.  RETURN.  (BOF ALREADY)
*
         LW        R3,IOC.RCBA,X2
         TBM       RCB.EOF,RCB.SBLR,X3  HAVE WE A EOF TO BACKSPACE OVER?
         BS        RM.BKXIT        NO-OP IF EOF.
         TBM       RCB.BOB,RCB.SBLR,X3  IS THIS A BOB?
         BNS       RM.BK03         NO.  PREV RECRD IN THIS BLK.
*
         LI        R3,1
         CAMW      R3,IOC.CBN,X2   FIRST BLOCK IN POOL?
         BLT       RM.BK02         NO.
         CAMW      R3,IOC.CPP,X2   FIRST POOL IN FILE?
         BGE       RM.BKXIT        NO - OP IF BOF
*
RM.BK02  BL        BF.REDB         READ PREVIOUS BUFFER
         LW        R3,IOC.CBA,X2
         ADMW      R3,0W,X3        CALCULATE A(RCB)
*
*  NOW BACKSPACE TO PREVIOUS RECORD IN THIS BLOCK
*
RM.BK03  SUMB      R3,RCB.BCLR,X3  SUBTRACT PREVIOUS RECORD LENGTH
         SUI       R3,4B           SUBTRACT PREVIOUS RCB LENGTH
         STW       R3,IOC.RCBA,X2
RM.BKXIT ZBM       WRITOP,IOC.FLAG,X2 WRITE ISN'T LAST OP
         ZBM       6,FCB.SFLG,X1   NOT EOF ANYMORE FOR USER
RM.BKRT  LF        R0,REGS                                          !008
         TRSW      R0
RM.BKE1  LI        R7,20           Compressed file error            !008
         STW       R7,ERR.CODE                                      !008
         BU        RM.BKRT         Return                           !008
         PAGE
************************************************************************
*  RM.READ
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.READ  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         STW       R2,IOCA         SAVE IOCA
         TBM       WRITOP,IOC.FLAG,X2   WAS LAST OPERATION WRITE?
         BS        ABRT9           READ NOT ALLOWED AFTER WRITE.
         TBM       OPENOP,IOC.FLAGS,X2  FILE OPENED YET
         BS        RM.RE00         YES
************************************************************************
*  DO IMPLICIT OPEN ON FILE
************************************************************************
         BL        OPEN            GO OPEN
*
RM.RE00  LW        R3,IOC.CPP,X2   ANY DATA IN POOL?
         BNZ       RM.RE01         YES.
************************************************************************
*  READ FROM FILE
************************************************************************
         BL        BF.REDF         READ IN A BLOCK
         LW        R3,IOC.CBA,X2   GET BUFFER ADDRESS
         LA        R3,1W,X3        CALCULATE RCB ADDRESS
         STW       R3,IOC.RCBA,X2  UPDATE RCB POINTER
         SBM       COMPOP,IOC.FLAG,X2  TESTED FOR COMPR FILE YET?
         BS        RM.RE01         BR IF WE HAVE
         LB        R7,4B,X3        GET FIRST DATA BYTE
         SBR       R7,26           Check for 9F or BF               !007
         CI        R7,X'BF'        IS IT COMPRESSED
         BNE       RM.RE01         BR IF NOT
         SBM       CMPFLG,IOC.FLAG,X2  SET COMPRESSED FILE HERE
         ZMW       IOC.BCNT,X2         NO CHARS LEFT
RM.RE01  ERWA      R5,X1           GET USERS BUFFER ADDRESS
         STW       R5,BUFADR       SAVE LOCALLY
         ZMW       BYTECNT         COUNT OF BYTES TO CALLER
         TBM       CMPFLG,IOC.FLAG,X2 ARE WE READING COMPRESSED FILE
         BNS       RM.RE18         BR IF WE ARE NOT
         LW        R4,IOC.BCNT,X2  ANY COUNT LEFT
         BNZ       RM.RE07         BR IF NOT FINISHED
RM.RE18  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         TBM       RCB.EOB,RCB.SBLR,X3   IS THIS THE END OF THIS BLOCK?
         BNS       RM.RE02  NOT END OF BLOCK
************************************************************************
*  END OF BLOCK.  GET NEXT BLOCK
************************************************************************
         BL        BF.REDF         GO GET NEXT BLOCK
         LW        R3,IOC.CBA,X2  R3 = CURRENT BUFFER ADDR
         ADI       R3,1W           R3 = A(RCB)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDR
************************************************************************
*  TEST FOR END OF FILE
************************************************************************
RM.RE02  TBM       RCB.EOF,RCB.SBTR,X3  IS THIS END OF FILE?
         BS        RM.RE05         YES.  GO TELL THE FCB.
         TBM       CMPFLG,IOC.FLAG,X2   READING COMPRESSED
         BNS       RM.RE09         BR IF NOT
RM.RE11  LB        R4,4B,X3        GET FIRST DATA BYTE
         ZBR       R4,26           CLEAR BIT FOR TEST
         CI        R4,X'9F'        IS THIS COMPRESSED RECORD
         BNE       RM.RE05         ASSUME EOF IF NOT, ERROR
         TRR       R3,R4           COPY BUFFER ADDR
         ADI       R4,10B          POINT TO START OF DATA
         STW       R4,IOC.BPTR,X2  SAVE CURRENT DATA POINTER
         LNB       R4,5B,X3        GET NEGATIVE BYTES THIS RECORD
         STW       R4,IOC.BCNT,X2  SAVE REMAINING COUNT
RM.RE06  LW        R4,IOC.BCNT,X2  GET REMAINING COUNT
         BNZ       RM.RE07         CONTINUE WITH LINE
RM.RE10  LW        R2,IOCA         ADDR OF IOC
         LW        R3,IOC.RCBA,X2  ADDR OF RCB
         ADMB      R3,RCB.BCTR,X3  ADD RECORD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         BU        RM.RE18         GO GET NEXT RECORD
RM.RE07  LW        R3,IOC.BPTR,X2  GET CURRENT POINTER
         LW        R2,BUFADR       GET CALLERS BUFFER ADDRESS
RM.RE20  LB        R6,0B,X3        GET NUMBER OF BLANKS
         BZ        RM.RE22         BR IF NON
         CI        R6,X'FF'        EOL RECORD?
         BEQ       RM.RE60         TRANSFER DONE, EXIT
         TRN       R6,R6           SET BLANK COUNT
         LI        R7,X'20'        GET A BLANK
RM.RE19  STB       R7,0B,X2        PUT IN CALLERS BUFFER
         ABM       31,BYTECNT      BUMP NUM OF BYTES OUT
         ADI       R2,1B           NEXT OUTPUT LOC
         BIB       R6,RM.RE19      PUT OUT BLANKS
RM.RE22  ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         BZ        RM.RE40         IF NON LEFT GET NEXT RECORD
         LB        R6,0B,X3        GET NUMBER OF DATA BYTES
         BZ        RM.RE24         BR IF NON
         ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         TRN       R6,R6           MAKE LOOP COUNTER
RM.RE21  LB        R7,0B,X3        GET DATA BYTE
         STB       R7,0B,X2        PUT IN USER BUFFER
         ABM       31,BYTECNT      BUMP NUM OF BYTES OUT
         ADI       R2,1B           NEXT OUTPUT LOC
         ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         BIB       R6,RM.RE21      LOOP FOR ALL DATA
         TRR       R4,R4           SEE IF DATA LEFT
         BNZ       RM.RE20         GO DO NEXT COMPRESSED RECORD
RM.RE40  STW       R2,BUFADR       SAVE CURRENT OUTPUT BUFFER
         BU        RM.RE10         GO READ NEXT RECORD
RM.RE24  ADI       R3,1B           NEXT RECORD LOC
         ADI       R4,1B           REDICE COUNT
         BZ        RM.RE40         GO GET NEXT RECORD
         BU        RM.RE20         GO DO NEXT RECORD
RM.RE60  ADI       R3,1B           NEXT RECORD BYTE
         LW        R2,IOCA         ADDR OF IOC
         ADI       R4,1B           REDUCE COUNT
         BNZ       RM.RE61         BR IF STILL SOME LEFT
         LW        R3,IOC.RCBA,X2  ADDR OF RCB
         ADMB      R3,RCB.BCTR,X3  ADD RECORD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         ADI       R3,10B          POINT TO START OF DATA
RM.RE61  LW        R6,BYTECNT      GET NUMBER OF BYTES COPIED
         STW       R6,FCB.RECL,X1  TELL USER WHAT HE GOT
         STW       R4,IOC.BCNT,X2  SAVE COUNTER
         STW       R3,IOC.BPTR,X2  SAVE CURRENT POINTER
         LF        R0,REGS
         TRSW      R0              EXIT
************************************************************************
*  TRANSFER RECORD TO USER
************************************************************************
RM.RE09  LB        R6,RCB.BCTR,X3  R6 = SOURCE BYTE COUNT
         EQTY      R5,X1           R5 = TARGET COUNT
         TRR       R5,R7           R7 = TARGET COUNT
         SUR       R6,R7           R7 = TAR CNT - SOR CNT = FILL COUNT
         BLE       RM.RE03         NO FILL NEEDED.  USE TARGET COUNT.
         TRR       R6,R5           R5 = SOURCE COUNT
RM.RE03  STW       R5,FCB.RECL,X1  TELL USER WHAT HE GOT
         ADI       R3,1W           R3 = A(SOURCE)
         ERWA      R2,X1           R2 = A(TARGET)
         BL        IR.CPPY
         TRR       R7,R5           R5 = FILL COUNT
         BLE       RM.RE04         NO FILL NEEDED
         LI        R6,C' '         R6 = FILL CHARACTER
*JCB*    BL        IR.FILL
************************************************************************
*  POST TRANSFER UPDATE TO NEXT RECORD
************************************************************************
RM.RE04  LW        R2,IOCA         R2 = A(IOC)
         LW        R3,IOC.RCBA,X2  R2 = A(RCB)
         ADMB      R3,RCB.BCTR,X3  ADD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         LF        R0,REGS
         TRSW      R0
*        DSECT
IOCA     RES       1W
BUFADR   RES       1W              USERS BUFFER ADDRESS
BYTECNT  RES       1W              TRANSFER CNT TO CALLER
*        CSECT
************************************************************************
*  RM.RE05
*  ENTER:  R1 = A(FCB)
*  RETURN END OF FILE STATUS IN FCB
************************************************************************
RM.RE05  SBM       6,FCB.SFLG,X1   SET EOF
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.ADVR
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.ADVR  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         STW       R2,IOCA         SAVE IOCA
         TBM       WRITOP,IOC.FLAG,X2   WAS LAST OPERATION WRITE?
         BS        ABRT9           ADVR NOT ALLOWED AFTER WRITE.
         TBM       OPENOP,IOC.FLAGS,X2  FILE OPENED YET
         BS        RM.AD00         YES
************************************************************************
*  DO IMPLICIT OPEN ON FILE
************************************************************************
         BL        OPEN            GO OPEN
         BL        BF.REDF         READ IN A BLOCK
         LW        R3,IOC.CBA,X2   GET BUFFER ADDRESS
         LA        R3,1W,X3        CALCULATE RCB ADDRESS
         STW       R3,IOC.RCBA,X2  UPDATE RCB POINTER
         BU        RM.AD02
*
RM.AD00  LW        R3,IOC.CPP,X2   ANY DATA IN POOL?
         BNZ       RM.AD01         YES.
************************************************************************
*  READ FROM FILE
************************************************************************
         BL        BF.REDF
         LW        R3,IOC.CBA,X2   UPDATE A(RCB)
         LA        R3,1W,X3
         STW       R3,IOC.RCBA,X2
RM.AD01  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         TBM       RCB.EOB,RCB.SBLR,X3   IS THIS THE END OF THIS BLOCK?
         BNS       RM.AD02  NOT END OF BLOCK
************************************************************************
*  END OF BLOCK.  GET NEXT BLOCK
************************************************************************
         BL        BF.REDF         GO GET NEXT BLOCK
         LW        R3,IOC.CBA,X2  R3 = CURRENT BUFFER ADDR
         ADI       R3,1W           R3 = A(RCB)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDR
************************************************************************
*  TEST FOR END OF FILE
************************************************************************
RM.AD02  TBM       RCB.EOF,RCB.SBTR,X3  IS THIS END OF FILE?
         BS        RM.AD05         YES.  GO TELL THE FCB.
************************************************************************
*  POST TRANSFER UPDATE TO NEXT RECORD
************************************************************************
RM.AD04  LW        R2,IOCA         R2 = A(IOC)
         LW        R3,IOC.RCBA,X2  R2 = A(RCB)
         ADMB      R3,RCB.BCTR,X3  ADD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         LF        R0,REGS
         TRSW      R0
************************************************************************
*  RM.AD05
*  ENTER:  R1 = A(FCB)
*  RETURN END OF FILE STATUS IN FCB
************************************************************************
RM.AD05  SBM       6,FCB.SFLG,X1   SET EOF
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.ADVF
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.ADVF  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         STW       R2,IOCA         SAVE IOCA
         TBM       WRITOP,IOC.FLAG,X2   WAS LAST OPERATION WRITE?
         BS        ABRT9           ADVF NOT ALLOWED AFTER WRITE.
         TBM       OPENOP,IOC.FLAGS,X2  FILE OPENED YET
         BS        RM.AF00         YES
************************************************************************
*  DO IMPLICIT OPEN ON FILE
************************************************************************
         BL        OPEN            GO OPEN
         BL        BF.REDF         READ IN A BLOCK
         LW        R3,IOC.CBA,X2   GET BUFFER ADDRESS
         LA        R3,1W,X3        CALCULATE RCB ADDRESS
         STW       R3,IOC.RCBA,X2  UPDATE RCB POINTER
         BU        RM.AF02
*
RM.AF00  LW        R3,IOC.CPP,X2   ANY DATA IN POOL?
         BNZ       RM.AF01         YES.
************************************************************************
*  READ FROM FILE
************************************************************************
         BL        BF.REDF
         LW        R3,IOC.CBA,X2   UPDATE A(RCB)
         LA        R3,1W,X3
         STW       R3,IOC.RCBA,X2
RM.AF01  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         TBM       RCB.EOB,RCB.SBLR,X3   IS THIS THE END OF THIS BLOCK?
         BNS       RM.AF02  NOT END OF BLOCK
************************************************************************
*  END OF BLOCK.  GET NEXT BLOCK
************************************************************************
         BL        BF.REDF         GO GET NEXT BLOCK
         LW        R3,IOC.CBA,X2  R3 = CURRENT BUFFER ADDR
         ADI       R3,1W           R3 = A(RCB)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDR
************************************************************************
*  TEST FOR END OF FILE
************************************************************************
RM.AF02  TBM       RCB.EOF,RCB.SBTR,X3  IS THIS END OF FILE?
         BS        RM.AF05         YES.  GO TELL THE FCB.
************************************************************************
*  POST TRANSFER UPDATE TO NEXT RECORD
************************************************************************
RM.AF04  LW        R2,IOCA         R2 = A(IOC)
         LW        R3,IOC.RCBA,X2  R2 = A(RCB)
         ADMB      R3,RCB.BCTR,X3  ADD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         BU        RM.AF00         READ UNTIL EOF
************************************************************************
*  RM.AF05
*  ENTER:  R1 = A(FCB)
*  RETURN END OF FILE STATUS IN FCB
************************************************************************
RM.AF05  SBM       6,FCB.SFLG,X1   SET EOF
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.WRIT
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.WRIT  STF       R0,REGS         SAVE REGISTERS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         ESTABLISH CONTEXT BLOCK
         STW       R2,IOCA         SAVE A(IOC)
         SBM       WRITOP,IOC.FLAG,X2  FLAG WRITE OPERATION
         SBM       OUTAOP,IOC.FLAG,X2  FLAG POOL OUTPUT ACTIVE
         TBM       OPENOP,IOC.FLAG,X2  FILE OPENED?
         BS        WRIT.00         YES.
************************************************************************
*  DO IMPLICIT OPEN ON FILE_
************************************************************************
         BL        OPEN
WRIT.00  LW        R7,IOC.CPP,X2   POOL INITIALIZED?
         BNZ       WRIT.01         YES.
         LA        R3,IOC.BUF,X2   INITIALIZE BUFFER
         STW       R3,IOC.CBA,X2
         LI        R3,1
         STW       R3,IOC.NAB,X2
         STW       R3,IOC.CBN,X2
         STW       R3,IOC.CPP,X2
         BL        IR.BINIT
************************************************************************
*  CALCULATE BLOCK SPACE NEEDED FOR THIS RECORD
************************************************************************
WRIT.01  EQTY      R7,X1           # BYTES IN USER RECORD
         CI        R7,X'00FF'      COMPARE TO MAXIMUM RECORD SIZE
         BGT       ABRT8           TOO BIG
         ADI       R7,1W           ADD RCB SIZE
************************************************************************
*  CALCULATE AVAILABLE SPACE IN CURRENT BLOCK
************************************************************************
         LW        R3,IOC.CBA,X2   CALCULATE END ADDRESS OF BLOCK
         LA        R6,BLKSIZ,X3    BY ADDING LENGTH TO ORIGIN.
         SUMW      R6,IOC.RCBA,X2  SUBTRACT RCB ADDR
         SUI       R6,1H           AND LAST RCB HALFWORD
         CAR       R7,R6           ENOUGH ROOM?
         BGE       WRIT.02         YES.
************************************************************************
*  WRITE OUT THIS BLOCK
************************************************************************
         BL        IR.FINIS        FINIS BLOCK WITH ZERO FILL
         BL        BF.WRIT         WRITE OUT THIS BUFFER TO POOL
         BL        IR.BINIT        INITIALIZE NEW BUFFER FOR WRITE
************************************************************************
*  TRANSFER USER RECORD TO BUFFER
************************************************************************
WRIT.02  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         EQTY      R5,X1           RECORD BYTE COUNT
         STB       R5,RCB.BCTR,X3  SAVE IN RCB
         ZMB       RCB.SBTR,X3     ZERO STATUS BYTE
         LA        R2,2H,X3        R2 = A(TARGET)
         ERWA      R3,X1           R3 = A(SOURCE)
         BL        IR.CPPY         TRANSFER
         TRR       R2,R3           R3 = TARGET NEXT BYTE ADDR
         ZMB       RCB.SBLR,X3     CLEAR STATUS BYTE
         EQTY      R5,X1           RECORD LEN
         STB       R5,RCB.BCLR,X3  STORE IN RCB BYTE COUNT
************************************************************************
*  UPDATE BLOCKING BUFFER CONTROL WORD
************************************************************************
         LW        R2,IOCA         R2 = A(IOC)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDRESS
         SUMW      R3,IOC.CBA,X2   SUBTRACT BUFFER STARTING ADDRESS
         LW        R1,IOC.CBA,X2   GET CURRENT BUFFER ADDRESS
         STW       R3,0W,X1        STORE REL
         LF        R0,REGS         RESTORE REGISTERS
         TRSW      R0
         PAGE
*
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
*
************************************************************************
*  BF.REDF - GET NEXT BUFFER THIS LFC
*  ENTER:  R1 = A(FCB), R2 = A(IOC)
*  EXIT :  R3 = A(RCB) = IOC.RCBA
*          IOC.CBN = A(BUFFER)
************************************************************************
BF.REDF  STW       R0,BF.RFXIT     SAVE RETURN ADDRESS
         LW        R3,IOC.CBN,X2   DO WE HAVE THE NEXT
         CAMW      R3,IOC.NAB,X2   BUFFER IN MEMORY?
         BLT       BF.RF01         YES.
************************************************************************
*  READ IN NEXT POOL
************************************************************************
         BL        PL.REDF         READ NEXT POOL
         LI        R3,1            INITIALIZE THE
         STW       R3,IOC.CBN,X2   BUFFER STATUS
         LA        R3,IOC.BUF,X2   FOR THIS POOL
         BU        BF.RF02         RETURN
************************************************************************
*  RETURN POINTER TO NEXT BUFFER IN POOL
************************************************************************
BF.RF01  ABM       31,IOC.CBN,X2   INCRIMENT CURRENT BUFFER NUMBER
         LW        R3,IOC.CBA,X2   BUMP ADDRESS
         LA        R3,BLKSIZ,X3    NO NEXT BUFFER
BF.RF02  EQU       $
         STW       R3,IOC.CBA,X2
         LW        R4,0W,X3        GET FIRST WORD OF BLOCK
         CI        R4,X'300'       BETTER BE LESS THAN 192W
         BGE       BF.RF03         ERROR IF NOT
         LH        R4,2H,X3        GET FIRST RCB
         ANMW      R4,=X'E000'     JUST US CONTROL BITS
         CI        R4,X'4000'      JUST BOB ON
         BEQ       *BF.RFXIT       EXIT IF O.K.
BF.RF03  SBM       6,FCB.SFLG,X1   SET EOF IN USERS FCB
         LI        R4,-1           GET EOF
         STW       R4,ERR.CODE     SET IN ERROR CODE
         BU        RM.CL02         ERROR EXIT
*
*        DSECT
BF.RFXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
*  BF.REDB - READ PREVIOUS BUFFER FROM POOL
************************************************************************
BF.REDB  STW       R0,BF.RBXIT
         LW        R3,IOC.CBN,X2
         CI        R3,1            IS PREVIOUS BUFFER IN POOL?
         BGT       BF.RB01         YES.
*
*  GET BUFFER FROM PREVIOUS POOL
*
         BL        PL.REDB
         LI        R3,BLKMAX
         STW       R3,IOC.CBN,X2
         LA        R3,BLKSIZ*BLKMAX-BLKSIZ+IOC.BUF,X2 LAST BUF ADDRESS
         STW       R3,IOC.CBA,X2   UPDATE CURRENT BUFFER ADDRESS
         BU        *BF.RBXIT       RETURN
*
*  GET BUFFER FROM CURRENT POOL
*
BF.RB01  LW        R3,IOC.CBN,X2   DECRIMENT
         SUI       R3,1            CURRENT
         STW       R3,IOC.CBN,X2   BUFFER NUMBER.
         LW        R3,IOC.CBA,X2   CALCULATE
         SUI       R3,BLKSIZ       BUFFER
         STW       R3,IOC.CBA,X2   ADDRESS
         BU        *BF.RBXIT       RETURN
*        DSECT
BF.RBXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
*  BF.WRIT - WRITE THIS BUFFER INTO POOL
************************************************************************
BF.WRIT  STW       R0,BF.WRXIT     SAVE RETURN ADDRESS
         LW        R3,IOC.CBN,X2   DO WE HAVE MORE FREE
         CI        R3,BLKMAX       BUFFERS?
         BLT       BF.WR01         YES
************************************************************************
*  WRITE THIS POOL TO FILE
************************************************************************
         BL        PL.WRIT
         LW        R3,IOC.CPP,X2
         ADI       R3,BLKMAX       INCRIMENT CURRENT POOL POSITION
         STW       R3,IOC.CPP,X2
         LI        R3,1
         STW       R3,IOC.NAB,X2   USER MUST BE MAKING THIS ACTIVE
         STW       R3,IOC.CBN,X2   SET BUFFER POINTERS
         LA        R3,IOC.BUF,X2
         STW       R3,IOC.CBA,X2
         BU        *BF.WRXIT       RETURN
************************************************************************
*RETURN POINTER TO NEXT FREE BUFFER
************************************************************************
BF.WR01  ABM       31,IOC.CBN,X2   INCRIMENT CURRENT BUFFER NUMBER
         LW        R3,IOC.CBN,X2
         STW       R3,IOC.NAB,X2   SET NUMBER OF ACTIVE BUFFERS
         LW        R3,IOC.CBA,X2   BUMP CURRENT BUFFER ADDRESS
         LA        R3,BLKSIZ,X3
         STW       R3,IOC.CBA,X2
         BU        *BF.WRXIT       RETURN
*        DSECT
BF.WRXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
*  BF.RWND - SET BUFFER TABLES FOR REWIND
************************************************************************
BF.RWND  STW       R0,BF.RWXIT
         BL        PL.RWND         REWIND POOL
         LW        R7,IOC.CPP,X2   POOL  # 1 IN MEM?
         BNZ       BF.RW01
         ZMW       IOC.CBN,X2
         BU        *BF.RWXIT
*
BF.RW01  LI        R7,1            BUFFER TABLES TO FIRST BLOCK
         STW       R7,IOC.CBN,X2
         LA        R7,IOC.BUF,X2
         STW       R7,IOC.CBA,X2
         BU        *BF.RWXIT         RETURN
*        DSECT
BF.RWXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
* PL.REDF - READ NEXT POOL
*  EXIT :  R7 = # BLOCKS READ
************************************************************************
PL.REDF  LI        R7,BLKMAX       NUMBER OF BLOCKS TO FILL
         MPI       R6,BLKSIZ       SIZE OF BLOCK
         STW       R7,FCB.EQTY,X2  SAVE IN FCB
         XCR       R1,R2           R1 = A(FCB)
         SVC       1,X'31'         READ REQUEST
         XCR       R1,R2           RESTORE REGS
         TBM       1,FCB.SFLG,X2   ERROR CONDITION?
         BS        ABRT4
         TBM       6,FCB.SFLG,X2   EOF?
         BS        ABRT5
         TBM       7,FCB.SFLG,X2   EOM?
         BS        ABRT6
         ZR        R6              ZERO FOR DIVIDE
         LW        R7,FCB.RECL,X2  ACTUAL READ LENGTH
         DVI       R6,BLKSIZ       COMPUTE # BLOCKS
         BZ        ABRT1
         TRR       R6,R6           CHECK FOR INTEGRAL BLOCK READ
         BNZ       ABRT2
         STW       R7,IOC.NAB,X2   UPDATE NUMBER OF ACTIVE BUFFERS
         LW        R6,IOC.CFP,X2   R6 = CURRENT FILE POSITION
         STW       R6,IOC.CPP,X2   UPDATE CURRENT POOL POSITION
         ADMW      R7,IOC.CFP,X2   UPDATE CFP
         STW       R7,IOC.CFP,X2   WITH NEW READ POSITION
         TRSW      R0
         PAGE
************************************************************************
*  PL.WRIT - WRITE THIS POOL TO FILE
************************************************************************
PL.WRIT  STW       R0,PL.WRXIT     SAVE RETURN ADDRESS
         LW        R3,IOC.CPP,X2   COMPARE POOL POSITION
         CAMW      R3,IOC.CFP,X2   TO FILE POSITION
         BGT       ABRT12          SHOULD NEVER BE
         BEQ       PL.WR01         NO POSITIONING NEEDED
         LW        R3,IOC.CPP,X2   R3 = DESIRED FILE POSITION
         BL        FL.POSS         POSITION FILE
PL.WR01  LW        R7,IOC.NAB,X2   NUMBER OF ACTIVE BLOCKS IN POOL
         MPI       R6,BLKSIZ       TRANSFER BYTE COUNT
         STW       R7,FCB.EQTY,X2  INTO FCB
         XCR       R1,R2           R1 = A(FCB)
         SVC       1,X'32'         WRITE REQUEST
         XCR       R1,R2           RESTORE REGISTERS
         TBM       1,FCB.SFLG,X2   ERROR CONDITION?
         BS        ABRT10
         TBM       7,FCB.SFLG,X2   EOM?
         BS        ABRT11
         LW        R3,IOC.NAB,X2   GET NUMBER OF BLOCKS WRITTEN
         ADMW      R3,IOC.CFP,X2   UPDATE CURRENT FILE POSITION
         STW       R3,IOC.CFP,X2
         BU        *PL.WRXIT       RETURN
*        DSECT
PL.WRXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
*  PL.RWND - SET POOL TABLES TO REWIND AND REWIND FILE
************************************************************************
PL.RWND  STW       R0,PL.RWXIT
         LI        R7,1
         CAMW      R7,IOC.CPP,X2   POOL # 1 IN MEMORY?
         BEQ       PL.RW02         YES.  SAVE THIS GOOD STUFF.
         ZBM       OUTAOP,IOC.FLAG,X2  OUTPUT ACTIVE?
         BNS       PL.RW01         NO.
         BL        PL.WRIT         OUTPUT THIS POOL TO FILE
PL.RW01  ZMW       IOC.CPP,X2      INDICATE NO DATA IN POOL
         ZMW       IOC.NAB,X2      NO ACTIVE BUFFERS
PL.RW02  LI        R7,1            SHOULD FILE BE REWOUND?
         CAMW      R7,IOC.CFP,X2
         BEQ       *PL.RWXIT       NOT NEEDED.
         LI        R3,1            R3 = FILE POSITION FOR FL.POSS
         BL        FL.POSS         POSITION THE FILE
         BU        *PL.RWXIT
*        DSECT
PL.RWXIT RES       1W              RETURN ADDRESS
*        CSECT
         SPACE     3
************************************************************************
*  PL.REDB - READ PREVIOUS POOL FROM FILE
************************************************************************
PL.REDB  STW       R0,PL.RBXIT
         LW        R3,IOC.CPP,X2   R3 = CURRENT POOL POSITION
         SUI       R3,BLKMAX       R3 = PREVIOUS POOL POSITION
         BLE       ABRT14          SHOULD NEVER BE
         BL        FL.POSS         POSITION FILE
         BL        PL.REDF         GO READ
         BU        *PL.RBXIT       RETURN
*        DSECT
PL.RBXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
*  FL.POSS - POSITION FILE
*  ENTER:  R2 = A(IOC)
*          IOC.CFP = CURRENT FILE POSITION
*  EXIT :  R2,R3 DESTROYED
*          IOC.CFP = NEW FILE POSITION
************************************************************************
FL.POSS  TRR       R3,R4           R4 = DESIRED POSITION
         SUMW      R4,IOC.CFP,X2   R4 = BACKSPACE/SKIP COUNT
         STW       R3,IOC.CFP,X2   UPDATE CURRENT FILE POSITION
         BEQ       FL.PO04         ALREADY THERE.  RETURN
         BGT       FL.PO02         GO ADVANCE TO POSITION
         CI        R3,1            IS THIS POSITION THE BEGINNING OF FIL
         BGT       FL.PO00         NO.  JUST BACKSPACE.
*
*  REWIND WILL QUICKLY GET US THERE
*
         XCR       R1,R2
         SVC       1,X'37'         REWIND FILE
         XCR       R1,R2
         TRSW      R0
*
*  BACKSPACE NUMBER IN R4
*
FL.PO00  XCR       R1,R2           R1 = A(IOCFCB)
FL.PO01  SVC       1,X'35'         BACKSPACE 1 BLOCK
         BIB       R4,FL.PO01      DO ANOTHER.
         XCR       R1,R2           RESTORE REGISTERS
         TRSW      R0              RETURN
*
*  SKIP TO POSITION
*
FL.PO02  TRN       R4,R4           NEGATE COUNT FOR LOOP
         XCR       R1,R2           R1 = A(IOCFCB)
FL.PO03  SVC       1,X'33'         ADVANCE 1 RECORD
         BIB       R4,FL.PO03      DO ANOTHER.
         XCR       R1,R2           RESTORE REGISTERS
FL.PO04  TRSW      R0              RETURN
         PAGE
************************************************************************
*  INTERNAL ROUTINES
************************************************************************
         SPACE     2
************************************************************************
*  IR.CONT  - ESTABLISH THE ADDRESS OF THE IOC FOR THIS LFC
*  ENTER:  R1  = A(FCB)
*  EXIT :  R2  = A(IOC)
************************************************************************
IR.CONT  STW       R0,IR.COXIT     SAVE RETURN ADDR
         LW        R4,=X'00FFFFFF' LFC MASK
         LW        R6,FCB.LFC,X1   USER LFC
         LW        R2,IOCBASE      R2 = START OF IOC'S
         BNZ       IR.CO10         BR IF BUFFERS ALLOCATED
         LW        R7,IOCTOTL      GET NUMBER OF BYTES REQ'D
         SVC       1,X'67'         GET A MAP BLOCK
         STW       R3,IOCBASE      SAVE STARTING ADDR
IR.CO11  TRR       R3,R3           Okay return?                     !006
         BZ        IR.COABT        Go if not                        !006
         ADI       R4,1W           FULL MAP SIZE                    !006
         SUR       R3,R4           SIZE OF MAP
         SUR       R4,R7           SUBT FROM REQUIRED
         BLE       IR.CO09         BR IF WE HAVE ENOUGH             !003
         SVC       1,X'67'         GET ANOTHER MAP
         BU        IR.CO11         LOOP TILL ENOUGH
* ----------------------------------------------------------------- !006
IR.COABT LW        R2,ABT.MEM2     Get error message                !006
         LW        R3,ABT.MEM3                                      !006
         LW        R5,ABT.MEM5                                      !006
         ZR        R6                                               !006
         ZR        R7              Abort this task                  !006
         SVC       1,X'62'         Extended abort, no return        !006
* ----------------------------------------------------------------- !006
IR.CO09  LI        R7,IOC.SIZE     SIZE OF EACH ENTRY               !003
         LW        R2,IOCBASE      FIRST ENTRY                      !003
         LW        R6,IOCTOTL      TOTAL MEMORY                     !003
IR.CO0A  LI        R5,-48                                           !003
IR.CO0B  ZMW       0,X2            CLEAR OUT FCB AND CONTROL WORDS  !003
         ADI       R2,1W                                            !003
         BIB       R5,IR.CO0B                                       !003
         SUI       R2,48W                                           !003
         ADR       R7,R2                                            !003
         SUR       R7,R6                                            !003
         BP        IR.CO0A                                          !003
IR.CO10  LI        R7,IOC.SIZE     R7 = BUMP COUNT
         LW        R2,IOCBASE      R2 = START OF IOC'S
         LW        R5,IOCNUM       R5 = NUMBER OF CURRENTLY USED IOC'S
         TRN       R5,R5           NEGATE COUNT
         BZ        IR.CO03         NONE ALLOCATED YET
************************************************************************
*  LOOP THRU IOC'S SEARCHING FOR LFC IN R6
************************************************************************
IR.CO01  CMMW      R6,FCB.LFC,X2   MATCH?
         BEQ       IR.CO05         YES.
         ADR       R7,R2           BUMP TO THE NEXT IOC
         BIB       R5,IR.CO01      CHECK IT IF ANY MORE
************************************************************************
*  SEARCH FOR DEALLOCATED SPACE
**********************************************************************:*
         LW        R2,IOCBASE      GET BASE ADDRESS
         LW        R5,IOCNUM
         TRN       R5,R5           NEGATE COUNT
         ZR        R6              LOOKING FOR ZERO LFC
IR.CO02  CMMW      R6,FCB.LFC,X2   DEACTIVATED?  (LFC=0?)
         BEQ       IR.CO04         YES.  R2 = A(DEALOCATED IOC)
         ADR       R7,R2           BUMP TO NEXT IOC
         BIB       R5,IR.CO02      TRY ANOTHER
************************************************************************
*  NO MATCH FOUND ALLOCATE A NEW ONE
************************************************************************
IR.CO03  LW        R7,IOCNUM       R7 = NUM ALLOCATED IOC'S
         CI        R7,IOCMAX       HOW DOES IT COMPARE TO TOTAL IOC'S?
         BGE       IR.CO06         NOT SO GOOD
         ABM       31,IOCNUM       INCRIMENT USED IOC COUNT
IR.CO04  BL        IR.INCB         INITIALIZE NEW IOC
IR.CO05  BL        IR.FCBINT       INITIALIZE USER'S FCB
         BU        *IR.COXIT       RETURN
IR.CO06  LI        R7,3            OUT OF IOC'S ERROR
         STW       R7,ERR.CODE     SAVE FOR CALLER
         BU        RM.OPXIT        RESTORE REGS & EXIT
*        DSECT
IOCNUM   DATAW     0               # IOC'S ALLOCATED (FOR IR.CONT ONLY)
IR.COXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
*  IR.FCBIN  INITIALIZE FCB
************************************************************************
IR.FCBIN ZMW       FCB.SFLG,X1     32 FLAG BITS
         ZMB       FCB.SPST,X1     8 FLAG BITS
         ZMW       FCB.RECL,X1     ZERO TRANSFER LENGTH (BYTES)
         TBM       6,FCB.GCFG,X1   EXPANDED FCB?
         BNS       INIT.ST2        NO
         ZMW       FCB.IST1,X1     EXPANDED STATUS WORD 1
         ZMW       FCB.IST2,X1     EXPANDED STATUS WORD 2
INIT.ST2 EQU       $
         TRSW      R0
         NOP                                                        !003
*
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
*
         PAGE
************************************************************************
*  IR.INCB - INITIALIZE NEW IOC BLOCK
*  ENTER: R1 = A(FCB), R2 = A(IOC), R5 DESTROYED
************************************************************************
IR.INCB  EQU       $
         LI        R5,-16          ZERO THE FCB                     !003
IR.IN01  ZMW       0,X2                                             !003
         ADI       R2,1W                                            !003
         BIB       R5,IR.IN01                                       !003
         SUI       R2,16W          RESET R2 TO BEGINNING            !003
         LW        R5,FCB.LFC,X1   GET LFC
         STW       R5,FCB.LFC,X2   SAVE IN IOC FCB
         LW        R5,=X'02000000' GCFG'S
         STW       R5,FCB.GCFG,X2
         LA        R5,IOC.BUF,X2
         STW       R5,FCB.ERWA,X2
*
*  INITIALIZE RECORD AND BUFFER POINTERS
*
         ZMW       IOC.CBN,X2      NO CURRENT BUFFER NUMBER
         ZMW       IOC.NAB,X2      NO ACTIVE BUFFERS
         ZMW       IOC.FLAG,X2     CLEAR FLAGS
         ZMW       IOC.CPP,X2      CURRENT POOL EMPTY
         ZMW       IOC.BCNT,X2     NO COMPRESS COUNT
         ZMW       IOC.BPTR,X2     NO POINTER
         LI        R5,1
         STW       R5,IOC.CFP,X2   CURRENT FILE POSITION  = 1ST BLOCK
         TRSW      R0
         PAGE
************************************************************************
*  IR.CPPY
*  ENTER:  R2 = A(TARGET), R3 = A(SOURCE), R5 = BYTE COUNT
*  EXIT :  R2 = A(NEXT BYTE AFTER TARGET)
*          R3 = LIKEWISE FOR SOURCE
*          R5 = 0
*          R6 = DESTROYED
************************************************************************
IR.CPPY  TRN       R5,R5           NEGATE COUNT
         BGE       IR.CP02
IR.CP01  LB        R6,0,X3         GET SOURCE BYTE
         STB       R6,0,X2         STUFF INTO TARGET BYTE
         ABR       R2,31           INC TARGET ADDR
         ABR       R3,31           INC SOURCE ADDR
         BIB       R5,IR.CP01
IR.CP02  TRSW      R0
         SPACE     2
************************************************************************
*  FILL - FILL TARGET WITH CHAR IN R6
*  ENTER:  R2 = A(TARGET), R5 = FILL COUNT, R6 = FILL CHARACTER
*  EXIT :  R2 = A(NEXT BYTE AFTER TARGET)
*          R5 = 0
*          R6 = DESTROYED
************************************************************************
IR.FILL  TRN       R5,R5           NEGATE COUNT
         BGE       IR.FI02
IR.FI01  STB       R6,0,X2         SAVE A BLANK
         ABR       R2,31
         BIB       R5,IR.FI01
IR.FI02  TRSW      R0
         PAGE
************************************************************************
*  IR.FINIS - FINISH BUFFER BY PADDING UNUSED SPACE WITH ZERO'S
************************************************************************
IR.FINIS STW       R0,IR.FIXIT     SAVE RETURN ADDRESS
         STW       R2,IOCA         SAVE CONTEXT ADDR
         LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         SBM       RCB.EOB,RCB.SBLR,X3  MARK END OF BLOCK
         LI        R5,BLKSIZ       TOTAL BLOCKSIZE
         TRR       R3,R6           SAVE R6
         LW        R3,IOC.CBA,X2   CURRENT BUFFER ADDRESS
         SUMW      R5,0W,X3        SUBTRACT USED BLOCK SPACE
         TRR       R6,R3           RESTORE R3
         SUI       R5,1H           SUBTRACT LAST RCB HALFWORD
         ZR        R6              FILL CHARACTER = 0
         LA        R2,1H,X3        ADDRESS OF TARGET BYTE
         BL        IR.FILL         FILL ANY CHAR SPACES
         LW        R2,IOCA         RESTORE A (IOC)
         BU        *IR.FIXIT       RETURN
*        DSECT
IR.FIXIT RES       1W              RETURN ADDRESS
*        CSECT
         SPACE     2
************************************************************************
*  INITIALIZE CURRENT BUFFER FOR WRITE
*  ENTER:  R2 = A(IOC)
*  EXIT :  R3 DESTROYED, IOC.RCBA DEFINED, BOB SET, REL BLK R/W SET
************************************************************************
IR.BINIT LW        R3,IOC.CBA,X2   R3 = ADDRESS OF CURRENT BUFFER
         ZMW       0W,X3           ZERO RCB'S
         SBM       29,0W,X3        INIT TO 1W
         ADI       R3,1W           ADD RELATIVE OFFSET TO GET RCB ADDR
         STW       R3,IOC.RCBA,X2  UPDATE A(RCB)
         ZMW       0W,X3           ZERO RCB'S
         SBM       RCB.BOB,RCB.SBLR,X3  TAG AS BEGINNING OF BLOCK
         TRSW      R0
         SPACE     2
************************************************************************
*  IR.WEOF - WRITE END OF FILE TO BLOCK
************************************************************************
IR.WEOF  STW       R0,IR.WEXIT
         LW        R7,IOC.CPP,X2   POOL INITIALIZED?
         BNZ       IR.WE00         YES.
         LA        R3,IOC.BUF,X2   INITIALIZE BUFFER
         STW       R3,IOC.CBA,X2
         LI        R3,1
         STW       R3,IOC.NAB,X2
         STW       R3,IOC.CBN,X2
         STW       R3,IOC.CPP,X2
         BL        IR.BINIT
IR.WE00  LI        R6,BLKSIZ       CALCULATE
         LW        R3,IOC.CBA,X2   GET CURR BUFF ADDR
         SUMW      R6,0W,X3        SPACE AVALIABLE IN BLOCK
         CI        R6,3H           ENOUGH FOR EOF?
         BGE       IR.WE01         YES
************************************************************************
*  COMPLETE THIS BLOCK.  EOF GOES IN NEXT BLOCK
************************************************************************
         BL        IR.FINIS        COMPLETE BLOCK
         BL        BF.WRIT         WRITE AND GET NEXT BUFFER
         BL        IR.BINIT        INITIALIZE FOR WRITE
IR.WE01  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         ZMB       RCB.SBTR,X3
         ZMB       RCB.BCTR,X3
         SBM       RCB.EOF,RCB.SBTR,X3   SET EOF.
         SBM       RCB.EOB,RCB.SBTR,X3   SET EOB.
         LA        R3,1W,X3
         ZMB       RCB.SBLR,X3
         ZMB       RCB.BCLR,X3
         SBM       RCB.EOF,RCB.SBLR,X3   SET EOF ALSO AT END OF RECORD
         SBM       RCB.EOB,RCB.SBLR,X3   SET EOB TOO.
         STW       R3,IOC.RCBA,X2  UPDATE THE RCB ADDRESS
         TRR       R3,R5           R5 = A(RCB)
         SUMW      R5,IOC.CBA,X2   SUBTRACT BLK ORIGIN FOR REL END
         LW        R3,IOC.CBA,X2   CURR BUFF ADDR
         STW       R5,0W,X3        UPDATE BLOCKING BUFFER CONTROL WORD
*
*  EOF IS ALWAYS LAST RECORD IN A BLOCK.
*  NOW WE PURGE THIS BLOCK AND READY NEW BLOCK
*
         BL        IR.FINIS        COMPLETE BLOCK
         BL        BF.WRIT         WRITE BLOCK
         BL        IR.BINIT        INITIALIZE NEW BLOCK
         BU        *IR.WEXIT
*        DSECT
IR.WEXIT RES       1W              RETURN ADDRESS
*        CSECT
         PAGE
************************************************************************
*  RECORD MANAGER ABORT EXITS
*  R2 = A(IOC)
************************************************************************
ABRT14   ABM       31,ABCODE       INTERNAL FILE POSITION ERROR
ABRT13   ABM       31,ABCODE       OPEN RESOURCE ERROR
ABRT12   ABM       31,ABCODE       INTERNAL FILE POSITION ERROR
ABRT11   ABM       31,ABCODE       END OF MEDIUM
ABRT10   ABM       30,ABCODE       ERROR ON WRITE
         ABM       28,ABCODE       ABOVE CODES ARE 10-14
         BU        RM.AB           GO ABORT YOURSELF
ABRT9    ABM       31,ABCODE       READ NOT ALLOWED AFTER WRITE
ABRT8    ABM       31,ABCODE       USER RECORD SIZE TOO LARGE
ABRT7    ABM       31,ABCODE       WRITE ATTEMPTED ON UNOPENED FILE
ABRT6    ABM       31,ABCODE       END OF MEDIUM
ABRT5    ABM       31,ABCODE       PREMATURE EOF
ABRT4    ABM       31,ABCODE       ERROR CONDITION ON READ
ABRT3    ABM       31,ABCODE       NO MORE IOC'S AVAILABLE
ABRT2    ABM       31,ABCODE       NOT A MULTIPLE # BLOCKS READ
ABRT1    ABM       31,ABCODE       LESS THAN 1 BLOCK ON READ
RM.AB    LW        R5,ABCODE       GET ABORT MESSAGE IN R5
         STW       R5,ERR.CODE     SET ABORT CODE FOR CALLER
         ZMW       ABCODE          CLEAR FOR LATER
         BU        RM.CL02         CLOSE THIS FILE & DEALLOCATE
         SPACE     2
*        DSECT
ABCODE   DATAW     0               ABORT CODE
         BOUND     1W                                               !006
ABT.MEM5 DATAB     C'B:FIO NO MEM'                                  !006
ABT.MEM2 EQU       ABT.MEM5+1W                                      !006
ABT.MEM3 EQU       ABT.MEM2+1W                                      !006
*        CSECT
         END
