/*~!MAIN.C*/
/* Name:  MAIN.C Part No.: _______-____r
 *			
 *	            SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *				M A I N . C
 *
 *				Revision History
 *				----------------
 */

#define		NCHNAM	8
#include	<ctype.h>
#include	"has.h"

extern	short	debug;
extern	struct	sdata easycodes[];
extern	struct	sdata hardcodes[];
extern	FILE	*reltfile;
extern	FILE	*reldfile;
extern	long	trsize;
extern	long	drsize;
extern	short	numsyms;
extern	short	dfltextern;
extern	long	textaddr;
extern	long	dataaddr;
extern	long	bssaddr;
extern	long	*addrp;
extern	short	curspace;
extern	char	*fgets();
extern	FILE	*fopen();
extern	char	*strcpy();
extern	char	*malloc();				
extern	char	*mktemp();
extern	short	symdebug;	/*  flag indicating use of "-g" option  */
extern	int 	totallines;	/*  total # of ".line" psudo ops */
extern	struct nlist *get();
extern	struct nlist *new();

/* All assembler file names */
char	*texttmp	= "text.XXXXX";
char	*datatmp	= "data.XXXXX";
char	*relttmp	= "trel.XXXXX";
char	*reldtmp	= "drel.XXXXX";
char	*Dfltoutput	= "a.out";	/* default output filename */

struct	output	textout;
struct	output	dataout;
struct	output	*curout;
FILE	*textfile;
FILE	*datafile;
FILE	*constfd;
char	*outfile = 0;		/* pointer to output file name */
char	*inputfile;		/* current input file */
short	prsymbols = 0;		/* -s flag, list symbols on completion */
short	listing = 0;		/* produce pretty listing on stdout */
short	linenumber = 0;		/* current linenumber in input file */
short	errors = 0;		/* if non-zero, terminates after pass 1 */
short	foundinput = 0;		/* if non-zero, input was given */
short	botherrs = 0;		/* errors on stderr as well as stdout (default) */
char	*symfile;		/* pointer to symbol file from compiler */
char	*astfile;		/* pointer to "assembler symbol file" */
FILE	*i_symf;		/* symbol file from compiler */
FILE	*o_astf;		/* symbol file generated by assembler */
short	lpi = 0;		/* current litteral pool index */

main (argc, argv)
int	argc;
char	**argv;
{
	FILE	*input;
	char	*fields[NFIELDS];
	char	linebuf[LINESIZE];
	char	listbuf[LINESIZE];
	register short	i;

	if (argc == 1) {
		printf ("Usage:  as [-elosv] files.s ...\n");
		exit (1);
	}

	/* scan argument list for assembler options */
	for (i = 1; i < argc; i++) {
		if (argv[i] == 0)
			/* was object filename - processed by preceding -o */
			continue;
		if (argv[i][0] != '-')
			/* source filename - skip for now */
			continue;
		argv[i]++;
		while (*argv[i]) {
			switch (*argv[i]) {

			case 'b':				
			case 'B':				
				botherrs++;			
				break;				

			case 'e':
			case 'E':				
				dfltextern++;
				break;

			case 'g':
			case 'G':
				symdebug++;
				break;

			case 'l':
			case 'L':				
				listing++;
				break;

			case 'o':
			case 'O':				
				if (outfile)
					bomb ("multiple outputs");
				if (i+1 >= argc)
					bomb ("no output filename");
				outfile = argv[i+1];
				argv[i+1] = 0;
				break;

			case 's':
			case 'S':				
				prsymbols++;
				break;

			case 'd':				
			case 'D':
				if (isdigit (*++argv[i])) {
					/* compute debug level */
					debug = 0;
					do debug = debug * 10 + *argv[i] - '0';
					while (isdigit (*++argv[i]));
				} else debug = 2; /* default */
				/* argv[i] points to next option (or EOS) */
				continue;

			default:
				bomb ("unknown flag %c", *argv[i]);
			}
			argv[i]++;
		}
		argv[i] = 0;
	}

	if (!outfile)
		outfile = Dfltoutput;

	overture();
	DEBUG(1, "\nBegin pass 1 ...\n", 0);

	/* Main Loop -- Pass 1 */
	/* scan argument list for source filenames */
	for (i = 1; i < argc; i++) {
		if (argv[i] == 0) /* was part of options declaration */
			continue;
		if ((input = fopen (argv[i], "r")) == NULL) {
			perror(argv[i]);
			bomb ("can't open input file");
		}
		foundinput++;

		/* Information for error prints */
		inputfile = argv[i];
		linenumber = 0;

		while (fgets (linebuf, LINESIZE, input) != NULL) {
			linenumber++;
			DEBUG (2, "> %s", linebuf);
	/* printf (">> %s\n", linebuf); */
			parse (linebuf, fields);

			if (fields[0] == 0)
				continue;	/* Blank line */
			{
				struct nlist *np;
				int	j;
				char*	strp;
				for (j=0; fields[j]; j++) {
					strp = fields[j];
	/* printf ("string %d = %s\n", j, strp); */
					if (*strp != '=')continue;
					if((np = get(strp)) != NULL)continue;
					np = new(strp);
					np->n_spare = lpi;
				}
			}
			pass1 (fields);
		}
		fclose (input);
	}

	interlude();
	DEBUG (1, "\nBegin pass 2 ...\n", 0);
	lpi = 0;		/* reset literal pool index */

	/* Main Loop -- Pass 2 */
	for (i = 1; i < argc; i++) {
		if (argv[i] == 0)
			continue;
		if ((input = fopen (argv[i], "r")) == NULL) {
			perror(argv[i]);
			bomb ("can't reopen input file");
		}

		/* Information for error prints */
		inputfile = argv[i];
		linenumber = 0;

		while (fgets (linebuf, LINESIZE, input) != NULL) {
			linenumber++;
			DEBUG (2, "> %s", linebuf);
			if (listing)
				strcpy( listbuf, linebuf );

			parse (linebuf, fields);
			if (fields[0] == 0) {
				/* Blank line or comment */
				prtbloc();
				if (listing)
					printf("%s", listbuf );
				continue;
			}
			pass2 (fields);
			if (listing)
				printf("%s", listbuf );
		}
		fclose (input);
	}

	finale();

#ifndef JUNK
	if (debug==0)					
	{						
	    unlink (texttmp);
	    unlink (datatmp);
	    unlink (relttmp);
	    unlink (reldtmp);
	}						
#endif
	exit ( errors ? 1 : 0 );
}

overture()
{
	textaddr = 0L;
	dataaddr = 0L;
	bssaddr = 0L;

	curspace = N_TEXT;
	addrp = &textaddr;

	symtabinit();
}

interlude()
{
/*
 *  Prepare for pass 2
 */
int	stroff; /* offset for .ast name string */
int	lpt = 0; /* off set of last . in outfile name */

	curspace = N_DATA;
	align1( N_AFWORD );
/*	bssfix( dataaddr );						 */

	textaddr = 0L;
	dataaddr = 0L;
	bssaddr = 0L;
	trsize = 0L;
	drsize = 0L;

	if (!foundinput) {
		fprintf (stderr, "No input specified\n");
		exit (2);
	}

	if (debug > 8)
		printsymbols (stdout);

	if (errors) {
		fprintf (stderr, "%d errors detected in pass 1\n", errors);
		exit (1);
	}

	if (debug)						
	{							
	    texttmp += 5;					
	    datatmp += 5;					
	    relttmp += 5;					
	    reldtmp += 5;					
	}							

	if ((textfile = fopen (mktemp (texttmp), "w")) == NULL) {
		perror (texttmp);
		bomb ("Cannot create TEXT temporary file");
	}
	textout.o_file = textfile;
	textout.o_nleft = sizeof (WORD);
	textout.o_ptr = (char *)&textout.o_word;

	if ((datafile = fopen (mktemp (datatmp), "w")) == NULL) {
		perror (datatmp);
		bomb ("Cannot create DATA temporary file");
	}
	dataout.o_file = datafile;
	dataout.o_nleft = sizeof (WORD);
	dataout.o_ptr = (char *)&dataout.o_word;

	/* Default to textspace */
	curout = &textout;
	curspace = N_TEXT;
	addrp = &textaddr;

	if ((reltfile = fopen (mktemp (relttmp), "w")) == NULL) {
		perror (relttmp);
		bomb ("Cannot create TEXT relocation temporary file");
	}

	if ((reldfile = fopen (mktemp (reldtmp), "w")) == NULL) {
		perror (reldtmp);
		bomb ("Cannot create DATA relocation temporary file");
	}

	if (symdebug)
	    {							
	    astfile = malloc(strlen(outfile)+4);		
	    for (stroff = 0; *(outfile+stroff); stroff++)	
		{						
		*(astfile + stroff) = *(outfile + stroff);	
		if (*(astfile + stroff) == '.')			
		    lpt = stroff;				
		}						
	    if (lpt)						
		strcpy(astfile+lpt+1, "ast");			
	    else					
		strcpy(astfile+stroff, ".ast");			
	    o_astf = fopen(astfile,"w");			
	    }							
}

finale()
{
	struct	exec	hdr;
	FILE	*ofile;

	if (debug > 2 || prsymbols) {				
		if (listing)
			printf ("\n");
		printsymbols (stdout);
	}

	if (errors) {
		printf ("%d errors detected in pass 2\n", errors);
		return;
	}

	curout = &textout;
	if (textout.o_nleft < 8) {
		dumpstr ("\0\0\0\0\0\0\0\0", textout.o_nleft);
		fwrite (&textout.o_word, sizeof (WORD) - textout.o_nleft,
			1, textfile);
	}
	fclose (textfile);

	curout = &dataout;
	addrp  = &dataaddr;					
	curspace = N_DATA;				
	if (dataout.o_nleft < 8) {
		dumpstr ("\0\0\0\0\0\0\0\0", dataout.o_nleft);
		fwrite (&dataout.o_word, sizeof (WORD) - dataout.o_nleft,
			1, datafile);
	}
	fclose (datafile);

	if ((ofile = fopen (outfile, "w+")) == NULL)
		bomb ("Cannot creat object file (%s)", outfile);

	hdr.a_magic = HEPMAGIC;	
	hdr.a_text = textaddr;
	hdr.a_data = dataaddr;
	hdr.a_bss = bssaddr;
	hdr.a_maxpsws = 0;
	hdr.a_constant = 0;
	hdr.a_trsize = trsize;
	hdr.a_drsize = drsize;
	hdr.a_syms = (long)numsyms*sizeof (struct nlist);
	hdr.a_entry = 0;
	hdr.a_maxstack = 0;
	hdr.a_symstrsiz = 0;
	hdr.a_areg = 0;
	hdr.a_ipsw = 0;
	hdr.a_spare[0] = 0;
	hdr.a_spare[1] = 0;
	fwrite (&hdr, sizeof hdr, 1, ofile);

	textfile = fopen (texttmp, "r");
	copy (textfile, ofile);

	datafile = fopen (datatmp, "r");
	copy (datafile, ofile);

	if (trsize > 0L) {
		fclose (reltfile);
		reltfile = fopen (relttmp, "r");
		copy (reltfile, ofile);
	}

	if (drsize > 0L) {
		fclose (reldfile);
		reldfile = fopen (reldtmp, "r");
		copy (reldfile, ofile);
	}

	dumpsymbols (ofile);

	if (ferror (ofile))
		bomb ("Error writing object file (%s)", outfile);
	fclose (ofile);

	if (symdebug)
		fclose (o_astf);
}

copy (in, out)
FILE	*in;
FILE	*out;
{
	short	nread;
	char	buf[512];

	while ((nread = fread (buf, 1, sizeof buf, in)) == sizeof buf)
		fwrite (buf, 1, sizeof buf, out);
	if (nread > 0)
		fwrite (buf, 1, nread, out);
	if (ferror(in) || ferror(out))
		bomb ("Error during copy to object (%s)", outfile);
}

int	label=0;	/* non zero if line contains label */

parse (str, fieldp)
register char	*str;
register char	**fieldp;
{
char	prev = ',';					

	label = 0;	/* assume no label */
	/* if * in col 1 comment, ignore line */
	if (str[0] == '*' || str[0] == '\n') {
		*fieldp = 0;
		return;
	}
	/* see if a label. must start in col 1 */
	if (str[0] != ' ' && str[0] != '\t') {
		/* we have a label */
		label = 1;
		*fieldp++ = str;	
		while (*str && *str != ' ' && *str != '\t' && *str != '\n')
			str++;
		*str++ = 0; /* replace delimiter with string terminator */
	}
	/* now get operation field */
	while (*str && (*str == ' ' || *str == '\t'))
		/* skip white space */
		str++;
	/* now at operation field */
	if (*str == '\n') {
		*fieldp = 0;
		return;
	}
	*fieldp++ = str;
	/* must terminate with \n, space or \t */
	while (*str && *str != ' ' && *str != '\t' && *str != '\n')
		str++;
	prev = *str;	/* remember what it was */	
	*str++ = 0; /* replace delimiter with string terminator */

	/* now get operand field */
	while (*str && (*str == ' ' || *str == '\t'))
		/* skip white space */
		str++;
	while (*str) {	/* get fields */
		/* now at operand field */
		if (*str == '\n') {
			*fieldp = 0;
			return;
		}
		*fieldp++ = str;
		if (*str == '\'') { /* if quoted string, continue */
			str++;	/* bump past quote */
			while (*str & *str != '\'')str++;
		}
		/* must terminate with \n, space, comma or \t */
		while (*str && *str != ',' && *str != ' ' && *str != '\t' && *str != '\n')
			str++;
		prev = *str;	/* remember what it was */	
		*str++ = 0; /* replace delimiter with string terminator */
		if (prev != ',')break;	/* done if not a comma */
	}
	*fieldp = 0;
}


/*	E R R O R ( )
 *
 *	Error() is for non-fatal errors caused by illegal input
 *	or assembling errors (undefines, multiple defines, bad opcodes).
 *	The file and linenumber is printed along with a message.
 *	The arguments to error() are the same as those to printf().
 */
/* VARARGS */
error (fmt, a, b, c, d, e, f, g, h)
char *fmt, *a, *b, *c, *d, *e, *f, *g, *h;
{
if (listing) {				/* on stdout if listing */
   printf ("nas: %s, line %d: ", inputfile, linenumber);
   printf (fmt, a, b, c, d, e, f, g, h);
   putchar ('\n');
}
errors++;
fprintf (stderr, "nas: %s, line %d: ", inputfile, linenumber);
fprintf (stderr, fmt, a, b, c, d, e, f, g, h);
fprintf (stderr, "\n");				
}

/*
 *	B O M B ( )
 *
 *	This function causes an abnormal termination after printing
 *	an appropriate error message.  The arguments to bomb() are
 *	identical to those of printf().
 */
/* VARARGS */
bomb (fmt, a, b, c, d, e, f, g, h)
char *fmt, *a, *b, *c, *d, *e, *f, *g, *h;
{
	fflush (stdout);
	fprintf (stderr, "Fatal ISC assembler error...\n");
	fprintf (stderr, fmt, a, b, c, d, e, f, g, h);
	fputc ('\n', stderr);
	exit (1);
}
