/*~!DO1PSEUDO.C*/
/* Name:  DO1PSEUDO.C Part No.: _______-____r
 *			
 *		            SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *			   D O 1 P S E U D O . C
 *
 *			     Revision History
 *			     ----------------
*/

#include <ctype.h>
#include "has.h"

extern	struct nlist *get();
extern	struct nlist *new();
extern	char *strchr();
extern	char *rdstring();
extern	long atol();
extern	struct	nlist	*curlabp;

do1equ (token, fieldp)
register char	*token;
char	**fieldp;
{
	long	ltmp;
	struct	nlist *np;
	WORD	hw;
	struct	relocation	rp;

	if (curlabp == NULL) {
		error ("equ missing label");
		return (-1);
	}
	np = curlabp;
	if (*(++fieldp) == 0) {
		error ("equ missing symbol and value");
		return (-1);
	}
	DEBUG(3,"do1equ(%s);\n", fieldp[0]);		
	if ((getval(*fieldp, &hw, &rp)) < NULL) {
		error ("Undefined equ value");
		return (-1);
	}

	ltmp = hw;
	np->n_type = N_CONST; /* no attributes */
	np->n_value = ltmp;
	DEBUG(3,"do1equ final value (%x);\n", ltmp);		
	return (0);
}

do1define (token, fieldp)
register char	*token;
char	**fieldp;
{
	long	ltmp;
	struct	nlist *np;

	DEBUG(3,"do1define( ,%s);\n", fieldp[1]);		
	if (*(++fieldp) == 0) {
		error (".define missing symbol and value");
		return (-1);
	}
	if ((np = get(*fieldp)) != NULL) {
		error ("Symbol '%s' multiply defined", *fieldp);
		return (-1);
	}
	np = new (*fieldp);
	np->n_value = ltmp;
	return (0);
}

extern	short	curspace;
extern	long	*addrp;
extern	long	dataaddr;
extern	long	textaddr;
extern	long	bssaddr;
extern	short	listing;

do1data ()
{
	addrp = &dataaddr;
	curspace = N_DATA;
	return (0);
}

do1text ()
{
	addrp = &textaddr;
	curspace = N_TEXT;
	return (0);
}

do1bss ()
{
	addrp = &bssaddr;
	curspace = N_BSS;
	return (0);
}

do1common (token, fieldp)
register char*	token;
char	**fieldp;
{
	struct	nlist *np;
	short	aligncode;
	long	ltmp;

	if (*(++fieldp) == 0) {
		error (".comm missing args");
		return (-1);
	}
	if ((np = get(*fieldp)) != NULL) {
		ltmp = np->n_value;
		if( ltmp != 0L ) {
			error ("Symbol '%s' multiply defined", *fieldp);
			return (-1);
		}
	} else
		np = new (*fieldp);
	if (*(++fieldp) == 0) {
		error (".comm missing bytes,alignment");
		return (-1);
	}
	np->n_type = N_EXTERN;
	if (getnum (*fieldp, &ltmp) == -1)
		return (-1);
	np->n_value = ltmp;
	if (*(++fieldp) == 0) {
		error (".comm missing alignment");
		return (-1);
	}
	if ((aligncode = (short) aligndecode (*fieldp)) == -1)
		return (-1);
	np->n_align = aligncode;
	return (0);
}

do1global (token, fieldp)
register char*	token;
char	**fieldp;
{
	struct nlist *np;

	if (*(++fieldp) == 0) {
		error (".global missing args");
		return (-1);
	}
	while (*fieldp) {
		if ((np = get(*fieldp)) == NULL)
			np = new ( *fieldp );
		np->n_type |= N_EXTERN;
		fieldp++;
	}
	return (0);
}

do1align (token, fieldp)
char	*token;
register char	**fieldp;
{
	if (*(++fieldp) == 0) {
		error (".align missing arg");
		return (-1);
	}
	return (align1 (aligndecode (*fieldp)));
}

align1 (where)
int	where;
{
	switch (where) {
	case N_AFILE:	
	case N_AFWORD:
	case N_AHWORD:	
	case N_AQWORD:
	case N_ABYTE:
		*addrp = (*addrp + (where-1)) & ~(where-1);
		break;
	default:
		error ("illegal bound arg is %x", where);
		return (-1);
	}
	return (0);
}

do1rez (token, fieldp)
char	*token;
char	**fieldp;
{
	short	numlocs;

	if ((evalqword (fieldp[1], &numlocs)) < 0 || numlocs <= 0) {
		error ("illegal .rez value");
		return (-1);
	}
	*addrp += numlocs;
	return(0);
}

do1zero (token, fieldp)
char	*token;
char	**fieldp;
{
long	howmuch;

DEBUG(2, "do1zero ( ,%s);\n", fieldp[1]);
	if (*(++fieldp) == 0) {
		error (".zero missing value");
		return (-1);
	}
	if ((getnum (*fieldp, &howmuch) < 0) || (howmuch < 0))
	    {
	    DEBUG(1,"\t.zero value is %d\n", howmuch);	
	    error ("illegal .zero value");
	    return (-1);
	    }

DEBUG(6,"\tdo1zero: howmuch is %d,", howmuch);
DEBUG(6,"\t*addrp is %d,", *addrp);
	*addrp += howmuch;
DEBUG(6,"\t*addrp is now %d\n", *addrp);
	return (0);
}

do1string(token, fieldp)
char	*token;
register char	**fieldp;
{
	register char *cp;

	if (*(++fieldp) == 0) {
		error (".string missing value");
		return (-1);
	}
	if ((cp = rdstring (*fieldp)) == NULL) {
		error ("bad .string value");
		return (-1);
	}

	if (strcmp(token, ".astring") == NULL) /* if equal */	
	   *addrp += (long) (strlen(cp));			
	else							
	   *addrp += (long) (strlen (cp) + 1);
	free(cp);						
	return (0);
}

do1fword (token, fieldp)
char	*token;
char	**fieldp;
{
	if (*(++fieldp) == 0) {
		error (".fword missing value");
		return (-1);
	}
	align1 (N_AFWORD);
	while (*fieldp++)
		*addrp += 8L;
	return (0);
}

do1hword (token, fieldp)
char	*token;
char	**fieldp;
{
	if (*(++fieldp) == 0) {
		error (".hword missing value");
		return (-1);
	}
	align1 (N_AHWORD);
	while (*fieldp++)
		*addrp += 4L;
	return (0);
}

do1qword (token, fieldp)
char	*token;
char	**fieldp;
{
	if (*(++fieldp) == 0) {
		error (".qword missing value");
		return (-1);
	}
	align1 (N_AQWORD);
	while (*fieldp++)
		*addrp += 2L;
	return (0);
}

do1byte (token, fieldp)
char	*token;
char	**fieldp;
{
	if (*(++fieldp) == 0) {
		error ("datab missing value");
		return (-1);
	}
	DEBUG (8, "do1byte(): starting at 0x%0lx\n", *addrp);
	while (*(fieldp++)) {
		(*addrp)++;
		DEBUG (8, "--- now at 0x%0lx\n", *addrp);
	}
	return (0);
}

do1loc (token, fieldp)
char	*token;
char	**fieldp;
{
	long	newloc;

	if (*(++fieldp) == 0) {
		error(".loc missing value");
		return (-1);
	}
	if (getnum (*fieldp, &newloc) == -1)
		return (-1);
	if (newloc < *addrp) {
		error (".loc goes backwards");
		return (-1);
	}
	*addrp = newloc;
	return (0);
}

do1line (token, fieldp)
char *token;
char **fieldp;
{
extern short symdebug;
extern int totallines;
/*
 *     In pass1, keep track of total # of occurances of ".line" pseudo.
 */
	++fieldp;
	if (symdebug) {
		if (fieldp == 0) {
			error (".line missing value");
			return (-1);
		}
		totallines++;
		return (0);
	}
	return (0);
}

do1end (token, fieldp)
char *token;
char **fieldp;
{
	align1 (N_AHWORD);
	return (do1lpool(token, fieldp));
}

do1lpool (token, fieldp)
char *token;
char **fieldp;
{
	extern short numsyms;
	extern short lpi;
	extern struct nlist	*symlist[];
	int	i;
	struct	nlist	*np;

	align1 (N_AHWORD);
	for (i=0; i<numsyms; i++) {
		np = symlist[i];
	DEBUG(1,"do1pool: looking at symbol %s\n", np->n_name);
	DEBUG(1,"do1pool: first char is %c\n", np->n_name[0]);
	DEBUG(1,"do1pool: type is %x\n", np->n_type);
		if (((np->n_type & N_TYPE) == N_UNDEF) && (np->n_name[0] == '=')) {
			if (np->n_spare != lpi)continue;
	DEBUG(1,"do1pool: symbol at %lx\n", *addrp);
			np->n_value = *addrp;
			*addrp += 4;
			np->n_type = N_CONSTA;	/* this a literal pointer */
		}
	}
	lpi++;
	return (0);
}
