


     BOOL(3F)                  UNIX System V                  BOOL(3F)



     NAME
          and, or, xor, not, lshift, rshift - Fortran bitwise boolean
          functions

     SYNTAX
          integer i, j, k
          real a, b, c
          double precision dp1, dp2, dp3

          k = and(i, j)
          c = or(a, b)
          j = xor(i, a)
          j = not(i)
          k = lshift(i, j)
          k = rshift(i, j)

     DESCRIPTION
          The generic intrinsic boolean functions and, or and xor
          return the value of the binary operations on their
          arguments.  Not is a unary operator returning the one's
          complement of its argument.  Lshift and rshift return the
          value of the first argument shifted left or right,
          respectively, the number of times specified by the second
          (integer) argument.

          The boolean functions are generic, that is, they are defined
          for all data types as arguments and return values. Where
          required, the compiler will generate appropriate type
          conversions.

     NOTE
          Although defined for all data types, use of boolean
          functions on any but integer data is not advised and will
          probably result in unexpected consequences.

     SPECIAL CONSIDERATIONS
          The implementation of the shift functions may cause large
          shift values to deliver weird results.

















     Page 1                                         (printed 11/19/90)



