/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3.4                                 */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.234.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Descriptions :          Verify that a fields size of 0 forces the next   */
/*                          field to be aligned on the next word boundary.   */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device and the file "result/decl.23.r".          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
/* global data for test 2.3.4                                           */
int    BSIZE = 8;
struct {  int       x      : 30;
          unsigned         : 0;        /* special width 0,may force     */
          unsigned rest    : 2;        /* alignment at the next boundary*/
       } boundary;                     /* for an unnamed field.         */
 
 
main()
{    FILE *fp;
    int size;
    int x;
    fp=fopen("decl_res bloc=y","a");
   /* Fields 2.3.4 */
   /* verify the special width 0 forces alignment at the next int       */
   /* boundary. There size of boundary should be 8.                     */
      if ( (size=sizeof(boundary)) != BSIZE ) {
         fprintf(fp,"  ** declaration, fields 2.3.4   class 2 fail exit return code : %d\n",size);
         printf("  ** declaration, fields 2.3.4   class 2 fail exit return code : %d\n",size);
         }
      else
      {
         boundary.x = 0xffffffff;       /* only allocate 30 bits        */
         boundary.rest = 1;
         if ( boundary.x != 0x3fffffff || boundary.rest != 1 ){
         fprintf(fp,"  ** declaration, fields 2.3.4   class 2 fail exit return code : %x\n",boundary.x);
         printf("  ** declaration, fields 2.3.4   class 2 fail exit return code : %x\n",boundary.x);
         }
         else
         {
         fprintf(fp,"  .. declaration, fields 2.3.4   class 2 pass\n");
         printf("  .. declaration, fields 2.3.4   class 2 pass\n");
         }
         fclose(fp);
      }
}
