/* local2.c */
/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 * 	(c) Copyright 1990 J B Systems
 *	This file contains non-based support modifications
 *	for operation under MPX.  Derived from Encores' base
 *	mode C compiler.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: local2.c,v 5.5 89/05/12 12:43:43 pcc Rel-3_0 $";
#endif

/*
    C compiler for Gould processors, base register instruction set.

    Ported from the 4.1c Berkeley Standard
	Distribution source for a VAX portable C compiler.
*/
#include "mfile2.h"
#include "ctype.h"

#ifndef JCB
#define u370 1
#undef i386
#include <a.out.h>
#define i386
#else /* JCB */
#include "stab.h"
#endif /* JCB */

#ifdef FORT
int         ftlab1, ftlab2;
#endif /* FORT */
/* a lot of the machine dependent parts of the second pass */

#define BITMASK (n) ((unsigned)((unsigned)1L << n) - 1)

int         argwordcount;
int         bittestused;
where(c)
{
    fprintf(stderr, "%s, line %d: ", filename, lineno);
}

lineid(l, fn) char *fn;
{
 /* identify line l and file fn */
    static char     lastfn[40];
    static      labno;
#ifdef MPX
    if (lflag >= 2) {
#else
    if (lflag == 1) {
#endif
	if (strncmp(lastfn, fn, sizeof lastfn)) {
	    strncpy(lastfn, fn, sizeof lastfn);
	    printf("	.stabs %s,0x%x,0,LLL%d\nLLL%d:\n",
	 	fn, N_SO, labno, labno);
	    labno++;
	}
	printf("	.stabd 0x%x,0,0x%x\n", N_SLINE, l);
    }
    else {
#ifdef UAS
	printf("*	line %d, file %s\n", l, fn);
#else
	printf("--	line %d, file %s\n", l, fn);
#endif
    }
}

int         maxargs;
eobl2(nregs)
{
    OFFSZ       spoff;		/* offset from stack pointer */
    OFFSZ	ntmp;
    maxargs *= SZCHAR;
    SETOFF(maxargs, ALLONG);
    SETOFF(maxoff, ALLONG);
    {
	OFFSZ   regsave;
	ntmp = maxargs + maxoff;		/* base of near temp, for c2 */
	regsave = maxargs + maxoff + FRAMESZ;	/* base of far locals (FLOC) */
#ifdef JUNK
printf("maxargs = %dw\n", maxargs/SZINT);
printf("maxoff = %dw\n", maxoff/SZINT);
printf("regsave = %dw\n", regsave/SZINT);
#endif
	SETOFF(regsave, ALFRAME);
#ifdef JUNK
printf("regsave = %dw\n", regsave/SZINT);
#endif
#ifdef UAS
#ifdef MPX
	printf("CALL%d	equ	0w\n", ftnno);
#endif
	printf("LOC%d	equ	%dw\n", ftnno, maxargs / SZINT);
	printf("L_TMP%d	equ	%dw\n", ftnno, ntmp / SZINT);
#ifdef FORT
	printf("FRM%d	equ	%dw\n", ftnno, regsave / SZINT);
#else /* NOT FORT */
	printf("LA%d	equ	%dw\n", ftnno, regsave / SZINT);
#ifdef MPX
	printf("SLA%d\tdataw\tLA%d\n", ftnno, ftnno);
#endif
#endif /* FORT */
#else /* NOT UAS */
	printf("	.set	LOC%d,%dw\n", ftnno, maxargs / SZINT);
	printf("	.set	L_TMP%d,%dw\n", ftnno, ntmp / SZINT);
#ifdef FORT
	printf("	.set	FRM%d,%dw\n", ftnno, regsave / SZINT);
#else /* NOT FORT */
	printf("	.set	LA%d,%dw\n", ftnno, regsave / SZINT);
#endif /* FORT */
#endif /* UAS */

#ifdef UAS
#ifndef MPX
	printf("L_FLOC%d	equ	%dw\n", ftnno, floc / SZINT);
	printf("L_FTMP%d	equ	%dw\n", ftnno, ftmp / SZINT);
#endif
#else
	printf("	.set	L_FLOC%d,%dw\n", ftnno, floc / SZINT);
	printf("	.set	L_FTMP%d,%dw\n", ftnno, ftmp / SZINT);
#endif /* UAS */

    }
    maxargs = 0;
}

struct      hoptab
{
    int         opmask;
    char       *opstring;
}           ioptab[] =
{
#ifdef UAS
		ASG PLUS, "ad",
                ASG MINUS, "su",
                ASG MUL, "mp",
                ASG DIV, "dv",
                ASG OR, "or",
                ASG ER, "eo",
                ASG AND, "an",
                ASG LS, "sll",
                ASG RS, "srl",
                PLUS, "ad",
                MINUS, "su",
                MUL, "mp",
                DIV, "dv",
                OR, "or",
                ER, "eo",
                AND, "an",
		LS, "sll",
                RS, "srl",
               -1, ""
#else
		ASG PLUS, "add",
                ASG MINUS, "sub",
                ASG MUL, "mul",
                ASG DIV, "div",
                ASG OR, "or",
                ASG ER, "xor",
                ASG AND, "and",
                ASG LS, "lsl",
                ASG RS, "lsr",
                PLUS, "add",
                MINUS, "sub",
                MUL, "mul",
                DIV, "div",
                OR, "or",
                ER, "xor",
                AND, "and",
                LS, "lsl",
                RS, "lsr",
               -1, ""
#endif
};

hopcode(f, o)
{
 /* output the appropriate string from the above table */

    register struct hoptab *q;

    for (q = ioptab; q -> opmask >= 0; ++q) {
	if (q -> opmask == o) {
	    printf("%s", q -> opstring);
/* tbl */
	    switch (f) {

		case 'L': 
		case 'W': 
		case 'H': 
		case 'B': 
		case 'D': 
		case 'F': 
		    printf("%c", tolower(f));
		    break;

	    }
/* tbl */
	    return;
	}
    }
    cerror("no hoptab for %s", opst[o]);
}

#ifdef MPX
int	    szrnames = 12;	/* Nbr entries in rnames[] */
#else
int	    szrnames = 19;	/* Nbr entries in rnames[] */
#endif /* MPX */
char       *rnames[] =
{				/* keyed to register number tokens */

    "r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7",
#ifndef MPX
    "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7",
#endif /* MPX */
#ifdef MPX
    "FP","AP","TP","CP",
#else
    "LA", "LOC", "NEWARG",
#endif

};

/*
 * DJK fix register classes
 */
int         rstatus[] =
{
#ifndef MPX
    SAREG | STAREG, SAREG | STAREG, SAREG | STAREG, SAREG | STAREG,
    SAREG, SAREG, SAREG, SAREG,

    SBREG, SBREG, SBREG, SBREG,			/* b0..b7 */
    SBREG, SBREG, SBREG, SBREG,

    SBREG, SBREG, SBREG			/* arg, frame, call psuedos */
#else
    SAREG | STAREG,
    SAREG | STAREG,
    SAREG | STAREG,
    SAREG,
    SAREG ,
    SAREG ,
    SAREG ,
    SAREG ,

    SBREG,
    SBREG,
    SBREG,
    SBREG,

#endif /* MPX */

};

tlen(p) NODE   *p;
{
    switch (p -> in.type) {

	case CHAR: 
	case UCHAR: 
	    return(1);

	case SHORT: 
	case USHORT: 
	    return(2);

	case LONG: 
	case DOUBLE: 
	    return(8);

	default: 
	    return(4);
    }
}

mixtypes(p, q) NODE    *p, *q;
{
    register    tp, tq;

    tp = p -> in.type;
    tq = q -> in.type;

    return((tp == FLOAT || tp == DOUBLE) !=
	    (tq == FLOAT || tq == DOUBLE));
}

prtype(n) NODE *n;
{
    switch (n -> in.type) {

#ifdef UAS
#else
	case DOUBLE: 
	    printf("d");
	    return;

	case FLOAT: 
	    printf("f");
	    return;
#endif

	case LONG: 
	case ULONG: 
#ifdef UAS
	case DOUBLE:
	    printf("d");
#else
	    printf("l");
#endif
	    return;

#ifdef UAS
	case FLOAT:
#endif
	case INT: 
	case UNSIGNED: 
#ifdef FORT
reg_is_int:
#endif /* FORT */
	    printf("w");
	    return;

	case SHORT: 
	case USHORT: 
#ifdef FORT
	    if (n->in.op == REG)
		goto reg_is_int;
#endif /* FORT */
	    printf("h");
	    return;

	case CHAR: 
	case UCHAR: 
#ifdef FORT
	    if (n->in.op == REG)
		goto reg_is_int;
#endif /* FORT */
	    printf("b");
	    return;

	default: 
#ifdef FORT
	    if (n -> in.op == ICON) {
		printf("w");
		return;
	    }
	    if (!ISPTR(n -> in.type) && !ISARY(n -> in.type))
#else /* NOT FORT */
#ifdef MPX
	    if (!ISPTR(n -> in.type) && !ISARY(n -> in.type))
#else
	    if (!ISPTR(n -> in.type))
#endif
#endif /* FORT */
{
#ifndef BUG1
		    fwalk(n, eprint, 0);
#endif
		cerror("Xzzzcode- bad type");
}
	    else {
		printf("w");
		return;
	    }
    }
}

extern int Aptr, Addr_Chg, Actr;
int plusused = 0;
struct optab psuedocook[] = {
	STASG, FOREFF|INAREG,
	SANY, TANY,
	SANY, TANY,
	2*NAREG, RNULL,
	    "-- psuedo cookie"
};

zzzcode(p, c) register NODE    *p;
{
    register    m;
    CONSZ       val;

    switch (c) {

	case '-':
	    plusused--;
	    break;

	case '+':	/* Generate + if lval >0, else nothing, */
			/* to pacify assembler.  I.E. - use     */
			/* 1ZL+AL in place of 1+AL, etc.	*/
			/* Also, generate + for OREG when that  */
			/* OREG does not represent an actual    */
			/* register. Fix for fang_406		*/
			/* Also, generate + for NAME because    */
			/* [13]_symbol will not be a valid      */
			/* operand. Fix for SPR 88000127	*/
	    if((p->in.op == OREG && isfakereg(p->tn.rval))
		|| p->in.op == NAME || p->tn.lval != 0) {
		plusused++;
		printf("+");
	    }

	    break;


	case 'r':	/* register moves, mainly for getting "fake" */
			/* register values into temp reg for STASG   */
	  {
	    NODE *p2 = getlr(p, 'R');

#ifndef BUG3
	    if(rdebug) {
		printf("zzzcode():   Zr\n");
	    }
#endif
	    if(isfakereg(p2->tn.rval)) {
		p2->in.op = OREG;	/* for adrput() */
#ifdef MPX
		expand(p2, FOREFF, "\tla	A1,AR");
#else
		expand(p2, FOREFF, "movea	AR,A1");
#endif /* MPX */
		p2->in.op = REG;		/* restore original value */
	    } else {
#ifdef MPX
		expand(p2, FOREFF, "\ttrr	AR,A1");
#else
		expand(p2, FOREFF, "movw	AR,A1");
#endif /* MPX */
	    }
	    break;
	  }

	case 'C': 
	    adrcon(argwordcount);
	    return;

#ifndef DEC07
	case 'D': 		/* generate double precision 0 */
	    {
	    NODE	tempnode;

	    tempnode.in.op = INT;
	    tempnode.in.type = LONG;
	    tempnode.in.name = "";
	    tempnode.tn.rval = 0;
	    tempnode.tn.lval = 0;	/* value of zero */
	    adrput(&tempnode);
	    return;
	    }
#endif

#ifdef MPX
	case 'm':
	    return;
#endif

	case 'M': 
	    adrcon(-p -> tn.lval);
	    return;

	case '~': 
	    adrcon(~p -> tn.lval);
	    return;

	case 'G': 
	    bittestused = 2;		/* when used to see sign bit */
#ifndef MPXTEMP	/* FEB15 */
	    cbgen(p -> in.op, p -> bn.label, c);
#endif
	    return;

	case 'B': 
	    bittestused = 1;		/* when used to see one bit */
#ifdef MPXTEMP
	    cbgen(p -> in.op, p -> bn.label, c);
#endif
	    break;

	case 'N': 			/* logical ops, turned into 0-1 */
    /* use register given by register 1 */
#ifndef FEB11	/* FEB15 */
	    bittestused = 0;		/* when used to see sign bit */
#endif
	    cbgen(0, m = getlab(), 'I');
	    deflab(p -> bn.label);
#ifdef UAS
	    printf("	zr	%s\n", rnames[resc[0].tn.rval]);
#else
	    printf("	movw	#0,%s\n", rnames[resc[0].tn.rval]);
#endif
	    deflab(m);
	    return;

	case 'J': 
#ifndef FEB11
	    bittestused = 0;		/* when used to see sign bit */
#endif
	    cbgen(p -> in.op, p -> bn.label, c);
	    return;


    /* 
     * emit code to do a field assignment of
     *  f = constant;
     */
	case 'F': {
		val = p -> in.right -> tn.lval;
		if (fldsz == 2) {
#ifdef UAS
		    expand(p, FOREFF, val & 2 ? "	sbm" : "	zbm");
#ifdef DEC03
		    printf ("	%d,", 30-fldshf);
#else
		    switch (p->in.type) {
			case SHORT: 
			case USHORT: 
			    if (p->in.left->in.op == REG)
				break;
			    fldshf += 16;
			    break;
			case CHAR: 
			case UCHAR: 
			    if (p->in.left->in.op == REG)
				break;
			    fldshf += 24;
			    break;
			default: 
			    break;
		    }
		    printf ("	%d,", 30-fldshf);
#endif
#else
		    m = 2 << (unsigned)fldshf;
		    expand(p, FOREFF, val & 2 ? "	bsetZP" : "	bclrZP");
		    printf("	#0x%x,", m);
#endif
		    adrput(p -> in.left);
		    PUTCHAR('\n');
		    fldsz = 1;
		}
		if (fldsz == 1) {
#ifdef UAS
		    expand(p, FOREFF, val & 1 ? "	sbm" : "	zbm");
#ifdef DEC03
		    printf ("	%d,", 31-fldshf);
#else
#ifdef JUNK
printf ("doing Zn type = %d\n", p->in.type);
printf ("doing Zn fldshf = %d, shift cnt = %d\n", fldshf, 31-fldshf);
#endif
		    switch (p->in.type) {
			case SHORT: 
			case USHORT: 
#ifdef JUNK
if (p->in.left->in.op == REG )printf("short left REG op found\n");
else printf("short left REG op not found\n");
#endif
			    if (p->in.left->in.op == REG)
				break;
			    fldshf += 16;
			    break;
			case CHAR: 
			case UCHAR: 
#ifdef JUNK
if (p->in.left->in.op == REG )printf("short left REG op found\n");
else printf("char left REG op not found\n");
#endif
			    if (p->in.left->in.op == REG)
				break;
			    fldshf += 24;
			    break;
			default: 
			    break;
		    }
		    printf ("	%d,", 31-fldshf);
#endif
#else
		    m = 1 << (unsigned)fldshf;
		    expand(p, FOREFF, val & 1 ? "	bsetZP" : "	bclrZP");
		    printf("	#0x%x,", m);
#endif
		    adrput(p -> in.left);
		    PUTCHAR('\n');
		    return;
		}
		if (fldsz == 32) {
#ifdef UAS
		    expand(p, FOREFF, "\tlw\tA1,AR\n\tstw\tA1,AL\n");
#else
		    expand(p, FOREFF, "	movw	AR,A1,AL\n");
#endif
		    return;
		}
		val &= ((unsigned)1 << (unsigned)fldsz) - 1;
		m = val != (((unsigned)1 << (unsigned)fldsz) - 1);
#ifdef DEC08
		val <<= (unsigned)fldshf;
#else
		val = (unsigned)val << (unsigned)fldshf;
#endif
		p -> in.right -> tn.lval = val;
#ifdef UAS
		expand(p, FOREFF, "	lZP	A1,AL\n");
		if (m) {
		    expand(p, FOREFF, "	anmw	A1,N\n");
		}
		if (val) {
		    expand(p, FOREFF, "	ormw	A1,AR\n");
		}
		expand(p, FOREFF, "	stZP	A1,AL\n");
#else
		expand(p, FOREFF, "	movZP	AL,A1\n");
		if (m) {
		    expand(p, FOREFF, "	andZP	N,A1\n");
		}
		if (val) {
		    expand(p, FOREFF, "	orw	AR,A1\n");
		}
		expand(p, FOREFF, "	movZP	A1,AL\n");
#endif
		val = (unsigned)val >> (unsigned)fldshf;
		p -> in.right -> tn.lval = val;

	    }
	    return;

	case 'P': 
	    prtype(p);
	    return;

	case 'S': 		/* structure assignment */
	    {
		register NODE  *l, *r;
		register    size;
		int	    i;
		int         inc = p -> in.stalign;
		int         oldtype = p -> in.type;
		char	    movedreg = 0;
#ifdef MPX
		int	    sr=0;
		int	    dr=0;
#endif
		char	    *a1, *a2, *ar, *al, *alhs;
		int	    looplab;
		int	    scratchreg;
		char	    ilchar;
		NODE	    tempnode, tempnodelt, tempnodert;
		NODE        saver0node;
		int	    left_is_name;	/* boolean */

#ifndef BUG3
		if(rdebug) {
			printf("zzzcode():  ZS, resources:\n");
			for(i=0; i<4; ++i) {
			    if(resc[i].in.op == REG
			      || resc[i].in.op == OREG) {
				printf("resc[%d]:  ", i);
			    	fwalk(&resc[i], eprint, 0);
			    }
			}
		}
#endif

		if (p -> in.op == STASG) {
		    l = p -> in.left;
		    r = p -> in.right;
#ifndef BUG3
		    if (rdebug) {
			printf("zzzcode():  ZS, leftreg = %x, rightreg = %x\n",
				l->tn.rval, r->tn.rval);
			if (l->in.op == REG)printf("left op is REG\n");
			if (r->in.op == REG)printf("right op is REG\n");
		    }
#endif
		}
		else {
		    if (p -> in.op != STARG) {
			cerror("STASG bad");
		    }
		    r = p -> in.left;
		    l = &resc[1];
		}

		switch (inc) {

		    case 1: 
			p -> in.type = CHAR;
			ilchar = 'b';
			break;

		    case 2: 
			p -> in.type = SHORT;
			ilchar = 'h';
			break;

		    case 8: 
			inc = 4;
			/* fall thru to case 4 */

		    case 4: 
			p -> in.type = INT;
			ilchar = 'w';
			break;
		}
		if (r -> in.op == ICON)
		    r -> in.op = NAME;
		else
		    if (r -> in.op == REG) {
			r -> in.op = OREG;

			if (r -> tn.rval == 0) {

			/*  should be able to use R0 as pointer */
			    int	newreg;
#ifdef MPX	/* FEB17 */
#ifndef BUG3
		if (rdebug) {
		    printf ("rt found op %s\n", opst[r->in.op]);
		    printf ("lf found op %s\n", opst[l->in.op]);
		}
#endif
			/* need to transfer structure address that is in
		 	 * register 0 into an OREG to x1 or x2 so
		 	 * we can move the structure.
		 	 */
		    	    if (!busy[R1]) newreg = R1;
		    	    else if (!busy[R2]) newreg = R2;
		    	    else cerror ("Index reg not available for struct move"); 
#else
			    newreg = resc[0].tn.rval;
#endif
			    r -> tn.rval = newreg;
#ifdef MPX
			    printf("	trr	r0,r%d\n", newreg);
#else
			    printf("	movw	r0,r%d\n", newreg);
#endif
			    ++busy[newreg];
			    --busy[R0];
			    movedreg = 1;
			}
		    }
		    else
			if (r -> in.op != OREG)
			    cerror("STASG-r");

		size = p -> stn.stsize;

		if(size > 128) {
		    /*
		     *	AL is left side 
		     *	AR is right side (register)
		     *	A1 is temp register, points to lhs during loop
		     		OR
		     *	A2 is temp register, points to lhs during loop
		     *
		     *	ar, al, a1 are hand-coded versions of AR, AL, A1,
		     *	to be used when not practical to call expand().
		     */
		    
		    if(allo(p, psuedocook)) {

		    if (busy[R0]) {
		        /* allocate temp space on stack */
		        saver0node.in.op = OREG;
		        saver0node.in.type = INT;
		        saver0node.in.name = "";
		        saver0node.tn.rval = TMPREG;
		        saver0node.tn.lval = BITOOR(freetemp(1)); /* 1 word */
#ifdef MPX
			printf("\tstw	r%d,",R0);
#else
			printf("\tmovw	r%d,",R0);
#endif /* MPX */
		        adrput(&saver0node);	
		    }

		    a1 = rnames[resc[0].tn.rval];
		    a2 = rnames[resc[1].tn.rval];
		    ar = rnames[p->in.right->tn.rval];
		    al = rnames[p->in.left->tn.rval];  /* Just use reg nbr */
		    /* Save the register value if the right operand   *
		     * is a register variable (R7-R4), and restore    *
		     * upon completing the structure assignment.      *
		     * This problem affected the port of INGRES to NP */

		    if (p->in.left->tn.rval == R7 ||
		        p->in.left->tn.rval == R6 ||
		        p->in.left->tn.rval == R5 ||
		        p->in.left->tn.rval == R4) {
		        /* allocate temp space on stack */
		        tempnodelt.in.op = OREG;
		        tempnodelt.in.type = INT;
		        tempnodelt.in.name = "";
		        tempnodelt.tn.rval = TMPREG;
		        tempnodelt.tn.lval = BITOOR(freetemp(1)); /* 1 word */
#ifdef MPX
			printf("\tstw	%s,",al);
#else
			printf("\tmovw	%s,",al);
#endif /* MPX */
		        adrput(&tempnodelt);	
		    }

		    if (p->in.right->tn.rval == R7 ||
		        p->in.right->tn.rval == R6 ||
		        p->in.right->tn.rval == R5 ||
		        p->in.right->tn.rval == R4) {
		        /* allocate temp space on stack */
		        tempnodert.in.op = OREG;
		        tempnodert.in.type = INT;
		        tempnodert.in.name = "";
		        tempnodert.tn.rval = TMPREG;
		        tempnodert.tn.lval = BITOOR(freetemp(1)); /* 1 word */
#ifdef MPX
			printf("\n\tstw\t%s,",ar);
#else
			printf("\n\tmovw	%s,",ar);
#endif /* MPX */
		        adrput(&tempnodert);	
		    }

		    scratchreg = resc[0].tn.rval;

		    /* allocate temp space on stack */
		    tempnode.in.op = OREG;
		    tempnode.in.type = INT;
		    tempnode.in.name = "";
		    tempnode.tn.rval = TMPREG;
		    tempnode.tn.lval = BITOOR(freetemp(1));	/* 1 word */

		    left_is_name = (p->in.left->in.op == NAME);

		    if(scratchreg == R0) {
			alhs = a2;	/* use second reg to index lhs */
			if(isfakereg(p->in.left->tn.rval) || 
			   left_is_name || p->in.left->in.op == OREG) {
#ifdef MPX
		    	   printf("\n\tla	%s,", a2);
			} else {
		    	   printf("\n\tlw	%s,", a2);
			}
			adrput(p->in.left);
#else
		    	   printf("\n\tmovea	");
			} else {
		    	   printf("\n\tmovw	");
			}
			adrput(p->in.left); printf(",%s", a2);
#endif /* MPX */
		    } else
			alhs = a1;	/* use scratch reg to index lhs */
		    
		    if(isfakereg(p->in.left->tn.rval) || 
			left_is_name || p->in.left->in.op == OREG) {
#ifdef MPX
		    	   printf("\n\tla	%s,",a1);
			} else {
		    	   printf("\n\tlw	%s,",a1);
			}
		    adrput(p->in.left); printf("\n", a1);
#else
			printf("\n\tmovea	");
		    } else {
			printf("\n\tmovw	");
		    }
		    adrput(p->in.left); printf(",%s\n", a1);
#endif /* MPX */
#ifdef MPX
		    printf("\tstw	%s,", a1); adrput(&tempnode);  
		    
		    printf("\n	lw	%s,=%d\n", a1, size - inc);

		    printf("\tadr\t%s,%s\n",a1,alhs);
		    printf("\tadr\t%s,%s\n",a1,ar);

		    looplab = getlab();
		    printf("L%d\tequ\t$\n", looplab);
		    printf("\tl%c	r0,0%c,%s\n", ilchar, ilchar, ar);
		    printf("\tst%c	r0,0%c,%s\n", ilchar, ilchar, alhs);
		    printf("\tsumw	%s,#%d\n", alhs, inc);
		    printf("\tsumw	%s,#%d\n", ar, inc);
#else
		    printf("\tmovw	%s,", a1); adrput(&tempnode);  
		    
		    printf("\n\tmovw	#%d,%s\n", size - inc, a1);

		    printf("\taddw\t%s,%s\n",a1,alhs);
		    printf("\taddw\t%s,%s\n",a1,ar);

		    looplab = getlab();
		    printf("L%d:\n", looplab);
		    printf("\tmov%c	[%s],r0,[%s]\n", ilchar, ar, alhs);
		    printf("\tsubw	#%d,%s\n", inc, alhs);
		    printf("\tsubw	#%d,%s\n", inc, ar);
#endif /* MPX */
		    if(scratchreg == R0
			|| isfakereg(p->in.left->tn.rval) || left_is_name ) {
#ifdef MPX
			printf("\tlw	r%s,",al);
		        adrput(&tempnodert);	
			printf("\n");
		    } else {
			printf("\tcar	%s,%s\n", al, alhs);
		    }
		    printf("\tblt	L%d\n", looplab);
#else
			printf("\tcmpw	");
			adrput(&tempnode);
			printf(",%s\n", alhs);
		    } else {
			printf("\tcmpw	%s,%s\n", al, alhs);
		    }
		    printf("\tjge	L%d\n", looplab);
#endif /* MPX */

		    if (p->in.left->tn.rval == R7 ||
		        p->in.left->tn.rval == R6 ||
		        p->in.left->tn.rval == R5 ||
		        p->in.left->tn.rval == R4) {
#ifdef MPX
			printf("\tlw	r%s,",al);
		        adrput(&tempnodert);	
			printf("\n");
#else
			printf("\tmovw	");
		        adrput(&tempnodelt);	
			printf(",%s\n",al);
#endif /* MPX */
		    }

		    if (p->in.right->tn.rval == R7 ||
		        p->in.right->tn.rval == R6 ||
		        p->in.right->tn.rval == R5 ||
		        p->in.right->tn.rval == R4) {
#ifdef MPX
			printf("\tlw	r%s,",ar);
		        adrput(&tempnodert);	
			printf("\n");
#else
			printf("\tmovw	");
		        adrput(&tempnodert);	
			printf(",%s\n",ar);
#endif
		    }

		    if (busy[R0]) {
#ifdef MPX
			printf("\tstw	r%d,",R0);	/* FEB17 was lw */
		        adrput(&saver0node);	
			printf("\n");
#else
			printf("\tmovw	");
		        adrput(&saver0node);	
			printf(",r%d\n",R0);
#endif
		    }

		    goto zzzScont;

		    }
		}	/* end of code for large structures */


		l -> tn.lval += size;
		r -> tn.lval += size;
		while (size % inc) {
		    size -= 1;
		    l -> tn.lval -= 1;
		    r -> tn.lval -= 1;
#ifdef UAS
		    expand(r, FOREFF, "\tlb\tr0,AR\n\tstb\tr0,");
#else
		    expand(r, FOREFF, "	movb	AR,r0,");
#endif
		    expand(l, FOREFF, "AL\n");
		}

#ifdef MPX
		/* need to transfer structure address that is in
		 * a reg variable made into an OREG to x1 or x2 so
		 * we can move the structure.  I can't seem to make
		 * local or trees not optimize away the UNARY MUL
	         * required to transfer the reg variable to an SAREG. 
		 */

#ifndef BUG3
		if (rdebug) {
		    printf ("rt found op %s\n", opst[r->in.op]);
		    printf ("lf found op %s\n", opst[l->in.op]);
		}
#endif
		if (r->in.op==OREG && (r->tn.rval >= R4 && r->tn.rval <= R7)) {
		    sr = r->tn.rval;
		    if (!busy[R1]) dr = R1;
		    else if (!busy[R2]) dr = R2;
		    else cerror ("Index reg not available for struct move"); 
		    expand(r, FOREFF|INAREG, "\ttrr\t");
		    printf("r%d,r%d\n", sr, dr); 
		    r->tn.rval = dr;
		}
#endif

		for (; size > 0; size -= inc) {
		    l -> tn.lval -= inc;
		    r -> tn.lval -= inc;
#ifdef UAS
		    expand(p, FOREFF, "	lZP	r0,");
		    expand(r, FOREFF, "AR\n");
		    expand(p, FOREFF, "	stZP	r0,");
#else
		    expand(p, FOREFF, "	movZP");
		    expand(r, FOREFF, "	AR,r0,");
#endif
		    expand(l, FOREFF, "AL\n");
		}
#ifdef MPX
		if(sr)
		    r->tn.rval = sr;
#endif

  zzzScont:

		if (r -> in.op == NAME)
		    r -> in.op = ICON;

		/* deleted else clause that changes result reg */
		if(r -> in.op == OREG) {
			r->in.op = REG;
		    }
		p -> in.type = oldtype;
	    }
	    break;
#ifdef MPX
	case 'n':			/* bit number of single-bit const */
#ifndef MPX_FEB20_OCT02
	    switch (p->in.type) {
		case SHORT: 
		case USHORT: 
#ifdef JUNK
if (p->in.op == INCR)printf("short INCR op found\n");
else printf("short INCR op not found\n");
if (p->in.left->in.op == REG )printf("short left REG op found\n");
else printf("short left REG op not found\n");
if (p->in.op == OR)printf("short INCR op found\n");
else printf("short OR op not found\n");
printf ("doing Zn short\n");
#endif
		    if (p->in.left->in.op == REG)
			break;
		    fldsz += 16;
		    break;
		case CHAR: 
		case UCHAR: 
#ifdef JUNK
if (p->in.op == INCR)printf("char INCR op found\n");
else printf("char INCR op not found\n");
if (p->in.left->in.op == REG )printf("char left REG op found\n");
else printf("char left REG op not found\n");
if (p->in.op == OR)printf("char INCR op found\n");
else printf("char OR op not found\n");
printf ("doing Zn char\n");
#endif
		    if (p->in.left->in.op == REG)
			break;
		    fldsz += 24;
		    break;
		default: 
		    break;
	    }
#endif
	    printf ("%d", 31-fldsz);
	    break;
#endif

	case 'w': /* Special Word Addressability */
	    if (Addr_Chg && (Aptr != 0))
	    {
	       Aptr = 0;
	       Actr++;
#ifndef BUG3
	       if (edebug)
	          fwalk(p, eprint, 0);
#endif
	       expand(p, INAREG|FOREFF, "\tmovb	AR,A1\n\tlslw	#8,A1\n\
\torb	1ZR+AR,A1\nZR-\tlslw	#8,A1\n\torb	2ZR+AR,A1\nZR-\
\tlslw	#8,A1\n\torb	3ZR+AR,A1\nZR-\tmovb	A1,3ZL+AL\nZL-\
\tlsrw	#8,A1\n\tmovb	A1,2ZL+AL\nZL-\tlsrw	#8,A1\n\
\tmovb	A1,1ZL+AL\nZL-\tlsrw	#8,A1\n\tmovb	A1,AL\n");
	    }
	    else expand(p, INAREG|FOREFF,"	movw	AR,A1,AL\n");
	    break;


	case 's': /* Special Short Addressability */
	    if (Addr_Chg && (Aptr != 0))
	    {
	       Aptr = 0;
	       Actr++;
#ifndef BUG3
	       if (edebug)
	          fwalk(p, eprint, 0);
#endif
	    }
	    else expand(p, INAREG|FOREFF,"	movZRP	AR,A1\n	movZLP	A1,AL\n");
	    break;

	case 'p':
	    if (Addr_Chg)
	       if (ISPTR(p->in.type)) {

#ifndef BUG3
	          if (edebug)
	             fwalk(p, eprint, 0);
#endif

	          switch(DECREF(p->in.type)) {

		     case INT:
		     case SHORT: Aptr++;
				 break;

		     default:    break;
	          }
	       }
	    break;

	default: 
#ifdef MPX
	    printf ("bad zzzcode of %c\n",c);
#endif
	    cerror("illegal zzzcode");
    }
}

rmove(rt, rs, t)
{
#ifdef UAS
    if (t == DOUBLE || t == LONG)
	printf ("	trr	%s,%s\n", rnames[rs+1], rnames[rt+1]);
    printf("	trr	%s,%s\n", rnames[rs], rnames[rt]);
#else
    printf("	mov%c	%s,%s\n", (t == DOUBLE||LONG ? 'd' : 'w'),
	    rnames[rs], rnames[rt]);
#endif
}

struct      respref
            respref[] =
{
    INTAREG | INTBREG, STAREG | STBREG,
#ifndef MPXTEMP
    INAREG | INBREG, SAREG | SBREG,
#else
    INTAREG | INTBREG | FORCC | INTEMP| SOREG, SAREG | SBREG | SOREG | STARREG | STARNM | SNAME | SCON,
#endif
    INAREG | INBREG, SAREG | SBREG | SOREG | STARREG | STARNM | SNAME | SCON,
    INTEMP, INTEMP,
#ifndef MPX
    FORARG, FORARG,
    INTEMP, STAREG | SAREG | STBREG | SBREG | SOREG | STARREG | STARNM,
    INTAREG | FORCC, STAREG | SAREG,
    INTAREG | FORCC, SAREG | SBREG | SOREG | STARREG | STARNM | SNAME | SCON,
#endif /* MPX */
    0, 0
};

/* set up temporary registers */
setregs()
{
    fregs = 4;
}

/* size, in registers, needed to hold thing of type t */
#ifndef szty
szty(t)
{
    return((t == LONG || t == DOUBLE) ? 2 : 1);
}
#endif

#ifndef rewfld
rewfld(p) NODE *p;
{
    return(1);
}
#endif

#ifndef callreg
callreg(p) NODE    *p;
{
    return(R0);
}
#endif

/* #ifdef MPX /* R2REGS */
#ifdef R2REGS 
base(p) register NODE  *p;
{
    register int    o = p -> in.op;
    register int    retval;

#ifndef BUG3
    if(odebug) {
	printf("base(0x%x):\n", p);
	fwalk(p, eprint, 0);
    }
#endif

/*
 *    if ((o == ICON && p -> in.name[0] != '\0')) {
 *	retval = 100;				/* ie no base reg *-/
 *	goto out;
 *    }
 */
    if (o == REG && isbreg(p->tn.rval) && ! isfakereg(p->tn.rval)) {
	retval = p -> tn.rval;
	goto out;
    }
    if ((o == PLUS || o == MINUS) && p -> in.left -> in.op == REG 
	&& isbreg(p -> in.left -> tn.rval)
	&& ! isfakereg(p -> in.left -> tn.rval)
	&& (p->in.right->in.op == ICON) ) {
	retval = p -> in.left -> tn.rval;
	goto out;
    }
/*
 *	Comment out for now.  OREG shouldn't be allowed here,
 *	but U& OREG probably should.
 *
 *    if (o == OREG && !R2TEST(p -> tn.rval) 
 *	&& (p -> in.type == INT || p -> in.type == UNSIGNED 
 *	    || ISPTR(p -> in.type))) {
 *	retval = p -> tn.rval + 0x80 * 1;
 *	goto out;
 *    }
 */
    if (o == INCR && p -> in.left -> in.op == REG
	&& isbreg(p -> in.left -> tn.rval)
	&&  ! isfakereg(p -> in.left -> tn.rval)) {
	retval = p -> in.left -> tn.rval + 0x80 * 2;
	goto out;
    }
    if (o == ASG MINUS && p -> in.left -> in.op == REG
	&& isbreg(p -> in.left -> tn.rval)
	&& ! isfakereg(p -> in.left -> tn.rval)         ) {
	retval = p -> in.left -> tn.rval + 0x80 * 4;
	goto out;
    }
    if (o == UNARY MUL && p -> in.left -> in.op == INCR 
	&& p -> in.left -> in.left -> in.op == REG
	&& isbreg(p -> in.left -> in.left -> tn.rval)
	&& ! isfakereg(p -> in.left -> in.left -> tn.rval)
    	&& (p -> in.type == INT || p -> in.type == UNSIGNED 
	    || ISPTR(p -> in.type))) {
	retval = p -> in.left -> in.left -> tn.rval + 0x80 * (1 + 2);
	goto out;
    }
    retval = (-1);

  out:
#ifndef BUG3
    if(odebug) {
	printf("	returning 0x%x\n", retval);
    }
#endif
    return(retval);
}
#endif

#ifdef R2REGS 
offset(p, tyl) register NODE   *p;
int         tyl;
{
    register int retval;

#ifndef BUG3
    if(odebug) {
	printf("offset(p=0x%x, tyl=0x%x)\n", p, tyl);
	fwalk(p, eprint, 0);
    }
#endif
    if (tyl <= 4 && p -> in.op == REG
	    && p -> tn.rval != R0
	    && ! isfakereg(p -> tn.rval)
	    && (p -> in.type == INT || p -> in.type == UNSIGNED
		|| ISPTR(p->in.type)) ) {
	retval = p -> tn.rval;
	goto out;
    }
    if ((p -> in.op == LS
	&& p -> in.left -> in.op == REG
	&& p -> tn.rval != R0
	&& ! isfakereg(p -> tn.rval)
	&& (p -> in.left -> in.type == INT 
		|| p -> in.left -> in.type == UNSIGNED)
		&& (p -> in.right -> in.op == ICON 
		&& p -> in.right -> in.name[0] == '\0')
		&& ((unsigned)1 << (unsigned)p->in.right->tn.lval) == tyl)) {
	retval = p -> in.left -> tn.rval;
	goto out;
    }
    retval = (-1);

  out:
#ifndef BUG3
    if(odebug) {
	printf("	returning 0x%x\n", retval);
    }
#endif
    return(retval);
}
#endif

#ifdef R2REGS 
makeor2(p, q, b, o) register NODE  *p, *q;
register int    b, o;
{
    register NODE  *t;
    register int    i;
    NODE       *f;

#ifndef BUG3
    if(odebug) {
	printf("makeor2(p=0x%x, q=0x%x, b=%d, o=%d)\n", p, q, b, o);
    }
#endif

    p -> in.op = OREG;
    f = p -> in.left;		/* have to free this subtree later */

 /* init base */
    switch (q -> in.op) {

	case ICON: 
	case REG: 
	case OREG: 
	    t = q;
	    break;

	case MINUS: 
	    q -> in.right -> tn.lval = -q -> in.right -> tn.lval;

	case PLUS: 
	    t = q -> in.right;
	    break;

	case INCR: 
	case ASG MINUS: 
	    t = q -> in.left;
	    break;

	case UNARY MUL: 
	    t = q -> in.left -> in.left;
	    break;

	default: 
	    cerror("illegal makeor2");
    }

    p -> tn.lval = t -> tn.lval;
    p -> in.name = t -> in.name;

 /* init offset */
    p -> tn.rval = R2PACK((b & 0x7f), o, (b >> 7));

    tfree(f);
    return;
}
#endif

canaddr(p) NODE    *p;
{
    register int    o = p -> in.op;

    if (o == NAME || o == ICON
	    || o == OREG
#ifndef OCT19
	    || (o == SCONV && p->in.left->in.op == OREG)
#endif
	    || (o == UNARY MUL && shumul(p -> in.left)))
	return(1);
    if(o == REG && ! isfakereg(p->tn.rval))
	return(1);
    return(0);
}

shltype(o, p) register NODE    *p;
{
    return(o == REG || o == NAME || o == ICON
	    || o == OREG
	    || (o == UNARY MUL && shumul(p -> in.left)));
}

flshape(p) register NODE   *p;
{
    return(p -> in.op == REG
	    || p -> in.op == NAME
	    || p -> in.op == ICON
	    || (p -> in.op == OREG && (!R2TEST(p -> tn.rval) || tlen(p) == 1)));
}

shtemp(p) register NODE    *p;
{
    if (p -> in.op == STARG)
	p = p -> in.left;
    return(p -> in.op == NAME
	    || p -> in.op == ICON
	    || p -> in.op == OREG
	    || (p -> in.op == UNARY AND && p -> in.left -> in.op == OREG)
	    || (p -> in.op == UNARY MUL && shumul(p -> in.left)));
}

shumul(p) register NODE    *p;
{
    return(p -> in.op == REG && p -> tn.rval & 7);
}

adrcon(val) CONSZ   val;
{
#ifdef UAS
    printf("=x'%x'", val);
#else
    printf("#0x%x", val);
#endif
}

conput(p) register NODE    *p;
{
    switch (p -> in.op) {

	case ICON: 
#ifdef JUNK_SEP3
	    acon(p);
#else
	    ahcon(p);
#endif
	    return;

	case REG: 
	    printf("%s", rnames[p -> tn.rval]);
	    return;

	default: 
	    cerror("illegal conput");
    }
}

insput(p) register NODE    *p;
{
    cerror("insput");
}

upput(p) register NODE *p;
{
    int         temp;
    switch (p -> in.op) {

	case REG: 
	    temp = p -> tn.rval;
	    p -> tn.rval++;
	    adrput(p);
	    p -> tn.rval = temp;
	    break;

	default: 
	    temp = p -> tn.lval;
	    p -> tn.lval += (SZINT / SZCHAR);
	    adrput(p);
	    p -> tn.lval = temp;
    }
}

adrput(p) register NODE    *p;
{
    register int    r;
 /* output an address, with offsets, from p */

    if (p -> in.op == FLD) {
	p = p -> in.left;
    }
    switch (p -> in.op) {

	case NAME: 
	    acon(p);
	    return;

	case ICON: 
#ifdef FORT
	case FCON: 
#endif /* FORT */
    /* addressable value of the constant */
#ifndef MPXTEMP
#ifdef UAS
	    if (p->in.type == LONG || p->in.type == ULONG) {
		char nn[100];
		int ll;
	        if (p->in.name[0])
		  sprintf(nn, "d\t%s", p->in.name);
		else
		  sprintf(nn, "d\tx'00000000%08x'", p->tn.lval);
		ll = settmpstr(nn);
		/* print returned label number */
		printf("L%d",ll);
		return;
	    }
	    if (p->in.name[0] && !p->tn.lval) {
		char nn[100];
		int ll;
		sprintf(nn, "w\t%s", p->in.name);
		ll = settmpstr(nn);
		/* print returned label number */
		printf("L%d",ll);
		return;
	    }
	    PUTCHAR('=');
#else
	    PUTCHAR('#');
#endif
#endif
	    ahcon(p);
	    return;

	case REG: 
	    printf("%s", rnames[p -> tn.rval]);
	    return;

	case OREG: 
	    r = p -> tn.rval;
	    if (R2TEST(r)) {		/* double indexing */
		if (p -> tn.lval != 0 || p -> in.name[0] != '\0')
		    acon(p);
#ifdef UAS
		if (R2UPK1(r) > R7)
		    printf ("(%s),%s", rnames[R2UPK1(r)], rnames[R2UPK2(r)]);
		else
		    printf ("(%s),%s", rnames[R2UPK2(r)], rnames[R2UPK1(r)]);
#else
		printf("[%s+%s]", rnames[R2UPK1(r)], rnames[R2UPK2(r)]);
#endif
		return;
	    }
	    if (r == AP) {			/* in the arg region */
#ifdef UAS
		if (p -> tn.lval) {
		    if (p -> tn.lval & 3) {
			printf("%d+LA%d,sp", p -> tn.lval, ftnno);
		    }
		    else {
			printf("%dw+LA%d,sp", p-> tn.lval/(SZINT/SZCHAR), ftnno);
		    }
		}
		else
		    printf("LA%d,sp", ftnno);
#else
		if (p -> tn.lval) {
		    if (p -> tn.lval & 3) {
			printf("%d+LA%d[b2]", p -> tn.lval, ftnno);
		    }
		    else {
			printf("%dw+LA%d[b2]", p -> tn.lval / (SZINT / SZCHAR), ftnno);
		    }
		}
		else
		    printf("LA%d[b2]", ftnno);
#endif
		return;
	    }
	    if (r == FP) {
#ifdef UAS
	    if (p -> tn.lval & 3) {
		printf("%d+LOC%d,sp", p->tn.lval+(FRAMESZ/SZCHAR), ftnno);
	    }
	    else {
		printf("%dw+LOC%d,sp", (p->tn.lval+(FRAMESZ/SZCHAR))/(SZINT/SZCHAR), ftnno);
		    }
#else
		if (p -> tn.lval) {
		    if (p -> tn.lval & 3) {
			printf("%d+LOC%d[b2]", p -> tn.lval, ftnno);
		    }
		    else {
			printf("%dw+LOC%d[b2]", p -> tn.lval / (SZINT / SZCHAR), ftnno);
		    }
		}
		else
		    printf("LOC%d[b2]", ftnno);
#endif
		return;
	    }
	    if (r == CP) {
#ifdef UAS
		if (p -> tn.lval & 3) {
		    printf("%d+CALL%d,sp", p -> tn.lval + ARGINIT / SZCHAR, ftnno);
		}
		else {
		    printf("%dw+CALL%d,sp", (p -> tn.lval / (SZINT / SZCHAR)) + ARGINIT / SZINT, ftnno);
		}
#else
		if (p -> tn.lval & 3) {
		    printf("%d[b2]", p -> tn.lval + ARGINIT / SZCHAR);
		}
		else {
		    printf("%dw[b2]", (p -> tn.lval / (SZINT / SZCHAR)) + ARGINIT / SZINT);
		}
#endif
		return;
	    }
	    if (p -> tn.lval != 0 || p -> in.name[0] != '\0')
		acon(p);
#ifdef UAS
	    else
		printf ("0");
	    printf(",%s", rnames[p -> tn.rval]);
#else
	    printf("[%s]", rnames[p -> tn.rval]);
#endif
	    return;

	default: 
	    cerror("illegal address");
	    return;

    }

}

ahcon(p) register NODE *p;
{				/* print out a constant */
    register    v = p -> tn.lval;

#ifdef FORT
    if (p -> in.type == DOUBLE && v != 0) {	/* double zero ok */
#else /* NOT FORT */
#ifdef DEC07
    if (p -> in.type == (DOUBLE||LONG) && v != 0) {	/* double zero ok */
#else
    if ((p->in.type == DOUBLE || p->in.type == LONG) && v != 0) {
    /* double zero ok */
#endif
    /* if (p -> in.type == DOUBLE) { */
    /* Introducing special case for  */
    /* Double Precision constants = 0*/
#endif /* FORT */
	cerror("double precision constant attempted");
    }
    if (p -> in.name[0] == '\0') {
	if (v >= 0 && v < 10) {
	    printf("%d", v);
	    return;
	}
	if (v < 0) {
#ifdef UAS
#ifdef JUNK_SEP4
	    if ((v & 0xff000000) == 0xff000000) {
		printf("x'-%x'", -v);
	    }
	    else {
		printf("x'%x'", v);
	    }
#else /* JUNK_SEP4 */
	    printf("x'%x'", v);
#endif /* JUNK_SEP4 */
#else
	    if ((v & 0xff000000) == 0xff000000) {
#ifdef FORT
		printf("-0x%x", -v);
#else /* NOT FORT */
		printf("~0x%x", ~v);
#endif /* FORT */
	    }
	    else {
		printf("0x%x", v);
	    }
#endif
	}
	else {
#ifdef UAS
	    printf("x'%x'", v);
#else
	    printf("0x%x", v);
#endif
	}
    }
    else
	if (v == 0) {
	    printf("%s", p -> in.name);
	}
	else {
	    printf("%s+%d", p -> in.name, v);
	}
}
acon(p) register NODE  *p;
{						/* print out a constant */
    char *prefix = "";

    if(p->in.op == OREG && plusused == 0)
#ifdef MPX
	prefix = "";
#else
	prefix = "`";
#endif
    if (p -> in.name[0] == '\0') {
#ifdef MPX
	    int val = p->tn.lval;
	    char *wd = "";

	    if ((val & 3) == 0) {
		val /= (SZINT / SZCHAR);
		wd = "w";
	    }
		printf ("%s%d%s", prefix, val, wd);
#else
	printf("%s%d", prefix, p -> tn.lval);
#endif
    }
    else {
	if (p -> tn.lval == 0) {
	    printf("%s%s", prefix, p -> in.name);
	}
	else {
	    int val = p->tn.lval;
	    char *wd = "";

	    if ((val & 3) == 0) {
		val /= (SZINT / SZCHAR);
		wd = "w";
	    }
	    if(val < 0)
		printf ("%s%s-%d%s", prefix, p->in.name, - val, wd);
	    else
		printf ("%s%s+%d%s", prefix, p->in.name, val, wd);
	}
    }
}


initcon(p) register NODE  *p;
{						/* print out a constant */
    char *prefix;

    if (p -> in.name[0] == '\0') {
	printf("%d", p -> tn.lval);
    }
    else {
	prefix = "";
	if (p -> tn.lval == 0) {
	    printf("%s%s", prefix, p -> in.name);
	}
	else {
#ifdef FORT
	    if(p->tn.lval < 0)
 		printf ("%s%s-%d", prefix, p->in.name, - p->tn.lval);
	    else
 		printf ("%s%s+%d", prefix, p->in.name, p->tn.lval);
#else
	    if ((p -> tn.lval & 3) == 0)
		printf("%s+%dw", p -> in.name, p -> tn.lval / (SZINT / SZCHAR));
	    else
		printf("%s+%d", p -> in.name, p -> tn.lval);
#endif
	}
    }
}


genscall(p, cookie) register NODE  *p;
{
 /* structure valued call */
    return(gencall(p, cookie));
}

extern int regfix();

gencall(p, cookie) register NODE   *p;
{
 /* generate the call given by p */
    register NODE  *p1, *ptemp;
    register    temp, temp1;
    register    m;
    int         saveawc = argwordcount;
    NODE	*argnode = NIL;
    NODE       *genargs();
    NODE	*svp = NIL;		/* node with structure dest addr */
    int		ty;

#ifndef BUG3
    if (odebug) {
	printf("gencall( %x, ", p);
	print("cookie", cookie);
	printf(" )\n");
	fwalk(p, eprint, 0);
	if(p->in.right) {
		printf("args:");
		fwalk(p->in.right, eprint, 0);
	}
    }
#endif

    if (p -> in.right)
	temp = argsize(p -> in.right);
    else
	temp = 0;
    argwordcount = temp / (SZINT / SZCHAR);


    if (p -> in.op == STCALL || p -> in.op == UNARY STCALL) {
 /* set aside room for structure return */

	if (p -> stn.stsize > temp)
	    temp1 = p -> stn.stsize;
	else
	    temp1 = temp;
    }

    if (temp > maxargs)
	maxargs = temp;

    SETOFF(temp1, (SZINT / SZCHAR));

    if (p -> in.right) { /* make temp node, put offset in, and generate args */
	ptemp = talloc();
	ptemp -> in.type = INT;
	ptemp -> in.op = OREG;
	ptemp -> tn.lval = 0;
	ptemp -> tn.rval = CP;
	ptemp -> in.name = "";
	ptemp -> in.rall = NOPREF;
	ptemp -> in.su = 0;

	genargs(p -> in.right, ptemp);
	ptemp -> in.op = FREE;
    }
    /* If any temp regs are busy, get them out of the way here. */

    if(busytregs())
	fwalk(stotree, regfix, 0);

    p1 = p -> in.left;
 /* 
  * undo damage done by making & name usually go for movea
  */
    if (p1 -> in.op == UNARY AND && p1 -> in.left -> in.op == NAME) {
	p -> in.left = p1 -> in.left;
	p1 -> in.op = FREE;
	p -> in.left -> in.op = ICON;
    }
    else {
	if (p1 -> in.op != ICON) {
#ifndef MPX
	    if (p1 -> in.op != REG) {
		p1 -> in.rall = R1;
		order(p1, INAREG);
	    }
#else
		p1 -> in.rall = R1;
		order(p1, INAREG);
#endif
	}
    }

    /* Fix for spr 86100263,  (*b())() problem */
    /* All busy temp regs have been stashed away by regfix() above. */

    if(p1->in.op == REG && p1->tn.rval == R0) {
	p1->tn.rall = R1;
	order(p1, INAREG); /* was INTAREG NOV1 */
    }

    /* End of 86100263 fix. */

    p -> in.op = UNARY CALL;

    	m = match(p, INTAREG | INTBREG);

#ifndef BUG3
    if (odebug) {
	printf("gencall( %x, ...) returning\n ", p);
	fwalk(p, eprint, 0);
    }
#endif

 /* 
  * nesting of calls is ok when the call is for the first parameter
  */
    argwordcount = saveawc;
    return(m != MDONE);
}

char       *ccbranches[] =
{
#ifdef UAS
    "	beq	L%d\n",
    "	bne	L%d\n",
    "	ble	L%d\n",
    "	blt	L%d\n",
    "	bge	L%d\n",
    "	bgt	L%d\n",
    "	bule	L%d\n",
    "	bult	L%d\n",
    "	buge	L%d\n",
    "	bugt	L%d\n",
#else
    "	jeq	L%d\n",
    "	jne	L%d\n",
    "	jle	L%d\n",
    "	jlt	L%d\n",
    "	jge	L%d\n",
    "	jgt	L%d\n",
    "	jule	L%d\n",
    "	jult	L%d\n",
    "	juge	L%d\n",
    "	jugt	L%d\n",
#endif
};

cbgen(o, lab, mode)
{		/*   printf conditional and unconditional branches */

    if (o == 0)
#ifdef UAS
	printf("	bu	L%d\n", lab);
#else
	printf("	jmp	L%d\n", lab);
#endif
    else {
	if (bittestused == 2) {

	    switch (o) {

		case GE: 
#ifdef UAS
		    printf("	bs	L%d\n", lab);
#else
		    printf("	jbf	L%d\n", lab);
#endif
		    break;

		case LT: 
#ifdef UAS
		    printf("	bns	L%d\n", lab);
#else
		    printf("	jbt	L%d\n", lab);
#endif
		    break;

#ifdef MPX
		case EQ: 
#ifdef UAS
		    printf("	bns	L%d\n", lab);
#else
		    printf("	jbf	L%d\n", lab);
#endif
		    break;

		case NE: 
#ifdef UAS
		    printf("	bs	L%d\n", lab);
#else
		    printf("	jbt	L%d\n", lab);
#endif
		    break;
#endif /* MPX */
		default: 
		printf ("bit test op2 bad, op=%s\n", opst[o]);
		    cerror("bit test incorrectly selected");
	    }
	    bittestused = 0;
	    return;
	}
	if (bittestused == 1) {
	    switch (o) {

		case EQ: 
#ifdef UAS
		    printf("	bns	L%d\n", lab);
#else
		    printf("	jbf	L%d\n", lab);
#endif
		    break;

#ifdef MPX
		case AND:
#endif
		case NE: 
#ifdef UAS
		    printf("	bs	L%d\n", lab);
#else
		    printf("	jbt	L%d\n", lab);
#endif
		    break;

		default: 
		printf ("bit test op1 bad, op = %s\n", opst[o]);
		    cerror("bit test incorrectly selected");
	    }
	    bittestused = 0;
	}
	else {

	    if (o >= ULE)
		cerror("bad conditional branch: %s", opst[o]);
#ifdef FEB11_NOV07
	    if (o <= UGT && o >= ULE) o -= (UGT-GT);
#endif
	    printf(ccbranches[o - EQ], lab);
	}
    }
}

nextcook(p, cookie) NODE   *p;
{
 /* we have failed to match p with cookie; try another */
    if (cookie == FORREW)
	return(0);			/* hopeless! */
    if (!(cookie & (INTAREG | INTBREG)))
	return(INTAREG | INTBREG);
    if (!(cookie & INTEMP) && asgop(p -> in.op))
	return(INTEMP | INAREG | INTAREG | INTBREG | INBREG);
    return(FORREW);
}

lastchance(p, cook) NODE   *p;
{
 /* forget it! */
#ifndef BUG4
    printf("-- lastchance %x (", p);
    print ("cookie", cook);
    printf (")\n");
    if (odebug) {
	fwalk(p, eprint, 0);
    }
#endif
    return(0);
}

optim2(p) register NODE    *p;
{
 /* do local tree transformations and optimizations */

    register NODE  *r;

#ifndef BUG3
    if (odebug) {
	printf("optim2(%x):\n", p);
	fwalk(p, eprint, 0);
    }
#endif

    switch (p -> in.op) {
	case LADDR:
	case PADDR:
		LAddrFix(p);
		break;

	case STADDR:
	case ADDR:
		p->in.op = ICON;
		break;

	case LNAME:
	case PNAME:
	case STATNAME:
		LNameFix(p);
		break;

#ifndef NOTDEF
	case EQ:
	case NE:
	    if ((p->in.left->in.type == CHAR 
			|| p->in.left->in.type == UCHAR)
		&& (p->in.right->in.type == CHAR 
			|| p->in.right->in.type == UCHAR)) {
		p->in.left->in.type = UCHAR;
		p->in.right->in.type = UCHAR;
	    }
	    break;
#endif
    }
}

#ifndef ONEPASS
main(argc, argv) char  *argv[];
{
    return(mainp2(argc, argv));
}
#endif

#ifdef HARDOPS  /* forget hardops for MPX */
struct      functbl
{
    int         fop;
    TWORD       ftype;
    char       *func;
}           opfunc[] =
{
    SCONV, TFLOAT, "cvtdf",	/* MUST BE FIRST ENTRY */
    DIV, TANY, "udiv",
    MOD, TANY, "urem",
    ASG DIV, TANY, "udiv",
    ASG MOD, TANY, "urem",
    0, 0, 0
};

hardops(p) register NODE   *p;
{
 /* change hard to do operators into function calls.  */
    register NODE  *q;
    register struct functbl    *f;
    register    o;
    register TWORD  t;

    o = p -> in.op;
    t = p -> in.type;
#ifdef FORT
 /* 
  * NOTE: only mulops need rewriting
  */
 /* 
  * fortran compiler believes that the machine actually
  * has a  double = single * double
  * type auto-converting floating point instruction set.
  * *sigh* we must SCONV it otherwise
  */
    if (t == FLOAT || t == DOUBLE) {
	if (o == ASSIGN || (dope[o] & (FLOFLG | LOGFLG))) {
	    if (asgop(o)) {
		t = p -> in.left -> in.type;
	    }
	    else {
		if (p -> in.left -> in.type != t) {
		    q = talloc();
		    q -> in.rall = NOPREF;
		    q -> in.op = SCONV;
		    q -> in.type = t;
		    q -> in.left = p -> in.left;
		    p -> in.left = q;
		    hardops(q);
		}
	    }
	    if (p -> in.right -> in.type != t) {
		q = talloc();
		q -> in.rall = NOPREF;
		q -> in.op = SCONV;
		q -> in.type = t;
		q -> in.left = p -> in.right;
		p -> in.right = q;
		hardops(q);
	    }
	    return;
	}
    }
#endif /* FORT */

    f = opfunc;
    if (o == SCONV && t == FLOAT && p -> in.left -> in.type == DOUBLE) {
	p -> in.right = p -> in.left;
	goto makeitcall;
    }
    if ((dope[o] & MULFLG) == 0) {
	return;
    }
    t = p -> in.type;
    if (asgop(o)) {
	if (t != UNSIGNED && p -> in.right -> in.type != UNSIGNED) {
	    return;
	}
    }
    else {
	if (p -> in.right -> in.type != UNSIGNED
		&& p -> in.left -> in.type != UNSIGNED) {
	    return;
	}
    }

    for (; f -> fop; f++) {
	if (o == f -> fop)
	    goto convert;
    }
    return;

 /* need to rewrite tree for ASG OP */
 /* must change ASG OP to a simple OP */
convert: 
    if (asgop(o)) {
	q = talloc();
	switch (p -> in.op) {

	    case ASG DIV: 
		q -> in.op = DIV;
		break;

	    case ASG MOD: 
		q -> in.op = MOD;
		break;
	}
	q -> in.rall = NOPREF;
	q -> in.type = p -> in.type;
	q -> in.left = tcopy(p -> in.left);
	q -> in.right = p -> in.right;
	p -> in.op = ASSIGN;
	p -> in.right = q;
	zappost(q -> in.left);	/* remove post-INCR(DECR) from new node */
	fixpre(q -> in.left);	/* change pre-INCR(DECR) to +/-	 */
	p = q;

    }

 /* build comma op for args to function */
    q = talloc();
    q -> in.op = CM;
    q -> in.rall = NOPREF;
    q -> in.type = INT;
    q -> in.left = p -> in.left;
    q -> in.right = p -> in.right;
    p -> in.right = q;

 /* put function name in left node of call */
makeitcall: 
    p -> in.op = CALL;
    p -> in.left = q = talloc();
    q -> in.op = ICON;
    q -> in.rall = NOPREF;
    q -> in.type = INCREF(FTN + p -> in.type);
    q -> in.name = f -> func;
    q -> tn.lval = 0;
    q -> tn.rval = 0;

    return;

}
#endif /* HARDOPS */

zappost(p) NODE    *p;
{
 /* look for ++ and -- operators and remove them */

    register    o, ty;
    NODE       *q;
    o = p -> in.op;
    ty = optype(o);

    switch (o) {

	case INCR: 
	case DECR: 
	    q = p -> in.left;
	    p -> in.right -> in.op = FREE;	/* zap constant */
	    ncopy(p, q);
	    q -> in.op = FREE;
	    return;

    }

    if (ty == BITYPE)
	zappost(p -> in.right);
    if (ty != LTYPE)
	zappost(p -> in.left);
}

fixpre(p) NODE *p;
{

    register    o, ty;
    o = p -> in.op;
    ty = optype(o);

    switch (o) {

	case ASG PLUS: 
	    p -> in.op = PLUS;
	    break;

	case ASG MINUS: 
	    p -> in.op = MINUS;
	    break;
    }

    if (ty == BITYPE)
	fixpre(p -> in.right);
    if (ty != LTYPE)
	fixpre(p -> in.left);
}

myreader(p) register NODE  *p;
{
#ifndef BUG3
    if (odebug) {
	printf("myreader(%x):\n", p);
	fwalk(p, eprint, 0);
    }
#endif

#ifdef HARDOPS	/* not defined for MPX */
    walkf(p, hardops);		/* convert ops to function calls */
#ifndef BUG3
    if(odebug) {
	printf("myreader(): after hardops()\n");
	fwalk(p, eprint, 0);
    }
#endif
#endif	/* HARDOPS */
    canon(p);			/* expands r-vals for fileds */
#ifndef BUG3
    if(odebug) {
	printf("myreader(): after canon()\n");
	fwalk(p, eprint, 0);
    }
#endif
    walkf(p, optim2);
}

special(p, shape) register NODE    *p;
{
    return(0);
}

busytregs()	/* check for busy temp regs before doing call */
{
	if( busy[R0] || busy[R1] || busy[R2] || busy[R3] )
		return(1);
	else
		return(0);
}

regfix(p)
NODE *p;
{
	int o;

	o = p->in.op;
	if( o != REG && o != OREG )
		return;

#ifndef BUG3
	if(odebug) {
		printf("regfix(%x): busy[%d] = %d\n", p, p->tn.rval,
			busy[p->tn.rval]);
	}
#endif

	switch(p->tn.rval) { /* Catch refs to temp registers. */
	case R0:
	case R1:
	case R2:
	case R3:
		order(p, INTEMP);  /* Stash it away in temp */
	}

#ifndef BUG3
	if(odebug) {
		printf("regfix() returns: busy[%d] = %d\n",  p->tn.rval,
			busy[p->tn.rval]);
	}
#endif
}

#define INRIGHT		0x1
#define INLEFT		0x2
#define INOUTER		0x4

#define iseven(r)	(((r) & 01) == 0)

lastditch(p, cookie)
NODE	*p;
int	cookie;
{
	register NODE	*pl, *pr;
	int		m, reg, rlower, rupper;
	int		rval0, rval1;

	int		rusage[REGSZ];	/* Values: or'ed together
					 *	INLEFT   - left side of p
					 *	INRIGHT  - right side of p
					 *	INOUTER  - Used outside of p
					 */

	int		rcount[REGSZ];	/*	Use count within tree p */
	int		wasbusy[REGSZ];	/*	Saved busy state */
	NODE		*n, svnode[2];	/*	Temps for save/restore */

#ifndef BUG3
	if(odebug) {
		printf("lastditch( %x, ", p);
		print("cookie", cookie);
		printf(")\n");
		fwalk(p, eprint, 0);
	}
#endif

	/* Check to see if tree obviously wont match. */
	pl = p->in.left;
	pr = GETR(p);

	/* Inventory register usage per tree and busy[] */

	for(reg=0; reg<REGSZ; reg++) {
		rusage[reg] = 0;
		rcount[reg] = 0;
	}

	switch(optype(p->in.op)) {

	case BITYPE:
	case LTYPE:
		if(pr->in.op == REG || pr->in.op == OREG) {
			reg = pr->tn.rval;
			rusage[reg] |= INRIGHT;
			rcount[reg] += 1;
			if(szty(pr->in.type) > 1) {
				rusage[reg+1] |= INRIGHT;
				rcount[reg+1] += 1;
			}
		}

		if(optype(p->in.op) == LTYPE)
			break;

		/* for BITYPE, fall thru to case UTYPE to do left side. */

	case UTYPE:
		if(pl->in.op == REG || pl->in.op == OREG) {
			reg = pl->tn.rval;
			rusage[reg] |= INLEFT;
			rcount[reg] += 1;
			if((szty(pl->in.type)) > 1) {
				rusage[reg+1] |= INLEFT;
				rcount[reg+1] += 1;
			}
		}
		break;
	default:
		goto sorry;
	}

	for(reg=0; reg<REGSZ; reg++) {
		if(rcount[reg] < busy[reg])
			rusage[reg] |= INOUTER;
	}

	/* Pick best even/odd pair.  For now just use R0, R1. */

	rlower = R0; rupper = R1;
	
	/* Save regs picked for use, as needed per rusage[] */

	reg = rlower;
	while(1) {
		if(rusage[reg] & INOUTER) {
			n = &svnode[reg];
			n->in.op = OREG;
			n->in.name = "";
			n->tn.rval = TMPREG;
			n->tn.lval = BITOOR(freetemp(1));  /* 1 word of temp space */

#ifdef MPX
			printf("	stw	%s,", rnames[reg]);
#else
			printf("	movw	%s,", rnames[reg]);
#endif /* MPX */
			adrput(n);
			printf("\n");

			wasbusy[reg] = busy[reg];
			busy[reg] = 0;
			/* Maybe need to account for possibility that
			   reg is in left or right as well as INOUTER ?? */
		} else {
			if((rusage[reg] & INRIGHT) ) {
				if( szty(pr->in.op) == 1 || iseven(reg) )
					order(pr, INTEMP);
			} else {
				if(rusage[reg] & INLEFT && !asgop(p->in.op)) {
					if(szty(pl->in.op) ==1 || iseven(reg) )
						order(pl, INTEMP);
				}
			}
		}

		if(reg == rupper)
			break;
		reg = rupper;
	}

#ifndef BUG3
	if(odebug) {
		prditch("rusage", rusage);
		prditch("rcount", rcount);
		prditch("wasbusy", wasbusy);
		prditch("busy", busy);
	}
#endif

	/* Attempt to match the tree p and cookie */

	m = match(p, cookie);
	if(m != MDONE)
		m = match(p, INTEMP);
	if( m != MDONE)
		goto sorry;

	/* Save result in temp if restoring registers will clobber it. */

	if( (rusage[rlower] & INOUTER) || (rusage[rupper] & INOUTER) ) {
		rval0 = -1;
		rval1 = -1;
		if(p->in.op == REG || p->in.op == OREG) {
			rval0 = p->tn.rval;
			if(szty(p->in.type) > 1)
				rval1 = rval0 + 1;
		}

		if(   rval0 == rlower || rval0 == rupper
		   || rval1 == rlower || rval1 == rupper
		) {
			match(p, INTEMP);
		}
	}


	/* Restore registers as needed per rusage. */

	reg = rlower;
	while(1) {
		if(rusage[reg] & INOUTER) {
			/* generate movw to restore reg */
#ifdef MPX
			printf("	lw	%s,", rnames[reg]);
			adrput(&svnode[reg]);
			printf("\n");
#else
			printf("	movw	");
			adrput(&svnode[reg]);
			printf(",%s\n", rnames[reg]);
#endif /* MPX */
			busy[reg] = wasbusy[reg];
		}

		if(reg == rupper)
			break;
		reg = rupper;
	}
	return(1);

  sorry:
	/* cant match */
	cerror("last ditch effort failed");
	return(0); /* silence warnings */
}


#ifndef BUG3
prditch(s, ip)
char *s;
int  *ip;
{
	register i;

	printf("%s[] = ", s);
	for(i=0; i<REGSZ; ++i) {
		printf(" %d", ip[i]);
	}
	printf("\n");
}
#endif

#ifdef FORT
/* SPR86100175 */  /* try making double register available by register swap */

static int rswpto, rswpfm;

tryregswap() {
	register int i, nlim, nbusy;
	extern int mina, maxa;
#ifdef MAR6
	extern NODE *fstack[];
#endif
	extern int regswap();
	NODE *p;

	rswpto = -1, rswpfm = -1, 
	nlim = maxa - mina - 1;
	nbusy = 0;
	for (i = maxa; i >= mina; --i) {
	    if (busy[i]) {
		if (++nbusy > nlim)
		    return 0;
		if (rswpto >= 0 && !busy[i ^ 1]
			&& (i & ~1) != (rswpto & ~1)) {
		    rswpfm = i;		/* highest reg below rswpto's pair */
					/* whose pairmate is not busy */
		    break;
		}
	    }
	    else if (rswpto < 0)
		    rswpto = i;		/* highest non-busy reg */
	}
	if (rswpto < 0 || rswpfm < 0)
	    return 0;
#ifdef MPX
	printf("\ttrr\tr%d,r%d\n", rswpfm, rswpto);
#else
	printf("\tmovw\tr%d,r%d\n", rswpfm, rswpto);
#endif /* MPX */
#ifdef MAR6
	p = (stotree ? stotree : fstack[0]);
#else
	p = stotree;
#endif
#ifndef BUG3
	if (edebug)
	    fwalk(p, eprint, 0);
#endif
	fwalk(p, regswap, 0);
	return 1;
}

regswap(p)
NODE *p;
{
	if ((p->in.op == REG || p->in.op == OREG) && p->tn.rval == rswpfm) {
	    p->tn.rval = rswpto;
	    ++busy[rswpto];
	    --busy[rswpfm];
#ifndef BUG3
	    if (edebug)
		printf("swapped %d, %d in %#x\n", rswpfm, rswpto, p);
#endif
	} else
#ifndef BUG3
	    if (edebug)
		printf("swapped %d, %d in %#x\n", rswpfm, rswpto, p);
#endif
}
#endif /* FORT */

/*
 * Turn LNAME and PNAME nodes into OREGs, STATNAMEs into NAMEs
 */
LNameFix(p)
	register NODE *p;
{
	if( p->in.op == STATNAME )
	{
		p->in.op = NAME;
	}
	else
	{
		/* NEED a FLEXNAME fix HERE ??? */
		p->tn.name = "";		/* forget name */
		p->tn.rval = (p->tn.op == LNAME ) ? FP : AP;
		p->in.op = OREG;
	}
}

/*
 * Fix up addresses of params and locals.  Main idea is to turn [LP]ADDR
 * into &, [LP]NAME and let others do all the work.
 */
LAddrFix(p)
	register NODE *p;
{
	register NODE *q;

	q = talloc();
	*q = *p;
	p->in.op = UNARY AND;
	p->in.left = q;
	p->tn.rval = 0;
	p->in.rall = NOPREF;
	p->in.name = "";
	q->in.type = DECREF(p->in.type);

	switch(q->in.op)
	{
	case LADDR:
		q->in.op = LNAME;
		break;

	case PADDR:
		q->in.op = PNAME;
		break;

	default:
		cerror("bad op type in LAddrFix");
	}

	/* Now, have &, [LP]NAME.  Call LNameFix to turn the [LP]NAME into
	 * an OREG, then call optim2 to turn the &,OREG into the correct
	 * arithmetic
	 */
	LNameFix(q);
	optim2(p);
}

#ifndef FORT
#ifndef ONEPASS

fltread(p) register NODE *p;
{
	int i;
	char buf[10];

	/* Read a floating point literal from the intermediate file */
	p->tn.lval = rdin(10);
	p->tn.rval = rdin(10);
	while ( getchar() != '\n' ) ;

	/* patch up FCONs to something pass2 understands */
	if (p->tn.type == FLOAT) {
		p->tn.name = tstr("\0");
		p->tn.op = ICON;
	} else { /* DOUBLE */
		printf("\t.data\n\t.align\t3\n");
		deflab(i = getlab());
		printf("\t.word\t0x%x,0x%x\n", p->tn.lval, p->tn.rval);
		printf("\t.fartext\n");
		p->tn.lval = 0;
		p->tn.rval = 0;
		sprintf(buf, "L%d\0", i);
		p->tn.name = tstr(buf);
		p->tn.op = NAME;
	}
}

#endif /* ONEPASS */
/* generate code for a return
 * plus a hint to the optimizer
 */

#ifdef ONEPASS
LclReturn(temp_label)
	register int temp_label;
{
#else
LclReturn()
{
	register int temp_label;

	temp_label = rdin(10);
#endif /* ONEPASS */
#ifdef MPX
	printf("\tbu\tL%d\n", temp_label);
#else
	printf("\tjmp\tL%d\n", temp_label);
#endif /* MPX */
}
#endif /* FORT */

ParamFetch(reg, offset, type, ftnno)
int reg, offset, type, ftnno;
{
#ifdef UAS
	    if (reg > 7)
		printf ("	lwbr	b%d", reg-7);
	    else
		printf ("	lw	r%d", reg);
#ifdef MPX
	    printf(",%dw+LA%d,sp\n", offset / (SZINT/SZCHAR), ftnno );
#else
	    printf(",%dw+LA%d(b2)\n", offset / (SZINT/SZCHAR), ftnno );
#endif
				     /* offset converted
				      * to bytes instead
				      * of words
				      */
#else
	    printf("	movw	%dw+LA%d[b2],%c%d\n",
	    offset / (SZINT/SZCHAR), ftnno, reg > 7 ? 'b' : 'r', reg & 7);
#endif /* UAS */
}

/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */
