/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts                           */
/*                          1.3.1  comments                                  */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  2/21/84                                          */
/*  Source File :            source/misc.131.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*  Description :           Comment is considered to a token separator.      */
/*                          It is enclosed by '/' following by '*' and       */
/*                          '*' following by '/'.                            */
/*                          This program tests if an unclosed comment is     */
/*                          detected by the compiler which should inform     */
/*                          user instructively.                              */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.j                                 */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
/* Comments  Comment is considered to be a token separator.
             It is enclosed by '/' following by '*'  and '*'
             following by '/'. Comment does not nest, even
             the comment delimiters enclosed by quotes.
             In case of an unclosed comment, does the compiler
             help the programmer to detect that ?
             The compiler fails if this program compiles.
*/
 
 
FILE *fp;
main(   /* main program  )                           /* test unclosed comment */
{
        int /* integer */ i  /* index */;
 
        for /* for loop */  ( i = 1 /* let i start from 1 */ ;
                              i < 6 /* upto 5 */ ;
                              ++ i  /* increment by 1 */ )
              { /* dummy loop */ };
        fp=fopen("misc_res bloc=y","a");
        fprintf(fp,"  ** miscellaneous, comments 1.3.1 class 1 fail\n");
        printf("  ** miscellaneous, comments 1.3.1 class 1 fail\n");
        fclose(fp);
}
 
