/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and declarations            */
/*                          Section - 3.3.6                                  */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/extn.336.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          03/08/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Removed pass statement.                       */
/*                          07/30/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Updated qar information.                      */
/*                                                                           */
/*  Date :                  11/20/84                                         */
/*  Description :           This program actually tests the syntax of an     */
/*                          expression.                                      */
/*                          Verify that the compiler will either reject or   */
/*                          accept and perform its function correctly, if    */
/*                          a declaration function identifier is used as an  */
/*                          expression pointer.                              */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>
 
 
main()
{
 
 
/* Function  This program generates a syntax error in function
             call and ensures the compiler will detect the error
             before code generation pass.
*/
 
/*           July 14, 1983
             The compiler generates incorrect code when function
             call omitted the (). No syntax error produced.
 
             March 8, 1984
             This problem submitted as a qar91 against UTX-32 1.0 Release.
 
Qar91 Resolution:
 
When a function name is referenced, not followed by "(" and possibly an
argument list and then ")", then the value of a pointer to the function is
intended. If one had declared, say, "int i;", it would then not be improper
to write the statement : "i;"; this is an expression the value of which is the
value of "i", and this value is immediately discarded since there is no
assignment. In the given example, it is just as legal to say "LABEL;"; this
specifies the value of a pointer to (i.e., address of) the function and this
value is immediately discarded. C is not intended to "second guess" the user;
the statement "LABEL;" is not a function call nor is it in error.
*/
        int LABEL();
FILE *fp;
fp = fopen("extn_res bloc=y","a");
fprintf(fp," .. external functions 3.3.6. class 1 pass\n");
printf("  .. external functions 3.3.6. class 1 pass\n");
fclose(fp);
 
        LABEL     /* missing () */;
 
}
 
LABEL()
{
}
