/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          Returned Values                                  */
/*                          Section  3.3.2                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/expr.33211.c                              */
/*  Revisions :             05/08/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that values are correctly returned        */
/*                          from a function return in an if statement.       */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*   This test was a problem reported in UNIX System V Release 2.0.
     Problem description:  Function return in an if statement does
             not work properly.
*/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
        int a, b;
        FILE *fp;
        fp=fopen("extn_res bloc=y","a");
 
        /* Test 1 */
 
        a = 10;
        b = func ( a );
        if ( b != 1 )
        {
                fail = TRUE;
                fprintf(fp,"  ** external, functions 3.3.2.11-1 class 1 fail -  exit return code : %d\n", b );
                printf("  ** external, functions 3.3.2.11-1 class 1 fail -  exit return code : %d\n", b );
        }
 
        /* Test 2 */
 
        a = 30;
        b = func ( a );
        if ( b != 3 )
        {
                fail = TRUE;
                fprintf(fp,"  ** external, functions 3.3.2.11-2 class 1 fail -  exit return code : %d\n", b );
                printf("  ** external, functions 3.3.2.11-2 class 1 fail -  exit return code : %d\n", b );
        }
 
        /* Test 3 */
 
        a = 20;
        b = func ( a );
        if ( b != 2 )
        {
                fail = TRUE;
                fprintf(fp,"  ** external, functions 3.3.2.11-3 class 1 fail -  exit return code : %d\n", b );
                printf("  ** external, functions 3.3.2.11-3 class 1 fail -  exit return code : %d\n", b );
        }
 
        if ( !fail )
               {fprintf(fp,"  .. external, functions 3.3.2.11 class 1 pass\n");
                printf("  .. external, functions 3.3.2.11 class 1 pass\n");}
        fclose(fp);
}
 
func ( i )
int i;
{
        if ( i == 10 )
                return ( 1 );
        else
                if ( i == 20 )
                        return ( 2 );
                else
                        return ( 3 );
}
 
