 
/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          Functions, Arguments - By Pointers               */
/*                          Section   3.3.1.2                                */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/extn.33126.c                              */
/*  Revisions :             04/10/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that an argument can be assigned the      */
/*                          pointer of a function.                           */
/*                          The compiler fails if this program compiles.     */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*     This test was originally spr0018 written against UTX Release 1.0.
       Problem Description:  When a local register argument is assigned the
               pointer of a function and a call is attempted throught this
               variable, a compiler error occurs.
*/
#include <stdio.h>
 
extern int func( a, b )
register int a, b;
{
        return ( a * b);
}
 
main()
{
        register int (*fn)();       /*  declaration of pointer to a function  */
        register t1, t2;
        int z;
        FILE *fp;
        fp=fopen("extn_res bloc=y","a");
 
        t1 = 5;
        t2 = 3;
 
        fn = func;
        z = (*fn)( t1, t2 );       /*  function call through pointer        */
 
        if ( z != 15 )
               {fprintf(fp,"  ** external, functions, pointers 3.3.1.2.6 class 2 fail - exit return code  :  %d\n", z );
                printf("  ** external, functions, pointers 3.3.1.2.6 class 2 fail - exit return code  :  %d\n", z );}
        else
               {fprintf(fp,"  .. external, functions, pointers 3.3.1.2.6 class 2 pass\n");
                printf("  .. external, functions, pointers 3.3.1.2.6 class 2 pass\n");}
        fclose(fp);
}
