/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          External Data - Section 3.1                      */
/*                          Local Basic types - Section 3.1.1                */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.3114.c                               */
/*  Revisions :             03/20/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  3/21/85                                          */
/*  Descriptions :          For all basic types, defined and declared        */
/*                          (implicitly by context or explicitly using the   */
/*                          extern storage class specifier ) in the same     */
/*                          file:                                            */
/*                          Verify that the variables can be referenced      */
/*                          correctly from the point of an identifier's      */
/*                          definition to the end of the file.               */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.31.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
int     fail, type;
 
#define INT                 1;
#define SHORT               2;
#define SHORT_INT           3;
#define LONG                4;
#define LONG_INT            5;
#define CHAR                6;
#define UNSIGNED            7;
#define UNSIGNED_INT        8;
#define UNSIGNED_SHORT      9;
#define UNSIGNED_SHORT_INT 10;
#define UNSIGNED_LONG      11;
#define UNSIGNED_LONG_INT  12;
#define UNSIGNED_CHAR      13;
 
int             in = 2;
short           sh = 4;
short int       si = 6;
long            lg = 8;
long int        li = 10;
char            ch = 12;
 
unsigned                un = 14;
unsigned int            ui = 16;
unsigned short          us = 18;
unsigned short int      usi = 20;
unsigned long           ul = 22;
unsigned long int       uli = 24;
unsigned char           uc = 26;
 
float           fl = 1.0;
long float      lf = 2.0;
double          db = 3.0;
 
FILE *fp;
main()
{
fp=fopen("extn_res bloc=y","a");
/*  Test 1   -  types integer, unsigned and char
*/
    {
        int in;
        short sh;
        short int si;
        long lg;
        long int li;
        char ch;
 
        unsigned un;
        unsigned int ui;
        unsigned short us;
        unsigned short int usi;
        unsigned long ul;
        unsigned long int uli;
        unsigned char uc;
 
           /*  initialize variables through function reset()
               which references the external variables
           */
 
           type = INT;       in = reset();
           type = SHORT;     sh = reset();
           type = SHORT_INT; si = reset();
           type = LONG;      lg = reset();
           type = LONG_INT;  li = reset();
           type = CHAR;      ch = reset();
 
           type = UNSIGNED;           un = reset();
           type = UNSIGNED_INT;       ui = reset();
           type = UNSIGNED_SHORT;     us = reset();
           type = UNSIGNED_SHORT_INT; usi = reset();
           type = UNSIGNED_LONG;      ul = reset();
           type = UNSIGNED_LONG_INT;  uli = reset();
           type = UNSIGNED_CHAR;      uc = reset();
 
           if ( in != 2   || sh != 4   || si != 6  || lg != 8   ||
                li != 10  || ch != 12  || un != 14 || ui != 16  ||
                us != 18  || usi != 20 || ul != 22 || uli != 24 ||
                uc != 26   )
              { fail = TRUE;
                fprintf(fp,"  ** external, local basic types 3.1.1.4-1 class 1 fail    -  exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d\n",
                in, sh, si, lg, li, ch, un, ui, us, usi, ul, uli, uc );
                 printf("  ** external, local basic types 3.1.1.4-1 class 1 fail    -  exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d\n",
                in, sh, si, lg, li, ch, un, ui, us, usi, ul, uli, uc );
              }
    }
 
    /*  verify that the external variables were incremented by one  */
 
           if ( in != 3   || sh != 5   || si != 7  || lg != 9   ||
                li != 11  || ch != 13  || un != 15 || ui != 17  ||
                us != 19  || usi != 21 || ul != 23 || uli != 25 ||
                uc != 27   )
              { fail = TRUE;
                fprintf(fp,"  ** external, local basic types 3.1.1.4-2 class 1 fail  -  exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d\n",
                in, sh, si, lg, li, ch, un, ui, us, usi, ul, uli, uc );
                 printf("  ** external, local basic types 3.1.1.4-2 class 1 fail  -  exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d\n",
                in, sh, si, lg, li, ch, un, ui, us, usi, ul, uli, uc );
              }
 
/*  Test 2  -  types float and double  -  verify that variables local to each
               block are referenced correctly.
*/
    {
        float fl = 2.0;
        long float lf = 3.0;
        double db = 4.0;
 
        if ( fl != 2.0 || lf != 3.0 || db != 4.0 )
           { fail = TRUE;
             fprintf(fp,"  ** external, local basic types 3.1.1.4-3 class 1 fail  exit return code  : %f%f%f\n", fl, lf, db );
             printf("  ** external, local basic types 3.1.1.4-3 class 1 fail  exit return code  : %f%f%f\n", fl, lf, db );
           }
 
        { /*  new block  */
 
           float fl = 3.0;
           long float lf = 4.0;
           double db = 5.0;
 
           if ( fl != 3.0 || lf != 4.0 || db != 5.0 )
              { fail = TRUE;
                fprintf(fp,"  ** external, local basic types 3.1.1.4-4 class 1 fail  -  exit return code : %f%f%f\n", fl, lf, db );
                printf("  ** external, local basic types 3.1.1.4-4 class 1 fail  -  exit return code : %f%f%f\n", fl, lf, db );
              }
 
           { /*  new block  */
 
              fl += 1.0;
              lf += 1.0;
              db += 1.0;
 
              if ( fl != 4.0 || lf != 5.0 || db != 6.0 )
              { fail = TRUE;
                fprintf(fp,"  ** external, local basic types 3.1.1.4-5 class 1 fail -  exit return code : %f%f%f\n", fl, lf, db );
                printf("  ** external, local basic types 3.1.1.4-5 class 1 fail -  exit return code : %f%f%f\n", fl, lf, db );
              }
 
           } /*  end block  */
 
           if ( fl != 4.0 || lf != 5.0 || db != 6.0 )
              { fail = TRUE;
                fprintf(fp,"  ** external, local basic types 3.1.1.4-6 class 1 fail -  exit return code : %f%f%f\n", fl,lf, db );
                printf("  ** external, local basic types 3.1.1.4-6 class 1 fail -  exit return code : %f%f%f\n", fl,lf, db );
              }
 
       }  /*  end block  */
 
       if ( fl != 2.0 || lf != 3.0 || db != 4.0 )
          { fail = TRUE;
            fprintf(fp,"  ** external, local basic types 3.1.1.4-7 class 1 fail - exit return code : %f%f%f\n", fl, lf, db );
          }
 
    }  /*  end block  */
 
    if ( fl != 1.0 || lf != 2.0 || db != 3.0 )
       { fail = TRUE;
         fprintf(fp,"  ** external, local basic types 3.1.1.4-8 class 1 fail exit return code : %f%f%f\n", fl, lf, db ); 
         printf("  ** external, local basic types 3.1.1.4-8 class 1 fail exit return code : %f%f%f\n", fl, lf, db ); 
       }
 
  if ( !fail )
    {fprintf(fp,"  .. external, local basic types 3.1.1.4 class 1 pass\n");
     printf("  .. external, local basic types 3.1.1.4 class 1 pass\n");}
}
 
/******************************************************************************/
/*                                                                            */
/*  reset()  -  This function references the external variables, returns      */
/*              their value to main and increments their values by one.       */
/*                                                                            */
/******************************************************************************/
reset()
{
        if ( type == 1 ) return (in++);
        else
           if ( type == 2 ) return (sh++);
        else
           if ( type == 3 ) return (si++);
        else
           if ( type == 4 ) return (lg++);
        else
           if ( type == 5 ) return (li++);
        else
           if ( type == 6 ) return (ch++);
        else
           if ( type == 7 ) return (un++);
        else
           if ( type == 8 ) return (ui++);
        else
           if ( type == 9 ) return (us++);
        else
           if ( type == 10 ) return (usi++);
        else
           if ( type == 11 ) return (ul++);
        else
           if ( type == 12 ) return (uli++);
        else
           if ( type == 13 ) return (uc++);
        else
         {fprintf(fp,"  ** external, local basic types 3.1.1.4-reset() class 1 fail - exit return code : %d\n", type );
          printf("  ** external, local basic types 3.1.1.4-reset() class 1 fail - exit return code : %d\n", type );}
        fclose(fp);
 
}
