/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initializations and Variable       */
/*                          Reference  -  Compound Statements                */
/*                          Section  - 2.9                                   */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.295.c                                */
/*  Revisions :             03/18/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  3/19/85                                          */
/*  Descriptions :          For all basic types, arrays, structures, unions  */
/*                          and fields in block declarations :               */
/*                          Verify that the space is deallocated after the   */
/*                          block is executed.                               */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.29.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  Test Method -  In order to verify that space is deallocated after the
                   block is executed, variables of each type are declared
                   within braces {}.  The address of the first variable declared
                   within the first set of braces is assigned to addr1, second
                   set of braces is assigned to addr2.  If space is deallocated
                   after the block is executed, addr1 and addr2 should be
                   equivalent.
 
                -  This test is position dependent.  The integer variable
                   "filler" is declared in order to insure that machine words
                   are correctly bounded for several tests.
*/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
FILE *fp;
main()
{
int addr1, addr2;
int test_no;
int filler;
fp=fopen("decl_res bloc=y","a");      /* OPEN FILE FOR WRITTING RESULTS */
 
/*  Test 1  */
 
      test_no = 1;
      {
        int a, b, *c, d[5], e, f;
        addr1 = (int) &a;
      }
      {
        short int b, c, d, e[3], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 2  */
 
      test_no++;
      {
        short  b, c, d[2][2], e[3], f;
        addr1 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 3  */
 
      test_no++;
      {
        long  b, *c, d[2][3], e[3], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 4  */
 
      test_no++;
      {
        long int  b, *c, d[4], e[2], f;
        addr1 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 5  */
 
      test_no++;
      {
        float  b, *c, d[2][2], e[2], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 6  */
 
      test_no++;
      {
        long float  b, c[4][2], d, e[2], f;
        addr1 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 7  */
 
      test_no++;
      {
        double  b, c[3][3], d, e[3], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 8  */
 
      test_no++;
      {
        char b, c[10], d, e[2][2], f;
        addr1 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 9  */
 
      test_no++;
      {
        unsigned b, *c, d[4], e[2][2], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 10  */
 
      test_no++;
      {
        unsigned int b, c[2][2], *d, e[3], f;
        addr1 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 11  */
 
      test_no++;
      {
        unsigned short b, c[1][2], d, e[4], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 12  */
 
      test_no++;
      {
        unsigned short int b, c[2][2], d[4], e, f;
        addr1 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 13  */
 
      test_no++;
      {
        unsigned long b, c[3][2], d, e[3], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 14  */
 
      test_no++;
      {
        unsigned long int b, *c, d[2], e[2][2], f;
        addr1 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 15  */
 
      test_no++;
      {
        unsigned char b, c, d[3], e[3][3], f;
        addr2 = (int) &b;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 16  */
 
      test_no++;
      {
        struct test {
               int a;
               short b;
               } one, two;
        addr1 = (int) &one;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 17  */
 
      test_no++;
      {
        union test {
              float a;
              double b;
              } one, two;
        addr2 = (int) &one;
      }
 
      verify( addr1, addr2, test_no );
 
/*  Test 18  */
 
      test_no++;
      {
        struct test {
               unsigned a :  4;
               unsigned b :  4;
               unsigned c :  2;
              } boundry_1, boundry_2;
        addr1 = (int) &boundry_1;
      }
 
      verify( addr1, addr2, test_no );
 
 
        if ( !fail ){
           fprintf(fp,"  .. declaration, compound 2.9.5 class 1 pass\n");
           printf("  .. declaration, compound 2.9.5 class 1 pass\n");
           }
           fclose(fp);
}
 
verify( addr1, addr2, test_no )
int addr1, addr2, test_no;
{
        if ( addr1 != addr2 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.5-%d class 1 fail exit return code : %d%d\n", test_no, addr1, addr2 );
             printf("  ** declaration, compound 2.9.5-%d class 1 fail exit return code : %d%d\n", test_no, addr1, addr2 );
           }
}
