/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initializations and Variable       */
/*                          Reference  -  Compound Statements                */
/*                          Section  - 2.9                                   */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.291.c                                */
/*  Revisions :             03/08/85    Sqa     Original UTX-32 1.2 Release  */
/*                          10/03/85    T. Aleksa        UTX-32 1.2 Release  */
/*                          -- all addresses now cast to unsigned int        */
/*                                                                           */
/*  Date :                  10/3/85                                          */
/*  Descriptions :          For all basic types, arrays, structures, unions  */
/*                          and fields in block declarations :               */
/*                          Verify that space is correctly allocated.        */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.29.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  Test Method -  In order to verify that space is correctly allocated
                   within a block declaration, each basic type, array,
                   structure etc. will be declared separately within its
                   own block.  Addresses of the variables will be subtracted
                   and then compared to the "sizeof" the particular type in
                   order to verify correct allocation of space.
 
                   THIS TEST IS COMPILER DEPENDENT.
*/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");          /* OPEN FILE FOR WRITTING RESULTS */
fail =0;
/*  Test 1  */
{
        int a, b, *c, d[5], e, f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        printf("a = %d\n", a);
        printf("sizeof = %d\n", sizeof(int));
        if ( a != ( 8 * sizeof(int) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-1 class 1 fail exit return code : %d%d\n", a, (8* sizeof(int)));
             printf("  ** declaration, compound 2.9.1-1 class 1 fail exit return code : %d%d\n", a, (8* sizeof(int)));
           }
}
/*  Test 2  */
{
        int a;
        short int b, c, d, e[3], f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        printf("a = %d\n", a);
        printf("e[2] - e[0] = %d\n", &e[2] - &e[0]);
        printf("e[1] - e[0] = %d\n", &e[1] - &e[0]);
        printf("sizeof short = %d\n", sizeof(short int));
        printf("f - b = %d\n", &f - &b);
        printf("f - d = %d\n", &f - &d);
        printf("d - c = %d\n", &d - &c);
        printf("e[0] - d = %d\n", &e[0] - &d);
        printf("e - d = %d\n", &e - &d);
        printf("f - e[0] = %d\n", &f - &e[0]);
        printf("f - e[2] = %d\n", &f - &e[2]);
        if ( a != ( 6 * sizeof(short int) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-2 class 1 fail exit return code : %d%d\n", a, (6* sizeof(short int)));
             printf("  ** declaration, compound 2.9.1-2 class 1 fail exit return code : %d%d\n", a, (6* sizeof(short int)));
           }
}
/*  Test 3  */
{
        int a;
        short  b, c, d[2][2], e[3], f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        printf("a = %d\n", a);
        if ( a != ( 9 * sizeof(short) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-3 class 1 fail exit return code : %d%d\n", a, (9* sizeof(short)));
             printf("  ** declaration, compound 2.9.1-3 class 1 fail exit return code : %d%d\n", a, (9* sizeof(short)));
           }
}
/*  Test 4  */
{
        int a;
        long  b, *c, d[2][3], e[3], f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        if ( a != ( 11 * sizeof(long) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-4 class 1 fail exit return code : %d%d\n", a, (11* sizeof(long)));
             printf("  ** declaration, compound 2.9.1-4 class 1 fail exit return code : %d%d\n", a, (11* sizeof(long)));
           }
}
/*  Test 5  */
{
        int a;
        long int  b, *c, d[4], e[2], f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        if ( a != ( 8 * sizeof(long int) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-5 class 1 fail exit return code : %d%d\n", a, (8* sizeof(long int)));
             printf("  ** declaration, compound 2.9.1-5 class 1 fail exit return code : %d%d\n", a, (8* sizeof(long int)));
           }
}
/*  Test 6  */
{
        int a;
        float  b, *c, d[2][2], e[2], f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        if ( a != ( 8 * sizeof(float) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-6 class 1 fail exit return code : %d%d\n", a, (8* sizeof(float)));
             printf("  ** declaration, compound 2.9.1-6 class 1 fail exit return code : %d%d\n", a, (8* sizeof(float)));
           }
}
/*  Test 7  */
{
        int a;
        long float  b, c[4][2], d, e[2], f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        if ( a != ( 12 * sizeof(long float) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-7 class 1 fail exit return code : %d%d\n", a, (12* sizeof(long float)));
             printf("  ** declaration, compound 2.9.1-7 class 1 fail exit return code : %d%d\n", a, (12* sizeof(long float)));
           }
}
/*  Test 8  */
{
        int a;
        double  b, c[3][3], d, e[3], f;
 
        a = ( (unsigned int) &f  - (unsigned int) &b );
        if ( a != ( 14 * sizeof(double) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-8 class 1 fail exit return code : %d%d\n", a, (14* sizeof(double)));
             printf("  ** declaration, compound 2.9.1-8 class 1 fail exit return code : %d%d\n", a, (14* sizeof(double)));
           }
}
/*  Test 9  */
{
        int a;
        char b, c[10], d, e[2][2], f;
 
        a = ( (unsigned int) &f - (unsigned int) &b );
        if ( a != ( 16 * sizeof(char) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-9 class 1 fail exit return code : %d%d\n", a, (16* sizeof(char)));
             printf("  ** declaration, compound 2.9.1-9 class 1 fail exit return code : %d%d\n", a, (16* sizeof(char)));
           }
}
/*  Test 10  */
{
        int a;
        unsigned b, *c, d[4], e[2][2], f;
 
        a = ( (unsigned int) &f - (unsigned int) &b );
        if ( a != ( 10 * sizeof(unsigned) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-10 class 1 fail exit return code : %d%d\n", a, (10* sizeof(unsigned)));
             printf("  ** declaration, compound 2.9.1-10 class 1 fail exit return code : %d%d\n", a, (10* sizeof(unsigned)));
           }
}
/*  Test 11  */
{
        int a;
        unsigned int b, c[2][2], *d, e[3], f;
 
        a = ( (unsigned int) &f - (unsigned int) &b );
        if ( a != ( 9 * sizeof(unsigned int) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-11 class 1 fail exit return code : %d%d\n", a, (9* sizeof(unsigned int)));
             printf("  ** declaration, compound 2.9.1-11 class 1 fail exit return code : %d%d\n", a, (9* sizeof(unsigned int)));
           }
}
/*  Test 12  */
{
        int a;
        unsigned short b, c[1][2], d, e[4], f;
 
        a = ( (unsigned int) &f - (unsigned int) &b );
        if ( a != ( 8 * sizeof(unsigned short) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-12 class 1 fail exit return code : %d%d\n", a, (8* sizeof(unsigned short)));
             printf("  ** declaration, compound 2.9.1-12 class 1 fail exit return code : %d%d\n", a, (8* sizeof(unsigned short)));
           }
}
/*  Test 13  */
{
        int a;
        unsigned short int b, c[2][2], d[4], e, f;
 
        a = ( (unsigned int) &f - (unsigned int) & b );
        if ( a != ( 10 * sizeof(unsigned short int) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-13 class 1 fail exit return code : %d%d\n", a, (10 * sizeof(unsigned short int)));
             printf("  ** declaration, compound 2.9.1-13 class 1 fail exit return code : %d%d\n", a, (10 * sizeof(unsigned short int)));
           }
}
/*  Test 14  */
{
        int a;
        unsigned long b, c[3][2], d, e[3], f;
 
        a = ( (unsigned int ) &f - (unsigned int) &b );
        if ( a != ( 11 * sizeof(unsigned long) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-14 class 1 fail exit return code : %d%d\n", a, (11* sizeof(unsigned long)));
             printf("  ** declaration, compound 2.9.1-14 class 1 fail exit return code : %d%d\n", a, (11* sizeof(unsigned long)));
           }
}
/*  Test 15  */
{
        int a;
        unsigned long int b, *c, d[2], e[2][2], f;
 
        a = ( (unsigned int) &f - (unsigned int) &b );
        if ( a != ( 8 * sizeof(unsigned long int) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-15 class 1 fail exit return code : %d%d\n", a, (8* sizeof(unsigned long int)));
             printf("  ** declaration, compound 2.9.1-15 class 1 fail exit return code : %d%d\n", a, (8* sizeof(unsigned long int)));
           }
}
/*  Test 16  */
{
        int a;
        unsigned char b, c, d[3], e[3][3], f;
 
        a = ( (unsigned int) &f - (unsigned int) &b );
        if ( a != ( 14 * sizeof(unsigned char) ) )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, compound 2.9.1-16 class 1 fail exit return code : %d%d\n", a, (14* sizeof(unsigned char)));
            printf("  ** declaration, compound 2.9.1-16 class 1 fail exit return code : %d%d\n", a, (14* sizeof(unsigned char)));
          }
}
/*  Test 17  */
{
        int a, b;
        struct test {            /*  sizeof structure one is  */
               int a;            /*  8 bytes due to rounding  */
               short b;          /*  to the nearest word      */
        } one;
        int c;
 
        a = ( (unsigned int) &c - (unsigned int) &b );
        if ( a != 12 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-17 class 1 fail exit return code : %d\n", a );
             printf("  ** declaration, compound 2.9.1-17 class 1 fail exit return code : %d\n", a );
           }
}
/*  Test 18  */
{
        int a, b;
        union test {        /* the sizeof of a union is the size */
              float a;      /* allocated to its largest member,  */
              double b;     /* which is 8 bytes - type double    */
        } one;
        int c;
 
        a = ( (unsigned int) &c - (unsigned int) &b );
        if ( a != 12 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-18 class 1 fail exit return code : %d\n", a );
             printf("  ** declaration, compound 2.9.1-18 class 1 fail exit return code : %d\n", a );
           }
}
/*  Test 19  */
{
        int a, b;
        struct test {
               unsigned a :  4;
               unsigned b :  4;
               unsigned c :  2;
        } boundry;
        int  c;
 
        a = ( (unsigned int) &c - (unsigned int) &b );
        if ( a != 8 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.1-19 class 1 fail exit return code : %d\n", a );
             printf("  ** declaration, compound 2.9.1-19 class 1 fail exit return code : %d\n", a );
           }
}
        if ( !fail ) {
           fprintf(fp,"  .. declaration, compound 2.9.1 class 1 pass\n");
           printf("  .. declaration, compound 2.9.1 class 1 pass\n");
           }
           fclose(fp);
}
