 
/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Pointer Reference                    */
/*                          Section  2.8                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/decl.284.c                                */
/*  Revisions :             04/06/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the compiler will correctly detect   */
/*                          and reject the incorrect usage of a pointer      */
/*                          reference to a structure.                        */
/*                          The compiler fails if the program compiles.      */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.28.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*      This test is qar191 written against UTX-32 Release 1.0.              */
/*      Problem description:  The compiler incorrectly generates a warning   */
/*              when an error message is required.  The procedure parameter  */
/*              is declared as a "struct TEST", but the structure is         */
/*              referenced as a pointer to "struct TEST".  A compiler error  */
/*              should occur but the following warning is issued:            */
/*                                                                           */
/*      "decl.284.c", line 32: warning : struct/union or struct/union        */
/*      pointer required.                                                    */
/*      When the a.out file is executed, an "Illegal instruction - core      */
/*      dumped" occurs.                                                      */
/*****************************************************************************/
 
#include <stdio.h>
 
struct TEST {
        int x;
};
 
FILE *fp;
main()
{
        struct TEST test;
        struct TEST *testptr;
        fp=fopen("decl_res bloc=y","a"); 
 
        test.x = 666;
        testptr = &test;
 
        fprintf(fp,"bad_test_print(*testptr): ");
        printf("bad_test_print(*testptr): ");
        bad_test_print(*testptr);
}
 
 
/*************************
print the value of test
*************************/
 
bad_test_print(test)
struct TEST test;
{
           /* Procedure parameter is declared as a
            * "struct TEST", but the structure is
            * referenced as a pointer to "struct TEST".
            * Compiler error should occur but only a
            * warning is issued.                     */
 
        fprintf(fp,"test->x = %d\n", test->x);
        printf("test->x = %d\n", test->x);
        fclose(fp);
}
 
 
