/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - Pointer Reference                  */
/*                          Section  - 2.8                                   */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.2813.c                               */
/*  Revisions :             03/05/85    Sqa     Original UTX 1.2 Release     */
/*                          09/30/85    T. Aleksa        UTX-32(1.2) Release */
/*                                                                           */
/*  Date :                  9/30/85                                          */
/*  Descriptions :          For a pointer to all of the basic types, arrays  */
/*                          structures and unions:                           */
/*                          Verify that space is allocated correctly for an  */
/*                          array of pointers for each type.                 */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.28.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
/*  Test Method
 
    Arrays of basic types are declared and initialized.  A pointer array
    is then declared and assigned the address of the declared arrays.  By
    verifying that a pointer takes into account the size that the object
    points to ( address arithmetic ), it is verified that space is allocated
    correctly for that pointer.  In addition, it is verified that the value
    of the pointer can be referenced.
 
    Note that register variable types are not tested because it is illegal
    to take the address of a register variable.  In addition, types char,
    short, unsigned char and unsigned short are too small to hold pointers
    on our machine.  Therefore pointer arrays of the above mentioned types
    are not tested.
*/
 
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
/*  Test 1  -  int  */
{
   static int  i1[5] = { 26, 1, 2, 3, 4 };
   static int  i2[5] = { 9, 8, 7, 6, 5 };
   static int  i3[2][2] = { {20,1},{2,3} };
   int i, j, k, *pi[2], (*pi3)[2];
 
   pi[0] = i1;        /*  pi[0] is assigned the address of i1[0]  */
   pi[1] = i2;        /*  pi[1] is assigned the address of i2[0]  */
   
fail =0; 
   for ( i = 0; i < 5; i++ )
       if ( *(pi[0] + i ) != i1[i]  || *(pi[1] + i) != i2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-1.1 class 1 fail exit return code : %d %d%d %d%d\n",i, i1[i], *(pi[0] + i), i2[i], *(pi[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-1.1 class 1 fail exit return code : %d %d%d %d%d\n",i, i1[i], *(pi[0] + i), i2[i], *(pi[1] + i) );
          }
 
   pi3 = i3;         /*  pi3 is type pointer to array of 2 integers and
                         is assigned the address of i3[0].             */
 
   for ( i = 0, j = 0, k = 0; i < 2; i++, k += 2 )
       if ( (*pi3)[k] != i3[i][j] )
            { fail = TRUE;
              fprintf(fp,"  ** declaration, pointer 2.8.1.3-1.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, i3[i][j], (*pi3)[k] );
              printf("  ** declaration, pointer 2.8.1.3-1.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, i3[i][j], (*pi3)[k] );
            }
}
/*  Test 2  -  long  */
{
   static long l1[5] = { 10, 9, 8, 7, 6 };
   static long l2[5] = { 5, 4, 3, 2, 1 };
   static long l3[2][2] = { 3, 4, 7, 8 };
   long i, j, k, *pl[2], (*pl3)[2];
 
   pl[0] = l1;            /*  pl[0] is assigned the address of l1[0]     */
   pl[1] = l2;            /*  pl[1] is assigned the address of l2[0]     */
 
   for ( i = 0; i < 5; i++ )
       if ( *(pl[0] + i ) != l1[i]  || *(pl[1] + i ) != l2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-2.1 class 1 fail exit return code : %d %d%d %d%d\n",i, l1[i], *(pl[0] + i), l2[i], *(pl[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-2.1 class 1 fail exit return code : %d %d%d %d%d\n",i, l1[i], *(pl[0] + i), l2[i], *(pl[1] + i) );
          }
 
   pl3 = l3;              /*  pl3 is type pointer to an array of 2 longs
                              and is assigned the address of l3[0].        */
 
   for ( i = 0, j = 0, k = 0; i < 2; i++, k += 2 )
       if ( (*pl3)[k] != l3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-2.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, l3[i][j], (*pl3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-2.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, l3[i][j], (*pl3)[k] );
          }
}
/*  Test 3  -  long int */
{
   static long int  li1[10] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
   static long int  li2[10] = { 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 };
   static long int  li3[2][2] = { 3, 4, 7, 8 };
   long int i, j, k, *pli[2], (*pli3)[2];
 
   pli[0] = li1;            /*  value of pli[0] = address of li1[0]     */
   pli[1] = li2;            /*  value of pli[1] = address of li2[0]     */
 
   for ( i = 0; i < 10; i++ )
       if ( *(pli[0] + i ) != li1[i]  || *(pli[1] + i ) != li2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-3.1 class 1 fail exit return code : %d %d%d %d%d\n",i, li1[i], *(pli[0] + i), li2[i], *(pli[1] + i ) );
            printf("  ** declaration, pointer 2.8.1.3-3.1 class 1 fail exit return code : %d %d%d %d%d\n",i, li1[i], *(pli[0] + i), li2[i], *(pli[1] + i ) );
          }
 
   pli3 = li3;             /* pli3 is type pointer to array of 2 long integers
                              and is assigned the address of li3[0].          */
 
   for ( i = 0, j = 0, k = 0; i < 2; i++, k += 2 )
       if ( (*pli3)[k] != li3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-3.2 class 1 fail exit return code : %d%d%d %d%d %d%d\n",i,j,k, li3[i][j], (*pli3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-3.2 class 1 fail exit return code : %d%d%d %d%d %d%d\n",i,j,k, li3[i][j], (*pli3)[k] );
          }
}
/*  Test 4  -  float    */
{
   static float     f1[5] = { 0.5, 1.5, 2.5, 3.5, 4.5 };
   static float     f2[5] = { 5.5, 6.5, 7.5, 8.5, 9.5 };
   static float     f3[2][2] = { 3.5, 4.5, 7.5, 8.5 };
   float            *pf[2], (*pf3)[2];
   int              i,j,k;
 
   pf[0] = f1;            /*  pf[0] is assigned the address of f1[0]  */
   pf[1] = f2;            /*  pf[1] is assigned the address of f2[0]  */
 
   for ( i = 0; i < 5; i++ )
       if ( *(pf[0] + i ) != f1[i]  || *(pf[1] + i ) != f2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-4.1 class 1 fail exit return code : %d %f%f %f%f\n",i, f1[i], *(pf[0] + i), f2[i], *(pf[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-4.1 class 1 fail exit return code : %d %f%f %f%f\n",i, f1[i], *(pf[0] + i), f2[i], *(pf[1] + i) );
          }
 
   pf3 = f3;             /*  pf3 is type pointer to an array of 2 floats
                             and is assigned the address of f3[0].         */
 
   for ( i = 0, j = 0, k = 0; i < 2; i++, k += 2 )
       if ( (*pf3)[k] != f3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-4.2 class 1 fail exit return code : %d%d%d %f%f\n",i,j,k, f3[i][j], (*pf3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-4.2 class 1 fail exit return code : %d%d%d %f%f\n",i,j,k, f3[i][j], (*pf3)[k] );
          }
}
/*  Test 5  -  long float    */
{
   static long float     lf1[5] = { 0.5, 1.5, 2.5, 3.5, 4.5 };
   static long float     lf2[5] = { 5.5, 6.5, 7.5, 8.5, 9.5 };
   static long float     lf3[2][2] = { 3.5, 4.5, 7.5, 8.5 };
   long float            *plf[2], (*plf3)[2];
   int                   i,j,k;
 
   plf[0] = lf1;        /*  plf[0] is assigned the address of lf1[0]. */
   plf[1] = lf2;        /*  plf[1] is assigned the address of lf2[0]. */
 
   for ( i = 0; i < 5; i++ )
       if ( *(plf[0] + i ) != lf1[i] || *(plf[1] + i ) != lf2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-5.1 class 1 fail exit return code : %d %f%f %f%f\n",i, lf1[i], *(plf[0] + i), lf2[i], *(plf[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-5.1 class 1 fail exit return code : %d %f%f %f%f\n",i, lf1[i], *(plf[0] + i), lf2[i], *(plf[1] + i) );
          }
 
   plf3 = lf3;          /*  plf3 is type pointer to an array of 2 long floats
                            and is assigned the address of lf3[0].        */
 
   for ( i=0, j=0, k=0; i < 2; i++, k+=2 )
       if ( (*plf3)[k] != lf3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-5.2 class 1 fail exit return code : %d%d%d %f%f\n",i,j,k, lf3[i][j], (*plf3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-5.2 class 1 fail exit return code : %d%d%d %f%f\n",i,j,k, lf3[i][j], (*plf3)[k] );
          }
}
/*  Test 6  -  double        */
{
   static double         d1[5] = { 0.5, 1.5, 2.5, 3.5, 4.5 };
   static double         d2[5] = { 5.5, 6.5, 7.5, 8.5, 9.5 };
   static double         d3[2][2] = { 3.5, 4.5, 7.5, 8.5 };
   double                *pd[2], (*pd3)[2];
   int                   i,j,k;
 
   pd[0] = d1;            /*  pd[0] is assigned the address of d1[0].  */
   pd[1] = d2;            /*  pd[1] is assigned the address of d2[0].  */
 
   for ( i = 0; i < 5; i++ )
       if ( *(pd[0] + i ) != d1[i]  || *(pd[1] + i ) != d2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-6.1 class 1 fail exit return code : %d %f%f %f%f\n",i, d1[i], *(pd[0] + i), d2[i], *(pd[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-6.1 class 1 fail exit return code : %d %f%f %f%f\n",i, d1[i], *(pd[0] + i), d2[i], *(pd[1] + i) );
          }
 
   pd3 = d3;            /*  pd3 is type pointer to an array of 2 doubles
                            and is assigned the address of d3[0].        */
 
   for ( i=0, j=0, k=0; i < 2; i++, k+=2 )
       if ( (*pd3)[k] != d3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-6.2 class 1 fail exit return code : %d%d%d %f%f\n",i,j,k, d3[i][j], (*pd3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-6.2 class 1 fail exit return code : %d%d%d %f%f\n",i,j,k, d3[i][j], (*pd3)[k] );
          }
}
/*  Test 7 -  unsigned  */
{
   static unsigned  u1[10] = { 26, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
   static unsigned  u2[10] = { 27, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
   static unsigned  u3[2][2] = { {20, 1}, {2, 3} };
   unsigned i, j, k, *pu[2], (*pu3)[2];
 
   pu[0] = u1;            /*  pu[0] is assigned the address of u1[0]  */
   pu[1] = u2;            /*  pu[1] is assigned the address of u2[0]  */
 
   for ( i = 0; i < 10; i++ )
       if ( *(pu[0] + i ) != u1[i] || *(pu[1] + i ) != u2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-7.1 class 1 fail exit return code : %d %d%d %d%d\n",i, u1[i], *(pu[0] + i), u2[i], *(pu[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-7.1 class 1 fail exit return code : %d %d%d %d%d\n",i, u1[i], *(pu[0] + i), u2[i], *(pu[1] + i) );
          }
 
   pu3 = u3;            /*  pu3 is type pointer to array of 2 unsigned's
                            and is assigned the address of u3[0].        */
 
   for ( i=0, j=0, k=0; i < 2; i++, k+=2 )
       if ( (*pu3)[k] != u3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-7.2 class 1 fail             - exit return code : %d%d%d %d%d\n",i,j,k, u3[i][j], (*pu3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-7.2 class 1 fail             - exit return code : %d%d%d %d%d\n",i,j,k, u3[i][j], (*pu3)[k] );
          }
}
/*  Test 8  -  unsigned int  */
{
   static unsigned int ui1[10] = { 26, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
   static unsigned int ui2[10] = { 26, 21, 22, 23, 24, 25, 26, 27, 28, 29 };
   static unsigned int ui3[2][2] = { {20, 1}, {2, 3} };
   unsigned int        i, j, k, *pui[2], (*pui3)[2];
 
   pui[0] = ui1;            /*  pui[0] is assigned the address of ui1[0].  */
   pui[1] = ui2;            /*  pui[1] is assigned the address of ui2[0].  */
 
   for ( i = 0; i < 10; i++ )
       if ( *(pui[0] + i ) != ui1[i] || *(pui[1] +i ) != ui2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-8.1 class 1 fail exit return code : %d %d%d %d%d\n",i, ui1[i], *(pui[0] + i), ui2[i], *(pui[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-8.1 class 1 fail exit return code : %d %d%d %d%d\n",i, ui1[i], *(pui[0] + i), ui2[i], *(pui[1] + i) );
          }
 
   pui3 = ui3;             /*  pui3 is type pointer to an array of 2 unsigned
                               integers and is assigned the address of ui3[0].*/
 
   for ( i=0, j=0, k=0; i < 2; i++, k+=2 )
       if ( (*pui3)[k] != ui3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-8.2 class 1 fail exit return code : %d%d%d %d%d %d%d\n",i,j,k, ui3[i][j], (*pui3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-8.2 class 1 fail exit return code : %d%d%d %d%d %d%d\n",i,j,k, ui3[i][j], (*pui3)[k] );
          }
}
/*  Test 9 -  unsigned long int */
{
   static unsigned long int uli1[10] = { 26, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
   static unsigned long int uli2[10] = { 26,21,22,23,24,25,26,27,28,29 };
   static unsigned long int uli3[2][2] = { {20, 1}, {2, 3} };
   unsigned long int    i, j, k, *puli[2], (*puli3)[2];
 
   puli[0] = uli1;        /* puli[0] is assigned the address of uli1[0]. */
   puli[1] = uli2;        /* puli[1] is assigned the address of uli2[0]. */
 
   for ( i = 0; i < 10; i++ )
       if ( *(puli[0] + i ) != uli1[i] || *(puli[1] + i ) != uli2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-9.1 class 1 fail exit return code : %d %d%d %d%d\n",i, uli1[i], *(puli[0] + i), uli2[1], *(puli[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-9.1 class 1 fail exit return code : %d %d%d %d%d\n",i, uli1[i], *(puli[0] + i), uli2[1], *(puli[1] + i) );
          }
 
   puli3 = uli3;        /* puli3 is type pointer to an array of 2 unsigned
                           long integers and is assigned the address of
                           uli3[0].                                        */
 
   for ( i=0, j=0, k=0; i < 2; i++, k+=2 )
       if ( (*puli3)[k] != uli3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-9.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, uli3[i][j], (*puli3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-9.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, uli3[i][j], (*puli3)[k] );
          }
}
/*  Test 10  -  unsigned long */
{
   static unsigned long ul1[10] = { 26, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
   static unsigned long ul2[10] = { 26, 31, 32, 33, 34, 35, 36, 37, 38, 39 };
   static unsigned long ul3[2][2] = { {20, 1}, {2, 3} };
   unsigned long   i, j, k, *pul[2], (*pul3)[2];
 
   pul[0] = ul1;        /*  pul[0] is assigned the address of ul1[0].  */
   pul[1] = ul2;        /*  pul[1] is assigned the address of ul2[0].  */
 
   for ( i = 0; i < 10; i++ )
       if ( *(pul[0] + i ) != ul1[i] || *(pul[1] + i ) != ul2[i] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-10.1 class 1 fail exit return code : %d %d%d %d%d\n",i, ul1[i], *(pul[0] + i), ul2[i], *(pul[1] + i) );
            printf("  ** declaration, pointer 2.8.1.3-10.1 class 1 fail exit return code : %d %d%d %d%d\n",i, ul1[i], *(pul[0] + i), ul2[i], *(pul[1] + i) );
          }
 
   pul3 = ul3;        /* pul3 is type pointer to array of 2 unsigned long's
                         and is assigned the address of ul3[0].            */
 
   for ( i=0, j=0, k=0; i < 2; i++, k+=2 )
       if ( (*pul3)[k] != ul3[i][j] )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, pointer 2.8.1.3-10.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, ul3[i][j], (*pul3)[k] );
            printf("  ** declaration, pointer 2.8.1.3-10.2 class 1 fail exit return code : %d%d%d %d%d\n",i,j,k, ul3[i][j], (*pul3)[k] );
          }
}
/*  Test 11  -  structures */
{
   static struct category {
                    int ca;
                    float cb;
   } cat[3] = { { 7, 8.0 }, { 9, 10.0 }, { 11, 12.0 } };
 
   static struct category key[3] = { { 1, 2.0 }, { 3, 4.0 }, { 5, 6.0 } };
   static struct category *ptr[2];
   int res1, res3, i;
   float res2, res4;
 
   ptr[0] = cat;          /* ptr[0] = address of cat[0] */
   ptr[1] = key;          /* ptr[1] = address of key[0] */
 
   for ( i = 0; i < 3; i++)
       {
         res1 = (ptr[0] + i)->ca;
         res2 = (ptr[0] + i)->cb;
         res3 = (ptr[1] + i)->ca;
         res4 = (ptr[1] + i)->cb;
         if ( res1 != cat[i].ca || res2 != cat[i].cb ||
              res3 != key[i].ca || res4 != key[i].cb )
            { fail = TRUE;
              fprintf(fp,"  ** declaration, pointers 2.8.1.3-11.1 class 1 fail exit return code : %d%d %f%f %d%d %f%f\n",res1, cat[i].ca, res2, cat[i].cb, res3, key[i].ca,res4, key[i].cb );
              printf("  ** declaration, pointers 2.8.1.3-11.1 class 1 fail exit return code : %d%d %f%f %d%d %f%f\n",res1, cat[i].ca, res2, cat[i].cb, res3, key[i].ca,res4, key[i].cb );
            }
       }
}
/*  Test 12  -  unions */
{
   union category {
              int ca;
              float cb;
   } cat[2];
 
   union category key[2];
   union category *ptr[2];
 
   int res1, res3;
   float res2, res4;
 
   ptr[0] = cat;          /* ptr[0] = address of cat[0] */
   ptr[1] = key;          /* ptr[1] = address of key[0] */
 
   /* assign values to the members of the unions      */
 
   cat[0].ca = 1;
   cat[1].cb = 2.0;
   key[0].ca = 3;
   key[1].cb = 4;
 
   res1 = (ptr[0])->ca;
   res2 = (ptr[0] + 1)->cb;
   res3 = (ptr[1])->ca;
   res4 = (ptr[1] + 1)->cb;
 
    if ( res1 != cat[0].ca || res2 != cat[1].cb ||
         res3 != key[0].ca || res4 != key[1].cb )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, pointers 2.8.1.3-12.1 class 1 fail exit return code : %d%d %f%f %d%d %f%f\n",res1, cat[0].ca, res2, cat[1].cb, res3, key[0].ca,res4, key[1].cb );
         printf("  ** declaration, pointers 2.8.1.3-12.1 class 1 fail exit return code : %d%d %f%f %d%d %f%f\n",res1, cat[0].ca, res2, cat[1].cb, res3, key[0].ca,res4, key[1].cb );
       }
}
 
   if (!fail) {
        fprintf(fp,"  .. declaration, pointer 2.8.1.3 class 1 pass\n");
        printf("  .. declaration, pointer 2.8.1.3 class 1 pass\n");
        }
        fclose(fp);
 
}
