/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - Pointer Reference                  */
/*                          Section  - 2.8                                   */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.2811.c                               */
/*  Revisions :             03/01/85    Sqa     Original UTX 1.2 Release     */
/*                                                                           */
/*  Date :                  3/8/85                                           */
/*  Descriptions :          For a pointer to all of the basic types, arrays  */
/*                          structures and unions:                           */
/*                          Verify that a declaration of a pointer for each  */
/*                          type allocates space correctly for the pointer.  */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.28.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
int                 a, *pa;
short               b, *pb;
short int           c, *pc;
long                d, *pd;
long int            e, *pe;
float               f, *pf;
long float          g, *pg;
double              h, *ph;
char                i, *pi;
unsigned            j, *pj;
unsigned int        k, *pk;
unsigned short      l, *pl;
unsigned short int  m, *pm;
unsigned long       n, *pn;
unsigned long int   o, *po;
unsigned char       p, *pp;
 
int one[10], *pone;
char two[5][5], *ptwo;
 
struct {
        int   aaa;
        short bbb;
        short ccc;
} three, *pthree;
 
union {
        float  i;
        double j;
} four, *pfour;
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
/*  Test 1  -  verify that space is allocated correctly by taking the
               sizeof the pointer variable.
*/
    if ( sizeof(*pa) != 4  || sizeof(*pb) != 2 || sizeof(*pc) != 2 ||
         sizeof(*pd) != 4  || sizeof(*pe) != 4 || sizeof(*pf) != 4 ||
         sizeof(*pg) != 8  || sizeof(*ph) != 8 || sizeof(*pi) != 1 ||
         sizeof(*pj) != 4  || sizeof(*pk) != 4 || sizeof(*pl) != 2 ||
         sizeof(*pm) != 2  || sizeof(*pn) != 4 || sizeof(*po) != 4 ||
         sizeof(*pp) != 1  || sizeof(*pone) != 4 || sizeof(*ptwo) != 1 ||
         sizeof(*pthree) != 8 || sizeof(*pfour) != 8 )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, pointer 2.8.1.1-1 class 1 fail\
             - exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",
            sizeof(*pa),sizeof(*pb),sizeof(*pc),
            sizeof(*pd),sizeof(*pe),sizeof(*pf),
            sizeof(*pg),sizeof(*ph),sizeof(*pi),
            sizeof(*pj),sizeof(*pk),sizeof(*pl),
            sizeof(*pm),sizeof(*pn),sizeof(*po),
            sizeof(*pp),sizeof(*pone),sizeof(*ptwo),
            sizeof(*pthree),sizeof(*pfour) );
            
         printf("  ** declaration, pointer 2.8.1.1-1 class 1 fail\
             - exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",
            sizeof(*pa),sizeof(*pb),sizeof(*pc),
            sizeof(*pd),sizeof(*pe),sizeof(*pf),
            sizeof(*pg),sizeof(*ph),sizeof(*pi),
            sizeof(*pj),sizeof(*pk),sizeof(*pl),
            sizeof(*pm),sizeof(*pn),sizeof(*po),
            sizeof(*pp),sizeof(*pone),sizeof(*ptwo),
            sizeof(*pthree),sizeof(*pfour) );
 
       }     
       
        
   if (!fail){
        fprintf(fp,"  .. declaration, pointer 2.8.1.1 class 1 pass\n");
        printf("  .. declaration, pointer 2.8.1.1 class 1 pass\n");
        }
        fclose(fp);
 
}
