/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - Type declarations                  */
/*                          Section  - 2.7                                   */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.272.c                                */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*                          07/12/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Added tests 2 and 3.                          */
/*                          02/27/85    T. Aleksa     UTX-32 1.2 Release     */
/*                          -- Added additional variable types.              */
/*                                                                           */
/*  Date :                  3/8/85                                           */
/*  Descriptions :          Verify that variables declared using synonyms    */
/*                          are initialized correctly.                       */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.27.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
 
typedef char CHAR;
typedef char *PTR_CHAR;
typedef int INT;
typedef short SHORT;
typedef long LONG;
typedef short int SHORT_INT;
typedef long int LONG_INT;
 
typedef unsigned UNSIGNED;
typedef unsigned char UNSIGNED_CHAR;
typedef unsigned int UNSIGNED_INT;
typedef unsigned short UNSIGNED_SHORT;
typedef unsigned short int UNSIGNED_SHORT_INT;
typedef unsigned long UNSIGNED_LONG;
typedef unsigned long int UNSIGNED_LONG_INT;
 
typedef float FLOAT;
typedef long float LONG_FLOAT;
typedef double DOUBLE;
 
typedef int INT_SD_ARRAY [10];       /* int single dim. array of 10 elements  */
typedef float FLOAT_DD_ARRAY [4][3]; /* float double dim. array of 12 elements*/
 
typedef union yy { int class1;
                   char class2;
                   float class3;
                 } UNION;
 
typedef  struct xx { int proc_id;
                     int proc_status;
                     int proc_loc;
                   }STRUCT;
STRUCT task, task_id();
 
 
main()
{
FILE *fp;
 
  int     fail = 0;
/*  Test 2.7.2-1  -  verify that the variables declared using synonyms are
                     initialized correctly.
*/
{
    int a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u;
 
    CHAR ch = 'a';
    PTR_CHAR ptrch = "b";
    INT in = (-5);
    SHORT sh = 0xff;
    LONG  lg = 0xffff;
    SHORT_INT si = 25;
    LONG_INT li = 270;
 
    UNSIGNED un = 20;
    UNSIGNED_CHAR unch = 'c';
    UNSIGNED_INT unin = 1;
    UNSIGNED_SHORT unsh = 2;
    UNSIGNED_SHORT_INT unsi = 3;
    UNSIGNED_LONG unlg = 4;
    UNSIGNED_LONG_INT unli = 5;
 
    FLOAT fl = 6.0;
    LONG_FLOAT lfl = 7.0;
    DOUBLE db = 8.0;
 
    INT_SD_ARRAY sd;
    FLOAT_DD_ARRAY dd;
 
    UNION unio;
    STRUCT st;
 
    sd[3] = 9;
    dd[3][2] = 10.0;
    st.proc_id = 54;
    unio.class3 = 1.0;
 
/* OPEN FILE FOR RESULTS OF TEST ANALYSIS  */
 
fp=fopen("decl_res bloc=y","a");
    if ( ch != 'a'    || *ptrch != 'b' || in != (-5)       || sh != 0xff  ||
         lg != 0xffff || si != 25      || li != 270        || un != 20    ||
         unch != 'c'  || unin != 1     || unsh != 2        || unsi != 3   ||
         unlg != 4    || unli != 5     || fl != 6.0        || lfl != 7.0  ||
         db != 8.0    || sd[3] != 9    || dd[3][2] != 10.0 ||
         unio.class3 != 1.0 || st.proc_id != 54  )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, typedef 2.7.2-1 class 2 fail exit return code:%c%c%d%x%x%d%d%d%c%d%d%d%d%d%f%f%f%d%f%f%d\n",ch,*ptrch,in,sh,lg,si,li,un,unch,unin,unsh,unsi,unlg,unli,fl,lfl,db,sd[3],dd[3][2],unio.class3,st.proc_id);
         printf("  ** declaration, typedef 2.7.2-1 class 2 fail exit return code:%c%c%d%x%x%d%d%d%c%d%d%d%d%d%f%f%f%d%f%f%d\n",ch,*ptrch,in,sh,lg,si,li,un,unch,unin,unsh,unsi,unlg,unli,fl,lfl,db,sd[3],dd[3][2],unio.class3,st.proc_id);
       }
 
/*  Test 2.7.2-2  -  verify that variables declared using typedefs are the
                     correct size.
*/
    a = sizeof( ch );              /* char = 1 byte                     */
    b = sizeof( ptrch );           /* ptr to char = 4 bytes             */
    c = sizeof( in );              /* int = 4 bytes                     */
    d = sizeof( sh );              /* short = 2 bytes                   */
    e = sizeof( lg );              /* long = 4 bytes                    */
    f = sizeof( si );              /* short int = 2 bytes               */
    g = sizeof( li );              /* long int = 4 bytes                */
    h = sizeof( un );              /* unsigned = 4 bytes                */
    i = sizeof( unch );            /* unsigned char = 1 byte            */
    j = sizeof( unin );            /* unsigned int = 4 bytes            */
    k = sizeof( unsh );            /* unsigned short = 2 bytes          */
    l = sizeof( unsi );            /* unsigned short int = 2 bytes      */
    m = sizeof( unlg );            /* unsigned long = 4 bytes           */
    n = sizeof( unli );            /* unsigned long int = 4 bytes       */
    o = sizeof( fl );              /* float = 4 bytes                   */
    p = sizeof( lfl );             /* long float = 8 bytes              */
    q = sizeof( db );              /* double = 8 bytes                  */
    r = sizeof( sd );              /* 10 int = 40 bytes                 */
    s = sizeof( dd );              /* 12 float = 48 bytes               */
    t = sizeof( unio );            /* float - widest = 4 bytes          */
    u = sizeof( st );              /* 3 int = 12 bytes                  */
 
    if ( a != 1  || b != 4 || c != 4 || d != 2 || e != 4 || f != 2  ||
         g != 4  || h != 4 || i != 1 || j != 4 || k != 2 || l != 2  ||
         m != 4  || n != 4 || o != 4 || p != 8 || q != 8 || r != 40 ||
         s != 48 || t != 4 || u != 12  )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, typedef 2.7.2-2 class 2 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u );
         printf("  ** declaration, typedef 2.7.2-2 class 2 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u );
       }
}
 
/*  Test 2.7.2-3  -  verify that typedefs may be used in casts.
*/
{
  int a, b;
 
  if ( ( a = (UNSIGNED) 65000 > (UNSIGNED) 65535 )  ||
       ( b = (SHORT)  65535  ==  (SHORT) 65000   ) )
     { fail = TRUE;
       fprintf(fp,"  ** declaration, typedef 2.7.2-3 class 2 fail exit return code : %d%d\n", a, b );
       printf("  ** declaration, typedef 2.7.2-3 class 2 fail exit return code : %d%d\n", a, b );
     }
}
 
/*  Test 2.7.2-4  -  verify that structures declared using typedefs
                     can be passed and returned from functions.
*/
{
        task_id( &task );
 
        if ( task.proc_id != 135 || task.proc_status != 75 ||
             task.proc_loc != 217345  )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, typedef 2.7.2-4 class 2 fail exit return code : %d %d %d\n",task.proc_id, task.proc_status, task.proc_loc );
             printf("  ** declaration, typedef 2.7.2-4 class 2 fail exit return code : %d %d %d\n",task.proc_id, task.proc_status, task.proc_loc );
           }
}
   if (!fail){
        fprintf(fp,"  .. declaration, typedef 2.7.2 class 2 pass\n");
        printf("  .. declaration, typedef 2.7.2 class 2 pass\n");
        }
        fclose(fp);
 
}
 
STRUCT task_id( job )
STRUCT *job;
{
        job->proc_id = 135;
        job->proc_status = 75;
        job->proc_loc = 217345;
        return( *job );
}
