/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Enumerations                         */
/*                          Section  2.5                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.255.c                                */
/*  Revisions :             05/31/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that enumeration constants can be used    */
/*                          with relational and logical operators.           */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.25.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
/*  Syntax:     enum identifier { enum-list }
                enum identifier
                enum identifier { enum-list }
*/
 
enum test  { TRUE, FALSE };
enum test fail;
 
enum numbers { zero, one, two, three, four, five, six, seven, eight, nine };
 
main()
{
 
FILE *fp;
fp=fopen("decl_res bloc=y","a");
fail = FALSE;  /*  initialize enumeration constant to FALSE  */
 
if ( zero > one || two > three )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.5-1 class 3 fail exit return code : > op %d%d%d%d\n",zero, one, two, three );
     printf("  ** declaration, enumeration 2.5.5-1 class 3 fail exit return code : > op %d%d%d%d\n",zero, one, two, three );
   }
 
if ( four >= five || six >= seven || eight >= nine )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.5-2 class 3 fail exit return code : >= op %d%d%d%d%d%d\n",four, five, six, seven, eight, nine );
     printf("  ** declaration, enumeration 2.5.5-2 class 3 fail exit return code : >= op %d%d%d%d%d%d\n",four, five, six, seven, eight, nine );
   }
 
if ( nine != nine || zero != zero || one != one || two != two )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.5-3 class 3 fail exit return code : != op %d%d%d%d\n",nine, zero, one, two );
     printf("  ** declaration, enumeration 2.5.5-3 class 3 fail exit return code : != op %d%d%d%d\n",nine, zero, one, two );
   }
 
if ( six < five  &&  five < four )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.5-4 class 3 fail exit return code : < op %d%d%d\n",six, five, four );
     printf("  ** declaration, enumeration 2.5.5-4 class 3 fail exit return code : < op %d%d%d\n",six, five, four );
   }
 
if ( two <= three  &&  two <= one )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.5-5 class 3 fail exit return code : <= op %d%d%d\n",two, three, one );
     printf("  ** declaration, enumeration 2.5.5-5 class 3 fail exit return code : <= op %d%d%d\n",two, three, one );
   }
 
if ( seven == seven  &&  eight == nine  &&  zero == zero )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.5-6 class 3 fail exit return code : == op %d%d%d%d\n",seven, eight, nine, zero );
     printf("  ** declaration, enumeration 2.5.5-6 class 3 fail exit return code : == op %d%d%d%d\n",seven, eight, nine, zero );
   }
 
/*   Tests 7 and 8 were originally spr0014 written against UTX Release 1.0.
     Problem description:  When a program contains the type specifier enum
             followed by some type of enumeration structure, the compiler
             seems to recognize enum as a valid type specifier because no
             error is produced by having it in the program.  However, the
             structure defined by enum is not handled properly.
*/
{
enum ans { yes, no };
enum ans ANSWER;
 
        ANSWER = no;
        if ( ANSWER != no )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, enumeration 2.5.5-7 class 3 fail exit return code : %d\n", ANSWER );
             printf("  ** declaration, enumeration 2.5.5-7 class 3 fail exit return code : %d\n", ANSWER );
           }
 
        ANSWER = yes;
        if ( ANSWER != yes )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, enumeration 2.5.5-8 class 3 fail exit return code : %d\n", ANSWER );
             printf("  ** declaration, enumeration 2.5.5-8 class 3 fail exit return code : %d\n", ANSWER );
           }
}
 
if ( fail == FALSE ){
   fprintf(fp,"  .. declaration, enumeration 2.5.5 class 3 pass\n" );
   printf("  .. declaration, enumeration 2.5.5 class 3 pass\n" );
   }
   fclose(fp);
 
}
