/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Union Reference                      */
/*                          Section  2.4.3                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.2432.c                               */
/*  Revisions :             05/24/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that array members of a union can be      */
/*                          referenced.                                      */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
 
union key {
        int t1[2];
        short t2[3];
        long t3[4];
        unsigned t4[5];
        char t5[6];
        float t6[7];
        double t7[8];
} types;
 
main()
{
FILE *fp;
 
        int a, b;
        float c;
        double d;
 
fp=fopen("decl_res bloc=y","a");
/* Test 1 */
        types.t1[0] = 1;
        types.t1[1] = 1;
        if ( types.t1[0] != 1 || types.t1[1] != 1 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.2-1 class 2 fail exit return code : %d%d\n", types.t1[0], types.t1[1] );
             printf("  ** declaration, unions 2.4.3.2-1 class 2 fail exit return code : %d%d\n", types.t1[0], types.t1[1] );
           }
 
/* Test 2 */
        for ( a = 0; a < 3 ; types.t2[a] = a, a++ );
        for ( a = 0; a < 3 ; a++ )
              if ( types.t2[a] != a )
                 { fail = TRUE;
                   fprintf(fp,"  ** declaration, unions 2.4.3.2-2 class 2 fail exit return code : %d\n", types.t2[a] );
                   printf("  ** declaration, unions 2.4.3.2-2 class 2 fail exit return code : %d\n", types.t2[a] );
           }
 
/* Test 3 */
        for ( a = 0; a < 4 ; types.t3[a] = a, a++ );
        for ( a = 0; a < 4 ; a++ )
              if ( types.t3[a] != a )
                 { fail = TRUE;
                   fprintf(fp,"  ** declaration, unions 2.4.3.2-3 class 2 fail  exit return code : %d\n", types.t3[a] );
                   printf("  ** declaration, unions 2.4.3.2-3 class 2 fail  exit return code : %d\n", types.t3[a] );
           }
 
/* Test 4 */
        for ( a = 0; a < 5 ; types.t4[a] = a, a++ );
        for ( a = 0; a < 5 ; a++ )
              if ( types.t4[a] != a )
                 { fail = TRUE;
                   fprintf(fp,"  ** declaration, unions 2.4.3.2-4 class 2 fail  exit return code : %d\n", types.t4[a] );
                   printf("  ** declaration, unions 2.4.3.2-4 class 2 fail  exit return code : %d\n", types.t4[a] );
           }
 
/* Test 5 */
        for ( a = 0, b = 'a'; a < 6 ; types.t5[a] = b, a++, b++ );
        for ( a = 0, b = 'a'; a < 6 ; a++, b++ )
              if ( types.t5[a] != b )
                 { fail = TRUE;
                   fprintf(fp,"  ** declaration, unions 2.4.3.2-5 class 2 fail exit return code : %c\n", types.t5[a] );
                   printf("  ** declaration, unions 2.4.3.2-5 class 2 fail exit return code : %c\n", types.t5[a] );
           }
 
/* Test 6 */
        for ( a = 0, c = 1.0; a < 7 ; types.t6[a] = c, a++, c++ );
        for ( a = 0, c = 1.0; a < 7 ; a++, c++ )
              if ( types.t6[a] != c )
                 { fail = TRUE;
                   fprintf(fp,"  ** declaration, unions 2.4.3.2-6 class 2 fail exit return code : %f\n", types.t6[a] );
                   printf("  ** declaration, unions 2.4.3.2-6 class 2 fail exit return code : %f\n", types.t6[a] );
           }
 
/* Test 7 */
        for ( a = 0, d = 10.0; a < 8 ; types.t7[a] = d, a++, d += .5 );
        for ( a = 0, d = 10.0; a < 8 ; a++, d += .5 )
              if ( types.t7[a] != d )
                 { fail = TRUE;
                   fprintf(fp,"  ** declaration, unions 2.4.3.2-7 class 2 fail  exit return code : %f\n", types.t7[a] );
                   printf("  ** declaration, unions 2.4.3.2-7 class 2 fail  exit return code : %f\n", types.t7[a] );
           }
 
        if ( !fail ) {
           fprintf(fp,"  .. declaration, unions 2.4.3.2 class 2 pass\n");
           printf("  .. declaration, unions 2.4.3.2 class 2 pass\n");
           }
           fclose(fp);
 
}
