 
/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Unions                               */
/*                          Section  2.4.2                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/23/84                                          */
/*  Source File :           source/decl.2422.c                               */
/*  Revisions :             05/23/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that a static or external union that      */
/*                          is not explicitly initialized is initialized     */
/*                          to zero.                                         */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      Page 198 of "The C Programming Language" by Kernighan and Ritchie
        states that it is not permitted to initialize unions.  However,
        unions may be initialized by arbitrary expressions involving
        constants, and previously declared variables and functions.
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
 
union key {
      int key1;
      float key2;
      unsigned key3;
};
 
union key a;              /*  external union  */
static union key b;       /*  external static union  */
 
main()
{
FILE *fp;
 
static union key c;       /*  internal static union  */
 
fp=fopen("decl_res bloc=y","a");
        if ( a.key1 != 0 || b.key1 != 0 || c.key1 != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.2.2-1 class 1 fail exit return code : %d%d%d\n", a.key1, b.key1, c.key1 );
             printf("  ** declaration, unions 2.4.2.2-1 class 1 fail exit return code : %d%d%d\n", a.key1, b.key1, c.key1 );
           }
 
        if ( a.key2 != 0 || b.key2 != 0 || c.key2 != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.2.2-2 class 1 fail exit return code : %f%f%f\n", a.key2, b.key2, c.key2 );
             printf("  ** declaration, unions 2.4.2.2-2 class 1 fail exit return code : %f%f%f\n", a.key2, b.key2, c.key2 );
           }
 
        if ( a.key3 != 0 || b.key3 != 0 || c.key3 != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.2.2-3 class 1 fail exit return code : %d%d%d\n", a.key3, b.key3, c.key3 );
             printf("  ** declaration, unions 2.4.2.2-3 class 1 fail exit return code : %d%d%d\n", a.key3, b.key3, c.key3 );
           }
 
        if ( !fail ){
           fprintf(fp,"  .. declaration, unions 2.4.2.2 class 1 pass\n");
           printf("  .. declaration, unions 2.4.2.2 class 1 pass\n");
           }
           fclose(fp);
}
