/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - Unions                             */
/*                          Section  - 2.4                                   */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.2411.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Descriptions :          Verify that the amount of space allocated for a  */
/*                          union is the space requird for its largest member*/
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE 1
 
/* Unions */
#define    INT   01
#define    FLOAT 02
#define    CHAR  03
/* define each variable of the same size */
int   VSIZE = 4;
union u_tag {
              int ival;
              float fval;
              char *sval;
            } val;
 
/* define variables of different size */
int   DSIZE = 8;
union u_table {
              int ival;
              float fval;
              double dval;
              char *sval;
              } dval;
main()
{
 /* local variables used */
         int   u_type;
         int   error;
         int   fail;
 
         FILE *fp;
         fp=fopen("decl_res bloc=y","a");
         fail =0;
   if ( (error = sizeof(dval)) != DSIZE )
   {
      fail = TRUE;
      fprintf(fp,"  ** declaration, unions 2.4.1.1-1 class 1 fail exit return code : %d\n",error);
      printf("  ** declaration, unions 2.4.1.1-1 class 1 fail exit return code : %d\n",error);
   }
 
   if ( (error = sizeof(val)) != VSIZE )
   {
      fail = TRUE;
      fprintf(fp,"  ** declaration, unions 2.4.1.1-2 class 1 fail exit return code : %d\n",error);
      printf("  ** declaration, unions 2.4.1.1-2 class 1 fail exit return code : %d\n",error);
   }
 
   if (!fail){
      fprintf(fp,"  .. declaration, unions 2.4.1.1   class 1 pass\n");
      printf("  .. declaration, unions 2.4.1.1   class 1 pass\n");
      }
fclose(fp);
}
 
 
