/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Self Referential structure           */
/*                          Section - 2.2.2.1                                */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  3/15/84                                          */
/*  Source File :           source/decl.2221.c                               */
/*  Revisions :             10/18/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/08/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Modified structure assignments.               */
/*                                                                           */
/*  Description :           Verify that self-referential structure can be    */
/*                          referenced.                                      */
/*                          The compiler fails if the program does not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
        struct    date { int day;
                         int month;
                         int year;
                       };
        /* create a structure with different type */
        struct    person { char *name;
                           char *address;
                           long zipcode;
                           double salary;
                           struct date hiredate;
                           struct person *llink;
                           struct person *rlink;
                         } ;
 
        /* Instead of using UNIX subroutine malloc(memory allocator),
           we simply generate a record identically to "person"
           and setup the left and right link.
        */
        struct   dependent { char *name;
                           char *address;
                           long zipcode;
                           double salary;
                           struct  { int day, month, year;} hiredate;
                           struct person *llink;
                           struct person *rlink;
                         } ;
main()
{       FILE *fp;
       int result;
        struct person emp;
        struct dependent emp_dep;
        fp=fopen("decl_res bloc=y","a");
 
        /* initialize parent record */
        emp.name = "GENIUS";
        emp.hiredate.day = 1;
        emp.hiredate.month = 1;
        emp.hiredate.year = 83;
        emp.llink = &emp;                       /* simply points to himself */
 
        /* initialize dependent */
        emp_dep.name = "GENIUS's son";
        emp_dep.llink = &emp ;
        emp.rlink = (struct person * ) &emp_dep ;
 
        /* verify the result */
        if ( result = compare(emp.name,"GENIUS") )
                {
                fprintf(fp,"  ** declaration, structures 2.2.2.1-1 class 2 fail  exit return code : %d\n",result);
                printf("  ** declaration, structures 2.2.2.1-1 class 2 fail  exit return code : %d\n",result);
                }
        else
        if ( result = compare(emp.llink->name, "GENIUS") )
                {
                fprintf(fp,"  ** declaration, structures 2.2.2.1-2 class 2 fail  exit return code : %d\n",result);
                printf("  ** declaration, structures 2.2.2.1-2 class 2 fail  exit return code : %d\n",result);
                }
        else
        if ( result = compare(emp.rlink->name, "GENIUS's son") )
                {
                fprintf(fp,"  ** declaration, structures 2.2.2.1-3 class 2 fail  exit return code : %d\n",result);
                printf("  ** declaration, structures 2.2.2.1-3 class 2 fail  exit return code : %d\n",result);
                }
        else
        if ( result = compare(emp_dep.llink->name, "GENIUS") )
                {
                fprintf(fp,"  ** declaration, structures 2.2.2.1-4 class 2 fail  exit return code : %d\n",result);
                printf("  ** declaration, structures 2.2.2.1-4 class 2 fail  exit return code : %d\n",result);
                }
        else
        if ( (result = compare(emp_dep.llink->name, "genius")) == 0 )
                {
                fprintf(fp,"  ** declaration, structures 2.2.2.1-5 class 2 fail  exit return code : %d\n",result);
                printf("  ** declaration, structures 2.2.2.1-5 class 2 fail  exit return code : %d\n",result);
                }
 
        else
                {
                fprintf(fp,"  .. declaration, structures 2.2.2.1 class 2 pass\n");
                printf("  .. declaration, structures 2.2.2.1 class 2 pass\n");
                }
                fclose(fp);
 
}
 
compare(s1,s2)
char s1[],s2[];
{
        int i;
        i = 0;
        while ( s1[i] == s2[i] )
          if (s1[i++] == '\0')
                return (0);
        return ( s1[i] - s2[i] );
}
