/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1.6                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.5                                         */
/*  Date :                  8/15/85                                          */
/*  Source File :           source/decl.22162.c                              */
/*                                                                           */
/*  Revisions :             05/16/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          05/18/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Added internal static structure.              */
/*                          08/15/85    T. Aleksa     UTX-32 1.2 Release     */
/*                          -- test modified due to protect bit violation    */
/*                                                                           */
/*  Description :           For a structure that has a structure as a        */
/*                          member, verify  for static and external          */
/*                          structures that the members of the member        */
/*                          structure can be initialized and referenced.     */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      syntax          struct { type-specifier declarator;
                               struct { type-specifier declarator;
                                      }
                               struct { type-specifier declarator;
                                      }
                               }
 
                        struct { type-specifier declarator;
                               struct { type-specifier declarator;
                                      struct { type-specifier declarator;
                                             }
                                      }
                               }
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail = 0;
 
struct employee{
 
       int emp_no;
       struct name {
                char *last;
                char *first;
                char mi;
       }emp_name;
       struct addr {
                char *street;
                char *city;
                char *state;
                int zip;
        }emp_adr;
 
}emp_rec =  { 2001, "Doe", "John", 'A', "6901 West Sunrise Blvd",
              "Ft. Lauderdale", "FL",33313 };
 
static struct payroll {         /*  external static structure */
 
              int ss_number;
              struct salary {
                     float payrate;
                     struct deductions {
                            float fed;
                            float FICA;
                            float ins;
                     }emp_ded;
                     float hour_rate;
              }emp_salary;
 
}emp_pay  = { 137846901, 24000.00, 236.50, 172.50, 18.50, 12.50 };
 
struct employee *ptr;
 
main()
{
FILE *fp;
 
static struct other {           /* internal static structure */
              int phone;
              struct hiredate {
                     int mo;
                     int day;
                     int yr;
              }emp_hire;
              float vacation;
}emp_oth = { 5872900, 5, 18, 84, 40.0 };
fp=fopen("decl_res bloc=y","a");
        ptr = &emp_rec;
 
/* Test 1       -       Begin referencing external struct emp_rec.      */
 
        if ( emp_rec.emp_no != 2001 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-1 class 2 fail exit return code : %d\n", emp_rec.emp_no );
             printf("  ** declaration, structures 2.2.1.6.2-1 class 2 fail exit return code : %d\n", emp_rec.emp_no );
           }
 
/* Test 2 */
 
        if ( compare( ptr->emp_name.last, "Doe") )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-2 class 2 fail exit return code : %s\n", ptr->emp_name.last );
             printf("  ** declaration, structures 2.2.1.6.2-2 class 2 fail exit return code : %s\n", ptr->emp_name.last );
           }
 
/* Test 3 */
 
        if ( compare( ptr->emp_name.first, "John") )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-3 class 2 fail exit return code : %s\n", ptr->emp_name.first );
             printf("  ** declaration, structures 2.2.1.6.2-3 class 2 fail exit return code : %s\n", ptr->emp_name.first );
           }
 
/* Test 4 */
 
        if ( ptr->emp_name.mi != 'A' )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-4 class 2 fail exit return code : %c\n", ptr->emp_name.mi );
             printf("  ** declaration, structures 2.2.1.6.2-4 class 2 fail exit return code : %c\n", ptr->emp_name.mi );
           }
 
/* Test 5 */
 
        if ( compare( ptr->emp_adr.street, "6901 West Sunrise Blvd" ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-5 class 2 fail exit return code : %s\n", ptr->emp_adr.street );
             printf("  ** declaration, structures 2.2.1.6.2-5 class 2 fail exit return code : %s\n", ptr->emp_adr.street );
           }
 
/* Test 6 */
 
        if ( compare( ptr->emp_adr.city, "Ft. Lauderdale" ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-6 class 2 fail exit return code : %s\n", ptr->emp_adr.city );
             printf("  ** declaration, structures 2.2.1.6.2-6 class 2 fail exit return code : %s\n", ptr->emp_adr.city );
           }
 
/* Test 7 */
 
        if ( compare( ptr->emp_adr.state, "FL" ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-7 class 2 fail exit return code : %s\n", ptr->emp_adr.state );
             printf("  ** declaration, structures 2.2.1.6.2-7 class 2 fail exit return code : %s\n", ptr->emp_adr.state );
           }
 
/* Test 8 */
 
        if ( emp_rec.emp_adr.zip != 33313 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-8 class 2 fail exit return code : %d\n", emp_rec.emp_adr.zip );
             printf("  ** declaration, structures 2.2.1.6.2-8 class 2 fail exit return code : %d\n", emp_rec.emp_adr.zip );
           }
 
/* Test 9       -       Begin referencing external static structure emp_pay *\
 
        if ( emp_pay.ss_number != 137846901 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-9 class 2 fail exit return code : %d\n", emp_pay.ss_number );
             printf("  ** declaration, structures 2.2.1.6.2-9 class 2 fail exit return code : %d\n", emp_pay.ss_number );
           }
 
/* Test 10 */
 
        if ( emp_pay.emp_salary.payrate != 24000.00 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-10 class 2 fail exit return code : %f\n", emp_pay.emp_salary.payrate );
             printf("  ** declaration, structures 2.2.1.6.2-10 class 2 fail exit return code : %f\n", emp_pay.emp_salary.payrate );
           }
 
/* Test 11 */
 
        if ( emp_pay.emp_salary.emp_ded.fed != 236.50 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-11 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.fed );
             printf("  ** declaration, structures 2.2.1.6.2-11 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.fed );
           }
 
/* Test 12 */
 
        if ( emp_pay.emp_salary.emp_ded.FICA != 172.50 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-12 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.FICA);
             printf("  ** declaration, structures 2.2.1.6.2-12 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.FICA);
           }
 
/* Test 13 */
 
        if ( emp_pay.emp_salary.emp_ded.ins != 18.50 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-13 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.ins );
             printf("  ** declaration, structures 2.2.1.6.2-13 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.ins );
           }
 
/* Test 14 */
 
        if ( emp_pay.emp_salary.hour_rate != 12.50 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-14 class 2 fail exit return code : %f\n", emp_pay.emp_salary.hour_rate );
             printf("  ** declaration, structures 2.2.1.6.2-14 class 2 fail exit return code : %f\n", emp_pay.emp_salary.hour_rate );
           }
 
/* Test 15      -       Begin referencing internal static structure emp_oth  */
 
        if ( emp_oth.phone != 5872900 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-15 class 2 fail exit return code : %d\n", emp_oth.phone );
             printf("  ** declaration, structures 2.2.1.6.2-15 class 2 fail exit return code : %d\n", emp_oth.phone );
           }
 
 
/* Test 16  */
 
        if ( emp_oth.emp_hire.mo != 5 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-16 class 2 fail exit return code : %d\n", emp_oth.emp_hire.mo );
             printf("  ** declaration, structures 2.2.1.6.2-16 class 2 fail exit return code : %d\n", emp_oth.emp_hire.mo );
           }
 
/* Test 17  */
 
        if ( emp_oth.emp_hire.day != 18 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-17 class 2 fail exit return code : %d\n", emp_oth.emp_hire.day );
             printf("  ** declaration, structures 2.2.1.6.2-17 class 2 fail exit return code : %d\n", emp_oth.emp_hire.day );
           }
 
/* Test 18  */
 
        if ( emp_oth.emp_hire.yr != 84 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-18 class 2 fail exit return code : %d\n", emp_oth.emp_hire.yr );
             printf("  ** declaration, structures 2.2.1.6.2-18 class 2 fail exit return code : %d\n", emp_oth.emp_hire.yr );
           }
 
/* Test 19  */
 
        if ( emp_oth.vacation != 40.0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.2-19 class 2 fail exit return code : %f\n", emp_oth.vacation );
             printf("  ** declaration, structures 2.2.1.6.2-19 class 2 fail exit return code : %f\n", emp_oth.vacation );
           }
 
        if ( !fail ){
           fprintf(fp,"  .. declaration, structures 2.2.1.6.2 class 2 pass\n");
           printf("  .. declaration, structures 2.2.1.6.2 class 2 pass\n");
           }
           fclose(fp);
}
 
/*      COMPARE:  function - compare two given strings
                  inputs   - two strings, s1 and s2
                  outputs  - == 0, if s1 is equal to s2
                              > 0, if s1 is greater than s2
                              < 0, if s1 is less than s2
*/
 
compare( s1, s2 )
 
char *s1, *s2;
{
        for( ; *s1 == *s2 ; s1++, s2++ )
           if ( *s1 == '\0' )
              return 0;
        return( *s1 - *s2 );
}
