/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.3                                */
/*  Product and Revision :  Unix 1.5                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  8/15/85                                          */
/*  Source File :           source/decl.2213.c                               */
/*                                                                           */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          05/14/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added type short int, long int, unsigned int  */
/*                             unsigned short, unsigned long, unsigned char, */
/*                             and long float.                               */
/*                          08/15/85    T. Aleksa   UTX-32 1.2 Release       */
/*                          -- modified test due to protect bit violation    */
/*                                                                           */
/*  Description :           Verify that the basic types of int, unsigned,    */
/*                          short int, long int, char, float, and double     */
/*                          that are not explicitly initialized in external  */
/*                          and static structure declarations are initialized*/
/*                          to zero.                                         */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
#define FALSE 0
int fail ;
/* Test 1
        verify the syntax    struct { type-specifier declarator;
                                    }
                             struct { type-specifier declarator : const expr;
                                      type-specifier : const expr;
                                    }
*/
 
typedef  char  *typedef_name;
typedef  int   def_bit;
static struct key {
             char *keyword ;
             int   key1;
             short key2 ;
             long  key3 ;
             unsigned key4 ;
             float key5 ;
             double key6 ;
             short int key7 ;
             long int key8 ;
             unsigned int key9 ;
             unsigned short key10 ;
             unsigned long key11 ;
             unsigned char key12 ;
             long float key13 ;
             typedef_name keyline ;
             struct field {
                           def_bit bit : 1;     /* used typedef definition */
                           def_bit     : 1;
                          };
           } table[1];
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
fail = FALSE;
     if ( table->key1 !=  0 || table->key2 != 0 ||
          table->key3 !=  0 || table->key4 != 0 ||
          table->key5 !=  0 || table->key6 != 0 ||
          table->key7 !=  0 || table->key8 != 0 ||
          table->key9 !=  0 || table->key10 != 0 ||
          table->key11 != 0 || table->key12 != 0 ||
          table->key13 != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.3-1 class 1 fail exit return code : %d\n",table->key1);
          printf("  ** declaration, structures 2.2.1.3-1 class 1 fail exit return code : %d\n",table->key1);
        }
     if ( table->keyword != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.3-2 class 1 fail exit return code : %d\n",table->keyword);
          printf("  ** declaration, structures 2.2.1.3-2 class 1 fail exit return code : %d\n",table->keyword);
        }
     if ( table->keyline != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.3-3 class 1 fail exit return code : %d\n",table->keyline);
          printf("  ** declaration, structures 2.2.1.3-3 class 1 fail exit return code : %d\n",table->keyline);
        }
 
if (!fail)
        fprintf(fp,"  .. declaration, structures 2.2.1.3 class 1 pass\n");
        printf("  .. declaration, structures 2.2.1.3 class 1 pass\n");
        fclose(fp);
 
}
