/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration, Initialization, and Variable Ref.   */
/*                          Section - Basic type 2.1                         */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  11/26/84                                         */
/*  Source File :           source/decl.212.c                                */
/*                                                                           */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*                          05/14/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added types long int, unsigned short,         */
/*                             unsigned long, unsigned char, long float.     */
/*                          07/11/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added variables of type register.             */
/*                                                                           */
/*  Description :           Verify that int, unsigned, short int, long int,  */
/*                          char, float, and double can be declared and      */
/*                          and initialized.                                 */
/*                          The compiler fails if this program cannot compile*/
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.21.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
 
#include <stdio.h>
 
#define TRUE 1
int fail;
 
main()
{    FILE *fp;
   int a=1, b=2, c=3, d=4, e=5, f=6, g=7, h=8;
    short int x=1;
    short    xx=2;
    long     yy=0xffffl;
    unsigned int z=0xffffl;
    unsigned     zz=0xffffl;
    char ch='\0';
    float    fl=123.5 ;
    double   dd=0xffffffff;
    long int li=0xffffffffl;
    unsigned short us=1234;
    unsigned long  ul=5678;
    unsigned char  uc='a';
    long float     lf=0xffffffffl;
    register rr=1234;
    register int ri=4567;
    register short rs=0xffff;
    register short int rsi=0xffff;
    register long rl=0xffffffff;
    register long int rli=0xfff00ff;
    fp=fopen("decl_res bloc=y","a");
 
    if ( a != 1 || b != 2 || c != 3 || d != 4 ||
         e != 5 || f != 6 || g != 7 || h != 8  )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, basic types 2.1.2-1 class 1 fail exit return code: %d%d%d%d%d%d%d%d\n", a,b,c,d,e,f,g,h );
         printf("  ** declaration, basic types 2.1.2-1 class 1 fail exit return code: %d%d%d%d%d%d%d%d\n", a,b,c,d,e,f,g,h );
       }
 
    if ( x != 1 || xx != 2 || yy != 0xffffl ||
         z != 0xffffl || zz != 0xffffl || ch != '\0' )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, basic types 2.1.2-2 class 1 fail exit return code : %d%d%x%x%x%c\n", x,xx,yy,z,zz,ch );
         printf("  ** declaration, basic types 2.1.2-2 class 1 fail exit return code : %d%d%x%x%x%c\n", x,xx,yy,z,zz,ch );
       }
 
    if ( fl != 123.5 || dd != 0xffffffff || li != 0xffffffffl ||
         us != 1234 || ul != 5678 || uc != 'a' || lf != 0xffffffffl )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, basic typs 2.1.2-3 class 1 fail exit return code : %f %f %d %d %d %c %f\n",fl, dd, li, us, ul, uc, lf );
         printf("  ** declaration, basic typs 2.1.2-3 class 1 fail exit return code : %f %f %d %d %d %c %f\n",fl, dd, li, us, ul, uc, lf );
       }
 
    if ( !fail )
       fprintf(fp,"  .. declaration, basic types 2.1.2 class 1 pass\n");
       printf("  .. declaration, basic types 2.1.2 class 1 pass\n");
       fclose(fp);
}
 
