/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*	@(#) (Gould) $Header: struct.h,v 5.2 88/08/30 01:11:27 pcc Released $		  */

/*
* Gould Base Register Assembler
*/

/* added defines */
/* POOL	makes as which builds a constant pool on a per .o file basis; each
 *	constant occurs once only in the pool
 * LDPOOL makes as which build a local pool for address constants dependent
 *	on local symbols and cooperates with ld to build a constant pool at
 *	link time for absolute constants and address constants dependent on
 *	globals
 * SPAN makes as which retains in the symbol table local symbols defined in
 *	data or bss and beginning with 'L' (even if -L option is not specified);
 *	this is so that correct object sizes can be calculated by the "span"
 *	capability added to ld
 * MODULAR_ADDRESS_ARITHMETIC makes as which does address calculations for the
 *	emitted .o file by two's complement arithmetic modulo either 2^19 or
 *	2^24 as is appropriate
 * REP_COUNT adds to as functionality that of a repeat count in data initial-
 *	ization (for the convenience of Fortran); syntax is: <e1>@<e2>
*/

#ifdef LDPOOL
#ifndef POOL
#define POOL 1
#endif POOL
#endif LDPOOL

typedef unsigned char Tuchar;	/* this is cheaper than char on Gould */

#ifdef GOTENUM
/* NOTE: ordering in enum SEGS and ordering of struct seginf */
/*	initialization in aout.c must correspond */
enum SEGS
{
#ifdef POOL
    S_text, S_data, S_bss,
    S_Lconstant, S_Dconstant, S_Wconstant, S_Xconstant, S_Hconstant, 
#else not POOL
    S_text, S_data, S_bss, S_constant,
#endif POOL
    S_fartext, S_fardata, S_farbss,
#ifdef DYN_BASE
    S_tex2, S_ftex2,
#endif DYN_BASE
    S_dat2, S_fdat2,
    last_SEGS			/* this value MUST be the last */
};
#else NOT GOTENUM

#define enum
typedef int SEGS;
#define S_text	0
#define S_data	1
#define S_bss	2
#ifdef POOL
#define S_Lconstant 3
#define S_Dconstant 4
#define S_Wconstant 5
#define S_Xconstant 6
#define S_Hconstant 7
#define S_fartext 8
#define S_fardata 9
#define S_farbss 10
#ifdef DYN_BASE
#define S_tex2	11
#define S_ftex2	12
#define S_dat2	13
#define S_fdat2	14
#define last_SEGS 15
#else NOT DYN_BASE
#define S_dat2	11
#define S_fdat2	12
#define last_SEGS 13
#endif DYNBASE
#else not POOL
#define S_constant 3
#define S_fartext 4
#define S_fardata 5
#define S_farbss 6
#ifdef DYN_BASE
#define S_tex2	7
#define S_ftex2	8
#define S_dat2	9
#define S_fdat2	10
#define last_SEGS 11
#else NOT DYN_BASE
#define S_dat2	7
#define S_fdat2	8
#define last_SEGS 9
#endif DYN_BASE
#endif POOL
#endif GOTENUM

typedef struct Symbol SYM;
typedef struct seginfo Tseginf;

struct seginfo
{				/* information about each temp segment */
	int	 si_ntype;	/* loader's N_* code for this */
	Tuchar	*si_buf;	/* core buffer to hold segment being built */
	int	 si_size;	/* size of said core buffer */
	int	 si_dot;	/* location pointer during each pass */
	int	 si_offset;	/* offset of next empty cell */
	int	 si_start;	/* offset w.r.t. start of program */
#if defined(COFF)
	struct
	reloc	*si_relbuf;	/* start of relocation info */
	int	 si_nrel;	/* number of relocation data */
	SYM	*si_scnsymp;	/* pointer to section symbol */
	int	 si_scnnum;	/* section number of segment in object */
	int	 si_align;	/* maximum alignment requirement for segment */
#else A.OUT
	int	 si_rstart;	/* offset for relocation addresses */
	struct
	relocation_info *si_relbuf; /* start of relocation info */
	int	 si_nrel;	/* number of relocation data */
#endif COFF
};

extern Tseginf seginf[];
extern Tseginf *cur_seg;

/* symbol table definitions and extern declarations */
/* if this structure is changed, change the declaration */
/* (initialization) of tmpsym in aout.c */

struct Symbol
{
    Tuchar *sname;
    int	svalue;
    int	sflags;
    int s_id;
    SYM *s_taborder;
    enum SEGS sspace;
    SYM *snext;
};

/* sflags values (note similarity to a.out n_type) */
/* S_LOOKSTAB is used in the stab symbol lookup routine lookstab in sym.c */
/* S_BASE is used for the nlist n_other field, (post_pass2 in aout.c) */
/* also S_SHARE, S_UBDP, S_BDDP */
#define S_UNDF	0x0	/* note S_DEF == 0x100 */
#define S_EXT	0x1	/* set by .globl directive */
#define S_ABS	0x2
#define S_TEXT	0x4
#define S_DATA	0x8
#define S_BSS	0x10
#define S_COMM	0x20
#define S_CONST	0x40	/* symbol from a .set and not relocatable */
#define S_FAR	0x80	/* symbol is in a far space */
#define S_DEF	0x100	/* symbol has a defined value */
#define S_DECL	0x200	/* symbol has been declared (could be undefined) */
#define S_LABEL	0x400	/* symbol is a label */
#define S_STABDN	0x800	/* symbol is due to a .stab[dn] pseudo op */
#define S_STABS	0x1000	/* symbol is due to a .stabs pseudo op */
#define S_LOOKSTAB	0x2000	/* symbol has been referenced by lookstab */
#define S_BASE	0x4000	/* symbol has been relocated R_MEMREFINST */
#define S_PAD	0x8000	/* symbol is label padded past a NOP */
#define S_SHARE	0x10000 /* eligible for shared memory */
#define S_BDDP	0x20000 /* eligible for bounded DATAPOOL resolution */
#define S_UBDP	0x40000 /* eligible for DATAPOOL resolution */

extern SYM *defsym();
extern SYM *lookup();
extern SYM *dot;
extern SYM symtab[];

/*
*  NHASH defines number of chains within (hashed) symbol table.
*  (essentially the dimension of symtab)
*/
#define NHASH 256

/*
*  preallocation block sizes for symbol table and string table.
*  choose SYM_INCR to maximize number of symbol table structures
*  per disk block. choose MAX_STR = disk block size, although it has
*  other uses besides space allocation (size of inbuf and token).
*/
#define SYM_INCR 40
#define MAX_STR 4096

/* operand handler declarations and definitions */

struct      opcode
{
    char	*oname;		/* opcode mnemonic */
    short	ocode;		/* opcode (reg fields zeroed) for mem->reg */
    short	ocoderr;	/* opcode, reg->reg */
    short	ocoderm;	/* opcode, reg->mem */
    short	ocodeim;	/* opcode, immed->reg */
    short	olength;	/* byte, half, word, long operation */
				/* jump ops use olength for condition */
    short	otype;		/* addressing and operation type data */
    short	onopnd;		/* number of operands (UNKN if infinite) */
    int		o1data;		/* first pass processing rules */
    int		(*o2data) ();	/* second pass procedure */
};

/* olength values */
#define NONE 		0
#define BYTE 		1
#define HALF 		2
#define WORD		3
#define LONG		4

/* otype values - must be bit fields due to multi address mode ops */
#define O_CALLFCN 	0x0	/* essentially a place holder */
#define O_PSEUDO 	0x1	/* pseudo op */
#define O_REGREG	0x2	/* register source, register destination */
#define O_REGMEM	0x4	/* register source, memory destination */
#define O_MEMREG	0x8	/* memory source, register destination */
#define O_SHIFT		0x10
#define O_IMMED		0x20	/* immediate mode instruction exists */
#define O_IO		0x40
#define O_INTR		0x80

#define O_VAR		0x100	/* opcode has non-standard length */
#define	O_HALF		0x200	/* half word instruction alignment */
#define	O_WORD		0x400	/* full word instruction alignment */
#define O_RRHALF	0x800	/* O_WORD unless R,R, then O_HALF */

/* o1data values */
#define M 0x1		/* memory */
#define	R 0x2		/* anyregister */
#define	E 0x4		/* even register */
#define B 0x8		/* base register */
#define I 0x10		/* immediate */
#define A 0x20		/* any operand */

/* operand 1 thru 4 shifts in o1data */
#define O1(n) (n)
#define O2(n) |((n)<<8)
#define O3(n) |((n)<<16)
#define O4(n) |((n)<<24)

/* used in onopnd field for unknown number of operands */
#define UNKN	 	0xFFFF

extern int	pass;
extern int	far_flag;
extern int	lineno, nerrors;
extern int	dbflag;
extern int	lineflag;
extern int	L_labflag;
extern int	R_readflag;
extern Tuchar	inbuf[];
extern Tuchar	*yylinept;

typedef struct 
{
    enum SEGS bv_seg;		/* breg is w.r.t. value in this seg */
    int	bv_offset;		/* and is this offset in seg */
} bvalT;

extern bvalT bval[];		/* holds current base values */

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
