/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: strnum.c,v 5.2 88/08/30 01:11:24 pcc Released $";
#endif

/*
* convert a string to a number. support bases 8, 10 and 16
* the same way the c compiler does.
*/

#include "struct.h"
#include "operand.h"

static Tuchar     decode[] = "0123456789abcdefABCDEF";
Tuchar *strnum_end;

strnum (str, opnd)
Tuchar  *str;
OPND *opnd;
{
    register int val = 0;
    int    sign = 0, cvtbase = 10;
    char       *index ();
    register Tuchar	*ndx;
    register Tuchar *s;
    register int digit;

    s = (Tuchar *) str;

    while (*s == ' ' || *s == '\t') s++;
    if (*s == '-')      sign = 1,   s++;
    if (*s == '+')      sign = 0,   s++;
    if (*s == '0') {
	cvtbase = 8;		/* leading zero forces octal base */
	while (*s == '0')	    s++;
	switch (*s) {
	    case 't': 
	    case 'T': cvtbase = 10; s++; break;

	    case 'x': 
	    case 'X': cvtbase = 16; s++; break;

	    case 'o': 
	    case 'O': cvtbase = 8;  s++; break;
	}
    }
    for ( ; *s; s++) {
	if ((ndx = (Tuchar *) index (decode, *s)) == 0)
	    break;
	digit = ndx - (Tuchar *) decode;
	if (digit >= 16  )  digit -= 6;
	if (digit >= cvtbase)  break;
	val = val * cvtbase + digit;
    }
    strnum_end = (Tuchar *) s;

    if (sign)
	opnd->constval = (-val);
    else
	opnd->constval = val;
}

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
