/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*	@(#) (Gould) $Header: gramops.h,v 5.2 88/08/30 01:10:35 pcc Released $		  */

/*
* Gould Base Register Assembler
* Initial design & coding by D. J. Kopetzky 
*/

transreg(to, a, b)
OPND       *to, *a, *b;
{
    if (a -> haveseen & b -> haveseen & (AREG | BREG)) {
	error("reg or breg used twice in expression");
	return;
    }
    to -> haveseen = a -> haveseen | b -> haveseen;
    if (to -> haveseen & (AREG | BREG)) {
	if (to -> haveseen & ~(CONST | AREG | BREG)) {
	    error("bad operand with registers");
	    to -> haveseen = COMPLEX;
	}
	to -> regval = a -> regval | b -> regval;
	to -> baseval = a -> baseval | b -> baseval;
	return;
    }
    if (a -> haveseen & b -> haveseen & NAME) {
	to -> haveseen |= COMPLEX;
    }
    else {
	if (a -> haveseen & NAME) {
	    to -> symname = a -> symname;
	    to -> constval = a -> constval;
	}
	else
	    if (b -> haveseen & NAME) {
		to -> symname = b -> symname;
		to -> constval = b -> constval;
	    }
    }
}
OPND muldiv(a, o, b)
OPND       *a, *b;
{
    OPND        ans;
    ans = opzero;
    if (a -> haveseen != CONST || b -> haveseen != CONST) {
	error("op %c needs constant operands", o);
    }
    else
	switch (o) {

	    case '*': 
		ans.constval = a -> constval * b -> constval;
		break;
	    case '/': 
		ans.constval = a -> constval / b -> constval;
		break;
	    case '%': 
		ans.constval = a -> constval % b -> constval;
		break;
	    default: 
		error("muldiv");
	}
    return(ans);
}
OPND addsub(a, o, b)
register OPND       *a, *b;
register o;
{
    OPND        ans;
    int         i, j, k;

    ans = opzero;
    transreg(&ans, a, b);
    if (ans.haveseen & COMPLEX)
    {
	if (o == '-' && (a->haveseen & b->haveseen & NAME)
		&& (a->symname->sflags & b->symname->sflags & S_DEF)
		&& (a->symname->sspace == b->symname->sspace)) {
			ans.haveseen = CONST;
			ans.constval = a->constval + a->symname->svalue
					 - b->constval - b->symname->svalue;
			ans.symname = (SYM *) 0;
	}
	return(ans);
    }
 /* 
  * accepted combinations N == NAME or NAME+CONST
  * R = general register  B = base register
  * N +- C	C + N
  * R + B	B + R
  * C op C
  */
    if (a -> haveseen & NAME)
    {
	if (o != '+' && o != '-')
	{
	    error("addsub: invalid operator, must be + or -");
	    goto out;
	}
	ans.constval += o == '+' ? b -> constval : -b -> constval;
#ifdef MODULAR_ADDRESS_ARITHMETIC
/* ld address arithmetic will be mod 2^24, with leftmost byte unchanged */
/* for externals, need to adjust for N - C case (C positive) */
	if (!(a->symname->sflags & S_DEF)
		&& (ans.constval & 0xff800000) == 0xff800000)
	    ans.constval += 0x01000000;
#endif MODULAR_ADDRESS_ARITHMETIC
	return(ans);
    }
    if (b -> haveseen & NAME)
    {
	if (o != '+')
	{
	    error("addsub: invalid operator, must be +");
	    goto out;
	}
	ans.constval += a -> constval;
#ifdef MODULAR_ADDRESS_ARITHMETIC
/* ld address arithmetic will be mod 2^24, with leftmost byte unchanged */
/* for externals, need to adjust for N - C case (C positive) */
	if (!(b->symname->sflags & S_DEF)
		&& (ans.constval & 0xff800000) == 0xff800000)
	    ans.constval += 0x01000000;
#endif MODULAR_ADDRESS_ARITHMETIC
	return( ans );
    }
    if( !(ans.haveseen & CONST))
    {
	if( o != '+' )
	{
	    error("addsub: invalid operator, must be +");
	}
	return( ans );
    }

    /* must have only constants at this point */
    if (a -> haveseen == b -> haveseen && a -> haveseen == CONST)
    {
	i = a -> constval;
	j = b -> constval;
    }
    else
    {
/* illegal expression, will get caught later, save an error message here */
	goto out;
    }

    switch (o) {

	case '-': 
	    k = i - j;
	    break;
	case '+': 
	    k = i + j;
	    break;
	case '^': 
	    k = i ^ j;
	    break;
	case '|': 
	    k = i | j;
	    break;
	case '<': 
	    k = i << j;
	    break;
	case '>': 
	    k = i >> j;
	    break;
	case '&': 
	    k = i & j;
	    break;
	default: 
	    error("Fatal assembler error (addsub parsing operator)");
	    exit(2);
    }

    ans.constval = k;

out: 
    return(ans);
}

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
