# /* makefile.m4 */
#
#	Makefile.m4 for AS
# (c) Copyright 1986 Gould Inc.
#
# @(#) (Gould) $Header: Makefile.m4,v 5.5 89/05/12 12:35:12 pcc Rel-3_0 $
#
#******************************************************************************
#
#	NOTE: This Makefile should be run through m4 to define MACHINE before
#	feeding it to make.  MACHINE is defined in a file called my_machine,
#	created by Makefile, which m4 will incorporate into this file.
#
#******************************************************************************
#
undefine(`index')
#
DESTDIR		=
BASEDIR		= $(DESTDIR)/usr/src/src/bin/as
INSTDIR		= $(DESTDIR)/bin
CC		= /bin/cc
HOST_CC		= /bin/cc
LD		= /bin/ld
HOST_LD		= /bin/ld
HOST_INC	=
INSTALL		= /usr/bin/install -c
LINT		= /usr/bin/lint
CTAGS		= /usr/ucb/ctags -w
CO		= co
OPT		= -O
PROGRAM		= gas

HDRS		= gramops.h operand.h ophash.h optab1.h \
		  parse.h struct.h y.tab.h

SRCS		= aout.c main.c opcode.c ophash.c pass.c pass2.c \
		  pseudo.c stab.c strnum.c sym.c yylex.c gram.y \
		  builder.c makevers.c

OBJS		= aout.o gram.o main.o opcode.o ophash.o pass.o pass2.o\
		  pseudo.o stab.o strnum.o sym.o yylex.o
#
include(my_machine)
undefine(`include')

$(PROGRAM):	optable.h $(OBJS) makevers
	rm -f vers.c
	./makevers > vers.c
	$(CC) $(CFLAGS) $(DFLAGS) -o $(PROGRAM) vers.c $(OBJS)

install: 
	$(INSTALL) $(PROGRAM) $(INSTDIR)

exclean:
	rm -f $(PROGRAM)

clean:	exclean
	rm -f *.o core builder makevers collision optable.h vers.c

builder:	ophash.h ophash.c optab1.h builder.c
	$(HOST_CC) $(CFLAGS) -c ophash.c
	$(HOST_CC) $(CFLAGS) -o builder ophash.o builder.c
	rm -f ophash.o

test:	ophash.h ophash.c optab1.h builder.c
	$(CC) $(CFLAGS) -DTEST -c ophash.c
	$(CC) $(CFLAGS) -DTEST -o tester ophash.o builder.c
	tester > hashtest

optable.h:	optab1.h builder
	rm -f collision
	builder -p optable.h > collision

makevers:	makevers.c
	$(HOST_CC) -o makevers makevers.c

lint:
	$(LINT) $(CFLAGS) $(DFLAGS) $(SRCS) 2>1 > Errfile

tags:	index

index:
	$(CTAGS) $(SRCS) $(HDRS)

depend:
	make HOST_CC="$(HOST_CC)" CFLAGS="$(CFLAGS)" DFLAGS=("$(DFLAGS)" optable.h
	$(CC) -M $(CFLAGS) $(DFLAGS) $(SRCS) > makedep
	cp Makefile.m4 Makefile.m4.bak
	echo >> Makefile.m4
	echo '# DO NOT DELETE THIS LINE -- DEPENDENCIES START HERE' \
	   >> Makefile.m4
	echo >> Makefile.m4
	cat makedep >> Makefile.m4
	rm -f makedep

base:;		-mkdir $(BASEDIR)
		for i in $(SRCS) $(HDRS) Makefile Makefile.m4 Mach_types; do \
		$(CO) $(COFLAGS) -p$(REV) RCS/$$i,v > $(BASEDIR)/$$i; \
		done
