/*
 * 	(c) Copyright 1986, 1987, 1988 Gould Inc.
 * 	    All Rights Reserved.
 */

#ifndef EXEC_H
#define EXEC_H
#if defined(RCSID) && !defined(lint)
static char *include_exec_hrcsid = "@(#) (Gould) $Header: exec.h,v 1.3 88/04/11 15:31:02 mholder Exp $";
#endif /* RCSID */

#ifdef COFF

/* ------------------------------------------------------------- */    
/* -------           Gould  COFF file header.             ------ */
/* ------------------------------------------------------------- */
    
typedef struct filehdr
{
	long 		f_magic;	/* magic number */
	long 		f_nscns;	/* number of sections */
	long		f_timdat;	/* time & date stamp */
	long		f_symptr;	/* file pointer to symtab */
	long		f_nsyms;	/* number of symtab entries */
	long 		f_opthdr;	/* sizeof(optional hdr) */
	unsigned	f_flags;	/* flags */
	long		f_entry;	/* entry point */
} FILHDR;

#define	FILHSZ	(sizeof(FILHDR))

#define f_pad f_entry			/* backward compatibility */

/*
 * Bits for f_flags
 */

#define  F_RELFLG	0x00000001 /* relocation info stripped from file */
#define  F_EXEC		0x00000002 /* file is executable (i.e. no 
				      unresolved externel references)	 */
#define  F_LNNO		0x00000004 /* line nunbers stripped from file	 */
#define  F_LSYMS	0x00000008 /* local symbols stripped from file	 */
#define  F_MINMAL	0x00000010 /* this is a minimal object file (".m")
				      output of fextract                 */
#define  F_UPDATE	0x00000020 /* this is a fully bound update file,
				      output of ogen			 */
#define  F_SWABD	0x00000040 /* this file has had its bytes swabbed
				      (in names)		         */
#define  F_AR16WR	0x00000080 /* this file has the byte ordering of
				      an AR16WR machine (e.g. 11/70)	 */
#define  F_AR32WR	0x00000100 /* this file has the byte ordering of
				      an AR32WR machine (e.g. vax)	 */
#define  F_AR32W	0x00000200 /* this file has the byte ordering of
				      an AR32W machine (e.g. gould,
				      3b, maxi)                          */
#define  F_PATCH	0x00000400 /* file contains "patch" list in
				      optional header			 */
#define  F_EDBX		0x00000800 /* file uses BSD symbol table format 
				      and supports the dbx symbolic 
				      debugger                           */
#define  F_DPOBJ	0x00001000 /* data pool object			 */
#define  F_MPXSHIM	0x00002000 /* shared image support		 */
#define  F_LOCKDOWN	0x00004000 /* object is not swappable		 */
#define  F_SHARED	0x00008000 /* object's text is shared		 */
#define  F_DEMAND	0x00010000 /* object is demand pages		 */
#define  F_OVRLY	0x00020000 /* object is in overlay format	 */
#define  F_ADA		0x00040000 /* object is ADA compiler output	 */


/* ------------------------------------------------------------- */    
/* ----------       Gould COFF optional headers       ---------- */
/* ------------------------------------------------------------- */    


/*
 * Aouthdr optionally enclosed in each NP1 COFF file.
 * If on a NP1 machine, the structure is called exec.
 * If on a Powernode, it is renamed np1_opthdr to notify an unsuspecting
 * user that the structure content is different from the exec structure
 * of a a.out file.
 * This is because Powernode supports both coff and a.out format executables.
 */

#ifdef GOULD_NP1
typedef	struct exec
#else
typedef struct np1_opthdr
#endif /* GOULD_NP1 */
{
	long	a_magic;	/* magic number */
	long	a_text;		/* size of text segment */
	long	a_data;		/* size of initialized data */
	long	a_bss;		/* size of uninitialized data */
	long	a_syms;		/* size of symbol table */
	long	a_stsize;	/* size of string table */
	long	a_entry;	/* entry point */
	long	a_txbase;	/* load address of text */
	long	a_dtbase;	/* load address of data */
	long	a_mstamp;	/* target machine stamp */
	long	a_sstamp;	/* target operating system stamp */
	long	a_cstamp;	/* compatibility stamp */
}	
#ifdef GOULD_NP1
AOUTHDR;
#define AOUTHSZ (sizeof(AOUTHDR))
#else
NP1_OPTHDR;
#define NP1_OPTHSZ (sizeof(NP1_OPTHDR))
#endif /* GOULD_NP1 */

#endif /* COFF */

/*
 * Header prepended to each a_out file
 * For coff, the structure has been renamed old_exec to make sure that
 * all the code that refers to the exec structure is corrected to work
 * with coff format executables.
 */

#ifndef COFF
typedef struct exec
#else /* COFF */
typedef struct old_exec
#endif /* NOT COFF */
{
	long		a_magic;	/* magic number */
	unsigned	a_text;		/* size of text segment */
	unsigned	a_data;		/* size of initialized data */
	unsigned	a_bss;		/* size of uninitialized data */
	unsigned	a_syms;		/* size of symbol table */
	unsigned	a_entry;	/* entry point */
	unsigned	a_trsize;	/* size of text relocation */
	unsigned	a_drsize;	/* size of data relocation */
	unsigned	a_stsize;	/* size of string table */
	unsigned	a_txbase;	/* load address of text,
					   determines stack size */
	unsigned	a_nbtext;	/* size of "far" part of text */
	unsigned	a_nbdata;	/* size of "far" part of data */
	unsigned	a_nbbss;	/* size of "far" part of bss */
	unsigned	a_tstamp;	/* time and date stamp */
	unsigned	a_mstamp;	/* target machine stamp */
	unsigned	a_sstamp;	/* target operating system stamp */
	unsigned	a_ccvers;	/* oldest compiler version stamp */
	unsigned	a_asvers;	/* oldest assembler version stamp */
	unsigned	a_ldvers;	/* oldest loader version stamp */
}	
#ifndef COFF
AOUTHDR;
#define AOUTHSZ (sizeof(AOUTHDR))
#define a_cstamp a_asvers
#define a_dtbase a_ccvers
#else /* COFF */
OLD_AOUTHDR;
#define OLD_AOUTHSZ (sizeof(OLD_AOUTHDR))
#endif /* NOT COFF */

#ifdef GOULD_PN

/*
 * The following macro is used to copy the a.out header into the
 * u area. X is of type struct old_exec and y is of type exec_data 
 */

#define EXECTOU(x,y) \
	(y)->ux_tsize = (x)->a_text; \
	(y)->ux_dsize = (x)->a_data; \
	(y)->ux_bsize = (x)->a_bss; \
	(y)->ux_mag = (x)->a_magic; \
	(y)->ux_txtreg = (x)->a_txbase; \
	(y)->ux_entrloc = (x)->a_entry; \
	(y)->ux_syms = (x)->a_syms; \
	(y)->ux_stsize = (x)->a_stsize; \
	(y)->ux_mstamp = (x)->a_mstamp; \
	(y)->ux_sstamp = (x)->a_sstamp; \
	(y)->ux_tstamp = (x)->a_tstamp;

#endif /* GOULD_PN */

#ifdef COFF

/* ------------------------------------------------------------- */    
/* ----------       Gould  COFF section header        ---------- */
/* ------------------------------------------------------------- */    

typedef struct scnhdr
{
	unsigned
	char	s_name[8];	/* section name */
	long	s_paddr;	/* physical address, aliased s_nlib */
	long	s_vaddr;	/* virtual address */
	long	s_size;		/* section size */
	long	s_scnptr;	/* file ptr to raw data for section */
	long	s_relptr;	/* file ptr to relocation */
	long	s_lnnoptr;	/* file ptr to line numbers */
	long	s_nreloc;	/* number of relocation entries */
	long	s_nlnno;	/* number of line number entries */
	unsigned s_flags;	/* flags */
	long	s_align;	/* alignment power-of-two */
} SCNHDR;

#define	SCNHSZ	(sizeof(SCNHDR))

/*
 * the number of shared libraries in a .lib section in an absolute
 * output file is put in the s_paddr field of the .lib section header,
 * the following define allows it to be referenced as s_nlib.
 */

#define s_nlib	s_paddr

/*
 * Define constants for names of "special" sections.
 */

#define _TEXT 		".text"
#define _DATA 		".data"
#define _BSS  		".bss"
#define _CONST_L	".constl"
#define _CONST_D	".constd"
#define _CONST_W	".constw"
#define _CONST_X	".constx"
#define _CONST_H	".consth"
#define _FARTEXT 	".nbtext"
#define _FARDATA 	".nbdata"
#define _FARBSS  	".nbbss"
#define _SHMEM  	".shmem"
#define _GCOMMON  	".gcommon"
#define _NDPOOL  	".ndpool"
#define _REGION  	".region"

/*
 * Bits for s_flags.
 */

#define STYP_REG	0x00000000	/* "regular" section:
					   allocated, relocated, loaded    */
#define STYP_DSECT	0x00000001	/* "dummy" section:
					   not allocated, relocated,
					   not loaded                      */
#define STYP_NOLOAD	0x00000002	/* "noload" section:
					   allocated, relocated,
					   not loaded                      */
#define STYP_GROUP	0x00000004	/* "grouped" section:
					   formed of input sections        */
#define STYP_PAD	0x00000008	/* "padding" section:
					   not allocated, not relocated,
					   loaded                          */
#define STYP_COPY	0x00000010	/* "copy" section:
					   for decision function used
					   by field update;  not
					   allocated, not relocated,
					   loaded;  reloc & lineno
					   entries processed normally      */
#define	STYP_TEXT	0x00000020	/* section contains text only      */
#define STYP_DATA	0x00000040	/* section contains data only      */
#define STYP_BSS	0x00000080	/* section contains bss only       */
#define STYP_INFO	0x00000200	/* comment section : not allocated
					   not relocated, not loaded       */
#define STYP_OVER	0x00000400	/* overlay section : relocated
					   not allocated or loaded         */
#define STYP_LIB	0x00000800	/* for .lib section : same as INFO */
#define STYP_FAR        0x00001000	/* far modifier                    */
#define STYP_CONST      0x00002000	/* constant section                */
#define STYP_GCOMMON	0x00004000	/* global common section           */
#define STYP_NDPOOL	0x00008000	/* datapool section                */
#define STYP_REGION	0x00010000	/* named memory region section     */
#define STYP_SHMEM	0x00020000	/* shared memory section           */

#ifdef GOULD_PN

/* 
 * This mask is used to determine the type of a section
 */
#define VALID_STYP_MASK (STYP_TEXT|STYP_DATA|STYP_BSS|STYP_REGION \
			|STYP_SHMEM|STYP_GCOMMON|STYP_NDPOOL)

/*
 * section types that have initializing data with them
 */

#define	STYP_INITDAT	(STYP_TEXT|STYP_DATA|STYP_NDPOOL|STYP_GCOMMON)

/*
 * sections which must be present to exec an image 
 */

#define	STYP_BASE	(STYP_TEXT|STYP_DATA|STYP_BSS)

/* ------------------------------------------------------------- */    
/* ---------- Exec specific Shared Memory Region Info ---------- */
/* ------------------------------------------------------------- */

/*
 * The raw data section of a .shmem or .region section consists
 * of a name_entry structure (one name per section). The ne_name
 * element is actually of arbitrary length and is terminated by a
 * null byte.
 */

typedef struct name_entry
{
	short	ne_length;	/* length of the entry */
	short	ne_offset;	/* offset from start of entry */
				/*  to the name */
	long	ne_region_size;	/* size of the shared memory or */
				/*  region segment */
	char	ne_name[1];	/* name of the segment to be attached */
				/*  or to be created */
} NAME_ENTRY;

/*
 * size of a name_entry exclusive of ne_name
 */

#define NE_SIZE 2*sizeof(short)+sizeof(long)

#define	MAXCOFFNAME	33		/* max shared mem name + 1 */
					/* SHOULD BE SAME AS MAXREGNAME */

/*
 * union for manipulating variable size region and shared memory names in 
 * COFF sections(see name_entry)
 */
union	coffname
{
	struct name_entry cn_ne;
	char cn_buf[MAXCOFFNAME+(sizeof (struct name_entry))-1];
};

#define	cn_length		cn_ne.ne_length
#define	cn_offset		cn_ne.ne_offset
#define	cn_region_size		cn_ne.ne_region_size
#define	cn_name			cn_ne.ne_name

#endif /* GOULD_PN */

#endif /* COFF */

/* ------------------------------------------------------------- */    
/* ----------              Magic Numbers              ---------- */
/* ------------------------------------------------------------- */    

#define	OMAGIC		0x107		/* old impure format       */
#define	NMAGIC		0x108		/* read-only text          */
#define	ZMAGIC		0x10b		/* demand load format      */
#define	GNP1MAGIC	0x14d		/* NP1 COFF file           */
#define	GPNMAGIC	0x150    	/* PN COFF formatted File  */
#define	PN_COFF		GPNMAGIC 	/* Backward compatibility  */	
#define	GDPMAGIC	0x14e		/* COFF datapool dictionary
					   object                  */

#define ISCOFF(x)	(((x) >= 0x140) && ((x) < 0x180))

#ifdef COFF

#ifdef GOULD_PN

/*
 * SHMCHECK -- returns 1 if prev was a .region or a .shmem section
 *             and returns 0 otherwise
 *
 * struct scnhdr *prev, *current
 */
#define SHMCHECK(prev,current)	\
    (((((prev)->s_flags & STYP_REGION) || ((prev)->s_flags & STYP_SHMEM)) \
      && ((prev)->s_vaddr == (current)->s_vaddr)) ? 1: 0)

/*
 * DETERMINEMAGIC -- determines the magic number of the executable
 * based upong the F_SHARED and F_DEMAND flags in the coff filehdr
 *
 *      Type            F_SHARED      F_DEMAND
 *      OMAGIC	          0              0
 *      ERROR (BADMAGIC)  0              1
 *      NMAGIC	          1              0
 *      ZMAGIC	          1              1
 */

#define BADMAGIC	-1		/* Bad magic number returned by */
					/* DETERMINEMAGIC */

#define  DETERMINEMAGIC(flags) \
    ((((flags) & F_SHARED) && ((flags) & F_DEMAND)) ? ZMAGIC : 	    \
     (((flags) & F_SHARED) && (! ((flags) & F_DEMAND))) ? NMAGIC : \
     ((flags) & F_DEMAND) ? BADMAGIC : OMAGIC)

/*
 * NLOCALSECS -- the number of section headers which exec allocates
 *		 space for to be optimal.
 *		
 * MAXSECTIONS  -- the maximum number of COFF sections which
 *		  can be handled by exec
 */
#define	NLOCALSECS	50
#define	MAXSECTIONS 	1000

/*
 * Macros to check for the type of a coff file.
 * (OMAGIC, NMAGIX, ZMAGIC)
 *
 * Usage:
 * 
 * FILEHDR p;
 *
 * if( ISCOMAGIC(p) ){ do something }
 */

#define ISCOMAGIC(x) \
   ( ! (((x).f_flags) & F_DEMAND) && ! (((x).f_flags) & F_SHARED) )
#define ISCNMAGIC(x) \
   ( ! (((x).f_flags) & F_DEMAND) &&   (((x).f_flags) & F_SHARED) )
#define ISCZMAGIC(x) \
   (   (((x).f_flags) & F_DEMAND) &&   (((x).f_flags) & F_SHARED) )

#endif /* GOULD_PN */

#endif /* COFF */

/* ------------------------------------------------------------- */    
/* ----------               Relocation Info           ---------- */
/* ------------------------------------------------------------- */    

/*
 *      Format of a relocation entry
 */

#ifdef COFF

typedef struct reloc
{
	long	r_vaddr;	/* (virtual) address of reference */
	long	r_symndx;	/* index into symbol table */
	unsigned
	char	r_length;	/* relocation length */
	unsigned
	char	r_type;		/* relocation type */
} RELINFO;

#define relocation_info old_reloc

typedef struct old_reloc
{
	int	r_address;	/* address which is relocated */
	unsigned
		r_symbolnum:24,	/* local symbol ordinal */
		r_pcrel:1, 	/* relocated pc relative */
		r_length:2,	/* 0=8bits,1=16bits,2=32bits,3=64bits */
		r_extern:1,	/* value relative to sym referenced */
		r_type:4;	/*	0=const,
					1=addr literal,
					2=mem ref inst */
} OLD_RELINFO;

#define OLD_RELINFOSZ (sizeof(OLD_RELINFO))

#else /* NOT COFF */

typedef struct relocation_info
{
	int	r_address;	/* address which is relocated */
	unsigned
		r_symbolnum:24,	/* local symbol ordinal */
		r_pcrel:1, 	/* relocated pc relative */
		r_length:2,	/* 0=8bits,1=16bits,2=32bits,3=64bits */
		r_extern:1,	/* value relative to sym referenced */
		r_type:4;	/*	0=const,
					1=addr literal,
					2=mem ref inst */

} RELINFO;

#endif /* COFF */

#define RELINFOSZ (sizeof(RELINFO))

/*
 *   relocation lengths and types for Gould PowerNode & NP1.
 */

#define	R_BYTE		0
#define	R_HALFWORD	1
#define	R_WORD		2
#define	R_DOUBLEWORD	3

#define	R_CONST		0
#define	R_ADDRLITERAL	1
#define	R_MEMREFINST	2
#define R_HI_ADDR	3
#define R_LO_ADDR	4

#ifdef COFF

/* ------------------------------------------------------------- */    	
/* ----------           Line Number Info              ---------- */
/* ------------------------------------------------------------- */	

/*
 * Not currently used.
 * Defined now so we don't have to change this file again.
 */

typedef struct lineno
{
	union
	{
		long	l_symndx ;	/* sym. table index of function name
					   iff l_lnno == 0 */
		long	l_paddr ;	/* (physical) address of line number */
	}		l_addr ;
	unsigned short	l_lnno ;	/* line number */
} LINENO;

#define	LINESZ	sizeof(LINENO)

#endif /* COFF */

#endif /* EXEC_H */

/*
 * 	(c) Copyright 1986, 1987, 1988 Gould Inc.
 * 	    All Rights Reserved.
 */
