/* code.c */

# include "mfile1.h"
# include "a.out.h"
# include "stab.h"
int symopt;
#ifndef NBC
int handopt = 0;
#endif
#ifdef ONEPASS
prtree(p) register NODE *p;
{
 register struct symtab *q;
 register ty;
 ty = optype(p->in.op);
 fprintf(textfc,  "%d\t", p->in.op );
 if( ty == LTYPE ) {
  fprintf(textfc,  CONFMT, p->tn.lval );
  fprintf(textfc,  "\t" );
 }
 if( ty != BITYPE ) {
  if( p->in.op == NAME || p->in.op == ICON ) fprintf(textfc,  "0\t" );
  else fprintf(textfc,  "%d\t", p->tn.rval );
 }
 fprintf(textfc,  "%o\t", p->in.type );
 /* handle special cases */
 switch( p->in.op ){
 case NAME:
 case ICON:
  /* print external name */
  if( p->tn.rval == NONAME ) fprintf(textfc,  "\n" );
  else if( p->tn.rval >= 0 ){
   q = &stab[p->tn.rval];
   fprintf(textfc,  "%s\n", exname( q));
  }
  else { /* label */
   fprintf(textfc,  "L.%d\n", -p->tn.rval );
  }
  break;
 case STARG:
 case STASG:
 case STCALL:
 case UNARY STCALL:
  /* print out size */
  fprintf(textfc,  CONFMT, (CONSZ) tsize( STRTY, p->fn.csiz,
                                   p->fn.csiz ) );
  fprintf(textfc,  "\t%d\t\n", talign( STRTY, p->fn.csiz ) );
  break;
 default:
  fprintf(textfc,   "\n" );
 }
 if( ty != LTYPE ) prtree( p->in.left );
 if( ty == BITYPE ) prtree( p->in.right );
}
#endif
branch( n ){
 /* output a branch to label n */
 trparen();
 fprintf(textfc,  " bu L.%d\n", n );
}
defalign(n) {
 /* cause the alignment to become a multiple of n */
 n /= SZCHAR;
 if( curloc != PROG && n > 1 ){
  trparen();
  fprintf(textfc, " bound %d\n", n );
 }
}
locctr( l ){
 register temp;
 /* l is PROG, ADATA, DATA, STRNG, ISTRNG, or STAB */
 /*
  * locctr file section
  *
  * PROG textfc csect
  * DATA textfc dsect
  * ADATA textfc dsect
  * STRNG sdatafc dsect
  * ISTRNG sdatafc dsect
  * COMMON textfc common org
  */
 if(xdebug) {
  trparen();
  fprintf(textfc, "* locctr = %d\n", l);
 }
 if(l == curloc)
  return( l );
 switch( l ){
 case PROG:
  curfc = textfc;
  if(txsect != CSECT) {
   trparen();
#ifdef NBC
   fprintf(curfc, " csect\n");
#else
   if (handopt)
    fprintf(curfc, " dsect\n");
   else
    fprintf(curfc, " csect\n");
#endif
  }
  txsect = CSECT;
  break;
 case DATA:
 case ADATA:
  curfc = textfc;
  if(txsect != DSECT) {
   trparen();
   fprintf(curfc, " dsect\n");
  }
  txsect = DSECT;
  break;
 case STRNG:
 case ISTRNG:
  curfc = sdatafc;
  /*  We don't produce dsect directive here */
  /*  because sdatafc is always in dsect.    */
  /* Initial dsect directive produced in p1init(). */
  break;
 case COMMON:
  curfc = textfc;
  /* beginit()  prints the "org" statement */
#ifdef NBC
  txsect = COMMON;
#else
  if (txsect != DSECT) {
   trparen ();
   fprintf (curfc, " dsect\n");
  }
  txsect = DSECT;
#endif
  break;
 default:
  cerror( "illegal location counter" );
 }
 temp = curloc;
 curloc = l;
 return( temp );
}
#ifndef NBC
/*
**  output line of text from the source
*/
void
defloi(s)
char *s;
{
 fprintf(textfc, "* %s", s);
}

/* get a line of input.  called from scan.c   */

int
getloi ( s, lim )                    /*  right from the book.  */

char s [];
int lim;

{
 int c, i;

 for(i = 0; --lim > 0 && (c =getchar()) != EOF && (s[i++] = c) != '\n';);
 if ((s[i-1] == '\n') && (i > 1)) {
  while ((s[i-2] == ' ') && (i > 1)) --i;
   s[i-1] = '\n';
 }
 s [ i ] = '\0';
 return ( i );
}
#endif
deflab( n ){
 /* output something to define the current position as label n */
 trparen();
 fprintf(curfc, "L.%d equ $\n", n );
}
int crslab = 10;
getlab(){
 /* return a number usable for a label */
 return( ++crslab );
}
genswitch(p,n) struct sw *p;
{
 /* p points to an array of structures, each consisting
   of a constant value and a label.
   The first is >=0 if there is a default label;
   it's value is the label number
   The entries p[1] to p[n] are the nontrivial cases
   The switch value is in  r1.
   Registers r0, r2 are free.
   */
 register i, j;
 CONSZ shift;
 int table, dflt;
 dflt = p[0].slab >= 0 ? p[0].slab : brklab;
 /*
  * Jump table code must use indexing instead of indirection.
  * For now it is commented out until it can be rewritten.
  * All switch stmts will be generated the simple way.
  *
 * if(p[n].sval - p[1].sval <= 2*n && n >= 8){
  *  shift = p[1].sval;
  *  mkinstr("sui", "sumw", shift);
  *  trparen(); fprintf(textfc, " blt L.%d\n", dflt);
  *  mkinstr("ci", "camw", p[n].sval - shift);
  *  trparen(); fprintf(textfc, " bgt L.%d\n", dflt);
  *  table = getlab();
  *  trparen(); fprintf(textfc, " sll r1.,2\n");
  *  trparen(); fprintf(textfc, " bu *L.%d,r1.\n", table);
  *  locctr(STRNG);
  *  fprintf(curfc, " bound 4\n");
  *  deflab(table);
  *  for(j=0, i=1; i <= n; j++)
  *   fprintf(curfc, " dataw L.%d\n",
  *   (j == p[i].sval-shift)? p[i++].slab : dflt );

  *  locctr(PROG);
  *  return;
  * }
  */
 /* simple switch code */
 for( i=1; i<=n; ++i ){
  mkinstr("ci", "camw", p[i].sval);
  trparen();
  fprintf(textfc,  " beq L.%d\n", p[i].slab );
 }
 if( p->slab>=0 ) branch( p->slab );
}
mkinstr(forshrt, forlong, val)
char *forshrt, *forlong;
CONSZ val;
{
 if (ishalfcon( val )) {
  trparen();
  fprintf(textfc, " %s r0.,", forshrt);
 }
 else {
  trparen();
  fprintf(textfc, " %s r0.,=", forlong);
 }
 fprintf(textfc,  CONFMT, val );
 fprintf(textfc, "\n");
}
efcode(){
 /* code for the end of a function */
 register struct symtab *p;
 register TWORD t;
#ifdef ONEPASS
 lineid(lineno,ftitle);
#endif
 deflab( retlab );
 p = &stab[curftn];
 t = p->stype;
 t = DECREF(t);
 trparen();
 fprintf(textfc, " lf r2.,2w,sp.\n");
 trparen();
 fprintf(textfc, " trsw r2.\n");
#ifdef ONEPASS
 p2bend();
#endif
 freetstr(); /* Clean up temp strings */
}
bfcode( a, n ) int a[];
{
 /* code for the beginning of a function; a is an array of
   indices in stab for the arguments; n is the number */
 register i, temp;
 register struct symtab *p;
 OFFSZ off, toff;
 freetstr(); /* Clean up temp strings */
 locctr( PROG );
 defnam( &stab[curftn] );
 retlab = getlab();
 /* routine prolog */
#ifdef ONEPASS
 lineid(lineno,ftitle);
#endif
 trparen();
 fprintf(textfc, " trr sp.,r1.\n");
 trparen();
 fprintf(textfc, " admw sp.,off%d.\n", ftnno);
 trparen();
 fprintf(textfc, " std r0.,2w,sp.\n");
 trparen();
 fprintf(textfc, " stf r4.,4w,sp.\n");
 off = ARGINIT;
 for( i=0; i<n; ++i ){
  p = &stab[a[i]];
  if( p->sclass == REGISTER ){
   temp = p->offset;  /* save register number */
   p->sclass = PARAM;  /* forget that it is a register */
   p->offset = NOOFFSET;
   oalloc( p, &off );
   trparen();
   fprintf(textfc,  " lw r%d.,arg%d.+%ld,sp.\n",
   temp, ftnno, toff = p->offset/SZCHAR );
   p->offset = temp;  /* remember register number */
   p->sclass = REGISTER;   /* remember that it is a register */
  }
  else {
   if( oalloc( p, &off ) ) cerror( "bad argument" );
   toff = p->offset;
  }
  if (symopt)
  {
   int t = p->stype, d, s = 0;
   d = t;
   if (d == STRTY || d == UNIONTY)
    s = dimtab[p->sizoff]/SZCHAR;
   symitem(exname(p), 0, N_PSYM, d, p->offset/SZCHAR, s);
   if (d == STRTY || d == UNIONTY) symelems(p);
  }
 }
}
bccode(){ /* called just before the first executable statment */
 /* by now, the automatics and register variables are allocated */
 SETOFF( autooff, SZDOUBLE );
#ifdef ONEPASS
 p2bbeg(autooff, regvar);
#endif
 /* set aside store area offset */
}
bracsym(levl,which)
{
 int ln;
 char lname[9];
 if (!symopt) return;
 trparen();
 fprintf(textfc, "L.%d equ $\n", ln = getlab());
 sprintf(lname, "L.%d", ln);
 symitem(lname, 0, which ? N_RBRAC : N_LBRAC, levl, 0, 0);
}
char *extfun[EXTFUNS] = {
 "_f.call,_f.calld",
 "_c.if,_c.fi",
 "_c.ld,_c.dl",
 "_l.mp,_l.dv,_l.mod",
 "_l.zero",
 "_c.dbg0,_c.dbg1",
};
ejobcode( flag ){
 /* called just before final exit */
 /* flag is 1 if errors, 0 if none */
 int i;
 int ncommons;
 register isfunct;
 register char *name;
 /* print 'EXT' declarations for undefined external functions */
 ncommons = 0;
 for (i = 0; i < SYMTSZ; i++){
  if( stab[i].stype == TNULL) continue;
  if(ddebug) prstab(i);
  name = exname( &stab[i]);
  isfunct = ISFTN( stab[i].stype );
  switch( stab[i].sclass ){
  case EXTDEF:
   if (isfunct)
    fprintf( dclfc, " def %s\n", name);
   else if( ldnames(&stab[i]) )
    uerror("Illegal to define %s", stab[i].sname);
   else {
    if( ++ncommons > 255 ) {
     uerror("Too many commons (max 256 allowed)\n");
    }
    pcommon( i );
   }
   break;
  case EXTERN:
  case FORTRAN:
  case UFORTRAN:        /* this line added by mjp */
   if ( isfunct || ldnames(&stab[i]) )
    fprintf( dclfc, " ext %s\n", name);
   else {
    if( stab[i].suse > 0 )
     break;  /* declared but not used */
    if( ++ncommons > 255 ) {
     uerror("Too many commons (max 256 allowed)\n");
    }
    pcommon( i );
   }
   break;
  }
 }
 for( i = 0; i < EXTFUNS; i++)
  if (extflg & (1 << i))
   fprintf( dclfc, " ext %s\n", extfun[i]);
#ifdef NBC
 fprintf(sdatafc, " csect\n end\n");
#else
 if (handopt)
  fprintf(sdatafc, " dsect\n end\n");
 else
  fprintf(sdatafc, " csect\n end\n");
#endif
}
aobeg(){
 /* called before removing automatics from stab */
 if(xdebug) fprintf(textfc, "aobeg\n");
}
aocode(p) struct symtab *p;
{
 /* called when automatic p removed from stab */
 if (xdebug) fprintf(textfc, "  aocode %o\n", p);
}
aoend(){
 /* called after removing all automatics from stab */
 if (xdebug) fprintf(textfc, "aoend\n\n");
}
rel(){
 trparen();
 fprintf(curfc, " dsect\n");
}
ldnames(p) register  struct symtab *p;
{
 /* Check for loader defined names */
 if(p->sname[0] != 'e') return(0);
 if( strcmp(p->sname, "end") == 0 ) return(1);
 if( strcmp(p->sname, "etext") == 0 ) return(1);
 if( strcmp(p->sname, "edata") == 0 ) return(1);
 return(0);
}
defnam( p ) register struct symtab *p;
{
 /* define the current location as the name p->sname */
 int t;
 register char *name;
 t = p->stype;
 name = exname( p );
 if(ddebug) prstab(p - stab);
 if (symopt)
 {
  char *sp = NULL;
  int desc = t, value = 0, size = 0, ntype;
  desc &= BTMASK;
  if (ISFTN(t)) symitem(name, NULL, N_FUN, lineno, 0, 0);
  else
  {
   if (ISARY(t) || desc == STRTY || desc == UNIONTY)
    size = ((int) tsize(t, p->dimoff, p->sizoff))/SZCHAR;
   switch(p->sclass)
   {
   case AUTO:
    ntype = N_LSYM;
    value = p->offset/SZCHAR;
    break;
   case EXTERN:
   case EXTDEF:
    ntype = N_GSYM;
    break;
   case REGISTER:
    ntype = N_RSYM;
    value = p->offset;
    break;
   case STATIC:
    ntype = N_STSYM;
    if (p->slevel > 1)
    {
#ifdef NBC
     char syn[9];
#else
     char syn[NCHNAM+1];
#endif
     sprintf(syn, "L.%d", (int) (p->offset));
     sp = syn;
    }
    break;
   }
   symitem(name, sp, ntype, t, value, size);
   if (desc == STRTY || desc == UNIONTY)
   {
    symelems(p);
    name = exname(p); /* restore name
                                    symelems calls exname */
   }
  }
 }
 if (p->sclass != STATIC && p->sclass != EXTDEF) return;
 if (p->sclass == STATIC && p->slevel > 1) deflab( (int)(p->offset) );
 else{
  if ( ISFTN( t ) ) {
   if( curloc != PROG )
    cerror("bad function definition");
   trparen();
   fprintf( curfc, " bound 1w\n");
   trparen();
   fprintf( curfc, "%s equ $\n", name);
  }
  else{
   trparen();
   if (p->sclass == STATIC)
    fprintf(curfc, "%s equ $\n", name);
   else
   {
    /*
     * fprintf(curfc, " org %s\n", name);
     */
   }
  }
 }
}
bycode( t, i ){
 /* put byte i+1 in a string */
#ifndef NBC
 if (idebug) {
  printf ("bycode (%d, %d)\n", t, i);
 }
#endif
#ifdef NBC
 i &= 07;
 if( t < 0 ){ /* end of the string */
  if( i != 0 ) fprintf(curfc, "\n" );
 }
 else { /* stash byte t into string */
  if( i == 0 ) fprintf(curfc, " datab " );
  else fprintf(curfc, "," );
  fprintf(curfc, "%d", t );
  if( i == 07 ) fprintf(curfc, "\n" );
 }
#else
 i &= 0x1f;
 if( t < 0 ){ /* end of the string */
  if( i != 0 ) fprintf(curfc, "'\n" );
 }
 else { /* stash byte t into string */
  if( i == 0 ) fprintf(curfc, " datab c'" );
  putabyte (t);
  if( i == 0x1f) fprintf(curfc, "'\n" );
 }
#endif
}
#ifndef NBC
putabyte(c)
char c;
{
 if (c < ' ') {
 putc('"', curfc);
 putc(c + 64, curfc);
 return;
 }
 if (c > '~') {
 fprintf(curfc, "',x'%x',c'",c);
 return;
 }
 /* undo funny chars */
 switch (c)
 {
 case '%':
 case '"':
 case '\'':
 case ';':
 putc('"', curfc);
 default:
 putc(c, curfc);
 }
}
#endif
zecode( n ){
 /* n integer words of zeros */
 OFFSZ temp;
 if( n <= 0 ) return;
 trparen();
#ifdef NBC
 fprintf(curfc, " rez %dw\n", n );
#else
 fprintf(curfc, " rez %db\n", n*4 );
#endif
 temp = n;
 inoff += temp*SZINT;
}
fldal( t ) int t;
{ /* return the alignment of field of type t */
 return( ALBIT );
}
fldty( p ) struct symtab *p;
{ /* fix up type of field p */
 switch(p->stype){
 default:
  uerror("Illegal Field Type");
 case CHAR:
 case SHORT:
 case INT:
  p->stype = INT;
  break;
 case UCHAR:
 case USHORT:
 case UNSIGNED:
  p->stype = UNSIGNED;
  break;
 }
}
where(c){ /* print location of error  */
 /* c is either 'u', 'c', or 'w' */
 /* GCOS version */
 fprintf( stderr, "%s, line %d: ", ftitle, lineno );
}
FILE *yyin, *yyout;
#ifndef ONEPASS
main( argc, argv ) char *argv[];
{
 char *cp1, *cp2;
 int j;
 char c;
 *ftitle = 0;
 if (argv[1][0] == '-'){
  for (j = 0; c = argv[1][j]; j++){
   switch(c){
#ifndef NBC
   case 'H':	/* this is a handler */
    handopt = 1;
    break;
#endif
   case 'X':
    break;
   case 'd':
    extflg =| dbgopt;
    break;
   case 'S':
    symopt = 1;
    break;
   }
  }
 }
 if(argc >= 8){ /* scc command */
  if( (yyin = fopen(argv[2], "r")) == NULL ||
      (textfc = fopen(argv[3], "w")) == NULL ||
      (dclfc = fopen(argv[4], "w")) == NULL ||
      (sdatafc = fopen(argv[5], "w")) == NULL ||
      (symfc = fopen(argv[6], "w")) == NULL )
   cerror("Bad open on tmp file\n");
  cp1 = ftitle;
  for(cp2=argv[7]; *cp1 = *cp2++; cp1++);
 }
 else{
  curfc = textfc = datafc = sdatafc = dclfc = stdout;
  yyin = stdin;
 }
 datafc = textfc;
 p1init();
 exit(mainp1( argc, argv )? 2 : 0);
}
#endif
#ifdef ONEPASS
main(argc, argv)  char  *argv[];
{/*
int   inreg[8],i;
 mpxsvc(0x1065,inreg,inreg);
 for(i=0;i<8;)printf("Reg %d = %x\n",i,inreg[i++]);*/
  exit(mainp1( argc, argv )? 2 : 0);
}
#endif
p1init()
{
 char *cp1, *cp2;
 /* fix dimtab for scan.c */
 dimtab[LONG] = SZLONG;
 curfc = dclfc;
 trparen();
 for(cp1=cp2=ftitle; *cp2; cp2++)
  if(*cp2 == '/') cp1 = cp2+1;
 fprintf(dclfc, " program ");
 for (cp2 = cp1; *cp2; cp2++)
 {
  if (*cp2 == '.') break;
  fprintf(dclfc, "%c", *cp2);
 }
 fprintf(dclfc, "\n");
 trparen();
#ifdef NBC
 fprintf(dclfc, " list off,nodata\n");
#endif
 fprintf(dclfc, "call. equ 8w\n");
 fprintf(dclfc, ".args equ 8w\n");
 fprintf(dclfc, "*\n");
 fprintf(dclfc, "r0. equ 0\n");
 fprintf(dclfc, "r1. equ 1\n");
 fprintf(dclfc, "r2. equ 2\n");
 fprintf(dclfc, "r3. equ 3\n");
 fprintf(dclfc, "r4. equ 4\n");
 fprintf(dclfc, "r5. equ 5\n");
 fprintf(dclfc, "r6. equ 6\n");
 fprintf(dclfc, "r7. equ 7\n");
 fprintf(dclfc, "*\n");
 fprintf(dclfc, "sp. equ 3\n");
 fprintf(dclfc, "*\n");
#ifdef NBC
 fprintf(dclfc, " list on\n");
#endif
#ifdef NBC
 fprintf(dclfc, " csect\n");
#else
 if (handopt)
  fprintf(dclfc, " dsect\n");
 else
  fprintf(dclfc, " csect\n");
#endif
 /* initialization for locctr() */
 fprintf(sdatafc, " dsect\n");
 locctr(PROG);
#ifdef NBC
 fprintf(curfc, " gen 32/c'\"\"C\"\":'\n"); /* 'magic' number */
#else
 if (!handopt)
  fprintf(curfc, " dataw x'2243223a'\n");  /* magic number */
#endif
 if (symopt)
 {
  symitem(ftitle, 0, N_SO, 0, 0, 0);
  cptitle(oldtitle, ftitle);
 }
}
struct sym_si {
 struct nlist sym_nl;
 char sym_syn[8];
}
sym_si;
symitem(name, sname, type, desc, value, size) char *name, *sname;
{
 int i;
 char ch, *cp, chs, *csp;
 cp = name;
 for (i = 0 ; i < 8; i++)
 {
  if ((ch = *cp)) cp++;
  if (ch == '>') ch = '_';
  sym_si.sym_nl.n_name[i] = ch;
 }
 sym_si.sym_nl.n_type = type;
 sym_si.sym_nl.n_other = 0;
 sym_si.sym_nl.n_desc = desc;
 sym_si.sym_nl.n_value = value;
 csp = sname;
 for (i = 0; i < 8; i++)
 {
  if (csp == NULL) chs = '\0';
  else
   if (chs = *csp) csp++;
  sym_si.sym_syn[i] = chs;
 }
 symout( &sym_si );
 while ((type == N_SO || type == N_SOL) && (ch != '\0'))
 {
  for (i = 0; i < 8; i++)
  {
   if (ch = *cp) cp++;
   sym_si.sym_nl.n_name[i] = ch;
  }
  symout( &sym_si );
 }
 if (size) symleng(size);
}
static int oldln = 0;
symline(n, f) char *f;
{
 int i, newtitle = 1;
 char lname[9], *fp = f, *ofp = oldtitle;
 if( !symopt )
  return;
 for (i = 0; i < TITLSIZ; i++)
 {
  if (*fp++ != *ofp) break;
  if (*ofp++ == 0) {
   newtitle = 0;
   break;
  }
 }
 if( newtitle )
 {
  cptitle(oldtitle, f);
  oldln = 0;
 }
 if (n == oldln) return;
 oldln = n;
 if( newtitle )
 {
  deflab(i = getlab());
  sprintf(lname, "L.%d", i);
  symitem(f, lname, N_SOL, 0, 0, 0);
  symitem(lname, 0, N_SLINE, n, 0, 0);
 } else if (curloc == PROG)
  {
   deflab(i = getlab());
   sprintf(lname, "L.%d", i);
   symitem(lname, 0, N_SLINE, n, 0, 0);
  }
}
symelems(p) struct symtab *p;
{
 register int dimx, i;
 struct symtab *q;
 int d, t, s = 0;
 for (dimx = dimtab[p->sizoff + 1]; (i = dimtab[dimx]) >= 0; dimx++)
 {
  q = &stab[i];
  t = q->stype;
  d = t & BTMASK;
  if (ISARY(t) || d == STRTY || d == UNIONTY)
   s = ((int) tsize(t, q->dimoff, q->sizoff)) / SZCHAR;
  symitem(exname(q), NULL, N_SSYM, t, q->offset / SZCHAR, s);
  if (t == STRTY || t == UNIONTY) symelems(q);
 }
}
symleng(s) int s;
{
 sym_si.sym_nl.n_type = N_LENG;
 sym_si.sym_nl.n_value = s;
 symout( &sym_si );
}
symout(symp)
struct sym_si *symp;
{
 if( xdebug ) {
  printf("%8.8s %02x %02x %04x %08x %s\n",
  symp->sym_nl.n_name, /* symbol name */
  symp->sym_nl.n_type,  /* type flag */
  symp->sym_nl.n_other,
  symp->sym_nl.n_desc,
  symp->sym_nl.n_value, /* value */
  symp->sym_syn
  );
  if(symfc == stdout)
   return;
 }
#ifdef NBC
 fwrite(&sym_si, sizeof(sym_si), 1, symfc);
#else
 fwrite((char*)&sym_si, sizeof(sym_si), 1, symfc);
#endif
 fwrite("\n",1,1,symfc);
}
/* Don't know what these routines are for in Compion compiler */
/* so abort if they are encountered.  Need to convert to our form. */
makeheap() {
 cerror("makeheap called\n");
 cabort();
}
select() {
 cerror("select called\n");
 cabort();
}
walkheap() {
 cerror("walkheap called\n");
 cabort();
}
cabort() {
 abort();
}
cptitle(to, from)
char *to, *from;
{
 /* Copy filename title, discarding quotes if present. */
 char *p, *q;
 char c;
 p = to;  q = from;
 if(*q == '"') ++q;
 do {
  c = *q++;
  if( c == '"' || c == 0 ) {
   *p++ = 0;
   break;
  } else {
   *p++ = c;
  }
 } while (from + TITLSIZ > q);
}
#ifdef NBC
int   abort(){
  int   inreg[8];
  int   otreg[8];
  mpxsvc(0x1055,inreg,otreg);
}
#endif
