/*~!dosys.c*/
/* Name:  dosys.c Part No.: _______-____r
 *
 * Copyright 1994 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)make:dosys.c	1.0"

#include "defs.h"

extern char Makecall;

dosys (comstring, nohalt)
register CHARSTAR comstring;
int nohalt;
{
  register CHARSTAR p;
  register int i;
  int status;

  p = comstring;
  while (*p == BLANK ||
    *p == TAB ||
    *p == AT ||
    *p == MINUS ||
    *p == NULL) p++;

  if (IS_ON (NOEX) && Makecall == NO)
    return (0);

  if (metas (comstring))
    status = doshell (comstring, nohalt);
  else
    status = doexec (comstring);

  return (status);
}



metas (s) /* Are there are any  Shell meta-characters? */
register CHARSTAR s;
{
  while (*s)
#ifdef mpx
    if (*s != '>' && funny [*s] & META)
      return (YES);
    else
      s++;
#else
    if (funny [*s++] & META)
      return (YES);
#endif

  return (NO);
}

doshell (comstring, nohalt)
register CHARSTAR comstring;
register int nohalt;
{
  register CHARSTAR shell;
  int status;

#ifndef mpx
  if ((waitpid = fork ()) == 0)
  {
    enbint (0);
    doclose ();

    setenv ();
    shell = varptr ("SHELL") ->varval;
    if (shell == 0 || shell [0] == CNULL)
      shell = SHELLCOM;
    execl (shell, "sh", (nohalt ? "-c" : "-ce"), comstring, 0);
    fatal ("Couldn't load Shell");
  }

  return (await ());
#else
  doclose ();
  setenv ();
  shell = varptr ("SHELL") ->varval;
  if (shell == 0 || shell [0] == CNULL)
    shell = SHELLCOM;
printf("vexecl %s comm %s\n", shell, comstring);
  status = vexecl (shell, "sh", (nohalt ? "-c" : "-ce"), comstring, 0);
printf("vexecl status %d\n", status);
  if (status)fatal ("Couldn't load Shell");
  freenv();
  return (status);
#endif
}



#ifndef mpx
await ()
{
  int intrupt ();
  int status;
  int pid;

  enbint (intrupt);
  while ((pid = wait (&status)) != waitpid)
    if (pid == -1)
      fatal ("bad wait code");
  waitpid = 0;
  return (status);
}
#endif


doclose () /* Close open directory files before exec'ing */
{
  register DIRLL od;

  for (od = firstod; od != 0; od = od->nextopendir)
    if (od->dirfc != NULL)
      closedir(od->dirfc);
}




doexec (str)
register CHARSTAR str;
{
  register CHARSTAR t;
  register CHARSTAR *p;
  CHARSTAR argv [200];
  int status;

  while (*str==BLANK || *str==TAB)
    ++str;
  if (*str == CNULL)
    return (-1); /* no command */

  p = argv;
  for (t = str ; *t ; )
  {
    *p++ = t;
    while (*t!=BLANK && *t!=TAB && *t!=CNULL)
      ++t;
    if (*t)
      for (*t++ = CNULL ; *t==BLANK || *t==TAB  ; ++t)
        ;
  }

  *p = NULL;

#ifndef mpx
  if ((waitpid = fork ()) == 0)
  {
    enbint (0);
    doclose ();
    setenv ();
    execvp (str, argv);
    fatal1 ("Cannot load %s", str);
  }

  return (await ());
#else
  doclose ();
  setenv ();
  status = Execvp (str, argv);
  if (status)fatal1 ("Cannot load %s", str);
  freenv();
  return (status);
#endif
}

touch (s)
register CHARSTAR s;
{
#ifdef mpx
  utime (s, 0);
#else
  if (junkname [0] == 0)
    sprintf (junkname, "MAKEJUNK%d", getpid ());

  link (s, junkname);
  unlink (junkname);
  sleep (1);
#endif
}
