/*~!test.c*/
/* Name:  test.c Part No.: _______-____r
 *
 * Copyright 1994 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"$Id: test.c,v 1.1 1995/04/04 22:25:34 jbev Exp $"

/*	$Log $
 */

/*
 *      test expression
 *      [ expression ]
 */

#include	"defs.h"
#include <sys/types.h>
#include <sys/stat.h>

int ap, ac;
char **av;

test(argn, com)
char *com[];
int argn;
{
    ac = argn;
    av = com;
    ap = 1;
    if (eq(com[0], lbstr)) {
    	if (!eq(com[--ac], rbstr))
    	    failed(btest, rbmiss);
    }
    com[ac] = 0;
    if (ac <= 1)
    	return(1);
    return(exp() ? 0 : 1);
}


char *
nxtarg(mt)
{
    if (ap >= ac) {
    	if (mt) {
    	    ap++;
    	    return(0);
    	}
    	failed(btest, argexp);
    }
    return(av[ap++]);
}


exp()
{
    int p1;
    char *p2;

    p1 = e1();
    p2 = nxtarg(1);
    if (p2 != 0) {
    	if (eq(p2, dasho))
    	    return(p1 | exp());

    	if (eq(p2, rbstr) && !eq(p2, rpstr))
    	    failed(btest, synmsg);
    }
    ap--;
    return(p1);
}


e1()
{
    int p1;
    char *p2;

    p1 = e2();
    p2 = nxtarg(1);

    if ((p2 != 0) && eq(p2, dasha))
    	return(p1 & e1());
    ap--;
    return(p1);
}


e2()
{
    if (eq(nxtarg(0), bang))
    	return(!e3());
    ap--;
    return(e3());
}


e3()
{
    int p1;
    register char *a;
    char *p2;
    long atol();
    long int1, int2;

    a = nxtarg(0);
    if (eq(a, lpstr)) {
    	p1 = exp();
    	if (!eq(nxtarg(0), rpstr))
    	    failed(btest, parexp);
    	return(p1);
    }
    p2 = nxtarg(1);
    ap--;
    if ((p2 == 0) || (!eq(p2, eqlstr) && !eq(p2, neqstr))) {
    	if (eq(a, dashr))
    	    return(tio(nxtarg(0), 4));
    	if (eq(a, dashw))
    	    return(tio(nxtarg(0), 2));
    	if (eq(a, dashx))
    	    return(tio(nxtarg(0), 1));
    	if (eq(a, dashd))
    	    return(filtyp(nxtarg(0), S_IFDIR));
    	if (eq(a, dashc))
    	    return(filtyp(nxtarg(0), S_IFCHR));
    	if (eq(a, dashb))
    	    return(filtyp(nxtarg(0), S_IFBLK));
    	if (eq(a, dashf))
    	    return(filtyp(nxtarg(0), S_IFREG));
    	if (eq(a, dashu))
    	    return(ftype(nxtarg(0), S_ISUID));
    	if (eq(a, dashg))
    	    return(ftype(nxtarg(0), S_ISGID));
    	if (eq(a, dashk))
    	    return(ftype(nxtarg(0), S_ISVTX));
#ifndef mpx
    	if (eq(a, dashp))
    	    return(filtyp(nxtarg(0), S_IFIFO));
#endif /* mpx */
    	if (eq(a, dashs))
    	    return(fsizep(nxtarg(0)));
    	if (eq(a, dasht)) {
    	    if (ap >= ac)		/* no args */
    	    	return(isatty(1));
    	    else if (eq((a = nxtarg(0)), dasha) || eq(a, dasho)) {
    	    	ap--;
    	    	return(isatty(1));
    	    } else
    	    	return(isatty(atoi(a)));
    	}
    	if (eq(a, dashn))
    	    return(!eq(nxtarg(0), nullstr));
    	if (eq(a, dashz))
    	    return(eq(nxtarg(0), nullstr));
    }

    p2 = nxtarg(1);
    if (p2 == 0)
    	return(!eq(a, nullstr));
    if (eq(p2, dasha) || eq(p2, dasho))	{
    	ap--;
    	return(!eq(a, nullstr));
    }
    if (eq(p2, eqlstr))
    	return(eq(nxtarg(0), a));
    if (eq(p2, neqstr))
    	return(!eq(nxtarg(0), a));
    int1 = atol(a);
    int2 = atol(nxtarg(0));
    if (eq(p2, dasheq))
    	return(int1 == int2);
    if (eq(p2, dashne))
    	return(int1 != int2);
    if (eq(p2, dashgt))
    	return(int1 > int2);
    if (eq(p2, dashlt))
    	return(int1 < int2);
    if (eq(p2, dashge))
    	return(int1 >= int2);
    if (eq(p2, dashle))
    	return(int1 <= int2);

    bfailed(btest, badop, p2);
    /* NOTREACHED */
}


tio(a, f)
char *a;
int f;
{
    if (access(a, f) == 0)
    	return(1);
    else
    	return(0);
}


ftype(f, field)
char *f;
int field;
{
    struct stat statb;

    if (stat(f, &statb) < 0)
    	return(0);
    if ((statb.st_mode & field) == field)
    	return(1);
    return(0);
}


filtyp(f, field)
char *f;
int field;
{
    struct stat statb;

    if (stat(f, &statb) < 0)
    	return(0);
    if ((statb.st_mode & S_IFMT) == field)
    	return(1);
    else
    	return(0);
}



fsizep(f)
char *f;
{
    struct stat statb;

    if (stat(f, &statb) < 0)
    	return(0);
    return(statb.st_size > 0);
}


/*
 * fake diagnostics to continue to look like original
 * test(1) diagnostics
 */
bfailed(s1, s2, s3)
char *s1;
char *s2;
char *s3;
{
    prp();
    prs(s1);
    if (s2) {
    	prs(colon);
    	prs(s2);
    	prs(s3);
    }
    newline();
    exitsh(ERROR);
}

