# Name:  SH.MK	Part No.: _______-____r
#			
#		             SOFTWARE ENGINEERING
#
# The recipient of this product specifically agrees not to distribute,
# disclose, or disseminate in any way, to any one, nor use for its own
# benefit, or the benefit of others, any information contained  herein
# without the expressed written consent of Software Engineering.
#
# @(#)SH.MK	1.5

ROOT = /xpm/sh/
TARGET = bin
SOURCE = /xpm/sh
INCLUDE = /system/cinclude
PREFIX =
BIN = /system/system

CC = $(BIN)/$(PREFIX)cc
CFLAGS =
LDFLAGS =
FRC =

OBJS = args.o blok.o builtin.o cmd.o ctype.o serror.o\
	expand.o fault.o io.o macro.o main.o msg.o name.o\
	print.o service.o setbrk.o stak.o string.o test.o\
	word.o xec.o
HDRS = brkincr.h ctype.h defs.h dup.h mac.h mode.h name.h\
	stak.h sym.h timeout.h

all: sh

clean:
	-$(BIN)/rm -f $(HDRS) $(OBJS)

clobber: clean
	-$(BIN)/rm -f sh

sh:	$(OBJS)\
	$(FRC)
	$(CC) $(OBJS) $(LDFLAGS) -o sh
	$(BIN)/chmod 775 sh
	$(BIN)/chgrp bin sh
	$(BIN)/chown bin sh

args.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.args.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.args.c
	$(CC) $(CFLAGS) -c args.c
	$(BIN)/rm -f args.c args.has

blok.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.blok.c\
	$(FRC)
	(BIN)/get $(SOURCE)/s.blok.c
	$(CC) $(CFLAGS) -c blok.c
	$(BIN)/rm -f blok.c blok.has

builtin.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.builtin.c\
	$(FRC)
	(BIN)/get $(SOURCE)/s.builtin.c
	$(CC) $(CFLAGS) -c builtin.c
	$(BIN)/rm -f builtin.c builtin.has

cmd.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.cmd.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.cmd.c
	$(CC) $(CFLAGS) -c cmd.c
	$(BIN)/rm -f cmd.c cmd.has

ctype.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.ctype.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.ctype.c
	$(CC) $(CFLAGS) -c ctype.c
	$(BIN)/rm -f ctype.c ctype.has

serror.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.error.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.error.c
	$(CC) $(CFLAGS) -c serror.c
	$(BIN)/rm -f serror.c serror.has

expand.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(INCLUDE)/types.h\
	$(INCLUDE)/param.h\
	$(INCLUDE)/stat.h\
	$(INCLUDE)/dir.h\
	$(SOURCE)/s.expand.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.expand.c
	$(CC) $(CFLAGS) -c expand.c
	$(BIN)/rm -f expand.c expand.has

fault.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.fault.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.fault.c
	$(CC) $(CFLAGS) -c fault.c
	$(BIN)/rm -f fault.c fault.has

io.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.io.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.io.c
	$(CC) $(CFLAGS) -c io.c
	$(BIN)/rm -f io.c io.has

macro.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.macro.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.macro.c
	$(CC) $(CFLAGS) -c macro.c
	$(BIN)/rm -f macro.c macro.has

main.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(INCLUDE)/types.h\
	$(INCLUDE)/stat.h\
	$(INCLUDE)/sgtty.h\
	$(INCLUDE)/signal.h\
	$(SOURCE)/s.main.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.main.c
	$(CC) $(CFLAGS) -c main.c
	$(BIN)/rm -f main.c main.has

msg.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.msg.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.msg.c
	$(CC) $(CFLAGS) -c msg.c
	$(BIN)/rm -f msg.c msg.has

name.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.name.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.name.c
	$(CC) $(CFLAGS) -c name.c
	$(BIN)/rm -f name.c name.has

print.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.print.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.print.c
	$(CC) $(CFLAGS) -c print.c
	$(BIN)/rm -f print.c print.has

service.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.service.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.service.c
	$(CC) $(CFLAGS) -c service.c
	$(BIN)/rm -f service.c service.has

setbrk.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.setbrk.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.setbrk.c
	$(CC) $(CFLAGS) -c setbrk.c
	$(BIN)/rm -f setbrk.c setbrk.has

stak.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.stak.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.stak.c
	$(CC) $(CFLAGS) -c stak.c
	$(BIN)/rm -f stak.c stak.has

string.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.string.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.string.c
	$(CC) $(CFLAGS) -c string.c
	$(BIN)/rm -f string.c string.has

test.o:\
	$(HDRS)\
	$(SOURCE)/s.test.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.test.c
	$(CC) $(CFLAGS) -c test.c
	$(BIN)/rm -f test.c test.has

word.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.word.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.word.c
	$(CC) $(CFLAGS) -c word.c
	$(BIN)/rm -f word.c word.has

xec.o:\
	$(HDRS)\
	$(INCLUDE)/setjmp.h\
	$(SOURCE)/s.xec.c\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.xec.c
	$(CC) $(CFLAGS) -c xec.c
	$(BIN)/rm -f xec.c xec.has

brkincr.h:\
	$(SOURCE)/s.brkincr.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.brkincr.h

ctype.h:\
	$(SOURCE)/s.ctype.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.ctype.h

defs.h:\
	$(SOURCE)/s.defs.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.defs.h

dup.h:\
	$(SOURCE)/s.dup.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.dup.h

mac.h:\
	$(SOURCE)/s.mac.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.mac.h

mode.h:\
	$(SOURCE)/s.mode.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.mode.h

name.h:\
	$(SOURCE)/s.name.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.name.h

stak.h:\
	$(SOURCE)/s.stak.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.stak.h

sym.h:\
	$(SOURCE)/s.sym.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.sym.h

timeout.h:\
	$(SOURCE)/s.timeout.h\
	$(FRC)
	$(BIN)/get $(SOURCE)/s.timeout.h

FRC:
