#~!Makefile for make
# Name:  Makefile Part No.: _______-____r
#
# Copyright 1994 - J B Systems, Morrison, CO
#
# The recipient of this product specifically agrees not to distribute,
# disclose, or disseminate in any way, to any one, nor use for its own
# benefit, or the benefit of others, any information contained  herein
# without the expressed written consent of J B Systems.
#
#                     RESTRICTED RIGHTS LEGEND
#
# Use, duplication, or disclosure by the Government is  subject  to
# restriction  as  set forth in paragraph (b) (3) (B) of the Rights
# in Technical Data and Computer Software  Clause  in  DAR  7-104.9
# (a).
#

#ident	"@(#)Make:make/Makefile	1.0"

# Make parameters when running on MPX

ROOT = /system/system
TARGET = /system/system
SOURCE = .
PREFIX = nb
INCLUDE = /system/$(PREFIX)include
SINCLUDE = $(INCLUDE)
SBIN = /system/system
BIN = /system/bin
UBIN = /system/bin
LIB = /system/bin
YBIN = /system/bin
CPP = $(LIB)/$(PREFIX)cpp
CPFLAGS = -M
CC = $(UBIN)/$(PREFIX)cc
CFLAGS = -DMPX #-N 
LD = $(UBIN)/$(PREFIX)nbcat
LDFLAGS = -Ymakemap
YACC = $(YBIN)/$(PREFIX)yacc
YFLAGS =
MAKEFILE = makefile

# Fill in with correct information

OBJECTS = main.o doname.o files.o rules.o dosys.o gram.o dyndep.o misc.o docd.o

HDRS = ar.h defs.h

SRCS = main.c doname.c files.c rules.c dosys.c gram.y dyndep.c misc.c docd.c

MAIN = make

ALL:	all

all:	$(MAIN)
	$(BIN)/echo $(MAIN) is up to date.

$(MAIN):	$(MAKEFILE) $(OBJECTS)
	$(CC) $(LDFLAGS) $(OBJECTS) -o $(MAIN)
	$(BIN)/chmod 775 $(MAIN)
	$(BIN)/chgrp system $(MAIN)
	$(BIN)/chown system $(MAIN)

CLEAN:  clean

clean:
	$(BIN)/rm -f $(OBJECTS)

CLOBBER: clobber

clobber: clean
	$(BIN)/rm -f $(MAIN)

DEPEND: depend

depend: $(SRCS) $(HDRS) $(MAKEFILE)
	$(BIN)/mkdep $(MAKEFILE) >dep.out
	@for i in $(SRCS); do \
	$(BIN)/echo "# Source file '$$i'" >> dep.out; \
	$(CPP) $(CPFLAGS) $$i >> dep.out; \
	done;
	$(BIN)/echo "# End of dependencies" >> dep.out;
	$(BIN)/mv dep.out $(MAKEFILE)

INSTALL: install

install: all
	$(BIN)/cp $(MAIN) $(BIN)/$(MAIN)
	$(BIN)/cp $(MAIN) $(ROOT)/$(MAIN)

# DO NOT DELETE THIS LINE -- the dependencies begin here
# Source file 'main.c'
main.o: main.c
main.o: defs.h
main.o: /system/nbinclude/stdio.h
main.o: /system/nbinclude/types.h
main.o: /system/nbinclude/dirent.h
main.o: /system/nbinclude/signal.h
# Source file 'doname.c'
doname.o: doname.c
doname.o: defs.h
doname.o: /system/nbinclude/stdio.h
doname.o: /system/nbinclude/types.h
doname.o: /system/nbinclude/dirent.h
# Source file 'files.c'
files.o: files.c
files.o: defs.h
files.o: /system/nbinclude/stdio.h
files.o: /system/nbinclude/types.h
files.o: /system/nbinclude/dirent.h
files.o: /system/nbinclude/stat.h
files.o: /system/nbinclude/types.h
files.o: /system/nbinclude/a.out.h
# Source file 'rules.c'
rules.o: rules.c
rules.o: defs.h
rules.o: /system/nbinclude/stdio.h
rules.o: /system/nbinclude/types.h
rules.o: /system/nbinclude/dirent.h
# Source file 'dosys.c'
dosys.o: dosys.c
dosys.o: defs.h
dosys.o: /system/nbinclude/stdio.h
dosys.o: /system/nbinclude/types.h
dosys.o: /system/nbinclude/dirent.h
# Source file 'gram.y'
gram.o: gram.y
gram.o: defs.h
gram.o: /system/nbinclude/stdio.h
gram.o: /system/nbinclude/types.h
gram.o: /system/nbinclude/dirent.h
gram.o: /system/nbinclude/ctype.h
# Source file 'dyndep.c'
dyndep.o: dyndep.c
dyndep.o: defs.h
dyndep.o: /system/nbinclude/stdio.h
dyndep.o: /system/nbinclude/types.h
dyndep.o: /system/nbinclude/dirent.h
# Source file 'misc.c'
misc.o: misc.c
misc.o: defs.h
misc.o: /system/nbinclude/stdio.h
misc.o: /system/nbinclude/types.h
misc.o: /system/nbinclude/dirent.h
misc.o: /system/nbinclude/ctype.h
misc.o: /system/nbinclude/stat.h
misc.o: /system/nbinclude/types.h
misc.o: /system/nbinclude/errno.h
# Source file 'docd.c'
docd.o: docd.c
docd.o: /system/nbinclude/stdio.h
docd.o: /system/nbinclude/types.h
docd.o: /system/nbinclude/stat.h
docd.o: /system/nbinclude/types.h
docd.o: /system/nbinclude/string.h
docd.o: /system/nbinclude/ctype.h
# End of dependencies
