

     GREP(C)		       UNIX System V		       GREP(C)


     Name
	  grep,	egrep, fgrep - Searches	a file for a pattern.

     Syntax
	  grep [ -bchlnsvy ] [ expression ] [ files ]

	  egrep	[ -bchlnv ] [ expression ] [ files ]

	  fgrep	[ -bclnvxy ] [ strings ] [ files ]

     Description
	  Commands of the grep family search the input files (standard
	  input	default) for lines matching a pattern.	Normally, each
	  line found is	copied to the standard output.	grep patterns
	  are limited regular expressions in the style of ed(C); it
	  uses a compact nondeterministic algorithm.  egrep patterns
	  are full regular expressions;	it uses	a fast deterministic
	  algorithm that sometimes needs exponential space.  fgrep
	  patterns are fixed strings; it is fast and compact.  The
	  following options are	recognized:

	  -v	All lines but those matching are displayed.

	  -x	Displays only exact matches of an entire line.	(fgrep
		only.)

	  -c	Only a count of	matching lines is displayed.

	  -l	Only the names of files	with matching lines are
		displayed, separated by	newlines.

	  -h	Prevents the name of the file containing the matching
		line from being	appended to that line.	Used when
		searching multiple files.

	  -n	Each line is preceded by its relative line number in
		the file.

	  -b	Each line is preceded by the block number on which it
		was found.  This is sometimes useful in	locating disk
		block numbers by context.

	  -s	Suppresses error messages produced for nonexistent or
		unreadable files.  ( grep only.) Note that the -s
		option will not	suppress error messages	generated by
		the -f option.

	  -y	Turns on matching of letters of	either case in the
		input so that case is insignificant.  Does not work
		for egrep.

	  -e expression


     Page 1					      (printed 5/7/94)


     GREP(C)		       UNIX System V		       GREP(C)


		Same as	a simple expression argument, but useful when
		the expression begins with a dash (-).

	  -f file
		The regular expression for grep	or egrep, or strings
		list (for fgrep) is taken from the file.

	  In all cases,	the filename is	output if there	is more	than
	  one input file.  Care	should be taken	when using the
	  characters $,	*, [, ^, |, (, ), and \	in expression, because
	  they are also	meaningful to the shell.  It is	safest to
	  enclose the entire expression	argument in single quotation
	  marks.

	  Fgrep	searches for lines that	contain	one of the strings
	  separated by newlines.

	  Egrep	accepts	regular	expressions as in ed(C), except	for \(
	  and \), with the addition of the following:

	  -    A regular expression followed by	a plus sign (+)
	       matches one or more occurrences of the regular
	       expression.

	  -    A regular expression followed by	a question mark	(?)
	       matches 0 or 1 occurrences of the regular expression.

	  -    Two regular expressions separated by a vertical bar (|)
	       or by a newline match strings that are matched by
	       either regular expression.

	  -    A regular expression may	be enclosed in parentheses ()
	       for grouping.

	  The order of precedence of operators is [], then *?+,	then
	  concatenation, then the backslash (\)	and the	newline.

     See Also
	  ed(C), sed(C), sh(C)

     Diagnostics
	  Exit status is 0 if any matches are found, 1 if none,	2 for
	  syntax errors	or inaccessible	files.

     Notes
	  Ideally there	should be only one grep, but there isn't a
	  single algorithm that	spans a	wide enough range of space-
	  time tradeoffs.

	  Lines	are limited to 256 characters; longer lines are
	  truncated.


     Page 2					      (printed 5/7/94)


     GREP(C)		       UNIX System V		       GREP(C)


	  When using grep with the -y option, the search is not	made
	  totally case insensitive in character	ranges specified
	  within brackets.

	  Multiple strings can be specified in fgrep without using a
	  separate strings file	by using the quoting conventions of
	  the shell to imbed newlines in the single string argument.
	  For example, you might enter the following on	the command
	  line:

	       fgrep 'string1
	       string2
	       string3'	text.file


	  Similarly, multiple strings can be specified in egrep	by
	  doing:

	       egrep 'string1|string2|string3' text.file

	  Thus egrep can do almost anything that grep and fgrep	can
	  do.


     Page 3					      (printed 5/7/94)


