  @  #include "stdio.h"  #include "defines.pet"  extern headertype header;  !extern char *meas_name[NUM_MEAS]; ! GETSUMS(type,length,fd,fp)  int type,length,fd;  	FILE *fp; 	 I/*=====================================================================*/ I I/*                                                                     */ I I/* MODULE NAME : GETSUMS                                               */ I I/*                                                                     */ I I/* FILE NAME   : GETSUMS.RED.C                                         */ I I/*                                                                     */ I I/* AUTHOR NAME : A CRANNY.    DATE :14SEP83      BADGE NUMBER : 6701   */ I                                             @  I/*                                                                     */ I I/* FUNCTION    : To calculate the mean and standard deviation from     */ I I/*               the sum, sum of squares and the count which is in the */ I I/*               next record of the file open on file descriptor fd.   */ I I/*                                                                     */ I I/* INPUTS     :  type - the record type - indicates where to put result*/ I I/*               length - the length of this record.                   */ I I/*               fd - the file descriptor of the input file.           */ I I/*                                                                     */ I                                                                       @  I/* OUTPUTS     : none.                                                 */ I I/*                                                                     */ I I/*                                                                     */ I I/*                           EDIT HISTORY                              */ I I/*                                                                     */ I I/* EDIT DATE |              LINE NO'S AND DESCRIPTION                  */ I I/* --------------------------------------------------------------------*/ I I/*                                                                     */ I I/*=====================================================================*/ I {  totaltype totals;                                              @  2double sum,sos,min,max,mean,variance,rate,std_dev; 2 int len,count;  float  SQRT(),fstd_dev;           /* read in the record */     %      len -= read(fd,&totals,length); %          count = totals.t_count;     ?      /* what are we dealing with - an EVENT or an INTERVAL? */ ?    "      if (length == EVNTSPACE*4) { " E            fprintf(fp," EVENT %s - COUNT = %d, ERROR COUNT = %d\n\n" E C                           ,meas_name[type],count,totals.t_ecount); C             return(0);        }  A      /* get the info in the buffer converted into doubles etc */ A    "      CNVRT(&totals.t_h_sum,&sum); " "      CNVRT(&totals.t_h_sos,&sos); "    +      sos *= 16.0;  /* shift left 4 bits */ +          /* calculate the mean */      @           if (count == 0) {              mean = 0;  ,            totals.t_max = totals.t_min = 0; ,       }  
      else 
             mean  = sum/count;     ;      /* now we calculate the variance using the formula */ ; 1      /* variance = (1/n-1)(sos - n*mean*mean) */ 1          if (count < 2)              variance = 0.0;        else {  H            /* try to select an order of evaluation to minimise error */ H    F            /* add the averge waste to sos - this is to make up for */ F             /* the shifting */                 sos += 7.5 * count;  (            variance = sos/(count - 1) - ( =                             mean * count * (mean/(count-1)); =             if (variance < 0.0)                               @  !                  variance = 0.0; !       }        /* change to seconds */           rate = header.h_rtrate;        rate /= 1000000000;            min = totals.t_min * rate;          max = totals.t_max * rate;         mean *= rate;         variance *= (rate * rate);   '      fstd_dev = SQRT((float)variance); '       std_dev = fstd_dev;           /* now format this */     $      if (meas_name[type][0] == '*') $ P            fprintf(fp," STANDARD MEASURE %s - COUNT = %d, ERROR COUNT = %d\n\n" P >                      ,meas_name[type],count,totals.t_ecount); > 
      else 
 H            fprintf(fp," INTERVAL %s - COUNT = %d, ERROR COUNT = %d\n\n" H >                      ,meas_name[type],count,totals.t_ecount); >                     @        fprintf(fp,"  MEAN = ");        RANGE(fp,mean);  ,      fprintf(fp,", STANDARD DEVIATION = "); ,       RANGE(fp,std_dev);  %      fprintf(fp,"\n\n  MINIMUM = "); %       RANGE(fp,min);  !      fprintf(fp,", MAXIMUM = "); !       RANGE(fp,max);        fprintf(fp,"\n\n");        return(0);  }  
RANGE(fp,num) 
 	FILE *fp; 	 double num;  {  
int index; 
 /static char *types[] = {"SECONDS","NANOSECONDS" / 7                       ,"MICROSECONDS","MILLISECONDS"}; 7 7static int multipliers[] = {1,1000000000,1000000,1000}; 7 /static char *outstr[] = {"%6.6f %s ","%6.3f %s" / 1                        ,"%6.3f %s ","%6.6f %s"}; 1          if (num < 0.000001)              index = 1;        else if (num < 0.001)                       @              index = 2;        else if (num < 1.0)              index = 3;     D      fprintf(fp,outstr[index],num*multipliers[index],types[index]); D          return(0);  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             