#include <stdio.h>

#define byte unsigned char

FILE *ifile, *ofile;
int i, k, n, Block, Def[26], PC, LOp, LAd, ROp, RAd;
byte L[50], Word[2][5];

void Error(int k);
int ProcessOp(int k);
int ProcessAd(int k);
int ConvertOctal(int m);
void ProcessTC(void);
void PackWord(void);

void main(int argc, char *argv[])
{
	if(argc != 3) Error(0);
	if((ifile = fopen(argv[1], "r")) == NULL) Error(1);
	if((ofile = fopen(argv[2], "wb")) == NULL) Error(2);
	for(i = 0; i < 26; i++) Def[i] = 0x8000;
	while(1)
	{
		i = 0;
		while((i < 29) && ((L[i++] = getc(ifile)) != 0x0A));
		if(feof(ifile)) exit(0);
      if(L[i - 1] != 0x0A)
		{
			L[i++] = 0x0A;
			while(getc(ifile) != 0x0A);
		}
		L[i] = '\0';
		printf("%s", L);
		n = i;
		i = 0;
		if(L[i] == ' ') goto noloc;
		if((L[i] > '/') && (L[i] < '8')) PC = ConvertOctal(4);
		else
		{
			if((L[i] > '@') && (L[i] < '['))
			{
				k = (int)(L[i] - 'A');
				i = 10;
				Def[k] = ConvertOctal(4);
				continue;
			}
			if(L[i] == '$')
			{
				i = 10;
				PC = ConvertOctal(4);
				continue;
			}
			if(L[i] == '.') ProcessTC();
			else Error(5);
		}
noloc:
		i = 5;
		LOp = ProcessOp(i);
		i = 9;
		if(i >= n) Error(3);
		LAd = ProcessAd(i);
		i = 18;
		if(i >= n) Error(3);
		ROp = ProcessOp(i);
		i = 22;
		if(i >= n) Error(3);
		RAd = ProcessAd(i);
		PackWord();
		PC += 1;
/*		getch();	*/
	}
}

void Error(int k)
{

	char EMsg[10][40] =
	{"Usage: JACASSJR input_file output_file\n",
	"Can't open input file.\n",
	"Can't open output file.\n",
	"Incomplete line of code.\n",
	"Mixed statement.\n",
	"Improper character in Location field.\n",
	"Improper character in Op field.\n",
	"Non-numeric character in octal field.\n",
	"Improper character in Address field.\n",
	"Undefined block specifier used.\n"};

	fprintf(stderr, "%s\n", EMsg[k]);
	if(k > 2) fprintf(stderr, "%s\n", L);
	exit(k);
}

int ProcessOp(int k)
{
	if((L[k] < '0') || (L[k] > '7')) Error(6);
	return(ConvertOctal(3));
}

int ProcessAd(int k)
{
	int temp, org, inc;
	char sign;

	if((L[k] > '/') && (L[k] < '8')) return(ConvertOctal(4));
	if(L[k] == '$')
	{
		temp = PC;
		if(++k >= n) Error(3);
		if((L[k] != '-') && (L[k] != '+')) Error(7);
		sign = L[k];
		++k;
		if(k >= n) Error(3);
		temp = 0;
		while((L[k] > '/') && (L[k] < '8')) temp = (temp << 3) + (L[k++] - '0');
/*		printf("%c %o\n", sign, temp);	*/
		if((L[k] != ' ') && (L[k] != 0x0A)) Error(8);
		if(sign == '-') return(PC - temp);
		else return(PC + temp);
	}
	L[k] = toupper(L[k]);
	if((L[k] < 'A') || (L[k] > 'Z')) Error(8);
	if((org = Def[L[i] - 'A']) < 0) Error(9);
	++i;
	inc = ConvertOctal(3);
	return(org + inc);
}

int ConvertOctal(int m)
{
	int temp = 0, l;

	for(l = 0; l < m; l++)
	{
		if((L[i + l] < '0') || (L[i +l] > '7')) break;
		temp = (int)((temp << 3) + (L[i + l] & 0x07));
	}
	return(temp);
}

void PackWord(void)
{
	int l, j;

	Word[0][0] = Word[0][1] = 0;
	Word[0][2] = 0x02;
	Word[0][3] = 0x80 + (PC >> 8);
   Word[0][4] = PC & 0x00FF;
   Word[1][0] = LOp << 1;
   Word[1][0] += (LAd >> 11);
   Word[1][1] = (LAd >> 3) & 0x00FF;
   Word[1][2] = (LAd << 5) + (ROp >> 4);
   Word[1][3] = (ROp << 4) + (RAd >> 8);
   Word[1][4] = RAd & 0x00FF;
	fwrite(Word, sizeof(char), 10, ofile);
	printf("%04o  %03o %04o %03o %04o  ", PC, LOp, LAd, ROp, RAd);
	for(j = 0; j < 2; j++) for(l = 0; l < 5; l++) printf("%02X", Word[j][l]);
	printf("\n");
	return;
}
void ProcessTC(void)
{
	i = 5;
	ROp = ConvertOctal(3);
	i = 9;
	RAd = ConvertOctal(4);
	LOp = LAd = 0;
	for(i = 0; i < 5; i++) Word[1][i] = 0;
  	Word[0][0] = LOp << 1;
  	Word[0][0] += (LAd >> 11);
  	Word[0][1] = (LAd >> 3) & 0x00FF;
  	Word[0][2] = (LAd << 5) + (ROp >> 4);
  	Word[0][3] = (ROp << 4) + (RAd >> 8);
  	Word[0][4] = RAd & 0x00FF;
	fwrite(Word, sizeof(char), 10, ofile);
	printf("%03o %04o %03o %04o  ", LOp, LAd, ROp, RAd);
	for(i = 0; i < 2; i++) for(n = 0; n < 5; n++) printf("%02X", Word[i][n]);
	printf("\n");
	fcloseall();
	exit(0);
}
