#include <stdio.h>

#define TAB (char)0x09
#define SPACE (char)0x20

main(int argc, char *argv[])
{
	int i, j, k, tabset, n;
	char linein[256], lineout[384];
	FILE *tf, *sf;

	if(argc != 4)
	{
		fprintf(stderr, "Usage: FIXTABS infile outfile tabset\n");
		exit(0);
	}
	if((tf = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr, "Can't open %s\n", argv[1]);
		exit(0);
	}
	if((sf = fopen(argv[2], "w")) == NULL)
	{
		fprintf(stderr, "Can't open %s\n", argv[2]);
		exit(0);
	}
	tabset = atoi(argv[3]);
	while(fgets(linein, 255, tf) != NULL)
	{
		n = strlen(linein);
		j = 0;
		for(i = 0; i < n; i++)
		{
			if(linein[i] != TAB)
				lineout[j++] = linein[i];
			else
			{
				k = tabset - (j % tabset);
				while(k > 0)
				{
					lineout[j++] = SPACE;
					--k;
				}
			}
		}
		lineout[j] = '\0';
		fputs(lineout, sf);
	}
	fcloseall();
}
