#include <stdio.h>
#include <string.h>

unsigned char core[4096][5], buffer[85], prevline[85];
int lop, lad, rop, rad, i, loc, prevloc = 0;
FILE *octin, *binout;

void StoreWord(int);
void MoveWord(char *, char *, int);
void LineOut(char *, int);

main(int argc, char *argv[])
{
	int c = 0;

	if(argc != 3)
	{
		fprintf(stderr, "Usage: OCT2BIN OctalInput BinaryOutput\n");
		exit(0);
	}
	if((octin = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr, "Can't open %s as input\n", argv[1]);
		exit(0);
	}
	if((binout = fopen(argv[2], "wb")) == NULL)
	{
		fprintf(stderr, "Can't open %s for input\n", argv[2]);
		exit(0);
	}
	while(fgets(buffer, 82, octin) != NULL)
	{
		if((buffer[0] == '\n') || (buffer[0] == ' ')) continue;
		sscanf(buffer, "%o", &loc);
		while((loc - prevloc) >= 4)
		{
			LineOut(prevline, prevloc);
			prevloc += 4;
		}
		LineOut(buffer, loc);
		prevloc = loc;
		strncpy(prevline, buffer, 82);
	}
	fwrite(core, sizeof(char), 5 * 4096, binout);
	fcloseall();
}

void StoreWord(int l)
{
	unsigned char word[6];

	word[0] = ((lop << 1) | ((lad >> 11) & 0x0001)) & 0x00FF;
	word[1] = (lad >> 3) & 0x00FF;
	word[2] = ((lad << 5) | ((rop >> 4) & 0x001F)) & 0x00FF;
	word[3] = ((rop << 4) | ((rad >> 8) & 0x000F)) & 0x00FF;
	word[4] = rad & 0x00FF;
	MoveWord(core[l], word, 5);
}

void MoveWord(char *w1, char *w2, int n)
{
	int k;

	for(k = 0; k < n; k++) w1[k] = w2[k];
}

void LineOut(char *buf, int l)
{
	for(i = 0; i < 4; i++)
	{
		sscanf(buf + (19 * i) + 6, "%o %o %o %o", &lop, &lad, &rop, &rad);
		StoreWord(l + i);
	}
}

