#include <stdio.h>
#include <string.h>

unsigned char line[21], lineout[21];
int i, j, k, loc, lop, lad, rop, rad, same, c;
FILE *core, *dump;

int linecomp(char *, char *, int);

main(int argc, char *argv[])
{
	if(argc != 3)
	{
		fprintf(stderr, "Usage: COREDUMP CoreImageFile DumpFile\n");
		exit(0);
	}
	if((core = fopen(argv[1], "rb")) == NULL)
	{
		fprintf(stderr, "Can't open Core Image File %s.\n", argv[1]);
		exit(0);
	}
	if((dump = fopen(argv[2], "w")) == NULL)
	{
		fprintf(stderr, "Can't open Dump File %s\n", argv[2]);
		exit(0);
	}
	same = 0;
	loc = 0;
	for(j = 0; j < 20; j++) lineout[j] = 0x7F;
	while(fread(line, sizeof(char), 20, core) == 20)
	{
		c = linecomp(line, lineout, 20);
/*		for(j = 0; j < 4; j++)
		{
			for(k = 0; k < 5; k++)
			{
				printf("%02X", lineout[(5 * j) + k]);
			}
			printf(" ");
		}
		printf("\n");
		for(j = 0; j < 4; j++)
		{
			for(k = 0; k < 5; k++)
			{
				printf("%02X", line[(5 * j) + k]);
			}
			printf(" ");
		}
		printf("\n");
		printf("%d\n", c);
		getch();	*/
		if(c != 0)
		{
			fprintf(dump, "%04o", loc);
/*			printf("%04o ", loc);	*/
			for(i = 0; i < 4; i++)
			{
/*				for(j = 0; j < 5; j++) printf("%03o ", line[(5 * i) + j]);
				printf("\n");	*/
				lop = ((int)line[5 * i] >> 1);
				lad = (((int)line[5 * i] & 0x0001) << 11) | ((int)line[(5 * i) + 1] << 3) | ((int)line[(5 * i) + 2] >> 5);
				rop = ((((int)line[(5 * i) + 2] & 0x001F) << 4) | ((int)line[(5 * i) + 3] >> 4)) & 0x01FF;
				rad = (((int)line[(5 * i) + 3] << 8) | (int)line[(5 * i) + 4]) & 0x0FFF;
				fprintf(dump, "  %03o %04o %03o %04o", lop, lad, rop, rad);
/*				printf("     %03o %04o %03o %04o\n", lop, lad, rop, rad);
				getch();	*/
			}
			fprintf(dump, "\n");
			for(j = 0; j < 20; j++) lineout[j] = line[j];
			same = 0;
		}
		else
		{
			if(same == 0)
			{
				fprintf(dump, "\n");
				same = 1;
			}
		}
		loc += 4;
	}
	fcloseall();
}

int linecomp(char *l1, char *l2, int n)
{
	int l;

	for(l = 0; l < n; l++) if(l1[l] != l2[l]) return(1);
	return(0);
}
