Program Slider;

{ Slider -- move a window horizontally.
  
  Three Rivers Computer Corporation
  Pittsburgh, Pa. 15213
  
  Written by: Brad Myers
}

Imports XScreen from XScreen;
Imports SigUtils from SigUtils;
Imports MultiRead from MultiRead;
Imports FileSystem from FileSystem;
Imports Memory from Memory;
Imports IO_Others from IO_Others;
Imports System from System;
Imports CmdParse from CmdParse;

var MinX, MinY, Width, Height: integer;
    WinNum: integer;
    XInc, YInc: integer;
    i,j,k: integer;
    win: WinRange;
    pusherY: integer;
    pusher, blks, bits, count, offset: integer;
    fid: FileID;
    
Procedure ParseCmds;
  var Str: string;
  begin
  if ArgCount < 4 then
    begin
    Writeln('** Usage: slider window# NextRunFile NextCmdLine');
    Exit(Slider);
    end;
  NextArgStr(Str);
  NextArgInt(WinNum);
  win := WinNum;
  NextArgStr(RFileName);
  RemDelimiters(UsrCmdLine,' ',str);
    
  fid := FSLookUp('Pusher.Animate',blks, bits);
  if fid = 0 then begin
                  WriteLn('** Pusher not found');
                  exit(Slider);
                  end;
  CreateSegment(pusher, blks, 1, blks);
  MultiRead(fid, MakePtr(pusher, 0, pDirBlk), 0, blks);
  end;


begin

ParseCmds;

count := 0;
repeat
  ChangeWindow(Win);
  XSGetFullWindow(win, MinX, MinY, Width, Height);
  If MinX < 2 then MinX := 0;
  If MinY < 2 then MinY := 0;
  if Height > 800 then height := 901;

  j := 0;
  pusherY := (height div 2) + minY - 32;
  
  if count = 1 then
     begin
     MinY := MinY-height;
     height := height*2;
     offset := 46;
     end
  else offset := 48;
       
  IOLoadCursor(MakePtr(pusher, 0, CurPatPtr), offset, 0);
  IOSetCursorPos(MinX, pusherY);
  IOCursorMode(IndepCursor);
  
  for i := 0 to (width div 2) -1 do
    begin
    RasterOp(RRpl, width-2, height, MinX+2, MinY, SScreenW, SScreenP,
                                    MinX, MinY, SScreenW, SScreenP);
    RasterOp(RXor, 2, height, MinX+i, MinY, SScreenW, SScreenP,
                              MinX+i, MinY, SScreenW, SScreenP);
    IOSetCursorPos(MinX+i*2, pusherY);
    if (i+1) mod 3 = 0 then
      begin
      IOLoadCursor(MakePtr(pusher, j*256, CurPatPtr), offset, 0);
      j := (j+1) mod 6;
      end;
    end;
  
  for i := offset downto 0 do
    begin
    RasterOp(RRpl, 2*(width div 3), height, MinX+1, MinY, SScreenW, SScreenP,
                                        MinX, MinY, SScreenW, SScreenP);
    IOLoadCursor(MakePtr(pusher, j*256, CurPatPtr), i, 0);
    if i mod 5 = 0 then
      begin
      IOLoadCursor(MakePtr(pusher, j*256, CurPatPtr), i, 0);
      j := (j+1) mod 6;
      end;
    end;
    
if count = 0 then win := 0;

count := count + 1;

until count = 2;

ChangeWindow(0);
SFullWindow;
SSetCursor(5,20);

end.


